/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public class ClassInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> className;
    private final Set<String> classFields;
    private final Set<Method> classSetters;

    public ClassInfo(Class<?> className, Set<String> classFields, Set<Method> classSetters) {
        this.className = className;
        this.classFields = classFields;
        this.classSetters = classSetters;
    }

    public Set<Method> getClassSetters() {
        return this.classSetters;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classFields == null ? 0 : this.classFields.hashCode());
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.classSetters == null ? 0 : this.classSetters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassInfo other = (ClassInfo)obj;
        if (this.classFields == null ? other.classFields != null : !this.classFields.equals(other.classFields)) {
            return false;
        }
        if (this.className == null ? other.className != null : !this.className.getName().equals(other.className.getName())) {
            return false;
        }
        return !(this.classSetters == null ? other.classSetters != null : !this.classSetters.equals(other.classSetters));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ClassInfo [className=");
        builder.append(this.className);
        builder.append(", classFields=");
        builder.append(this.classFields);
        builder.append(", classSetters=");
        builder.append(this.classSetters);
        builder.append("]");
        return builder.toString();
    }
}

