/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.lang.annotation.Annotation;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.ClassInfo;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.LoggingExternalFactory;
import uk.co.jemos.podam.api.MapArguments;
import uk.co.jemos.podam.api.MapKeyOrElementsArguments;
import uk.co.jemos.podam.api.ObjectStrategy;
import uk.co.jemos.podam.api.PodamFactory;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.api.RandomDataProviderStrategy;
import uk.co.jemos.podam.common.AttributeStrategy;
import uk.co.jemos.podam.common.PodamBooleanValue;
import uk.co.jemos.podam.common.PodamByteValue;
import uk.co.jemos.podam.common.PodamCharValue;
import uk.co.jemos.podam.common.PodamCollection;
import uk.co.jemos.podam.common.PodamDoubleValue;
import uk.co.jemos.podam.common.PodamFloatValue;
import uk.co.jemos.podam.common.PodamIntValue;
import uk.co.jemos.podam.common.PodamLongValue;
import uk.co.jemos.podam.common.PodamShortValue;
import uk.co.jemos.podam.common.PodamStrategyValue;
import uk.co.jemos.podam.common.PodamStringValue;
import uk.co.jemos.podam.exceptions.PodamMockeryException;

@ThreadSafe
@Immutable
public class PodamFactoryImpl
implements PodamFactory {
    private static final String RESOLVING_COLLECTION_EXCEPTION_STR = "An exception occurred while resolving the collection";
    private static final String MAP_CREATION_EXCEPTION_STR = "An exception occurred while creating a Map object";
    private static final String RAWTYPES_STR = "rawtypes";
    private static final String UNCHECKED_STR = "unchecked";
    private static final String THE_ANNOTATION_VALUE_STR = "The annotation value: ";
    private static final Type[] NO_TYPES = new Type[0];
    private static final Logger LOG = LoggerFactory.getLogger((String)PodamFactoryImpl.class.getName());
    private final PodamFactory externalFactory;
    private final DataProviderStrategy strategy;
    private Map<Class<?>, Object> memoizationTable = new HashMap();

    public PodamFactoryImpl() {
        this(LoggingExternalFactory.getInstance(), RandomDataProviderStrategy.getInstance());
    }

    public PodamFactoryImpl(DataProviderStrategy strategy) {
        this(LoggingExternalFactory.getInstance(), strategy);
    }

    public PodamFactoryImpl(PodamFactory externalFactory) {
        this(externalFactory, RandomDataProviderStrategy.getInstance());
    }

    public PodamFactoryImpl(PodamFactory externalFactory, DataProviderStrategy strategy) {
        this.externalFactory = externalFactory;
        this.strategy = strategy;
    }

    @Override
    public <T> T manufacturePojo(Class<T> pojoClass) {
        return this.manufacturePojo(pojoClass, NO_TYPES);
    }

    @Override
    public <T> T manufacturePojo(Class<T> pojoClass, Type ... genericTypeArgs) {
        HashMap pojos = new HashMap();
        pojos.put(pojoClass, 0);
        try {
            return this.manufacturePojoInternal(pojoClass, pojos, genericTypeArgs);
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException("", e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException("", e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException("", e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException("", e);
        }
    }

    @Override
    public DataProviderStrategy getStrategy() {
        return this.strategy;
    }

    private Type[] fillTypeArgMap(Map<String, Type> typeArgsMap, Class<?> pojoClass, Type[] genericTypeArgs) {
        int i;
        TypeVariable<Class<?>>[] typeParameters = pojoClass.getTypeParameters();
        if (typeParameters.length > genericTypeArgs.length) {
            String msg = pojoClass.getCanonicalName() + " is missing generic type arguments, expected " + typeParameters.length + " found " + Arrays.toString(genericTypeArgs);
            throw new IllegalStateException(msg);
        }
        for (i = 0; i < typeParameters.length; ++i) {
            typeArgsMap.put(typeParameters[i].getName(), genericTypeArgs[i]);
        }
        Type[] genericTypeArgsExtra = typeParameters.length < genericTypeArgs.length ? Arrays.copyOfRange(genericTypeArgs, i, genericTypeArgs.length) : null;
        Class<?> clazz = pojoClass;
        while (clazz != null) {
            Type superType = clazz.getGenericSuperclass();
            clazz = clazz.getSuperclass();
            if (!(superType instanceof ParameterizedType)) continue;
            ParameterizedType paramType = (ParameterizedType)superType;
            Type[] actualParamTypes = paramType.getActualTypeArguments();
            TypeVariable<Class<?>>[] paramTypes = clazz.getTypeParameters();
            for (i = 0; i < actualParamTypes.length && i < paramTypes.length; ++i) {
                if (!(actualParamTypes[i] instanceof Class)) continue;
                typeArgsMap.put(paramTypes[i].getName(), actualParamTypes[i]);
            }
        }
        return genericTypeArgsExtra;
    }

    private Object createNewInstanceForClassWithoutConstructors(Class<?> pojoClass, Map<Class<?>, Integer> pojos, Class<?> clazz, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object retValue = null;
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 0 || Modifier.isAbstract(clazz.getModifiers())) {
            HashMap<String, Type> typeArgsMap = new HashMap<String, Type>();
            try {
                Object[] genericTypeArgsExtra = this.fillTypeArgMap(typeArgsMap, pojoClass, genericTypeArgs);
                if (genericTypeArgsExtra != null) {
                    LOG.warn("Lost generic type arguments {}", (Object)Arrays.toString(genericTypeArgsExtra));
                }
            }
            catch (IllegalStateException e) {
                LOG.error("An error occurred while filling the type argument in the map", (Throwable)e);
                return null;
            }
            Method[] declaredMethods = clazz.getDeclaredMethods();
            this.strategy.sort(declaredMethods);
            Object[] parameterValues = null;
            Object[] noParams = new Object[]{};
            for (Method candidateConstructor : declaredMethods) {
                if (!Modifier.isStatic(candidateConstructor.getModifiers()) || !candidateConstructor.getReturnType().equals(clazz) || retValue != null) continue;
                parameterValues = new Object[candidateConstructor.getParameterTypes().length];
                Type[] parameterTypes = candidateConstructor.getGenericParameterTypes();
                if (parameterTypes.length == 0) {
                    parameterValues = noParams;
                } else {
                    Annotation[][] parameterAnnotations = candidateConstructor.getParameterAnnotations();
                    int idx = 0;
                    for (Type paramType : parameterTypes) {
                        AtomicReference<Type[]> methodGenericTypeArgs = new AtomicReference<Type[]>();
                        Class<?> parameterType = this.resolveGenericParameter(paramType, typeArgsMap, methodGenericTypeArgs);
                        List<Annotation> annotations = Arrays.asList(parameterAnnotations[idx]);
                        String attributeName = null;
                        if (Collection.class.isAssignableFrom(parameterType)) {
                            Class elementType;
                            Collection<? super Object> listType = this.resolveCollectionType(parameterType);
                            if (paramType instanceof ParameterizedType) {
                                elementType = (Class)methodGenericTypeArgs.get()[0];
                            } else {
                                LOG.warn("Collection parameter {} type is non-generic.We will assume a Collection<Object> for you.", (Object)paramType);
                                elementType = Object.class;
                            }
                            int nbrElements = this.strategy.getNumberOfCollectionElements(elementType);
                            for (Annotation annotation : annotations) {
                                if (!annotation.annotationType().equals(PodamCollection.class)) continue;
                                PodamCollection ann = (PodamCollection)annotation;
                                nbrElements = ann.nbrElements();
                            }
                            for (int i = 0; i < nbrElements; ++i) {
                                Object attributeValue = this.manufactureAttributeValue(clazz, pojos, elementType, annotations, attributeName, new Type[0]);
                                listType.add(attributeValue);
                            }
                            parameterValues[idx] = listType;
                        } else if (Map.class.isAssignableFrom(parameterType)) {
                            Class valueClass;
                            Class keyClass;
                            Map<? super Object, ? super Object> mapType = this.resolveMapType(parameterType);
                            if (paramType instanceof ParameterizedType) {
                                keyClass = (Class)methodGenericTypeArgs.get()[0];
                                valueClass = (Class)methodGenericTypeArgs.get()[1];
                            } else {
                                LOG.warn("Map parameter {} type is non-generic.We will assume a Map<Object,Object> for you.", (Object)paramType);
                                keyClass = Object.class;
                                valueClass = Object.class;
                            }
                            int nbrElements = this.strategy.getNumberOfCollectionElements(valueClass);
                            for (Annotation annotation : annotations) {
                                if (!annotation.annotationType().equals(PodamCollection.class)) continue;
                                PodamCollection ann = (PodamCollection)annotation;
                                nbrElements = ann.nbrElements();
                            }
                            for (int i = 0; i < nbrElements; ++i) {
                                Object keyValue = this.manufactureAttributeValue(clazz, pojos, keyClass, annotations, attributeName, new Type[0]);
                                Object elementValue = this.manufactureAttributeValue(clazz, pojos, valueClass, annotations, attributeName, new Type[0]);
                                mapType.put(keyValue, elementValue);
                            }
                            parameterValues[idx] = mapType;
                        } else {
                            parameterValues[idx] = this.manufactureAttributeValue(clazz, pojos, parameterType, annotations, attributeName, typeArgsMap, genericTypeArgs);
                        }
                        ++idx;
                    }
                }
                try {
                    retValue = candidateConstructor.invoke(clazz, parameterValues);
                    LOG.debug("Could create an instance using " + candidateConstructor);
                }
                catch (Exception t) {
                    LOG.debug("PODAM could not create an instance for constructor: " + candidateConstructor + ". Will try another one...", (Throwable)t);
                }
            }
        } else {
            this.strategy.sort(constructors);
            for (Constructor<?> constructor : constructors) {
                try {
                    Object[] constructorArgs = this.getParameterValuesForConstructor(constructor, pojoClass, pojos, genericTypeArgs);
                    retValue = constructor.newInstance(constructorArgs);
                    LOG.debug("For class: " + clazz.getName() + " a valid constructor: " + constructor + " was found. PODAM will use it to create an instance.");
                    break;
                }
                catch (Exception t) {
                    LOG.info("Couldn't create attribute with constructor: " + constructor + ". Will check if other constructors are available", (Throwable)t);
                }
            }
        }
        if (retValue == null) {
            retValue = this.externalFactory.manufacturePojo(clazz, genericTypeArgs);
        }
        if (retValue == null) {
            LOG.warn("For attribute {}[{}] PODAM could not possibly create a value. It will be returned as null.", pojoClass, clazz);
        }
        return retValue;
    }

    private Class<?> resolveGenericParameter(Type paramType, Map<String, Type> typeArgsMap, AtomicReference<Type[]> methodGenericTypeArgs) {
        Class<Object> parameterType = null;
        methodGenericTypeArgs.set(new Type[0]);
        if (paramType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)paramType;
            Type type = typeArgsMap.get(typeVariable.getName());
            if (type != null) {
                parameterType = this.resolveGenericParameter(type, typeArgsMap, methodGenericTypeArgs);
            }
        } else if (paramType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)paramType;
            parameterType = (Class<?>)pType.getRawType();
            methodGenericTypeArgs.set(pType.getActualTypeArguments());
        } else if (paramType instanceof WildcardType) {
            String msg;
            WildcardType wType = (WildcardType)paramType;
            Object[] bounds = wType.getLowerBounds();
            if (bounds != null && bounds.length > 0) {
                msg = "Lower bounds:";
            } else {
                bounds = wType.getUpperBounds();
                msg = "Upper bounds:";
            }
            if (bounds != null && bounds.length > 0) {
                LOG.debug(msg + Arrays.toString(bounds));
                parameterType = this.resolveGenericParameter((Type)bounds[0], typeArgsMap, methodGenericTypeArgs);
            }
        } else if (paramType instanceof Class) {
            parameterType = (Class)paramType;
        }
        if (parameterType == null) {
            LOG.warn("Unrecognized type {}. Will use Object instead", (Object)paramType);
            parameterType = Object.class;
        }
        return parameterType;
    }

    private Object resolvePrimitiveValue(Class<?> primitiveClass, List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Constable retValue = null;
        if (primitiveClass.equals(Integer.TYPE)) {
            if (!annotations.isEmpty()) {
                retValue = this.getIntegerValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getInteger(attributeMetadata);
            }
        } else if (primitiveClass.equals(Long.TYPE)) {
            if (!annotations.isEmpty()) {
                retValue = this.getLongValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getLong(attributeMetadata);
            }
        } else if (primitiveClass.equals(Float.TYPE)) {
            if (!annotations.isEmpty()) {
                retValue = this.getFloatValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getFloat(attributeMetadata);
            }
        } else if (primitiveClass.equals(Double.TYPE)) {
            if (!annotations.isEmpty()) {
                retValue = this.getDoubleValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getDouble(attributeMetadata);
            }
        } else if (primitiveClass.equals(Boolean.TYPE)) {
            if (!annotations.isEmpty()) {
                retValue = this.getBooleanValueForAnnotation(annotations);
            }
            if (retValue == null) {
                retValue = this.strategy.getBoolean(attributeMetadata);
            }
        } else if (primitiveClass.equals(Byte.TYPE)) {
            if (!annotations.isEmpty()) {
                retValue = this.getByteValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getByte(attributeMetadata);
            }
        } else if (primitiveClass.equals(Short.TYPE)) {
            if (!annotations.isEmpty()) {
                retValue = this.getShortValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getShort(attributeMetadata);
            }
        } else if (primitiveClass.equals(Character.TYPE)) {
            if (!annotations.isEmpty()) {
                retValue = this.getCharacterValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getCharacter(attributeMetadata);
            }
        }
        return retValue;
    }

    private Boolean getBooleanValueForAnnotation(List<Annotation> annotations) {
        Boolean retValue = null;
        for (Annotation annotation : annotations) {
            if (!PodamBooleanValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamBooleanValue localStrategy = (PodamBooleanValue)annotation;
            retValue = localStrategy.boolValue();
            break;
        }
        return retValue;
    }

    private Byte getByteValueWithinRange(List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Byte retValue = null;
        for (Annotation annotation : annotations) {
            byte maxValue;
            if (!PodamByteValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamByteValue intStrategy = (PodamByteValue)annotation;
            String numValueStr = intStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Byte.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The precise value: " + numValueStr + " cannot be converted to a byte type. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            byte minValue = intStrategy.minValue();
            if (minValue > (maxValue = intStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getByteInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        return retValue;
    }

    private Short getShortValueWithinRange(List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Short retValue = null;
        for (Annotation annotation : annotations) {
            short maxValue;
            if (!PodamShortValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamShortValue shortStrategy = (PodamShortValue)annotation;
            String numValueStr = shortStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Short.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The precise value: " + numValueStr + " cannot be converted to a short type. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            short minValue = shortStrategy.minValue();
            if (minValue > (maxValue = shortStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getShortInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        return retValue;
    }

    private Character getCharacterValueWithinRange(List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Character retValue = null;
        for (Annotation annotation : annotations) {
            char maxValue;
            if (!PodamCharValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamCharValue annotationStrategy = (PodamCharValue)annotation;
            char charValue = annotationStrategy.charValue();
            if (charValue != ' ') {
                retValue = Character.valueOf(charValue);
                break;
            }
            char minValue = annotationStrategy.minValue();
            if (minValue > (maxValue = annotationStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getCharacterInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        return retValue;
    }

    private Integer getIntegerValueWithinRange(List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Integer retValue = null;
        for (Annotation annotation : annotations) {
            int maxValue;
            if (!PodamIntValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamIntValue intStrategy = (PodamIntValue)annotation;
            String numValueStr = intStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Integer.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = THE_ANNOTATION_VALUE_STR + numValueStr + " could not be converted to an Integer. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            int minValue = intStrategy.minValue();
            if (minValue > (maxValue = intStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getIntegerInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        return retValue;
    }

    private Float getFloatValueWithinRange(List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Float retValue = null;
        for (Annotation annotation : annotations) {
            float maxValue;
            if (!PodamFloatValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamFloatValue floatStrategy = (PodamFloatValue)annotation;
            String numValueStr = floatStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Float.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = THE_ANNOTATION_VALUE_STR + numValueStr + " could not be converted to a Float. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            float minValue = floatStrategy.minValue();
            if (minValue > (maxValue = floatStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getFloatInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        return retValue;
    }

    private Double getDoubleValueWithinRange(List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Double retValue = null;
        for (Annotation annotation : annotations) {
            double maxValue;
            if (!PodamDoubleValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamDoubleValue doubleStrategy = (PodamDoubleValue)annotation;
            String numValueStr = doubleStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Double.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = THE_ANNOTATION_VALUE_STR + numValueStr + " could not be converted to a Double. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            double minValue = doubleStrategy.minValue();
            if (minValue > (maxValue = doubleStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getDoubleInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        return retValue;
    }

    private Long getLongValueWithinRange(List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Long retValue = null;
        for (Annotation annotation : annotations) {
            long maxValue;
            if (!PodamLongValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamLongValue longStrategy = (PodamLongValue)annotation;
            String numValueStr = longStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Long.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = THE_ANNOTATION_VALUE_STR + numValueStr + " could not be converted to a Long. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            long minValue = longStrategy.minValue();
            if (minValue > (maxValue = longStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getLongInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        return retValue;
    }

    private Object resolveWrapperValue(Class<?> candidateWrapperClass, List<Annotation> annotations, AttributeMetadata attributeMetadata) {
        Constable retValue = null;
        if (candidateWrapperClass.equals(Integer.class)) {
            if (!annotations.isEmpty()) {
                retValue = this.getIntegerValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getInteger(attributeMetadata);
            }
        } else if (candidateWrapperClass.equals(Long.class)) {
            if (!annotations.isEmpty()) {
                retValue = this.getLongValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getLong(attributeMetadata);
            }
        } else if (candidateWrapperClass.equals(Float.class)) {
            if (!annotations.isEmpty()) {
                retValue = this.getFloatValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getFloat(attributeMetadata);
            }
        } else if (candidateWrapperClass.equals(Double.class)) {
            if (!annotations.isEmpty()) {
                retValue = this.getDoubleValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getDouble(attributeMetadata);
            }
        } else if (candidateWrapperClass.equals(Boolean.class)) {
            if (!annotations.isEmpty()) {
                retValue = this.getBooleanValueForAnnotation(annotations);
            }
            if (retValue == null) {
                retValue = this.strategy.getBoolean(attributeMetadata);
            }
        } else if (candidateWrapperClass.equals(Byte.class)) {
            if (!annotations.isEmpty()) {
                retValue = this.getByteValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getByte(attributeMetadata);
            }
        } else if (candidateWrapperClass.equals(Short.class)) {
            if (!annotations.isEmpty()) {
                retValue = this.getShortValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getShort(attributeMetadata);
            }
        } else if (candidateWrapperClass.equals(Character.class)) {
            if (!annotations.isEmpty()) {
                retValue = this.getCharacterValueWithinRange(annotations, attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getCharacter(attributeMetadata);
            }
        }
        return retValue;
    }

    private <T> T instantiatePojo(Class<T> pojoClass, Map<Class<?>, Integer> pojos, Type ... genericTypeArgs) throws SecurityException {
        Object retValue = null;
        Constructor<?>[] constructors = pojoClass.getConstructors();
        if (constructors.length == 0) {
            try {
                retValue = this.createNewInstanceForClassWithoutConstructors(pojoClass, pojos, pojoClass, genericTypeArgs);
            }
            catch (Exception e) {
                LOG.debug("We couldn't create an instance for pojo: " + pojoClass + " with factory methods, will " + " try non-public constructors.", (Throwable)e);
            }
            if (retValue == null) {
                constructors = pojoClass.getDeclaredConstructors();
            }
        }
        if (retValue == null && constructors.length > 0) {
            this.strategy.sort(constructors);
            for (Constructor<?> constructor : constructors) {
                try {
                    Object[] parameterValues = this.getParameterValuesForConstructor(constructor, pojoClass, pojos, genericTypeArgs);
                    if (!constructor.isAccessible()) {
                        constructor.setAccessible(true);
                    }
                    if ((retValue = constructor.newInstance(parameterValues)) instanceof Collection && ((Collection)retValue).isEmpty()) {
                        LOG.debug("We could create an instance with constructor: " + constructor + ", but collection is empty" + ". Will try with another one.");
                        continue;
                    }
                    if (retValue instanceof Map && ((Map)retValue).isEmpty()) {
                        LOG.debug("We could create an instance with constructor: " + constructor + ", but map is empty" + ". Will try with another one.");
                        continue;
                    }
                    LOG.debug("We could create an instance with constructor: " + constructor);
                    break;
                }
                catch (Exception e) {
                    LOG.debug("We couldn't create an instance for pojo: " + pojoClass + " for constructor: " + constructor + ". Will try with another one.", (Throwable)e);
                }
            }
        }
        if (retValue == null) {
            retValue = this.externalFactory.manufacturePojo(pojoClass, genericTypeArgs);
        }
        return (T)retValue;
    }

    private <T> T manufacturePojoInternal(Class<T> pojoClass, Map<Class<?>, Integer> pojos, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object objectToReuse;
        T retValue = null;
        if (this.strategy.isMemoizationEnabled() && (objectToReuse = this.memoizationTable.get(pojoClass)) != null) {
            return (T)objectToReuse;
        }
        if (pojoClass.isPrimitive()) {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            String noName = null;
            return (T)this.resolvePrimitiveValue(pojoClass, annotations, new AttributeMetadata(noName, pojoClass, annotations, pojoClass));
        }
        if (pojoClass.isInterface() || Modifier.isAbstract(pojoClass.getModifiers())) {
            Class<T> specificClass = this.strategy.getSpecificClass(pojoClass);
            if (!specificClass.equals(pojoClass)) {
                return this.manufacturePojoInternal(specificClass, pojos, genericTypeArgs);
            }
            if (Modifier.isAbstract(pojoClass.getModifiers())) {
                return (T)this.createNewInstanceForClassWithoutConstructors(pojoClass, pojos, pojoClass, genericTypeArgs);
            }
            return this.externalFactory.manufacturePojo(pojoClass, genericTypeArgs);
        }
        try {
            retValue = this.instantiatePojo(pojoClass, pojos, genericTypeArgs);
        }
        catch (SecurityException e) {
            throw new PodamMockeryException("Security exception while applying introspection.", e);
        }
        if (this.strategy.isMemoizationEnabled()) {
            this.memoizationTable.put(pojoClass, retValue);
        }
        if (retValue == null) {
            return null;
        }
        if (retValue instanceof Collection && ((Collection)retValue).size() == 0) {
            this.fillCollection((Collection)retValue, pojos, genericTypeArgs);
        } else if (retValue instanceof Map && ((Map)retValue).size() == 0) {
            this.fillMap((Map)retValue, pojos, genericTypeArgs);
        }
        Class<?>[] parameterTypes = null;
        Class attributeType = null;
        ClassInfo classInfo = PodamUtils.getClassInfo(pojoClass, this.strategy.getExcludedAnnotations());
        Object setterArg = null;
        for (Method setter : classInfo.getClassSetters()) {
            List<Annotation> pojoAttributeAnnotations = this.retrieveFieldAnnotations(pojoClass, setter);
            String attributeName = PodamUtils.extractFieldNameFromSetterMethod(setter);
            parameterTypes = setter.getParameterTypes();
            if (parameterTypes.length != 1) {
                throw new IllegalStateException("A " + pojoClass.getSimpleName() + "." + setter.getName() + "() should have only one argument");
            }
            attributeType = parameterTypes[0];
            PodamStrategyValue attributeStrategyAnnotation = this.containsAttributeStrategyAnnotation(pojoAttributeAnnotations);
            if (null != attributeStrategyAnnotation) {
                AttributeStrategy<?> attributeStrategy = attributeStrategyAnnotation.value().newInstance();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The attribute: " + attributeName + " will be filled using the following strategy: " + attributeStrategy);
                }
                setterArg = this.returnAttributeDataStrategyValue(attributeType, attributeStrategy);
            } else {
                HashMap<String, Type> typeArgsMap = new HashMap<String, Type>();
                Object[] genericTypeArgsExtra = this.fillTypeArgMap(typeArgsMap, pojoClass, genericTypeArgs);
                if (genericTypeArgsExtra != null) {
                    LOG.warn("Lost generic type arguments {}", (Object)Arrays.toString(genericTypeArgsExtra));
                }
                Type[] typeArguments = new Type[]{};
                if (setter.getGenericParameterTypes()[0] instanceof ParameterizedType) {
                    ParameterizedType attributeParameterizedType = (ParameterizedType)setter.getGenericParameterTypes()[0];
                    typeArguments = attributeParameterizedType.getActualTypeArguments();
                } else if (setter.getGenericParameterTypes()[0] instanceof TypeVariable) {
                    TypeVariable typeVariable = (TypeVariable)setter.getGenericParameterTypes()[0];
                    Type type = (Type)typeArgsMap.get(typeVariable.getName());
                    if (type instanceof ParameterizedType) {
                        ParameterizedType attributeParameterizedType = (ParameterizedType)type;
                        typeArguments = attributeParameterizedType.getActualTypeArguments();
                        attributeType = (Class)attributeParameterizedType.getRawType();
                    } else {
                        attributeType = (Class)type;
                    }
                }
                AtomicReference<Type[]> typeGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
                for (int i = 0; i < typeArguments.length; ++i) {
                    Class<?> resolvedType;
                    if (!(typeArguments[i] instanceof TypeVariable) || Collection.class.isAssignableFrom(resolvedType = this.resolveGenericParameter(typeArguments[i], typeArgsMap, typeGenericTypeArgs)) || Map.class.isAssignableFrom(resolvedType)) continue;
                    typeArguments[i] = resolvedType;
                }
                setterArg = this.manufactureAttributeValue(pojoClass, pojos, attributeType, pojoAttributeAnnotations, attributeName, typeArgsMap, typeArguments);
                if (null == setterArg) {
                    setterArg = this.externalFactory.manufacturePojo(attributeType);
                }
            }
            if (setterArg != null) {
                try {
                    setter.invoke(retValue, setterArg);
                }
                catch (IllegalAccessException e) {
                    LOG.warn("{} is not accessible. Setting it to accessible. However this is a security hack and your code should really adhere to JavaBeans standards.", (Object)setter.toString());
                    setter.setAccessible(true);
                    setter.invoke(retValue, setterArg);
                }
                continue;
            }
            LOG.warn("Couldn't find a suitable value for attribute {}[{}]. It will be left to null.", pojoClass, attributeType);
        }
        return retValue;
    }

    private Object manufactureAttributeValue(Class<?> pojoClass, Map<Class<?>, Integer> pojos, Class<?> attributeType, List<Annotation> annotations, String attributeName, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        HashMap<String, Type> nullTypeArgsMap = new HashMap<String, Type>();
        return this.manufactureAttributeValue(pojoClass, pojos, attributeType, annotations, attributeName, nullTypeArgsMap, genericTypeArgs);
    }

    private Object manufactureAttributeValue(Class<?> pojoClass, Map<Class<?>, Integer> pojos, Class<?> attributeType, List<Annotation> annotations, String attributeName, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> attributeValue = null;
        Class realAttributeType = genericTypeArgs.length > 0 && genericTypeArgs[0] instanceof Class && attributeType.isAssignableFrom((Class)genericTypeArgs[0]) ? (Class)genericTypeArgs[0] : attributeType;
        AttributeMetadata attributeMetadata = new AttributeMetadata(attributeName, realAttributeType, annotations, pojoClass);
        if (realAttributeType.isPrimitive()) {
            attributeValue = this.resolvePrimitiveValue(realAttributeType, annotations, attributeMetadata);
        } else if (this.isWrapper(realAttributeType)) {
            attributeValue = this.resolveWrapperValue(realAttributeType, annotations, attributeMetadata);
        } else if (realAttributeType.equals(String.class)) {
            attributeValue = this.resolveStringValue(annotations, attributeMetadata);
        } else if (realAttributeType.getName().startsWith("[")) {
            attributeValue = this.resolveArrayElementValue(realAttributeType, pojos, annotations, pojoClass, attributeName, typeArgsMap);
        } else if (Collection.class.isAssignableFrom(realAttributeType)) {
            try {
                attributeValue = this.resolveCollectionValueWhenCollectionIsPojoAttribute(pojoClass, pojos, realAttributeType, attributeName, annotations, typeArgsMap, genericTypeArgs);
            }
            catch (IllegalArgumentException e) {
                LOG.info("Cannot manufacture list {}, will try strategy", (Object)realAttributeType);
            }
        } else if (Map.class.isAssignableFrom(realAttributeType)) {
            try {
                attributeValue = this.resolveMapValueWhenMapIsPojoAttribute(pojoClass, pojos, realAttributeType, attributeName, annotations, typeArgsMap, genericTypeArgs);
            }
            catch (IllegalArgumentException e) {
                LOG.info("Cannot manufacture map {}, will try strategy", (Object)realAttributeType);
            }
        } else if (realAttributeType.isEnum()) {
            int enumConstantsLength = realAttributeType.getEnumConstants().length;
            if (enumConstantsLength > 0) {
                int enumIndex = this.strategy.getIntegerInRange(0, enumConstantsLength, attributeMetadata) % enumConstantsLength;
                attributeValue = realAttributeType.getEnumConstants()[enumIndex];
            }
        } else if (Type.class.isAssignableFrom(realAttributeType)) {
            if (genericTypeArgs.length > 0 && genericTypeArgs[0] != null) {
                AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
                attributeValue = this.resolveGenericParameter(genericTypeArgs[0], typeArgsMap, elementGenericTypeArgs);
            } else {
                LOG.error("{} is missing generic type argument", (Object)realAttributeType);
            }
        }
        if (attributeValue == null) {
            Integer depth = pojos.get(realAttributeType);
            if (depth == null) {
                depth = -1;
            }
            if (depth <= this.strategy.getMaxDepth(pojoClass)) {
                pojos.put(realAttributeType, depth + 1);
                attributeValue = this.manufacturePojoInternal(realAttributeType, pojos, genericTypeArgs);
                pojos.put(realAttributeType, depth);
            } else {
                LOG.warn("Loop in {} production detected.", (Object)realAttributeType);
                attributeValue = this.externalFactory.manufacturePojo(realAttributeType, genericTypeArgs);
            }
        }
        return attributeValue;
    }

    private String resolveStringValue(List<Annotation> annotations, AttributeMetadata attributeMetadata) throws InstantiationException, IllegalAccessException {
        String retValue = null;
        if (annotations == null || annotations.isEmpty()) {
            retValue = this.strategy.getStringValue(attributeMetadata);
        } else {
            for (Annotation annotation : annotations) {
                if (!PodamStringValue.class.isAssignableFrom(annotation.getClass())) continue;
                PodamStringValue podamAnnotation = (PodamStringValue)annotation;
                if (podamAnnotation.strValue() != null && podamAnnotation.strValue().length() > 0) {
                    retValue = podamAnnotation.strValue();
                    continue;
                }
                retValue = this.strategy.getStringOfLength(podamAnnotation.length(), attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.strategy.getStringValue(attributeMetadata);
            }
        }
        return retValue;
    }

    private <T> T getDefaultFieldValue(Class<?> pojoClass, String attributeName) {
        Object retValue = null;
        try {
            Field field = this.getField(pojoClass, attributeName);
            if (field != null) {
                field.setAccessible(true);
                Object newInstance = pojoClass.newInstance();
                retValue = field.get(newInstance);
            } else {
                LOG.info("The field {}[{}] didn't exist.", pojoClass, (Object)attributeName);
            }
        }
        catch (Exception e) {
            LOG.info("We couldn't call an empty constructor for {} to get default value for {}.", new Object[]{pojoClass, attributeName, e});
        }
        return (T)retValue;
    }

    private Field getField(Class<?> pojoClass, String attributeName) {
        Field field = null;
        for (Class<?> clazz = pojoClass; clazz != null; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(attributeName);
                break;
            }
            catch (NoSuchFieldException e) {
                LOG.info("A field could not be found for attribute '{}[{}]'", clazz, (Object)attributeName);
                continue;
            }
        }
        return field;
    }

    private PodamStrategyValue containsAttributeStrategyAnnotation(List<Annotation> annotations) {
        PodamStrategyValue retValue = null;
        for (Annotation annotation : annotations) {
            if (!PodamStrategyValue.class.isAssignableFrom(annotation.getClass())) continue;
            retValue = (PodamStrategyValue)annotation;
            break;
        }
        return retValue;
    }

    private boolean isWrapper(Class<?> candidateWrapperClass) {
        return candidateWrapperClass.equals(Byte.class) ? true : (candidateWrapperClass.equals(Boolean.class) ? true : (candidateWrapperClass.equals(Character.class) ? true : (candidateWrapperClass.equals(Short.class) ? true : (candidateWrapperClass.equals(Integer.class) ? true : (candidateWrapperClass.equals(Long.class) ? true : (candidateWrapperClass.equals(Float.class) ? true : candidateWrapperClass.equals(Double.class)))))));
    }

    private List<Annotation> retrieveFieldAnnotations(Class<?> clazz, Method setter) {
        Annotation[] annotations;
        List<Annotation> retValue = new ArrayList<Annotation>();
        String attributeName = PodamUtils.extractFieldNameFromSetterMethod(setter);
        Field setterField = this.getField(clazz, attributeName);
        if (setterField != null && (annotations = setterField.getAnnotations()) != null && annotations.length != 0) {
            retValue = Arrays.asList(annotations);
        }
        return retValue;
    }

    private Collection<? super Object> resolveCollectionValueWhenCollectionIsPojoAttribute(Class<?> pojoClass, Map<Class<?>, Integer> pojos, Class<?> collectionType, String attributeName, List<Annotation> annotations, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) {
        Collection<? super Object> retValue = null;
        if (null != attributeName) {
            retValue = (Collection<? super Object>)this.getDefaultFieldValue(pojoClass, attributeName);
        }
        if (null == retValue) {
            retValue = this.resolveCollectionType(collectionType);
        }
        try {
            Class<Object> typeClass = null;
            AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
            if (genericTypeArgs == null || genericTypeArgs.length == 0) {
                LOG.warn("The collection attribute: " + attributeName + " does not have a type. We will assume Object for you");
                typeClass = Object.class;
            } else {
                Type actualTypeArgument = genericTypeArgs[0];
                typeClass = this.resolveGenericParameter(actualTypeArgument, typeArgsMap, elementGenericTypeArgs);
            }
            this.fillCollection(pojoClass, pojos, annotations, retValue, typeClass, elementGenericTypeArgs.get());
        }
        catch (SecurityException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        catch (IllegalArgumentException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        return retValue;
    }

    private void fillCollection(Collection<? super Object> collection, Map<Class<?>, Integer> pojos, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        HashMap<String, Type> typeArgsMap = new HashMap<String, Type>();
        Class<?> pojoClass = collection.getClass();
        Object[] genericTypeArgsExtra = this.fillTypeArgMap(typeArgsMap, pojoClass, genericTypeArgs);
        if (genericTypeArgsExtra != null && genericTypeArgsExtra.length > 0) {
            LOG.warn("Lost generic type arguments {}", (Object)Arrays.toString(genericTypeArgsExtra));
        }
        Annotation[] annotations = collection.getClass().getAnnotations();
        Class<?> collectionClass = pojoClass;
        AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
        Type[] typeParams = collectionClass.getTypeParameters();
        while (typeParams.length < 1) {
            Type type = collectionClass.getGenericSuperclass();
            collectionClass = this.resolveGenericParameter(type, typeArgsMap, elementGenericTypeArgs);
            typeParams = elementGenericTypeArgs.get();
        }
        Class<?> elementTypeClass = this.resolveGenericParameter(typeParams[0], typeArgsMap, elementGenericTypeArgs);
        this.fillCollection(pojoClass, pojos, Arrays.asList(annotations), collection, elementTypeClass, elementGenericTypeArgs.get());
    }

    private void fillCollection(Class<?> pojoClass, Map<Class<?>, Integer> pojos, List<Annotation> annotations, Collection<? super Object> collection, Class<?> collectionElementType, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        PodamCollection collectionAnnotation = null;
        AttributeStrategy<?> elementStrategy = null;
        for (Annotation annotation : annotations) {
            if (!PodamCollection.class.isAssignableFrom(annotation.getClass())) continue;
            collectionAnnotation = (PodamCollection)annotation;
            break;
        }
        int nbrElements = this.strategy.getNumberOfCollectionElements(collectionElementType);
        if (null != collectionAnnotation) {
            nbrElements = collectionAnnotation.nbrElements();
            elementStrategy = collectionAnnotation.collectionElementStrategy().newInstance();
        }
        for (int i = 0; i < nbrElements; ++i) {
            Object element;
            if (null != elementStrategy && ObjectStrategy.class.isAssignableFrom(elementStrategy.getClass()) && Object.class.equals(collectionElementType)) {
                LOG.debug("Element strategy is ObjectStrategy and collection element is of type Object: using the ObjectStrategy strategy");
                element = elementStrategy.getValue();
            } else if (null != elementStrategy && !ObjectStrategy.class.isAssignableFrom(elementStrategy.getClass())) {
                LOG.debug("Collection elements will be filled using the following strategy: " + elementStrategy);
                element = this.returnAttributeDataStrategyValue(collectionElementType, elementStrategy);
            } else {
                String elementAttributeName = null;
                element = this.manufactureAttributeValue(pojoClass, pojos, collectionElementType, annotations, elementAttributeName, genericTypeArgs);
            }
            collection.add(element);
        }
    }

    private Map<? super Object, ? super Object> resolveMapValueWhenMapIsPojoAttribute(Class<?> pojoClass, Map<Class<?>, Integer> pojos, Class<?> attributeType, String attributeName, List<Annotation> annotations, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) {
        Map<? super Object, ? super Object> retValue = null;
        if (null != attributeName) {
            retValue = (Map<? super Object, ? super Object>)this.getDefaultFieldValue(pojoClass, attributeName);
        }
        if (null == retValue) {
            retValue = this.resolveMapType(attributeType);
        }
        try {
            Class keyClass = null;
            Class elementClass = null;
            AtomicReference<Type[]> keyGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
            AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
            if (genericTypeArgs == null || genericTypeArgs.length == 0) {
                LOG.warn("Map attribute: " + attributeName + " is non-generic. We will assume a Map<Object, Object> for you.");
                keyClass = Object.class;
                elementClass = Object.class;
            } else {
                if (genericTypeArgs.length != 2) {
                    throw new IllegalStateException("In a Map only key value generic type are expected.");
                }
                Type[] actualTypeArguments = genericTypeArgs;
                keyClass = this.resolveGenericParameter(actualTypeArguments[0], typeArgsMap, keyGenericTypeArgs);
                elementClass = this.resolveGenericParameter(actualTypeArguments[1], typeArgsMap, elementGenericTypeArgs);
            }
            MapArguments mapArguments = new MapArguments();
            mapArguments.setPojoClass(pojoClass);
            mapArguments.setPojos(pojos);
            mapArguments.setAnnotations(annotations);
            mapArguments.setMapToBeFilled(retValue);
            mapArguments.setKeyClass(keyClass);
            mapArguments.setElementClass(elementClass);
            mapArguments.setKeyGenericTypeArgs(keyGenericTypeArgs.get());
            mapArguments.setElementGenericTypeArgs(elementGenericTypeArgs.get());
            this.fillMap(mapArguments);
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException(MAP_CREATION_EXCEPTION_STR, e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException(MAP_CREATION_EXCEPTION_STR, e);
        }
        catch (SecurityException e) {
            throw new PodamMockeryException(MAP_CREATION_EXCEPTION_STR, e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException(MAP_CREATION_EXCEPTION_STR, e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException(MAP_CREATION_EXCEPTION_STR, e);
        }
        return retValue;
    }

    private void fillMap(Map<? super Object, ? super Object> map, Map<Class<?>, Integer> pojos, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        HashMap<String, Type> typeArgsMap = new HashMap<String, Type>();
        Class<?> pojoClass = map.getClass();
        Object[] genericTypeArgsExtra = this.fillTypeArgMap(typeArgsMap, pojoClass, genericTypeArgs);
        if (genericTypeArgsExtra != null && genericTypeArgsExtra.length > 0) {
            LOG.warn("Lost generic type arguments {}", (Object)Arrays.toString(genericTypeArgsExtra));
        }
        Class<?> mapClass = pojoClass;
        AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
        Type[] typeParams = mapClass.getTypeParameters();
        while (typeParams.length < 2) {
            Type type = mapClass.getGenericSuperclass();
            mapClass = this.resolveGenericParameter(type, typeArgsMap, elementGenericTypeArgs);
            typeParams = elementGenericTypeArgs.get();
        }
        AtomicReference<Type[]> keyGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
        Class<?> keyClass = this.resolveGenericParameter(typeParams[0], typeArgsMap, keyGenericTypeArgs);
        Class<?> elementClass = this.resolveGenericParameter(typeParams[1], typeArgsMap, elementGenericTypeArgs);
        MapArguments mapArguments = new MapArguments();
        mapArguments.setPojoClass(pojoClass);
        mapArguments.setPojos(pojos);
        mapArguments.setAnnotations(Arrays.asList(pojoClass.getAnnotations()));
        mapArguments.setMapToBeFilled(map);
        mapArguments.setKeyClass(keyClass);
        mapArguments.setElementClass(elementClass);
        mapArguments.setKeyGenericTypeArgs(keyGenericTypeArgs.get());
        mapArguments.setElementGenericTypeArgs(elementGenericTypeArgs.get());
        this.fillMap(mapArguments);
    }

    private void fillMap(MapArguments mapArguments) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        PodamCollection collectionAnnotation = null;
        AttributeStrategy<?> keyStrategy = null;
        AttributeStrategy<?> elementStrategy = null;
        for (Annotation annotation : mapArguments.getAnnotations()) {
            if (!PodamCollection.class.isAssignableFrom(annotation.getClass())) continue;
            collectionAnnotation = (PodamCollection)annotation;
            break;
        }
        int nbrElements = this.strategy.getNumberOfCollectionElements(mapArguments.getElementClass());
        if (null != collectionAnnotation) {
            nbrElements = collectionAnnotation.nbrElements();
            keyStrategy = collectionAnnotation.mapKeyStrategy().newInstance();
            elementStrategy = collectionAnnotation.mapElementStrategy().newInstance();
        }
        for (int i = 0; i < nbrElements; ++i) {
            Object keyValue = null;
            Object elementValue = null;
            MapKeyOrElementsArguments valueArguments = new MapKeyOrElementsArguments();
            valueArguments.setPojoClass(mapArguments.getPojoClass());
            valueArguments.setPojos(mapArguments.getPojos());
            valueArguments.setAnnotations(mapArguments.getAnnotations());
            valueArguments.setKeyOrValueType(mapArguments.getKeyClass());
            valueArguments.setElementStrategy(keyStrategy);
            valueArguments.setGenericTypeArgs(mapArguments.getKeyGenericTypeArgs());
            keyValue = this.getMapKeyOrElementValue(valueArguments);
            valueArguments = new MapKeyOrElementsArguments();
            valueArguments.setPojoClass(mapArguments.getPojoClass());
            valueArguments.setPojos(mapArguments.getPojos());
            valueArguments.setAnnotations(mapArguments.getAnnotations());
            valueArguments.setKeyOrValueType(mapArguments.getElementClass());
            valueArguments.setElementStrategy(elementStrategy);
            valueArguments.setGenericTypeArgs(mapArguments.getElementGenericTypeArgs());
            elementValue = this.getMapKeyOrElementValue(valueArguments);
            Map<? super Object, ? super Object> map = mapArguments.getMapToBeFilled();
            if (elementValue == null && map instanceof ConcurrentHashMap) continue;
            map.put(keyValue, elementValue);
        }
    }

    private Object getMapKeyOrElementValue(MapKeyOrElementsArguments keyOrElementsArguments) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object retValue = null;
        if (null != keyOrElementsArguments.getElementStrategy() && ObjectStrategy.class.isAssignableFrom(keyOrElementsArguments.getElementStrategy().getClass()) && Object.class.equals(keyOrElementsArguments.getKeyOrValueType())) {
            LOG.debug("Element strategy is ObjectStrategy and Map key or value type is of type Object: using the ObjectStrategy strategy");
            retValue = keyOrElementsArguments.getElementStrategy().getValue();
        } else if (null != keyOrElementsArguments.getElementStrategy() && !ObjectStrategy.class.isAssignableFrom(keyOrElementsArguments.getElementStrategy().getClass())) {
            LOG.debug("Map key or value will be filled using the following strategy: " + keyOrElementsArguments.getElementStrategy());
            retValue = this.returnAttributeDataStrategyValue(keyOrElementsArguments.getKeyOrValueType(), keyOrElementsArguments.getElementStrategy());
        } else {
            String keyOrElementAttributeName = null;
            retValue = this.manufactureAttributeValue(keyOrElementsArguments.getPojoClass(), keyOrElementsArguments.getPojos(), keyOrElementsArguments.getKeyOrValueType(), keyOrElementsArguments.getAnnotations(), keyOrElementAttributeName, keyOrElementsArguments.getGenericTypeArgs());
        }
        return retValue;
    }

    private Object resolveArrayElementValue(Class<?> attributeType, Map<Class<?>, Integer> pojos, List<Annotation> annotations, Class<?> pojoClass, String attributeName, Map<String, Type> typeArgsMap) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        int nbrElements;
        Type type;
        Type genericType;
        Field field;
        Class<?> componentType = attributeType.getComponentType();
        AtomicReference<Type[]> genericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
        if (null != attributeName && (field = this.getField(pojoClass, attributeName)) != null && (genericType = field.getGenericType()) instanceof GenericArrayType && (type = ((GenericArrayType)genericType).getGenericComponentType()) instanceof TypeVariable) {
            Type typeVarType = typeArgsMap.get(((TypeVariable)type).getName());
            componentType = this.resolveGenericParameter(typeVarType, typeArgsMap, genericTypeArgs);
        }
        PodamCollection collectionAnnotation = null;
        AttributeStrategy<?> elementStrategy = null;
        for (Annotation annotation : annotations) {
            if (!PodamCollection.class.isAssignableFrom(annotation.getClass())) continue;
            collectionAnnotation = (PodamCollection)annotation;
            break;
        }
        if (null != collectionAnnotation) {
            nbrElements = collectionAnnotation.nbrElements();
            elementStrategy = collectionAnnotation.collectionElementStrategy().newInstance();
        } else {
            nbrElements = this.strategy.getNumberOfCollectionElements(attributeType);
        }
        Object arrayElement = null;
        Object array = Array.newInstance(componentType, nbrElements);
        for (int i = 0; i < nbrElements; ++i) {
            if (null != elementStrategy && ObjectStrategy.class.isAssignableFrom(collectionAnnotation.collectionElementStrategy()) && Object.class.equals(componentType)) {
                LOG.debug("Element strategy is ObjectStrategy and array element is of type Object: using the ObjectStrategy strategy");
                arrayElement = elementStrategy.getValue();
            } else if (null != elementStrategy && !ObjectStrategy.class.isAssignableFrom(collectionAnnotation.collectionElementStrategy())) {
                LOG.debug("Array elements will be filled using the following strategy: " + elementStrategy);
                arrayElement = this.returnAttributeDataStrategyValue(componentType, elementStrategy);
            } else {
                arrayElement = this.manufactureAttributeValue(pojoClass, pojos, componentType, annotations, attributeName, typeArgsMap, genericTypeArgs.get());
            }
            Array.set(array, i, arrayElement);
        }
        return array;
    }

    private Collection<? super Object> resolveCollectionType(Class<?> collectionType) {
        AbstractCollection retValue = null;
        if (Queue.class.isAssignableFrom(collectionType)) {
            if (collectionType.isAssignableFrom(LinkedList.class)) {
                retValue = new LinkedList();
            }
        } else if (Set.class.isAssignableFrom(collectionType)) {
            if (collectionType.isAssignableFrom(HashSet.class)) {
                retValue = new HashSet();
            }
        } else if (collectionType.isAssignableFrom(ArrayList.class)) {
            retValue = new ArrayList();
        }
        if (null == retValue) {
            throw new IllegalArgumentException("Collection type: " + collectionType + " not supported");
        }
        return retValue;
    }

    private Map<? super Object, ? super Object> resolveMapType(Class<?> mapType) {
        AbstractMap retValue = null;
        if (SortedMap.class.isAssignableFrom(mapType)) {
            if (mapType.isAssignableFrom(TreeMap.class)) {
                retValue = new TreeMap();
            }
        } else if (ConcurrentMap.class.isAssignableFrom(mapType)) {
            if (mapType.isAssignableFrom(ConcurrentHashMap.class)) {
                retValue = new ConcurrentHashMap();
            }
        } else if (mapType.isAssignableFrom(HashMap.class)) {
            retValue = new HashMap();
        }
        if (null == retValue) {
            throw new IllegalArgumentException("Map type: " + mapType + " not supported");
        }
        return retValue;
    }

    private Object[] getParameterValuesForConstructor(Constructor<?> constructor, Class<?> pojoClass, Map<Class<?>, Integer> pojos, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        HashMap<String, Type> typeArgsMap = new HashMap<String, Type>();
        Type[] genericTypeArgsExtra = null;
        genericTypeArgsExtra = this.fillTypeArgMap(typeArgsMap, pojoClass, genericTypeArgs);
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        Object[] parameterValues = new Object[constructor.getParameterTypes().length];
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        int idx = 0;
        for (Class<?> parameterType : parameterTypes) {
            Type type;
            List<Annotation> annotations = Arrays.asList(parameterAnnotations[idx]);
            String attributeName = null;
            if (Collection.class.isAssignableFrom(parameterType)) {
                Class collectionElementType;
                Collection<? super Object> collection = this.resolveCollectionType(parameterType);
                type = constructor.getGenericParameterTypes()[idx];
                AtomicReference<Type[]> collectionGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
                if (type instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)type;
                    Type actualTypeArgument = pType.getActualTypeArguments()[0];
                    collectionElementType = this.resolveGenericParameter(actualTypeArgument, typeArgsMap, collectionGenericTypeArgs);
                } else {
                    LOG.warn("Collection parameter {} type is non-generic.We will assume a Collection<Object> for you.", (Object)type);
                    collectionElementType = Object.class;
                }
                Type[] genericTypeArgsAll = this.mergeTypeArrays(collectionGenericTypeArgs.get(), genericTypeArgsExtra);
                this.fillCollection(pojoClass, pojos, annotations, collection, collectionElementType, genericTypeArgsAll);
                parameterValues[idx] = collection;
            } else if (Map.class.isAssignableFrom(parameterType)) {
                Class elementClass;
                Class keyClass;
                Map<? super Object, ? super Object> mapType = this.resolveMapType(parameterType);
                type = constructor.getGenericParameterTypes()[idx];
                AtomicReference<Type[]> keyGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
                AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(new Type[0]);
                if (type instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)type;
                    Type[] actualTypeArguments = pType.getActualTypeArguments();
                    keyClass = this.resolveGenericParameter(actualTypeArguments[0], typeArgsMap, keyGenericTypeArgs);
                    elementClass = this.resolveGenericParameter(actualTypeArguments[1], typeArgsMap, elementGenericTypeArgs);
                } else {
                    LOG.warn("Map parameter {} type is non-generic.We will assume a Map<Object,Object> for you.", (Object)type);
                    keyClass = Object.class;
                    elementClass = Object.class;
                }
                Type[] genericTypeArgsAll = this.mergeTypeArrays(elementGenericTypeArgs.get(), genericTypeArgsExtra);
                MapArguments mapArguments = new MapArguments();
                mapArguments.setPojoClass(pojoClass);
                mapArguments.setPojos(pojos);
                mapArguments.setAnnotations(annotations);
                mapArguments.setMapToBeFilled(mapType);
                mapArguments.setKeyClass(keyClass);
                mapArguments.setElementClass(elementClass);
                mapArguments.setKeyGenericTypeArgs(keyGenericTypeArgs.get());
                mapArguments.setElementGenericTypeArgs(genericTypeArgsAll);
                this.fillMap(mapArguments);
                parameterValues[idx] = mapType;
            } else {
                parameterValues[idx] = this.manufactureAttributeValue(pojoClass, pojos, parameterType, annotations, attributeName, typeArgsMap, genericTypeArgs);
            }
            ++idx;
        }
        return parameterValues;
    }

    private Type[] mergeTypeArrays(Type[] original, Type[] extra) {
        Type[] merged;
        if (extra != null) {
            merged = new Type[original.length + extra.length];
            System.arraycopy(original, 0, merged, 0, original.length);
            System.arraycopy(extra, 0, merged, original.length, extra.length);
        } else {
            merged = original;
        }
        return merged;
    }

    private Object returnAttributeDataStrategyValue(Class<?> attributeType, AttributeStrategy<?> attributeStrategy) throws InstantiationException, IllegalAccessException {
        Object retValue = null;
        Method attributeStrategyMethod = null;
        try {
            attributeStrategyMethod = attributeStrategy.getClass().getMethod("getValue", new Class[0]);
            if (!attributeType.isAssignableFrom(attributeStrategyMethod.getReturnType())) {
                String errMsg = "The type of the Podam Attribute Strategy is not " + attributeType.getName() + " but " + attributeStrategyMethod.getReturnType().getName() + ". An exception will be thrown.";
                LOG.error(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            retValue = attributeStrategy.getValue();
        }
        catch (SecurityException e) {
            throw new IllegalStateException("A security issue occurred while retrieving the Podam Attribute Strategy details", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("It seems the Podam Attribute Annotation is of the wrong type", e);
        }
        return retValue;
    }
}

