/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.ClassInfo;
import uk.co.jemos.podam.common.PodamExclude;

public final class PodamUtils {
    private static final int SETTER_IDENTIFIER_LENGTH = 3;
    private static final Logger LOG = LoggerFactory.getLogger(PodamUtils.class);

    private PodamUtils() {
        throw new AssertionError();
    }

    public static ClassInfo getClassInfo(Class<?> clazz) {
        return PodamUtils.getClassInfo(clazz, null);
    }

    public static ClassInfo getClassInfo(Class<?> clazz, Set<Class<? extends Annotation>> excludeFieldAnnotations) {
        Set<String> classFields = PodamUtils.getDeclaredInstanceFields(clazz, excludeFieldAnnotations);
        Set<Method> classSetters = PodamUtils.getPojoSetters(clazz, classFields);
        return new ClassInfo(clazz, classFields, classSetters);
    }

    public static Set<String> getDeclaredInstanceFields(Class<?> clazz) {
        return PodamUtils.getDeclaredInstanceFields(clazz, null);
    }

    public static Set<String> getDeclaredInstanceFields(Class<?> clazz, Set<Class<? extends Annotation>> excludeAnnotations) {
        if (excludeAnnotations == null) {
            excludeAnnotations = new HashSet<Class<? extends Annotation>>();
        }
        excludeAnnotations.add(PodamExclude.class);
        HashSet<String> classFields = new HashSet<String>();
        for (Class<?> workClass = clazz; workClass != null; workClass = workClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = workClass.getDeclaredFields()) {
                int modifiers;
                if (PodamUtils.containsAnyAnnotation(field, excludeAnnotations) || Modifier.isStatic(modifiers = field.getModifiers())) continue;
                classFields.add(field.getName());
            }
        }
        return classFields;
    }

    public static boolean containsAnyAnnotation(Field field, Set<Class<? extends Annotation>> annotations) {
        Method method = PodamUtils.getGetterFor(field);
        for (Class<? extends Annotation> annotation : annotations) {
            if (field.getAnnotation(annotation) != null) {
                return true;
            }
            if (method == null || method.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }

    public static Method getGetterFor(Field field) {
        String name = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        String methodName = Boolean.TYPE.isAssignableFrom(field.getType()) || Boolean.class.isAssignableFrom(field.getType()) ? "is" + name : "get" + name;
        try {
            return field.getDeclaringClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.debug("No getter {}() for field {}[{}]", new Object[]{methodName, field.getDeclaringClass().getName(), field.getName()});
            if (methodName.startsWith("is")) {
                methodName = "get" + name;
                try {
                    return field.getDeclaringClass().getMethod(methodName, new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    LOG.debug("No getter {}() for field {}[{}]", new Object[]{methodName, field.getDeclaringClass().getName(), field.getName()});
                }
            }
            return null;
        }
    }

    public static Set<Method> getPojoSetters(Class<?> clazz, Set<String> classFields) {
        HashSet<Method> classSetters = new HashSet<Method>();
        for (Class<?> workClass = clazz; workClass != null; workClass = workClass.getSuperclass()) {
            Method[] declaredMethods = workClass.getDeclaredMethods();
            String candidateField = null;
            for (Method method : declaredMethods) {
                if (method.isBridge() || !method.getName().startsWith("set") || !method.getReturnType().equals(Void.TYPE) || !classFields.contains(candidateField = PodamUtils.extractFieldNameFromSetterMethod(method))) continue;
                classSetters.add(method);
            }
        }
        return classSetters;
    }

    public static String extractFieldNameFromSetterMethod(Method method) {
        String candidateField = null;
        candidateField = method.getName().substring(3);
        if (!"".equals(candidateField)) {
            candidateField = Character.toLowerCase(candidateField.charAt(0)) + candidateField.substring(1);
        } else {
            LOG.warn("Encountered method {}. This will be ignored.", (Object)method);
        }
        return candidateField;
    }
}

