/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.api.RandomDataProviderStrategy;
import uk.co.jemos.podam.common.AbstractConstructorComparator;
import uk.co.jemos.podam.common.AbstractMethodComparator;
import uk.co.jemos.podam.common.AttributeStrategy;
import uk.co.jemos.podam.common.ConstructorHeavyFirstComparator;
import uk.co.jemos.podam.common.ConstructorLightFirstComparator;
import uk.co.jemos.podam.common.MethodHeavyFirstComparator;
import uk.co.jemos.podam.common.MethodLightFirstComparator;

@NotThreadSafe
public abstract class AbstractRandomDataProviderStrategy
implements RandomDataProviderStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRandomDataProviderStrategy.class);
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    public static final int MAX_DEPTH = 1;
    private final int maxDepth = 1;
    private int nbrOfCollectionElements;
    private boolean isMemoizationEnabled = true;
    private final ConcurrentMap<Class<?>, ConcurrentMap<Type[], Object>> memoizationTable = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Class<?>> specificTypes = new ConcurrentHashMap();
    private final ConcurrentMap<Class<? extends Annotation>, Class<AttributeStrategy<?>>> attributeStrategies = new ConcurrentHashMap();
    private AbstractConstructorComparator constructorHeavyComparator = ConstructorHeavyFirstComparator.INSTANCE;
    private AbstractConstructorComparator constructorLightComparator = ConstructorLightFirstComparator.INSTANCE;
    private AbstractMethodComparator methodHeavyComparator = MethodHeavyFirstComparator.INSTANCE;
    private AbstractMethodComparator methodLightComparator = MethodLightFirstComparator.INSTANCE;

    public AbstractRandomDataProviderStrategy() {
        this(5);
    }

    public AbstractRandomDataProviderStrategy(int nbrOfCollectionElements) {
        this.nbrOfCollectionElements = nbrOfCollectionElements;
    }

    @Override
    public Boolean getBoolean(AttributeMetadata attributeMetadata) {
        this.log(attributeMetadata);
        return Boolean.TRUE;
    }

    @Override
    public Byte getByte(AttributeMetadata attributeMetadata) {
        byte nextByte;
        this.log(attributeMetadata);
        while ((nextByte = (byte)RANDOM.nextInt(127)) == 0) {
        }
        return nextByte;
    }

    @Override
    public Byte getByteInRange(byte minValue, byte maxValue, AttributeMetadata attributeMetadata) {
        this.log(attributeMetadata);
        return (byte)((double)minValue + Math.random() * (double)(maxValue - minValue) + 0.5);
    }

    @Override
    public Character getCharacter(AttributeMetadata attributeMetadata) {
        this.log(attributeMetadata);
        return PodamUtils.getNiceCharacter();
    }

    @Override
    public Character getCharacterInRange(char minValue, char maxValue, AttributeMetadata attributeMetadata) {
        this.log(attributeMetadata);
        return Character.valueOf((char)((double)minValue + Math.random() * (double)(maxValue - minValue) + 0.5));
    }

    @Override
    public Double getDouble(AttributeMetadata attributeMetadata) {
        double retValue;
        this.log(attributeMetadata);
        while ((retValue = RANDOM.nextDouble()) == 0.0) {
        }
        return retValue;
    }

    @Override
    public Double getDoubleInRange(double minValue, double maxValue, AttributeMetadata attributeMetadata) {
        double retValue;
        this.log(attributeMetadata);
        if (minValue == maxValue) {
            return minValue;
        }
        while ((retValue = minValue + Math.random() * (maxValue - minValue + 1.0)) > maxValue) {
        }
        return retValue;
    }

    @Override
    public Float getFloat(AttributeMetadata attributeMetadata) {
        float retValue;
        this.log(attributeMetadata);
        while ((retValue = RANDOM.nextFloat()) == 0.0f) {
        }
        return Float.valueOf(retValue);
    }

    @Override
    public Float getFloatInRange(float minValue, float maxValue, AttributeMetadata attributeMetadata) {
        float retValue;
        this.log(attributeMetadata);
        if (minValue == maxValue) {
            return Float.valueOf(minValue);
        }
        while ((retValue = (float)((double)minValue + Math.random() * (double)(maxValue - minValue + 1.0f))) > maxValue) {
        }
        return Float.valueOf(retValue);
    }

    @Override
    public Integer getInteger(AttributeMetadata attributeMetadata) {
        Integer retValue;
        this.log(attributeMetadata);
        while ((retValue = Integer.valueOf(RANDOM.nextInt())) == 0) {
        }
        return retValue;
    }

    @Override
    public int getIntegerInRange(int minValue, int maxValue, AttributeMetadata attributeMetadata) {
        this.log(attributeMetadata);
        return (int)((double)minValue + Math.random() * (double)(maxValue - minValue) + 0.5);
    }

    @Override
    public Long getLong(AttributeMetadata attributeMetadata) {
        this.log(attributeMetadata);
        return System.nanoTime();
    }

    @Override
    public Long getLongInRange(long minValue, long maxValue, AttributeMetadata attributeMetadata) {
        this.log(attributeMetadata);
        return PodamUtils.getLongInRange(minValue, maxValue);
    }

    @Override
    public Short getShort(AttributeMetadata attributeMetadata) {
        short retValue;
        this.log(attributeMetadata);
        while ((retValue = (short)RANDOM.nextInt(127)) == 0) {
        }
        return retValue;
    }

    @Override
    public Short getShortInRange(short minValue, short maxValue, AttributeMetadata attributeMetadata) {
        this.log(attributeMetadata);
        return (short)((double)minValue + Math.random() * (double)(maxValue - minValue) + 0.5);
    }

    @Override
    public String getStringValue(AttributeMetadata attributeMetadata) {
        this.log(attributeMetadata);
        return this.getStringOfLength(10, attributeMetadata);
    }

    @Override
    public String getStringOfLength(int length, AttributeMetadata attributeMetadata) {
        this.log(attributeMetadata);
        StringBuilder buff = new StringBuilder();
        while (buff.length() < length) {
            buff.append(this.getCharacter(attributeMetadata));
        }
        return buff.toString();
    }

    @Override
    public int getNumberOfCollectionElements(Class<?> type) {
        return this.nbrOfCollectionElements;
    }

    @Override
    public void setDefaultNumberOfCollectionElements(int newNumberOfCollectionElements) {
        this.nbrOfCollectionElements = newNumberOfCollectionElements;
    }

    @Override
    public int getMaxDepth(Class<?> type) {
        return 1;
    }

    @Override
    public boolean isMemoizationEnabled() {
        return this.isMemoizationEnabled;
    }

    @Override
    public void setMemoization(boolean isMemoizationEnabled) {
        this.isMemoizationEnabled = isMemoizationEnabled;
    }

    @Override
    public Object getMemoizedObject(AttributeMetadata attributeMetadata) {
        ConcurrentMap map;
        Class<?> pojoClass;
        if (this.isMemoizationEnabled && ((pojoClass = attributeMetadata.getPojoClass()) == null || !pojoClass.isArray() && !Collection.class.isAssignableFrom(pojoClass) && !Map.class.isAssignableFrom(pojoClass)) && (map = (ConcurrentMap)this.memoizationTable.get(attributeMetadata.getAttributeType())) != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (!Arrays.equals((Object[])entry.getKey(), attributeMetadata.getAttrGenericArgs())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @Override
    public void cacheMemoizedObject(AttributeMetadata attributeMetadata, Object instance) {
        if (this.isMemoizationEnabled) {
            ConcurrentHashMap<Type[], Object> map = (ConcurrentHashMap<Type[], Object>)this.memoizationTable.get(attributeMetadata.getAttributeType());
            if (map == null) {
                map = new ConcurrentHashMap<Type[], Object>();
                this.memoizationTable.putIfAbsent(attributeMetadata.getAttributeType(), map);
            }
            map.putIfAbsent(attributeMetadata.getAttrGenericArgs(), instance);
        }
    }

    @Override
    public void clearMemoizationCache() {
        this.memoizationTable.clear();
    }

    @Override
    public void sort(Constructor<?>[] constructors, DataProviderStrategy.Order order) {
        AbstractConstructorComparator constructorComparator;
        switch (order) {
            case HEAVY_FIRST: {
                constructorComparator = this.constructorHeavyComparator;
                break;
            }
            default: {
                constructorComparator = this.constructorLightComparator;
            }
        }
        Arrays.sort(constructors, constructorComparator);
    }

    @Override
    public void sort(Method[] methods, DataProviderStrategy.Order order) {
        AbstractMethodComparator methodComparator;
        switch (order) {
            case HEAVY_FIRST: {
                methodComparator = this.methodHeavyComparator;
                break;
            }
            default: {
                methodComparator = this.methodLightComparator;
            }
        }
        Arrays.sort(methods, methodComparator);
    }

    @Override
    public <T> DataProviderStrategy addOrReplaceSpecific(Class<T> abstractClass, Class<? extends T> specificClass) {
        this.specificTypes.put(abstractClass, specificClass);
        return this;
    }

    @Override
    public <T> DataProviderStrategy removeSpecific(Class<T> abstractClass) {
        this.specificTypes.remove(abstractClass);
        return this;
    }

    @Override
    public <T> Class<? extends T> getSpecificClass(Class<T> nonInstantiatableClass) {
        Class<T> found = (Class<T>)this.specificTypes.get(nonInstantiatableClass);
        if (found == null) {
            found = nonInstantiatableClass;
        }
        return found;
    }

    @Override
    public RandomDataProviderStrategy addOrReplaceAttributeStrategy(Class<? extends Annotation> annotationClass, Class<AttributeStrategy<?>> strategyClass) {
        this.attributeStrategies.put(annotationClass, strategyClass);
        return this;
    }

    @Override
    public RandomDataProviderStrategy removeAttributeStrategy(Class<? extends Annotation> annotationClass) {
        this.attributeStrategies.remove(annotationClass);
        return this;
    }

    @Override
    public Class<AttributeStrategy<?>> getStrategyForAnnotation(Class<? extends Annotation> annotationClass) {
        return (Class)this.attributeStrategies.get(annotationClass);
    }

    @Override
    public AbstractConstructorComparator getConstructorLightComparator() {
        return this.constructorLightComparator;
    }

    @Override
    public void setConstructorLightComparator(AbstractConstructorComparator constructorLightComparator) {
        this.constructorLightComparator = constructorLightComparator;
    }

    @Override
    public AbstractConstructorComparator getConstructorHeavyComparator() {
        return this.constructorHeavyComparator;
    }

    @Override
    public void setConstructorHeavyComparator(AbstractConstructorComparator constructorHeavyComparator) {
        this.constructorHeavyComparator = constructorHeavyComparator;
    }

    @Override
    public AbstractMethodComparator getMethodLightComparator() {
        return this.methodLightComparator;
    }

    @Override
    public void setMethodLightComparator(AbstractMethodComparator methodLightComparator) {
        this.methodLightComparator = methodLightComparator;
    }

    @Override
    public AbstractMethodComparator getMethodHeavyComparator() {
        return this.methodHeavyComparator;
    }

    @Override
    public void setMethodHeavyComparator(AbstractMethodComparator methodHeavyComparator) {
        this.methodHeavyComparator = methodHeavyComparator;
    }

    private void log(AttributeMetadata attributeMetadata) {
        LOG.trace("Providing data for attribute {}.{}", (Object)attributeMetadata.getPojoClass().getName(), (Object)(attributeMetadata.getAttributeName() != null ? attributeMetadata.getAttributeName() : ""));
    }
}

