/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.ws.Holder;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandlingException;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.ClassAttribute;
import uk.co.jemos.podam.api.ClassInfo;
import uk.co.jemos.podam.api.ClassInfoStrategy;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.DefaultClassInfoStrategy;
import uk.co.jemos.podam.api.MapArguments;
import uk.co.jemos.podam.api.MapKeyOrElementsArguments;
import uk.co.jemos.podam.api.NullExternalFactory;
import uk.co.jemos.podam.api.ObjectStrategy;
import uk.co.jemos.podam.api.PodamFactory;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.api.RandomDataProviderStrategyImpl;
import uk.co.jemos.podam.common.AttributeStrategy;
import uk.co.jemos.podam.common.ManufacturingContext;
import uk.co.jemos.podam.common.PodamConstants;
import uk.co.jemos.podam.exceptions.PodamMockeryException;
import uk.co.jemos.podam.typeManufacturers.TypeManufacturerUtil;

@NotThreadSafe
@Immutable
public class PodamFactoryImpl
implements PodamFactory {
    private static final String RESOLVING_COLLECTION_EXCEPTION_STR = "An exception occurred while resolving the collection";
    private static final String MAP_CREATION_EXCEPTION_STR = "An exception occurred while creating a Map object";
    private static final String UNCHECKED_STR = "unchecked";
    private static MessageChannel messageChannel;
    private static final Logger LOG;
    private AbstractApplicationContext applicationContext;
    private PodamFactory externalFactory = NullExternalFactory.getInstance();
    private DataProviderStrategy strategy = new RandomDataProviderStrategyImpl();
    private ClassInfoStrategy classInfoStrategy = DefaultClassInfoStrategy.getInstance();

    public PodamFactoryImpl() {
        this(NullExternalFactory.getInstance(), new RandomDataProviderStrategyImpl());
    }

    public PodamFactoryImpl(DataProviderStrategy strategy) {
        this(NullExternalFactory.getInstance(), strategy);
    }

    public PodamFactoryImpl(PodamFactory externalFactory) {
        this(externalFactory, new RandomDataProviderStrategyImpl());
    }

    public PodamFactoryImpl(PodamFactory externalFactory, DataProviderStrategy strategy) {
        this.externalFactory = externalFactory;
        this.strategy = strategy;
        this.applicationContext = new ClassPathXmlApplicationContext("META-INF/spring/podam-config.xml");
        messageChannel = (MessageChannel)this.applicationContext.getBean("podamInputChannel", MessageChannel.class);
    }

    @Override
    public <T> T manufacturePojoWithFullData(Class<T> pojoClass, Type ... genericTypeArgs) {
        ManufacturingContext manufacturingCtx = new ManufacturingContext();
        manufacturingCtx.getPojos().put(pojoClass, 0);
        manufacturingCtx.setConstructorOrdering(DataProviderStrategy.Order.HEAVY_FIRST);
        try {
            Class<?> declaringClass = null;
            AttributeMetadata pojoMetadata = new AttributeMetadata(pojoClass, genericTypeArgs, declaringClass);
            return this.manufacturePojoInternal(pojoClass, pojoMetadata, manufacturingCtx, genericTypeArgs);
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
    }

    @Override
    public <T> T manufacturePojo(Class<T> pojoClass, Type ... genericTypeArgs) {
        ManufacturingContext manufacturingCtx = new ManufacturingContext();
        manufacturingCtx.getPojos().put(pojoClass, 0);
        try {
            Class<?> declaringClass = null;
            AttributeMetadata pojoMetadata = new AttributeMetadata(pojoClass, genericTypeArgs, declaringClass);
            return this.manufacturePojoInternal(pojoClass, pojoMetadata, manufacturingCtx, genericTypeArgs);
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
    }

    @Override
    public <T> T populatePojo(T pojo, Type ... genericTypeArgs) {
        ManufacturingContext manufacturingCtx = new ManufacturingContext();
        manufacturingCtx.getPojos().put(pojo.getClass(), 0);
        HashMap<String, Type> typeArgsMap = new HashMap<String, Type>();
        Type[] genericTypeArgsExtra = TypeManufacturerUtil.fillTypeArgMap(typeArgsMap, pojo.getClass(), genericTypeArgs);
        try {
            return this.populatePojoInternal(pojo, manufacturingCtx, typeArgsMap, genericTypeArgsExtra);
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
    }

    @Override
    public DataProviderStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public PodamFactory setStrategy(DataProviderStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    @Override
    public ClassInfoStrategy getClassStrategy() {
        return this.classInfoStrategy;
    }

    @Override
    public PodamFactory setClassStrategy(ClassInfoStrategy classInfoStrategy) {
        this.classInfoStrategy = classInfoStrategy;
        return this;
    }

    @Override
    public PodamFactory getExternalFactory() {
        return this.externalFactory;
    }

    @Override
    public PodamFactory setExternalFactory(PodamFactory externalFactory) {
        this.externalFactory = externalFactory;
        return this;
    }

    private Object instantiatePojoWithoutConstructors(Class<?> pojoClass, ManufacturingContext manufacturingCtx, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object retValue = null;
        Method[] declaredMethods = pojoClass.getDeclaredMethods();
        this.strategy.sort(declaredMethods, manufacturingCtx.getConstructorOrdering());
        Object[] parameterValues = null;
        for (Method candidateConstructor : declaredMethods) {
            if (!Modifier.isStatic(candidateConstructor.getModifiers()) || !candidateConstructor.getReturnType().equals(pojoClass) || retValue != null) continue;
            parameterValues = this.getParameterValuesForMethod(candidateConstructor, pojoClass, manufacturingCtx, typeArgsMap, genericTypeArgs);
            try {
                retValue = candidateConstructor.invoke(pojoClass, parameterValues);
                LOG.debug("Could create an instance using " + candidateConstructor);
                if (retValue == null) continue;
                break;
            }
            catch (Exception t) {
                LOG.debug("PODAM could not create an instance for constructor: " + candidateConstructor + ". Will try another one...", (Throwable)t);
            }
        }
        if (retValue == null) {
            LOG.debug("For class {} PODAM could not possibly create a value statically. Will try other means.", pojoClass);
        }
        return retValue;
    }

    private <T> T instantiatePojo(Class<T> pojoClass, ManufacturingContext manufacturingCtx, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) throws SecurityException {
        Object retValue = null;
        Constructor<?>[] constructors = pojoClass.getConstructors();
        if (constructors.length == 0 || Modifier.isAbstract(pojoClass.getModifiers())) {
            try {
                retValue = this.instantiatePojoWithoutConstructors(pojoClass, manufacturingCtx, typeArgsMap, genericTypeArgs);
            }
            catch (Exception e) {
                LOG.debug("We couldn't create an instance for pojo: " + pojoClass + " with factory methods, will " + " try non-public constructors.", (Throwable)e);
            }
            if (retValue == null) {
                constructors = pojoClass.getDeclaredConstructors();
            }
        }
        if (retValue == null && constructors.length > 0) {
            this.strategy.sort(constructors, manufacturingCtx.getConstructorOrdering());
            for (Constructor<?> constructor : constructors) {
                try {
                    Object[] parameterValues = this.getParameterValuesForConstructor(constructor, pojoClass, manufacturingCtx, typeArgsMap, genericTypeArgs);
                    if (!constructor.isAccessible()) {
                        constructor.setAccessible(true);
                    }
                    if ((retValue = constructor.newInstance(parameterValues)) == null) continue;
                    LOG.debug("We could create an instance with constructor: " + constructor);
                    break;
                }
                catch (Exception e) {
                    LOG.debug("We couldn't create an instance for pojo: {} with constructor: {}. Will try with another one.", new Object[]{pojoClass, constructor, e});
                }
            }
        }
        if (retValue == null) {
            LOG.debug("For class {} PODAM could not possibly create a value. Will try other means.", pojoClass);
        }
        return (T)retValue;
    }

    private <T> T manufacturePojoInternal(Class<T> pojoClass, AttributeMetadata pojoMetadata, ManufacturingContext manufacturingCtx, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        LOG.debug("Manufacturing {} with parameters {}", pojoClass, (Object)Arrays.toString(genericTypeArgs));
        T retValue = null;
        Object objectToReuse = this.strategy.getMemoizedObject(pojoMetadata);
        if (objectToReuse != null) {
            LOG.debug("Fetched memoized object for {}", pojoClass);
            return (T)objectToReuse;
        }
        if (pojoClass.isEnum()) {
            return (T)TypeManufacturerUtil.getTypeValue(this.strategy, messageChannel, pojoMetadata, "Enumeration");
        }
        if (pojoClass.isPrimitive()) {
            return (T)TypeManufacturerUtil.getTypeValue(this.strategy, messageChannel, pojoMetadata, pojoClass.getName());
        }
        if (pojoClass.isInterface()) {
            return this.getValueForAbstractType(pojoClass, pojoMetadata, manufacturingCtx, genericTypeArgs);
        }
        HashMap<String, Type> typeArgsMap = new HashMap<String, Type>();
        Type[] genericTypeArgsExtra = TypeManufacturerUtil.fillTypeArgMap(typeArgsMap, pojoClass, genericTypeArgs);
        try {
            retValue = this.instantiatePojo(pojoClass, manufacturingCtx, typeArgsMap, genericTypeArgsExtra);
        }
        catch (SecurityException e) {
            throw new PodamMockeryException("Security exception while applying introspection.", e);
        }
        if (retValue == null) {
            return this.getValueForAbstractType(pojoClass, pojoMetadata, manufacturingCtx, genericTypeArgs);
        }
        this.strategy.cacheMemoizedObject(pojoMetadata, retValue);
        if (retValue != null) {
            this.populatePojoInternal(retValue, manufacturingCtx, typeArgsMap, genericTypeArgsExtra);
        }
        return retValue;
    }

    private <T> T populatePojoInternal(T pojo, ManufacturingContext manufacturingCtx, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> pojoClass = pojo.getClass();
        if (pojo instanceof Collection && ((Collection)pojo).size() == 0) {
            this.fillCollection((Collection)pojo, manufacturingCtx, typeArgsMap, genericTypeArgs);
        } else if (pojo instanceof Map && ((Map)pojo).size() == 0) {
            this.fillMap((Map)pojo, manufacturingCtx, typeArgsMap, genericTypeArgs);
        }
        Class<?>[] parameterTypes = null;
        Class attributeType = null;
        ClassInfo classInfo = this.classInfoStrategy.getClassInfo(pojo.getClass());
        Set<ClassAttribute> classAttributes = classInfo.getClassAttributes();
        Object setterArg = null;
        Iterator<ClassAttribute> iter = classAttributes.iterator();
        while (iter.hasNext()) {
            ClassAttribute attribute = iter.next();
            Set<Method> setters = attribute.getSetters();
            if (setters.isEmpty()) {
                if (!attribute.getGetters().isEmpty()) continue;
                iter.remove();
                continue;
            }
            iter.remove();
            Method setter = null;
            for (Method current : setters) {
                if (setter != null && !setter.getDeclaringClass().isAssignableFrom(current.getDeclaringClass())) continue;
                setter = current;
            }
            parameterTypes = setter.getParameterTypes();
            if (parameterTypes.length != 1) {
                LOG.warn("Skipping setter with non-single arguments {}", (Object)setter);
                continue;
            }
            attributeType = parameterTypes[0];
            String attributeName = PodamUtils.extractFieldNameFromSetterMethod(setter);
            List<Annotation> pojoAttributeAnnotations = PodamUtils.getAttributeAnnotations(attribute.getAttribute(), setter);
            AttributeStrategy<?> attributeStrategy = TypeManufacturerUtil.findAttributeStrategy(this.strategy, pojoAttributeAnnotations, attributeType);
            if (null != attributeStrategy) {
                LOG.debug("The attribute: " + attributeName + " will be filled using the following strategy: " + attributeStrategy);
                setterArg = TypeManufacturerUtil.returnAttributeDataStrategyValue(attributeType, attributeStrategy);
            } else {
                Type[] typeArguments = PodamConstants.NO_TYPES;
                Type genericType = setter.getGenericParameterTypes()[0];
                if (genericType instanceof ParameterizedType) {
                    ParameterizedType attributeParameterizedType = (ParameterizedType)genericType;
                    typeArguments = attributeParameterizedType.getActualTypeArguments();
                } else if (genericType instanceof TypeVariable) {
                    TypeVariable typeVariable = (TypeVariable)genericType;
                    Type type = typeArgsMap.get(typeVariable.getName());
                    if (type instanceof ParameterizedType) {
                        ParameterizedType attributeParameterizedType = (ParameterizedType)type;
                        typeArguments = attributeParameterizedType.getActualTypeArguments();
                        attributeType = (Class)attributeParameterizedType.getRawType();
                    } else {
                        attributeType = (Class)type;
                    }
                }
                AtomicReference<Type[]> typeGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
                for (int i = 0; i < typeArguments.length; ++i) {
                    Class<?> resolvedType;
                    if (!(typeArguments[i] instanceof TypeVariable) || Collection.class.isAssignableFrom(resolvedType = TypeManufacturerUtil.resolveGenericParameter(typeArguments[i], typeArgsMap, typeGenericTypeArgs)) || Map.class.isAssignableFrom(resolvedType)) continue;
                    typeArguments[i] = resolvedType;
                }
                setterArg = this.manufactureAttributeValue(pojo, manufacturingCtx, attributeType, genericType, pojoAttributeAnnotations, attributeName, typeArgsMap, typeArguments);
            }
            try {
                setter.invoke(pojo, setterArg);
            }
            catch (IllegalAccessException e) {
                LOG.warn("{} is not accessible. Setting it to accessible. However this is a security hack and your code should really adhere to JavaBeans standards.", (Object)setter.toString());
                setter.setAccessible(true);
                setter.invoke(pojo, setterArg);
            }
        }
        for (ClassAttribute readOnlyAttribute : classAttributes) {
            Method getter = readOnlyAttribute.getGetters().iterator().next();
            if (getter == null || getter.getReturnType().isPrimitive()) continue;
            if (getter.getGenericParameterTypes().length == 0) {
                Type[] genericTypeArgsAll;
                Map<String, Type> paramTypeArgsMap;
                Object fieldValue = null;
                try {
                    fieldValue = getter.invoke(pojo, PodamConstants.NO_ARGS);
                }
                catch (Exception e) {
                    LOG.debug("Cannot access {}, skipping", (Object)getter);
                }
                if (fieldValue == null) continue;
                LOG.debug("Populating read-only field {}", (Object)getter);
                if (getter.getGenericReturnType() instanceof ParameterizedType) {
                    paramTypeArgsMap = new HashMap<String, Type>(typeArgsMap);
                    ParameterizedType paramType = (ParameterizedType)getter.getGenericReturnType();
                    Type[] actualTypes = paramType.getActualTypeArguments();
                    TypeManufacturerUtil.fillTypeArgMap(paramTypeArgsMap, getter.getReturnType(), actualTypes);
                    genericTypeArgsAll = TypeManufacturerUtil.fillTypeArgMap(paramTypeArgsMap, getter.getReturnType(), genericTypeArgs);
                } else {
                    paramTypeArgsMap = typeArgsMap;
                    genericTypeArgsAll = genericTypeArgs;
                }
                Class<?> fieldClass = fieldValue.getClass();
                Integer depth = manufacturingCtx.getPojos().get(fieldClass);
                if (depth == null) {
                    depth = -1;
                }
                if (depth <= this.strategy.getMaxDepth(fieldClass)) {
                    manufacturingCtx.getPojos().put(fieldClass, depth + 1);
                    this.populatePojoInternal(fieldValue, manufacturingCtx, paramTypeArgsMap, genericTypeArgsAll);
                    manufacturingCtx.getPojos().put(fieldClass, depth);
                    continue;
                }
                LOG.warn("Loop in filling read-only field {} detected.", (Object)getter);
                continue;
            }
            LOG.warn("Skipping invalid getter {}", (Object)getter);
        }
        Collection<Method> extraMethods = this.classInfoStrategy.getExtraMethods(pojoClass);
        if (null != extraMethods) {
            for (Method extraMethod : extraMethods) {
                Object[] args = this.getParameterValuesForMethod(extraMethod, pojoClass, manufacturingCtx, typeArgsMap, genericTypeArgs);
                extraMethod.invoke(pojo, args);
            }
        }
        return pojo;
    }

    private Object manufactureAttributeValue(Object pojo, ManufacturingContext manufacturingCtx, Class<?> attributeType, Type genericAttributeType, List<Annotation> annotations, String attributeName, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, MessageHandlingException {
        Class<?> realAttributeType;
        Class<?> pojoClass;
        Object attributeValue = null;
        Class<?> clazz = pojoClass = pojo instanceof Class ? (Class<?>)pojo : pojo.getClass();
        if (Object.class.equals(attributeType) && attributeType != genericAttributeType) {
            AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
            realAttributeType = TypeManufacturerUtil.resolveGenericParameter(genericAttributeType, typeArgsMap, elementGenericTypeArgs);
        } else {
            realAttributeType = attributeType;
        }
        AttributeMetadata attributeMetadata = new AttributeMetadata(attributeName, realAttributeType, genericTypeArgs, annotations, pojoClass);
        if (realAttributeType.isPrimitive() || TypeManufacturerUtil.isWrapper(realAttributeType) || realAttributeType.equals(String.class)) {
            attributeValue = TypeManufacturerUtil.getTypeValue(this.strategy, messageChannel, attributeMetadata, realAttributeType.getName());
        } else if (realAttributeType.isArray()) {
            attributeValue = this.resolveArrayElementValue(realAttributeType, genericAttributeType, attributeName, manufacturingCtx, annotations, pojo, typeArgsMap);
        } else if (Collection.class.isAssignableFrom(realAttributeType)) {
            attributeValue = this.resolveCollectionValueWhenCollectionIsPojoAttribute(pojo, manufacturingCtx, realAttributeType, attributeName, annotations, typeArgsMap, genericTypeArgs);
        } else if (Map.class.isAssignableFrom(realAttributeType)) {
            attributeValue = this.resolveMapValueWhenMapIsPojoAttribute(pojo, manufacturingCtx, realAttributeType, attributeName, annotations, typeArgsMap, genericTypeArgs);
        } else if (realAttributeType.isEnum()) {
            attributeValue = TypeManufacturerUtil.getTypeValue(this.strategy, messageChannel, attributeMetadata, "Enumeration");
        } else if (Type.class.isAssignableFrom(realAttributeType)) {
            attributeValue = TypeManufacturerUtil.getTypeValueForGenericTypes(this.strategy, messageChannel, attributeMetadata, genericAttributeType, typeArgsMap, "GenericType");
        }
        if (attributeValue == null) {
            Type[] typeParams = attributeType.getTypeParameters();
            Type[] genericTypeArgsAll = TypeManufacturerUtil.mergeActualAndSuppliedGenericTypes(typeParams, genericTypeArgs, typeArgsMap);
            Integer depth = manufacturingCtx.getPojos().get(realAttributeType);
            if (depth == null) {
                depth = -1;
            }
            if (depth <= this.strategy.getMaxDepth(pojoClass)) {
                manufacturingCtx.getPojos().put(realAttributeType, depth + 1);
                attributeValue = this.manufacturePojoInternal(realAttributeType, attributeMetadata, manufacturingCtx, genericTypeArgsAll);
                manufacturingCtx.getPojos().put(realAttributeType, depth);
            } else {
                attributeValue = this.resortToExternalFactory(manufacturingCtx, "Loop in {} production detected. Resorting to {} external factory", realAttributeType, genericTypeArgsAll);
            }
        }
        return attributeValue;
    }

    private <T> T resortToExternalFactory(ManufacturingContext manufacturingCtx, String msg, Class<T> pojoClass, Type ... genericTypeArgs) {
        LOG.warn(msg, pojoClass, (Object)this.externalFactory.getClass().getName());
        if (manufacturingCtx.getConstructorOrdering() == DataProviderStrategy.Order.HEAVY_FIRST) {
            return this.externalFactory.manufacturePojoWithFullData(pojoClass, genericTypeArgs);
        }
        return this.externalFactory.manufacturePojo(pojoClass, genericTypeArgs);
    }

    private Collection<? super Object> resolveCollectionValueWhenCollectionIsPojoAttribute(Object pojo, ManufacturingContext manufacturingCtx, Class<?> collectionType, String attributeName, List<Annotation> annotations, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) {
        Collection retValue = null;
        if (null != pojo && null != attributeName) {
            retValue = (Collection)PodamUtils.getFieldValue(pojo, attributeName);
        }
        if (null == (retValue = TypeManufacturerUtil.resolveCollectionType(collectionType, retValue))) {
            return null;
        }
        try {
            Class<Object> typeClass = null;
            AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
            if (genericTypeArgs == null || genericTypeArgs.length == 0) {
                LOG.warn("The collection attribute: " + attributeName + " does not have a type. We will assume Object for you");
                typeClass = Object.class;
            } else {
                Type actualTypeArgument = genericTypeArgs[0];
                typeClass = TypeManufacturerUtil.resolveGenericParameter(actualTypeArgument, typeArgsMap, elementGenericTypeArgs);
            }
            this.fillCollection(manufacturingCtx, annotations, attributeName, retValue, typeClass, elementGenericTypeArgs.get());
        }
        catch (SecurityException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        catch (IllegalArgumentException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        return retValue;
    }

    private void fillCollection(Collection<? super Object> collection, ManufacturingContext manufacturingCtx, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> pojoClass = collection.getClass();
        Annotation[] annotations = collection.getClass().getAnnotations();
        AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
        Class<?> collectionClass = pojoClass;
        Type[] typeParams = collectionClass.getTypeParameters();
        block0: while (typeParams.length < 1) {
            Class<?> clazz;
            for (Type genericIface : collectionClass.getGenericInterfaces()) {
                Class<?> clazz2 = TypeManufacturerUtil.resolveGenericParameter(genericIface, typeArgsMap, elementGenericTypeArgs);
                if (!Collection.class.isAssignableFrom(clazz2)) continue;
                collectionClass = clazz2;
                typeParams = elementGenericTypeArgs.get();
                continue block0;
            }
            Type type = collectionClass.getGenericSuperclass();
            if (type != null && Collection.class.isAssignableFrom(clazz = TypeManufacturerUtil.resolveGenericParameter(type, typeArgsMap, elementGenericTypeArgs))) {
                collectionClass = clazz;
                typeParams = elementGenericTypeArgs.get();
                continue;
            }
            if (!Collection.class.equals(collectionClass)) continue;
            LOG.warn("Collection {} doesn't have generic types,will use Object instead", pojoClass);
            typeParams = new Type[]{Object.class};
        }
        Class<?> elementTypeClass = TypeManufacturerUtil.resolveGenericParameter(typeParams[0], typeArgsMap, elementGenericTypeArgs);
        Type[] elementGenericArgs = TypeManufacturerUtil.mergeTypeArrays(elementGenericTypeArgs.get(), genericTypeArgs);
        String attributeName = null;
        this.fillCollection(manufacturingCtx, Arrays.asList(annotations), attributeName, collection, elementTypeClass, elementGenericArgs);
    }

    private void fillCollection(ManufacturingContext manufacturingCtx, List<Annotation> annotations, String attributeName, Collection<? super Object> collection, Class<?> collectionElementType, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Holder elementStrategyHolder = new Holder();
        Holder<AttributeStrategy<?>> keyStrategyHolder = null;
        Integer nbrElements = TypeManufacturerUtil.findCollectionSize(this.strategy, annotations, collectionElementType, elementStrategyHolder, keyStrategyHolder);
        AttributeStrategy elementStrategy = (AttributeStrategy)elementStrategyHolder.value;
        try {
            if (collection.size() > nbrElements) {
                collection.clear();
            }
            for (int i = collection.size(); i < nbrElements; ++i) {
                Object element;
                if (null != elementStrategy && elementStrategy instanceof ObjectStrategy && Object.class.equals(collectionElementType)) {
                    LOG.debug("Element strategy is ObjectStrategy and collection element is of type Object: using the ObjectStrategy strategy");
                    element = elementStrategy.getValue();
                } else if (null != elementStrategy && !(elementStrategy instanceof ObjectStrategy)) {
                    LOG.debug("Collection elements will be filled using the following strategy: " + elementStrategy);
                    element = TypeManufacturerUtil.returnAttributeDataStrategyValue(collectionElementType, elementStrategy);
                } else {
                    HashMap<String, Type> nullTypeArgsMap = new HashMap<String, Type>();
                    element = this.manufactureAttributeValue(collection, manufacturingCtx, collectionElementType, collectionElementType, annotations, attributeName, nullTypeArgsMap, genericTypeArgs);
                }
                collection.add(element);
            }
        }
        catch (UnsupportedOperationException e) {
            LOG.warn("Cannot fill immutable collection {}", collection.getClass());
        }
    }

    private Map<? super Object, ? super Object> resolveMapValueWhenMapIsPojoAttribute(Object pojo, ManufacturingContext manufacturingCtx, Class<?> attributeType, String attributeName, List<Annotation> annotations, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) {
        Map retValue = null;
        if (null != pojo && null != attributeName) {
            retValue = (Map)PodamUtils.getFieldValue(pojo, attributeName);
        }
        if (null == (retValue = TypeManufacturerUtil.resolveMapType(attributeType, retValue))) {
            return null;
        }
        try {
            Class keyClass = null;
            Class elementClass = null;
            AtomicReference<Type[]> keyGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
            AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
            if (genericTypeArgs == null || genericTypeArgs.length == 0) {
                LOG.warn("Map attribute: " + attributeName + " is non-generic. We will assume a Map<Object, Object> for you.");
                keyClass = Object.class;
                elementClass = Object.class;
            } else {
                if (genericTypeArgs.length != 2) {
                    throw new IllegalStateException("In a Map only key value generic type are expected.");
                }
                Type[] actualTypeArguments = genericTypeArgs;
                keyClass = TypeManufacturerUtil.resolveGenericParameter(actualTypeArguments[0], typeArgsMap, keyGenericTypeArgs);
                elementClass = TypeManufacturerUtil.resolveGenericParameter(actualTypeArguments[1], typeArgsMap, elementGenericTypeArgs);
            }
            MapArguments mapArguments = new MapArguments();
            mapArguments.setAttributeName(attributeName);
            mapArguments.setAnnotations(annotations);
            mapArguments.setMapToBeFilled(retValue);
            mapArguments.setKeyClass(keyClass);
            mapArguments.setElementClass(elementClass);
            mapArguments.setKeyGenericTypeArgs(keyGenericTypeArgs.get());
            mapArguments.setElementGenericTypeArgs(elementGenericTypeArgs.get());
            this.fillMap(mapArguments, manufacturingCtx);
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException(MAP_CREATION_EXCEPTION_STR, e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException(MAP_CREATION_EXCEPTION_STR, e);
        }
        catch (SecurityException e) {
            throw new PodamMockeryException(MAP_CREATION_EXCEPTION_STR, e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException(MAP_CREATION_EXCEPTION_STR, e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException(MAP_CREATION_EXCEPTION_STR, e);
        }
        return retValue;
    }

    private void fillMap(Map<? super Object, ? super Object> map, ManufacturingContext manufacturingCtx, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> pojoClass;
        Class<?> mapClass = pojoClass = map.getClass();
        AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
        Type[] typeParams = mapClass.getTypeParameters();
        block0: while (typeParams.length < 2) {
            Class<?> clazz;
            for (Type genericIface : mapClass.getGenericInterfaces()) {
                Class<?> clazz2 = TypeManufacturerUtil.resolveGenericParameter(genericIface, typeArgsMap, elementGenericTypeArgs);
                if (!Map.class.isAssignableFrom(clazz2)) continue;
                typeParams = elementGenericTypeArgs.get();
                mapClass = clazz2;
                continue block0;
            }
            Type type = mapClass.getGenericSuperclass();
            if (type != null && Map.class.isAssignableFrom(clazz = TypeManufacturerUtil.resolveGenericParameter(type, typeArgsMap, elementGenericTypeArgs))) {
                typeParams = elementGenericTypeArgs.get();
                mapClass = clazz;
                continue;
            }
            if (!Map.class.equals(mapClass)) continue;
            LOG.warn("Map {} doesn't have generic types,will use Object, Object instead", pojoClass);
            typeParams = new Type[]{Object.class, Object.class};
        }
        AtomicReference<Type[]> keyGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
        Class<?> keyClass = TypeManufacturerUtil.resolveGenericParameter(typeParams[0], typeArgsMap, keyGenericTypeArgs);
        Class<?> elementClass = TypeManufacturerUtil.resolveGenericParameter(typeParams[1], typeArgsMap, elementGenericTypeArgs);
        Type[] keyGenericArgs = TypeManufacturerUtil.mergeTypeArrays(keyGenericTypeArgs.get(), genericTypeArgs);
        Type[] elementGenericArgs = TypeManufacturerUtil.mergeTypeArrays(elementGenericTypeArgs.get(), genericTypeArgs);
        MapArguments mapArguments = new MapArguments();
        mapArguments.setAnnotations(Arrays.asList(pojoClass.getAnnotations()));
        mapArguments.setMapToBeFilled(map);
        mapArguments.setKeyClass(keyClass);
        mapArguments.setElementClass(elementClass);
        mapArguments.setKeyGenericTypeArgs(keyGenericArgs);
        mapArguments.setElementGenericTypeArgs(elementGenericArgs);
        this.fillMap(mapArguments, manufacturingCtx);
    }

    private void fillMap(MapArguments mapArguments, ManufacturingContext manufacturingCtx) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Holder elementStrategyHolder = new Holder();
        Holder keyStrategyHolder = new Holder();
        Integer nbrElements = TypeManufacturerUtil.findCollectionSize(this.strategy, mapArguments.getAnnotations(), mapArguments.getElementClass(), elementStrategyHolder, keyStrategyHolder);
        AttributeStrategy keyStrategy = (AttributeStrategy)keyStrategyHolder.value;
        AttributeStrategy elementStrategy = (AttributeStrategy)elementStrategyHolder.value;
        Map<? super Object, ? super Object> map = mapArguments.getMapToBeFilled();
        try {
            if (map.size() > nbrElements) {
                map.clear();
            }
            for (int i = map.size(); i < nbrElements; ++i) {
                Object keyValue = null;
                Object elementValue = null;
                MapKeyOrElementsArguments valueArguments = new MapKeyOrElementsArguments();
                valueArguments.setAttributeName(mapArguments.getAttributeName());
                valueArguments.setMapToBeFilled(mapArguments.getMapToBeFilled());
                valueArguments.setAnnotations(mapArguments.getAnnotations());
                valueArguments.setKeyOrValueType(mapArguments.getKeyClass());
                valueArguments.setElementStrategy(keyStrategy);
                valueArguments.setGenericTypeArgs(mapArguments.getKeyGenericTypeArgs());
                keyValue = this.getMapKeyOrElementValue(valueArguments, manufacturingCtx);
                valueArguments.setKeyOrValueType(mapArguments.getElementClass());
                valueArguments.setElementStrategy(elementStrategy);
                valueArguments.setGenericTypeArgs(mapArguments.getElementGenericTypeArgs());
                elementValue = this.getMapKeyOrElementValue(valueArguments, manufacturingCtx);
                if (elementValue == null && map instanceof ConcurrentHashMap) continue;
                map.put(keyValue, elementValue);
            }
        }
        catch (UnsupportedOperationException e) {
            LOG.warn("Cannot fill immutable map {}", map.getClass());
        }
    }

    private Object getMapKeyOrElementValue(MapKeyOrElementsArguments keyOrElementsArguments, ManufacturingContext manufacturingCtx) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object retValue = null;
        if (null != keyOrElementsArguments.getElementStrategy() && ObjectStrategy.class.isAssignableFrom(keyOrElementsArguments.getElementStrategy().getClass()) && Object.class.equals(keyOrElementsArguments.getKeyOrValueType())) {
            LOG.debug("Element strategy is ObjectStrategy and Map key or value type is of type Object: using the ObjectStrategy strategy");
            retValue = keyOrElementsArguments.getElementStrategy().getValue();
        } else if (null != keyOrElementsArguments.getElementStrategy() && !ObjectStrategy.class.isAssignableFrom(keyOrElementsArguments.getElementStrategy().getClass())) {
            LOG.debug("Map key or value will be filled using the following strategy: " + keyOrElementsArguments.getElementStrategy());
            retValue = TypeManufacturerUtil.returnAttributeDataStrategyValue(keyOrElementsArguments.getKeyOrValueType(), keyOrElementsArguments.getElementStrategy());
        } else {
            HashMap<String, Type> nullTypeArgsMap = new HashMap<String, Type>();
            retValue = this.manufactureAttributeValue(keyOrElementsArguments.getMapToBeFilled(), manufacturingCtx, keyOrElementsArguments.getKeyOrValueType(), keyOrElementsArguments.getKeyOrValueType(), keyOrElementsArguments.getAnnotations(), keyOrElementsArguments.getAttributeName(), nullTypeArgsMap, keyOrElementsArguments.getGenericTypeArgs());
        }
        return retValue;
    }

    private Object resolveArrayElementValue(Class<?> attributeType, Type genericType, String attributeName, ManufacturingContext manufacturingCtx, List<Annotation> annotations, Object pojo, Map<String, Type> typeArgsMap) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> componentType = null;
        Class<?> genericComponentType = null;
        AtomicReference<Type[]> genericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
        if (genericType instanceof GenericArrayType) {
            genericComponentType = ((GenericArrayType)genericType).getGenericComponentType();
            if (genericComponentType instanceof TypeVariable) {
                TypeVariable componentTypeVariable = (TypeVariable)((Object)genericComponentType);
                Type resolvedType = typeArgsMap.get(componentTypeVariable.getName());
                componentType = TypeManufacturerUtil.resolveGenericParameter(resolvedType, typeArgsMap, genericTypeArgs);
            }
        } else if (genericType instanceof Class) {
            Class arrayClass = (Class)genericType;
            genericComponentType = arrayClass.getComponentType();
        } else {
            genericComponentType = attributeType.getComponentType();
        }
        if (componentType == null) {
            componentType = attributeType.getComponentType();
        }
        Holder elementStrategyHolder = new Holder();
        Holder<AttributeStrategy<?>> keyStrategyHolder = null;
        Integer nbrElements = TypeManufacturerUtil.findCollectionSize(this.strategy, annotations, attributeType, elementStrategyHolder, keyStrategyHolder);
        AttributeStrategy elementStrategy = (AttributeStrategy)elementStrategyHolder.value;
        Object arrayElement = null;
        Object array = Array.newInstance(componentType, (int)nbrElements);
        for (int i = 0; i < nbrElements; ++i) {
            if (null != elementStrategy && elementStrategy instanceof ObjectStrategy && Object.class.equals(componentType)) {
                LOG.debug("Element strategy is ObjectStrategy and array element is of type Object: using the ObjectStrategy strategy");
                arrayElement = elementStrategy.getValue();
            } else if (null != elementStrategy && !(elementStrategy instanceof ObjectStrategy)) {
                LOG.debug("Array elements will be filled using the following strategy: " + elementStrategy);
                arrayElement = TypeManufacturerUtil.returnAttributeDataStrategyValue(componentType, elementStrategy);
            } else {
                arrayElement = this.manufactureAttributeValue(array, manufacturingCtx, componentType, genericComponentType, annotations, attributeName, typeArgsMap, genericTypeArgs.get());
            }
            Array.set(array, i, arrayElement);
        }
        return array;
    }

    private Object[] getParameterValuesForConstructor(Constructor<?> constructor, Class<?> pojoClass, ManufacturingContext manufacturingCtx, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object[] parameterValues;
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length == 0) {
            parameterValues = PodamConstants.NO_ARGS;
        } else {
            parameterValues = new Object[parameterTypes.length];
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            Type[] genericTypes = constructor.getGenericParameterTypes();
            for (int idx = 0; idx < parameterTypes.length; ++idx) {
                List<Annotation> annotations = Arrays.asList(parameterAnnotations[idx]);
                Class<?> genericType = idx < genericTypes.length ? genericTypes[idx] : parameterTypes[idx];
                parameterValues[idx] = this.manufactureParameterValue(pojoClass, parameterTypes[idx], genericType, annotations, typeArgsMap, manufacturingCtx, genericTypeArgs);
            }
        }
        return parameterValues;
    }

    private Object[] getParameterValuesForMethod(Method method, Class<?> pojoClass, ManufacturingContext manufacturingCtx, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object[] parameterValues;
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            parameterValues = PodamConstants.NO_ARGS;
        } else {
            parameterValues = new Object[parameterTypes.length];
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            Type[] genericTypes = method.getGenericParameterTypes();
            for (int idx = 0; idx < parameterTypes.length; ++idx) {
                List<Annotation> annotations = Arrays.asList(parameterAnnotations[idx]);
                Class<?> genericType = idx < genericTypes.length ? genericTypes[idx] : parameterTypes[idx];
                parameterValues[idx] = this.manufactureParameterValue(pojoClass, parameterTypes[idx], genericType, annotations, typeArgsMap, manufacturingCtx, genericTypeArgs);
            }
        }
        return parameterValues;
    }

    private Object manufactureParameterValue(Class<?> pojoClass, Class<?> parameterType, Type genericType, List<Annotation> annotations, Map<String, Type> typeArgsMap, ManufacturingContext manufacturingCtx, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Map<? super Object, ? super Object> map;
        Map<? super Object, ? super Object> defaultValue;
        Object parameterValue = null;
        AttributeStrategy<?> attributeStrategy = TypeManufacturerUtil.findAttributeStrategy(this.strategy, annotations, parameterType);
        if (null != attributeStrategy) {
            LOG.debug("The parameter: " + genericType + " will be filled using the following strategy: " + attributeStrategy);
            return TypeManufacturerUtil.returnAttributeDataStrategyValue(parameterType, attributeStrategy);
        }
        if (Collection.class.isAssignableFrom(parameterType)) {
            defaultValue = null;
            Collection<? super Object> collection = TypeManufacturerUtil.resolveCollectionType(parameterType, defaultValue);
            if (collection != null) {
                Class collectionElementType;
                AtomicReference<Type[]> collectionGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
                if (genericType instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)genericType;
                    Type actualTypeArgument = pType.getActualTypeArguments()[0];
                    collectionElementType = TypeManufacturerUtil.resolveGenericParameter(actualTypeArgument, typeArgsMap, collectionGenericTypeArgs);
                } else {
                    LOG.warn("Collection parameter {} type is non-generic.We will assume a Collection<Object> for you.", (Object)genericType);
                    collectionElementType = Object.class;
                }
                Type[] genericTypeArgsAll = TypeManufacturerUtil.mergeTypeArrays(collectionGenericTypeArgs.get(), genericTypeArgs);
                String attributeName = null;
                this.fillCollection(manufacturingCtx, annotations, attributeName, collection, collectionElementType, genericTypeArgsAll);
                parameterValue = collection;
            }
        } else if (Map.class.isAssignableFrom(parameterType) && (map = TypeManufacturerUtil.resolveMapType(parameterType, defaultValue = null)) != null) {
            Class elementClass;
            Class keyClass;
            AtomicReference<Type[]> keyGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
            AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)genericType;
                Type[] actualTypeArguments = pType.getActualTypeArguments();
                keyClass = TypeManufacturerUtil.resolveGenericParameter(actualTypeArguments[0], typeArgsMap, keyGenericTypeArgs);
                elementClass = TypeManufacturerUtil.resolveGenericParameter(actualTypeArguments[1], typeArgsMap, elementGenericTypeArgs);
            } else {
                LOG.warn("Map parameter {} type is non-generic.We will assume a Map<Object,Object> for you.", (Object)genericType);
                keyClass = Object.class;
                elementClass = Object.class;
            }
            Type[] genericTypeArgsAll = TypeManufacturerUtil.mergeTypeArrays(elementGenericTypeArgs.get(), genericTypeArgs);
            MapArguments mapArguments = new MapArguments();
            mapArguments.setAnnotations(annotations);
            mapArguments.setMapToBeFilled(map);
            mapArguments.setKeyClass(keyClass);
            mapArguments.setElementClass(elementClass);
            mapArguments.setKeyGenericTypeArgs(keyGenericTypeArgs.get());
            mapArguments.setElementGenericTypeArgs(genericTypeArgsAll);
            this.fillMap(mapArguments, manufacturingCtx);
            parameterValue = map;
        }
        if (parameterValue == null) {
            Map<String, Type> typeArgsMapForParam;
            if (genericType instanceof ParameterizedType) {
                typeArgsMapForParam = new HashMap<String, Type>(typeArgsMap);
                ParameterizedType parametrizedType = (ParameterizedType)genericType;
                TypeVariable<Class<?>>[] argumentTypes = parameterType.getTypeParameters();
                Type[] argumentGenericTypes = parametrizedType.getActualTypeArguments();
                for (int k = 0; k < argumentTypes.length; ++k) {
                    if (!(argumentGenericTypes[k] instanceof Class)) continue;
                    Class genericParam = (Class)argumentGenericTypes[k];
                    typeArgsMapForParam.put(argumentTypes[k].getName(), genericParam);
                }
            } else {
                typeArgsMapForParam = typeArgsMap;
            }
            String attributeName = null;
            parameterValue = this.manufactureAttributeValue(pojoClass, manufacturingCtx, parameterType, genericType, annotations, attributeName, typeArgsMapForParam, genericTypeArgs);
        }
        return parameterValue;
    }

    private <T> T getValueForAbstractType(Class<T> pojoClass, AttributeMetadata pojoMetadata, ManufacturingContext manufacturingCtx, Type[] genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<T> specificClass = this.strategy.getSpecificClass(pojoClass);
        if (!specificClass.equals(pojoClass)) {
            return this.manufacturePojoInternal(specificClass, pojoMetadata, manufacturingCtx, genericTypeArgs);
        }
        return this.resortToExternalFactory(manufacturingCtx, "{} is an abstract class or interface. Resorting to {} external factory", pojoClass, genericTypeArgs);
    }

    static {
        LOG = LoggerFactory.getLogger(PodamFactoryImpl.class);
    }
}

