/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.ClassAttribute;
import uk.co.jemos.podam.api.ClassAttributeApprover;
import uk.co.jemos.podam.api.ClassInfo;
import uk.co.jemos.podam.api.DefaultClassInfoStrategy;
import uk.co.jemos.podam.common.PodamExclude;

public final class PodamUtils {
    private static final int SETTER_IDENTIFIER_LENGTH = 3;
    private static final String GETTER_PREFIX = "get";
    private static final String GETTER_PREFIX2 = "is";
    public static final char[] NICE_ASCII_CHARACTERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_'};
    private static final Logger LOG = LoggerFactory.getLogger(PodamUtils.class);

    private PodamUtils() {
        throw new AssertionError();
    }

    public static ClassInfo getClassInfo(Class<?> clazz, ClassAttributeApprover attributeApprover) {
        return PodamUtils.getClassInfo(clazz, new HashSet<Class<? extends Annotation>>(), Collections.<String>emptySet(), attributeApprover);
    }

    public static ClassInfo getClassInfo(Class<?> clazz, Set<Class<? extends Annotation>> excludeFieldAnnotations, Set<String> excludedFields, ClassAttributeApprover attributeApprover) {
        return PodamUtils.getClassInfo(clazz, excludeFieldAnnotations, excludedFields, attributeApprover, Collections.<Method>emptySet());
    }

    public static ClassInfo getClassInfo(Class<?> clazz, Set<Class<? extends Annotation>> excludeFieldAnnotations, Set<String> excludedFields, ClassAttributeApprover attributeApprover, Collection<Method> extraMethods) {
        Object attribute;
        String attributeName;
        ClassAttribute attribute2;
        if (null == attributeApprover) {
            attributeApprover = DefaultClassInfoStrategy.getInstance().getClassAttributeApprover(clazz);
        }
        HashSet<Field> classFields = new HashSet<Field>();
        HashSet<Method> classGetters = new HashSet<Method>();
        HashSet<Method> classSetters = new HashSet<Method>();
        PodamUtils.fillPojoSets(clazz, classFields, classGetters, classSetters, excludeFieldAnnotations, excludedFields);
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Field classField : classFields) {
            attribute2 = new ClassAttribute(classField, Collections.<Method>emptySet(), Collections.<Method>emptySet());
            map.put(classField.getName(), attribute2);
        }
        for (Method classGetter : classGetters) {
            attributeName = PodamUtils.extractFieldNameFromGetterMethod(classGetter);
            attribute = (ClassAttribute)map.get(attributeName);
            if (attribute != null) {
                ((ClassAttribute)attribute).getRawGetters().add(classGetter);
                continue;
            }
            attribute = new ClassAttribute(null, Collections.singleton(classGetter), Collections.<Method>emptySet());
            map.put(attributeName, attribute);
        }
        for (Method classSetter : classSetters) {
            attributeName = PodamUtils.extractFieldNameFromSetterMethod(classSetter);
            attribute = (ClassAttribute)map.get(attributeName);
            if (attribute != null) {
                ((ClassAttribute)attribute).getRawSetters().add(classSetter);
                continue;
            }
            attribute = new ClassAttribute(null, Collections.<Method>emptySet(), Collections.singleton(classSetter));
            map.put(attributeName, attribute);
        }
        ArrayList<ClassAttribute> attributes = new ArrayList<ClassAttribute>(map.values());
        Iterator iter = attributes.iterator();
        block3: while (iter.hasNext()) {
            attribute2 = (ClassAttribute)iter.next();
            for (Method classGetter : attribute2.getRawGetters()) {
                if (!PodamUtils.containsAnyAnnotation(classGetter, excludeFieldAnnotations)) continue;
                iter.remove();
                continue block3;
            }
            for (Method classSetter : attribute2.getRawSetters()) {
                if (!PodamUtils.containsAnyAnnotation(classSetter, excludeFieldAnnotations)) continue;
                iter.remove();
                continue block3;
            }
            Field field = attribute2.getAttribute();
            if (field != null && (excludedFields.contains(field.getName()) || PodamUtils.containsAnyAnnotation(field, excludeFieldAnnotations))) {
                iter.remove();
                continue;
            }
            if (attributeApprover.approve(attribute2)) continue;
            iter.remove();
        }
        return new ClassInfo(clazz, attributes, extraMethods);
    }

    public static boolean containsAnyAnnotation(Field field, Set<Class<? extends Annotation>> annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (field.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean containsAnyAnnotation(Method method, Set<Class<? extends Annotation>> annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (method.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }

    public static void fillPojoSets(Class<?> clazz, Set<Field> classFields, Set<Method> classGetters, Set<Method> classSetters, Set<Class<? extends Annotation>> excludeAnnotations, Set<String> excludedFields) {
        if (excludeAnnotations == null) {
            excludeAnnotations = new HashSet<Class<? extends Annotation>>();
        }
        excludeAnnotations.add(PodamExclude.class);
        for (Class<?> workClass = clazz; workClass != null; workClass = workClass.getSuperclass()) {
            Field[] declaredFields;
            Method[] declaredMethods;
            for (Method method : declaredMethods = workClass.getDeclaredMethods()) {
                if (method.isBridge() || Modifier.isNative(method.getModifiers())) continue;
                if (method.getName().startsWith("set") && method.getReturnType().equals(Void.TYPE)) {
                    classSetters.add(method);
                    continue;
                }
                if (!method.getName().startsWith(GETTER_PREFIX) && !method.getName().startsWith(GETTER_PREFIX2) || method.getParameterTypes().length != 0 || method.getReturnType().equals(Void.TYPE)) continue;
                classGetters.add(method);
            }
            for (Field field : declaredFields = workClass.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers)) continue;
                classFields.add(field);
            }
        }
    }

    public static String extractFieldNameFromSetterMethod(Method method) {
        String candidateField = method.getName().substring(3);
        if (!"".equals(candidateField)) {
            candidateField = Character.toLowerCase(candidateField.charAt(0)) + candidateField.substring(1);
        } else {
            LOG.debug("Encountered method {}. This will be ignored.", (Object)method);
        }
        return candidateField;
    }

    public static String extractFieldNameFromGetterMethod(Method method) {
        String candidateField = method.getName();
        if (candidateField.startsWith(GETTER_PREFIX)) {
            candidateField = candidateField.substring(GETTER_PREFIX.length());
        } else if (candidateField.startsWith(GETTER_PREFIX2)) {
            candidateField = candidateField.substring(GETTER_PREFIX2.length());
        }
        if (!"".equals(candidateField)) {
            candidateField = Character.toLowerCase(candidateField.charAt(0)) + candidateField.substring(1);
        } else {
            LOG.debug("Encountered method {}. This will be ignored.", (Object)method);
        }
        return candidateField;
    }

    public static Field getField(Class<?> pojoClass, String attributeName) {
        Field field = null;
        for (Class<?> clazz = pojoClass; clazz != null; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(attributeName);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        if (field == null) {
            LOG.warn("A field could not be found for attribute '{}[{}]'", pojoClass, (Object)attributeName);
        }
        return field;
    }

    public static <T> T getFieldValue(Object pojo, String attributeName) {
        Object retValue = null;
        try {
            Field field = PodamUtils.getField(pojo.getClass(), attributeName);
            if (field != null) {
                Object t;
                field.setAccessible(true);
                retValue = t = field.get(pojo);
            } else {
                LOG.info("The field {}[{}] didn't exist.", pojo.getClass(), (Object)attributeName);
            }
        }
        catch (Exception e) {
            LOG.warn("We couldn't get default value for {}[{}]", new Object[]{pojo.getClass(), attributeName, e});
        }
        return (T)retValue;
    }

    public static List<Annotation> getAttributeAnnotations(Field attribute, Method setter) {
        Annotation[] annotations = attribute != null ? attribute.getAnnotations() : null;
        ArrayList<Annotation> retValue = annotations != null && annotations.length != 0 ? new ArrayList<Annotation>(Arrays.asList(annotations)) : new ArrayList();
        for (Annotation annotation : setter.getParameterAnnotations()[0]) {
            retValue.add(annotation);
        }
        return retValue;
    }

    public static Character getNiceCharacter() {
        int randomCharIdx = (int)(Math.random() * (double)(NICE_ASCII_CHARACTERS.length - 1) + 0.5);
        return Character.valueOf(NICE_ASCII_CHARACTERS[randomCharIdx]);
    }

    public static long getLongInRange(long minValue, long maxValue) {
        return (long)((double)minValue + Math.random() * (double)(maxValue - minValue) + 0.5);
    }

    public static Class<?> primitiveToBoxedType(Class<?> primitiveType) {
        if (Integer.TYPE.equals(primitiveType)) {
            return Integer.class;
        }
        if (Double.TYPE.equals(primitiveType)) {
            return Double.class;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return Long.class;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return Byte.class;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return Float.class;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return Character.class;
        }
        if (Short.TYPE.equals(primitiveType)) {
            return Short.class;
        }
        return primitiveType;
    }
}

