/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.common.PodamCharValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;
import uk.co.jemos.podam.typeManufacturers.TypeManufacturerParamsWrapper;

public class CharTypeManufacturerImpl
extends AbstractTypeManufacturer {
    private static final Logger LOG = LoggerFactory.getLogger(CharTypeManufacturerImpl.class);

    public Character getType(TypeManufacturerParamsWrapper wrapper) {
        super.checkWrapperIsValid(wrapper);
        DataProviderStrategy strategy = wrapper.getDataProviderStrategy();
        Character retValue = null;
        for (Annotation annotation : wrapper.getAttributeMetadata().getAttributeAnnotations()) {
            char maxValue;
            if (!PodamCharValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamCharValue annotationStrategy = (PodamCharValue)annotation;
            char charValue = annotationStrategy.charValue();
            if (charValue != ' ') {
                retValue = Character.valueOf(charValue);
                break;
            }
            char minValue = annotationStrategy.minValue();
            if (minValue > (maxValue = annotationStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = strategy.getCharacterInRange(minValue, maxValue, wrapper.getAttributeMetadata());
            break;
        }
        if (retValue == null) {
            retValue = strategy.getCharacter(wrapper.getAttributeMetadata());
        }
        return retValue;
    }
}

