/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.common.PodamDoubleValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;
import uk.co.jemos.podam.typeManufacturers.TypeManufacturerParamsWrapper;

public class DoubleTypeManufacturerImpl
extends AbstractTypeManufacturer {
    private static final Logger LOG = LoggerFactory.getLogger(DoubleTypeManufacturerImpl.class);

    public Double getType(TypeManufacturerParamsWrapper wrapper) {
        super.checkWrapperIsValid(wrapper);
        DataProviderStrategy strategy = wrapper.getDataProviderStrategy();
        Double retValue = null;
        for (Annotation annotation : wrapper.getAttributeMetadata().getAttributeAnnotations()) {
            double maxValue;
            if (!PodamDoubleValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamDoubleValue doubleStrategy = (PodamDoubleValue)annotation;
            String numValueStr = doubleStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Double.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The annotation value: " + numValueStr + " could not be converted to a Double. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            double minValue = doubleStrategy.minValue();
            if (minValue > (maxValue = doubleStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = strategy.getDoubleInRange(minValue, maxValue, wrapper.getAttributeMetadata());
            break;
        }
        if (retValue == null) {
            retValue = strategy.getDouble(wrapper.getAttributeMetadata());
        }
        return retValue;
    }
}

