/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.common.PodamFloatValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;
import uk.co.jemos.podam.typeManufacturers.TypeManufacturerParamsWrapper;

public class FloatTypeManufacturerImpl
extends AbstractTypeManufacturer {
    private static final Logger LOG = LoggerFactory.getLogger(FloatTypeManufacturerImpl.class);

    public Float getType(TypeManufacturerParamsWrapper wrapper) {
        super.checkWrapperIsValid(wrapper);
        DataProviderStrategy strategy = wrapper.getDataProviderStrategy();
        Float retValue = null;
        for (Annotation annotation : wrapper.getAttributeMetadata().getAttributeAnnotations()) {
            float maxValue;
            if (!PodamFloatValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamFloatValue floatStrategy = (PodamFloatValue)annotation;
            String numValueStr = floatStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Float.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The annotation value: " + numValueStr + " could not be converted to a Float. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            float minValue = floatStrategy.minValue();
            if (minValue > (maxValue = floatStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = strategy.getFloatInRange(minValue, maxValue, wrapper.getAttributeMetadata());
            break;
        }
        if (retValue == null) {
            retValue = strategy.getFloat(wrapper.getAttributeMetadata());
        }
        return retValue;
    }
}

