/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.common.PodamIntValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;
import uk.co.jemos.podam.typeManufacturers.TypeManufacturerParamsWrapper;

public class IntTypeManufacturerImpl
extends AbstractTypeManufacturer {
    private static final Logger LOG = LoggerFactory.getLogger(IntTypeManufacturerImpl.class);

    public Integer getType(TypeManufacturerParamsWrapper wrapper) {
        super.checkWrapperIsValid(wrapper);
        DataProviderStrategy strategy = wrapper.getDataProviderStrategy();
        Integer retValue = null;
        for (Annotation annotation : wrapper.getAttributeMetadata().getAttributeAnnotations()) {
            int maxValue;
            if (!PodamIntValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamIntValue intStrategy = (PodamIntValue)annotation;
            String numValueStr = intStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Integer.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The annotation value: " + numValueStr + " could not be converted to an Integer. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            int minValue = intStrategy.minValue();
            if (minValue > (maxValue = intStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = strategy.getIntegerInRange(minValue, maxValue, wrapper.getAttributeMetadata());
            break;
        }
        if (retValue == null) {
            retValue = strategy.getInteger(wrapper.getAttributeMetadata());
        }
        return retValue;
    }
}

