/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.common.PodamLongValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;
import uk.co.jemos.podam.typeManufacturers.TypeManufacturerParamsWrapper;

public class LongTypeManufacturerImpl
extends AbstractTypeManufacturer {
    private static final Logger LOG = LoggerFactory.getLogger(LongTypeManufacturerImpl.class);

    public Long getType(TypeManufacturerParamsWrapper wrapper) {
        super.checkWrapperIsValid(wrapper);
        DataProviderStrategy strategy = wrapper.getDataProviderStrategy();
        Long retValue = null;
        for (Annotation annotation : wrapper.getAttributeMetadata().getAttributeAnnotations()) {
            long maxValue;
            if (!PodamLongValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamLongValue longStrategy = (PodamLongValue)annotation;
            String numValueStr = longStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Long.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The annotation value: " + numValueStr + " could not be converted to a Long. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            long minValue = longStrategy.minValue();
            if (minValue > (maxValue = longStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = strategy.getLongInRange(minValue, maxValue, wrapper.getAttributeMetadata());
            break;
        }
        if (retValue == null) {
            retValue = strategy.getLong(wrapper.getAttributeMetadata());
        }
        return retValue;
    }
}

