/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.common.PodamShortValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;
import uk.co.jemos.podam.typeManufacturers.TypeManufacturerParamsWrapper;

public class ShortTypeManufacturerImpl
extends AbstractTypeManufacturer {
    private static final Logger LOG = LoggerFactory.getLogger(ShortTypeManufacturerImpl.class);

    public Short getType(TypeManufacturerParamsWrapper wrapper) {
        super.checkWrapperIsValid(wrapper);
        DataProviderStrategy strategy = wrapper.getDataProviderStrategy();
        Short retValue = null;
        for (Annotation annotation : wrapper.getAttributeMetadata().getAttributeAnnotations()) {
            short maxValue;
            if (!PodamShortValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamShortValue shortStrategy = (PodamShortValue)annotation;
            String numValueStr = shortStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Short.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The precise value: " + numValueStr + " cannot be converted to a short type. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            short minValue = shortStrategy.minValue();
            if (minValue > (maxValue = shortStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = strategy.getShortInRange(minValue, maxValue, wrapper.getAttributeMetadata());
            break;
        }
        if (retValue == null) {
            retValue = strategy.getShort(wrapper.getAttributeMetadata());
        }
        return retValue;
    }
}

