/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.annotation.Annotation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.common.PodamStringValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;
import uk.co.jemos.podam.typeManufacturers.TypeManufacturerParamsWrapper;

public class StringTypeManufacturerImpl
extends AbstractTypeManufacturer {
    private static final Logger LOG = LoggerFactory.getLogger(StringTypeManufacturerImpl.class);

    public String getType(TypeManufacturerParamsWrapper wrapper) {
        super.checkWrapperIsValid(wrapper);
        DataProviderStrategy strategy = wrapper.getDataProviderStrategy();
        String retValue = null;
        AttributeMetadata attributeMetadata = wrapper.getAttributeMetadata();
        List<Annotation> annotations = attributeMetadata.getAttributeAnnotations();
        if (annotations == null || annotations.isEmpty()) {
            retValue = strategy.getStringValue(attributeMetadata);
        } else {
            for (Annotation annotation : annotations) {
                if (!PodamStringValue.class.isAssignableFrom(annotation.getClass())) continue;
                PodamStringValue podamAnnotation = (PodamStringValue)annotation;
                if (podamAnnotation.strValue() != null && podamAnnotation.strValue().length() > 0) {
                    retValue = podamAnnotation.strValue();
                    continue;
                }
                retValue = strategy.getStringOfLength(podamAnnotation.length(), attributeMetadata);
            }
            if (retValue == null) {
                retValue = strategy.getStringValue(attributeMetadata);
            }
        }
        return retValue;
    }
}

