/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.co.jemos.podam.api.ClassAttribute;
import uk.co.jemos.podam.api.ClassAttributeApprover;
import uk.co.jemos.podam.api.ClassInfo;
import uk.co.jemos.podam.api.ClassInfoStrategy;
import uk.co.jemos.podam.api.PodamUtils;

public abstract class AbstractClassInfoStrategy
implements ClassInfoStrategy,
ClassAttributeApprover {
    private final Set<Class<? extends Annotation>> excludedAnnotations = new HashSet<Class<? extends Annotation>>();
    private Map<Class<?>, Set<String>> excludedFields = new HashMap();
    private final Map<Class<?>, List<Method>> extraMethods = new HashMap();

    public AbstractClassInfoStrategy addExcludedAnnotation(Class<? extends Annotation> annotation) {
        this.excludedAnnotations.add(annotation);
        return this;
    }

    public AbstractClassInfoStrategy addExtraMethod(Class<?> pojoClass, String methodName, Class<?> ... methodArgs) throws NoSuchMethodException, SecurityException {
        Method method = pojoClass.getMethod(methodName, methodArgs);
        List<Method> methods = this.extraMethods.get(pojoClass);
        if (methods == null) {
            methods = new ArrayList<Method>();
            this.extraMethods.put(pojoClass, methods);
        }
        methods.add(method);
        return this;
    }

    public AbstractClassInfoStrategy removeExcludedAnnotation(Class<? extends Annotation> annotation) {
        this.excludedAnnotations.remove(annotation);
        return this;
    }

    public AbstractClassInfoStrategy addExcludedField(Class<?> pojoClass, String fieldName) {
        Set<String> fields = this.excludedFields.get(pojoClass);
        if (fields == null) {
            fields = new HashSet<String>();
            this.excludedFields.put(pojoClass, fields);
        }
        fields.add(fieldName);
        return this;
    }

    public AbstractClassInfoStrategy removeExcludedField(Class<?> pojoClass, String fieldName) {
        Set<String> fields = this.excludedFields.get(pojoClass);
        if (fields != null) {
            fields.remove(fieldName);
        }
        return this;
    }

    @Override
    public boolean approve(ClassAttribute attribute) {
        return attribute.getAttribute() != null;
    }

    @Override
    public Set<Class<? extends Annotation>> getExcludedAnnotations() {
        return this.excludedAnnotations;
    }

    @Override
    public Set<String> getExcludedFields(Class<?> pojoClass) {
        return this.excludedFields.get(pojoClass);
    }

    @Override
    public ClassInfo getClassInfo(Class<?> pojoClass) {
        List<Method> localExtraMethods;
        Set<String> excludedAttributes = this.excludedFields.get(pojoClass);
        if (null == excludedAttributes) {
            excludedAttributes = Collections.emptySet();
        }
        if (null == (localExtraMethods = this.extraMethods.get(pojoClass))) {
            localExtraMethods = Collections.emptyList();
        }
        return PodamUtils.getClassInfo(pojoClass, this.excludedAnnotations, excludedAttributes, this, localExtraMethods);
    }

    @Override
    public ClassAttributeApprover getClassAttributeApprover(Class<?> pojoClass) {
        return this;
    }

    @Override
    public Collection<Method> getExtraMethods(Class<?> pojoClass) {
        return this.extraMethods.get(pojoClass);
    }
}

