/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public class ClassAttribute
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Field attribute;
    private final Set<Method> getters = new HashSet<Method>();
    private final Set<Method> setters = new HashSet<Method>();

    public ClassAttribute(Field attribute, Set<Method> getters, Set<Method> setters) {
        this.attribute = attribute;
        this.getters.addAll(getters);
        this.setters.addAll(setters);
    }

    public Field getAttribute() {
        return this.attribute;
    }

    public Set<Method> getGetters() {
        return new HashSet<Method>(this.getters);
    }

    Set<Method> getRawGetters() {
        return this.getters;
    }

    public Set<Method> getSetters() {
        return new HashSet<Method>(this.setters);
    }

    Set<Method> getRawSetters() {
        return this.setters;
    }

    public int hashCode() {
        int hashCode = this.getters.hashCode() ^ this.setters.hashCode();
        if (this.attribute != null) {
            hashCode ^= this.attribute.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassAttribute)) {
            return false;
        }
        ClassAttribute other = (ClassAttribute)obj;
        if (this.attribute != null && !this.attribute.equals(other.getAttribute())) {
            return false;
        }
        if (!this.setters.equals(other.getSetters())) {
            return false;
        }
        return this.getters.equals(other.getGetters());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.attribute);
        builder.append("={ getters: {");
        builder.append(this.getters);
        builder.append("}, { setters: {");
        builder.append(this.setters);
        builder.append("}}");
        return builder.toString();
    }
}

