/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.common.PodamByteValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;

public class ByteTypeManufacturerImpl
extends AbstractTypeManufacturer<Byte> {
    private static final Logger LOG = LoggerFactory.getLogger(ByteTypeManufacturerImpl.class);

    @Override
    public Byte getType(DataProviderStrategy strategy, AttributeMetadata attributeMetadata, Map<String, Type> genericTypesArgumentsMap) {
        Byte retValue = null;
        for (Annotation annotation : attributeMetadata.getAttributeAnnotations()) {
            byte maxValue;
            if (!PodamByteValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamByteValue intStrategy = (PodamByteValue)annotation;
            String numValueStr = intStrategy.numValue();
            if (null != numValueStr && !numValueStr.isEmpty()) {
                try {
                    retValue = Byte.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The precise value: " + numValueStr + " cannot be converted to a byte type. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            byte minValue = intStrategy.minValue();
            if (minValue > (maxValue = intStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.getByteInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        if (retValue == null) {
            retValue = this.getByte(attributeMetadata);
        }
        return retValue;
    }

    public Byte getByte(AttributeMetadata attributeMetadata) {
        byte nextByte;
        while ((nextByte = (byte)RANDOM.nextInt(127)) == 0) {
        }
        return nextByte;
    }

    public Byte getByteInRange(byte minValue, byte maxValue, AttributeMetadata attributeMetadata) {
        return (byte)((double)minValue + Math.random() * (double)(maxValue - minValue) + 0.5);
    }
}

