/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PodamUtils {
    public static final char[] NICE_ASCII_CHARACTERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_'};
    private static final Logger LOG = LoggerFactory.getLogger(PodamUtils.class);

    private PodamUtils() {
        throw new AssertionError();
    }

    public static Field getField(Class<?> pojoClass, String attributeName) {
        Field field = null;
        for (Class<?> clazz = pojoClass; clazz != null; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(attributeName);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        if (field == null) {
            LOG.warn("A field could not be found for attribute '{}[{}]'", pojoClass, (Object)attributeName);
        }
        return field;
    }

    public static <T> T getFieldValue(Object pojo, String attributeName) {
        Object retValue = null;
        try {
            Field field = PodamUtils.getField(pojo.getClass(), attributeName);
            if (field != null) {
                Object t;
                field.setAccessible(true);
                retValue = t = field.get(pojo);
            } else {
                LOG.info("The field {}[{}] didn't exist.", pojo.getClass(), (Object)attributeName);
            }
        }
        catch (Exception e) {
            LOG.warn("We couldn't get default value for {}[{}]", new Object[]{pojo.getClass(), attributeName, e});
        }
        return (T)retValue;
    }

    public static List<Annotation> getAttributeAnnotations(Field attribute, Method setter) {
        Annotation[] annotations;
        ArrayList<Annotation> retValue = new ArrayList<Annotation>();
        Annotation[] annotationArray = annotations = attribute != null ? attribute.getAnnotations() : null;
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                retValue.add(annotation);
            }
        }
        for (Annotation annotation : setter.getParameterAnnotations()[0]) {
            retValue.add(annotation);
        }
        return retValue;
    }

    public static Character getNiceCharacter() {
        int randomCharIdx = (int)(Math.random() * (double)(NICE_ASCII_CHARACTERS.length - 1) + 0.5);
        return Character.valueOf(NICE_ASCII_CHARACTERS[randomCharIdx]);
    }

    public static long getLongInRange(long minValue, long maxValue) {
        return (long)((double)minValue + Math.random() * (double)(maxValue - minValue) + 0.5);
    }

    public static int getIntegerInRange(int minValue, int maxValue) {
        return (int)((double)minValue + Math.random() * (double)(maxValue - minValue) + 0.5);
    }

    public static Class<?> primitiveToBoxedType(Class<?> primitiveType) {
        if (Integer.TYPE.equals(primitiveType)) {
            return Integer.class;
        }
        if (Double.TYPE.equals(primitiveType)) {
            return Double.class;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return Long.class;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return Byte.class;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return Float.class;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return Character.class;
        }
        if (Short.TYPE.equals(primitiveType)) {
            return Short.class;
        }
        return primitiveType;
    }
}

