/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.common.PodamDoubleValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;

public class DoubleTypeManufacturerImpl
extends AbstractTypeManufacturer<Double> {
    private static final Logger LOG = LoggerFactory.getLogger(DoubleTypeManufacturerImpl.class);

    @Override
    public Double getType(DataProviderStrategy strategy, AttributeMetadata attributeMetadata, Map<String, Type> genericTypesArgumentsMap) {
        Double retValue = null;
        for (Annotation annotation : attributeMetadata.getAttributeAnnotations()) {
            double maxValue;
            if (!PodamDoubleValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamDoubleValue doubleStrategy = (PodamDoubleValue)annotation;
            String numValueStr = doubleStrategy.numValue();
            if (null != numValueStr && !numValueStr.isEmpty()) {
                try {
                    retValue = Double.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The annotation value: " + numValueStr + " could not be converted to a Double. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            double minValue = doubleStrategy.minValue();
            if (minValue > (maxValue = doubleStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.getDoubleInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        if (retValue == null) {
            retValue = this.getDouble(attributeMetadata);
        }
        return retValue;
    }

    public Double getDouble(AttributeMetadata attributeMetadata) {
        double retValue;
        while ((retValue = RANDOM.nextDouble()) == 0.0) {
        }
        return retValue;
    }

    public Double getDoubleInRange(double minValue, double maxValue, AttributeMetadata attributeMetadata) {
        double retValue;
        if (minValue == maxValue) {
            return minValue;
        }
        while ((retValue = minValue + Math.random() * (maxValue - minValue + 1.0)) > maxValue) {
        }
        return retValue;
    }
}

