/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.common.PodamConstants;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;
import uk.co.jemos.podam.typeManufacturers.TypeManufacturerUtil;

public class GenericTypeManufacturerImpl
extends AbstractTypeManufacturer<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(GenericTypeManufacturerImpl.class);

    @Override
    public Object getType(DataProviderStrategy strategy, AttributeMetadata attributeMetadata, Map<String, Type> genericTypesArgumentsMap) {
        Object[] genericArgs = attributeMetadata.getAttrGenericArgs();
        if (null == genericArgs) {
            throw new IllegalArgumentException("For generic type arguments, the attribute metadata should contain a non null Type[]");
        }
        Type genericAttributeType = attributeMetadata.getAttributeGenericType();
        Class<?> attributeType = attributeMetadata.getAttributeType();
        Type paremeterType = null;
        if (genericAttributeType instanceof ParameterizedType) {
            ParameterizedType parametrized = (ParameterizedType)genericAttributeType;
            Type[] arguments = parametrized.getActualTypeArguments();
            if (arguments.length > 0) {
                paremeterType = arguments[0];
            }
        } else if (attributeType.getTypeParameters().length > 0) {
            paremeterType = attributeType.getTypeParameters()[0];
        }
        if (paremeterType != null) {
            if (null == genericTypesArgumentsMap) {
                throw new IllegalArgumentException("The type arguments map in the wrapper cannot be null");
            }
            AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
            return TypeManufacturerUtil.resolveGenericParameter(paremeterType, genericTypesArgumentsMap, elementGenericTypeArgs);
        }
        LOG.error("{} is missing generic type argument, supplied {} {}", new Object[]{genericAttributeType, genericTypesArgumentsMap, Arrays.toString(genericArgs)});
        return null;
    }
}

