/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.common.PodamStringValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;

public class StringTypeManufacturerImpl
extends AbstractTypeManufacturer<String> {
    @Override
    public String getType(DataProviderStrategy strategy, AttributeMetadata attributeMetadata, Map<String, Type> genericTypesArgumentsMap) {
        String retValue = null;
        List<Annotation> annotations = attributeMetadata.getAttributeAnnotations();
        if (annotations == null || annotations.isEmpty()) {
            retValue = this.getStringValue(attributeMetadata);
        } else {
            for (Annotation annotation : annotations) {
                if (!PodamStringValue.class.isAssignableFrom(annotation.getClass())) continue;
                PodamStringValue podamAnnotation = (PodamStringValue)annotation;
                if (podamAnnotation.strValue() != null && podamAnnotation.strValue().length() > 0) {
                    retValue = podamAnnotation.strValue();
                    continue;
                }
                retValue = this.getStringOfLength(podamAnnotation.length(), attributeMetadata);
            }
            if (retValue == null) {
                retValue = this.getStringValue(attributeMetadata);
            }
        }
        return retValue;
    }

    public String getStringValue(AttributeMetadata attributeMetadata) {
        return this.getStringOfLength(10, attributeMetadata);
    }

    public String getStringOfLength(int length, AttributeMetadata attributeMetadata) {
        StringBuilder buff = new StringBuilder();
        while (buff.length() < length) {
            buff.append(PodamUtils.getNiceCharacter());
        }
        return buff.toString();
    }
}

