/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.validation.Constraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.ws.Holder;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.ObjectStrategy;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.common.AttributeStrategy;
import uk.co.jemos.podam.common.BeanValidationStrategy;
import uk.co.jemos.podam.common.PodamCollection;
import uk.co.jemos.podam.common.PodamConstants;
import uk.co.jemos.podam.common.PodamStrategyValue;

public final class TypeManufacturerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TypeManufacturerUtil.class);

    private TypeManufacturerUtil() {
        throw new AssertionError((Object)"Non instantiable");
    }

    public static AttributeStrategy<?> findAttributeStrategy(DataProviderStrategy strategy, List<Annotation> annotations, Class<?> attributeType) throws InstantiationException, IllegalAccessException {
        ArrayList<Annotation> localAnnotations = new ArrayList<Annotation>(annotations);
        Iterator iter = localAnnotations.iterator();
        while (iter.hasNext()) {
            Class<AttributeStrategy<?>> attrStrategyClass;
            Class<?>[] interfaces;
            Annotation annotation = (Annotation)iter.next();
            if (annotation instanceof PodamStrategyValue) {
                PodamStrategyValue strategyAnnotation = (PodamStrategyValue)annotation;
                return strategyAnnotation.value().newInstance();
            }
            Class<?> annotationClass = annotation.getClass();
            if (Proxy.isProxyClass(annotationClass) && (interfaces = annotationClass.getInterfaces()).length == 1) {
                Class<?> tmp = interfaces[0];
                annotationClass = tmp;
            }
            if ((attrStrategyClass = strategy.getStrategyForAnnotation(annotationClass)) != null) {
                return attrStrategyClass.newInstance();
            }
            if (annotation.annotationType().getAnnotation(Constraint.class) != null) {
                if (annotation instanceof NotNull || annotation.annotationType().getName().equals("org.hibernate.validator.constraints.NotEmpty")) {
                    iter.remove();
                    continue;
                }
                if (NotNull.class.getPackage().equals(annotationClass.getPackage())) continue;
                LOG.warn("Please, register AttributeStratergy for custom constraint {}, in DataProviderStrategy! Value will be left to null", (Object)annotation);
                continue;
            }
            iter.remove();
        }
        BeanValidationStrategy retValue = null;
        if (!(localAnnotations.isEmpty() || Collection.class.isAssignableFrom(attributeType) || Map.class.isAssignableFrom(attributeType) || attributeType.isArray())) {
            retValue = new BeanValidationStrategy(localAnnotations, attributeType);
        }
        return retValue;
    }

    public static Type[] fillTypeArgMap(Map<String, Type> typeArgsMap, Class<?> pojoClass, Type[] genericTypeArgs) {
        int i;
        TypeVariable<Class<?>>[] array = pojoClass.getTypeParameters();
        ArrayList typeParameters = new ArrayList(Arrays.asList(array));
        Iterator iterator = typeParameters.iterator();
        while (iterator.hasNext()) {
            if (!typeArgsMap.containsKey(((TypeVariable)iterator.next()).getName())) continue;
            iterator.remove();
        }
        ArrayList<Type> genericTypes = new ArrayList<Type>(Arrays.asList(genericTypeArgs));
        Iterator iterator2 = genericTypes.iterator();
        while (iterator2.hasNext()) {
            if (!(iterator2.next() instanceof TypeVariable)) continue;
            iterator2.remove();
        }
        if (typeParameters.size() > genericTypes.size()) {
            String msg = pojoClass.getCanonicalName() + " is missing generic type arguments, expected " + typeParameters + ", provided " + Arrays.toString(genericTypeArgs);
            throw new IllegalArgumentException(msg);
        }
        for (i = 0; i < typeParameters.size(); ++i) {
            typeArgsMap.put(((TypeVariable)typeParameters.get(i)).getName(), (Type)genericTypes.get(0));
            genericTypes.remove(0);
        }
        Type[] genericTypeArgsExtra = genericTypes.size() > 0 ? genericTypes.toArray(new Type[genericTypes.size()]) : PodamConstants.NO_TYPES;
        Class<?> clazz = pojoClass;
        while (clazz != null) {
            Type superType = clazz.getGenericSuperclass();
            clazz = clazz.getSuperclass();
            if (!(superType instanceof ParameterizedType)) continue;
            ParameterizedType paramType = (ParameterizedType)superType;
            Type[] actualParamTypes = paramType.getActualTypeArguments();
            TypeVariable<Class<?>>[] paramTypes = clazz.getTypeParameters();
            for (i = 0; i < actualParamTypes.length && i < paramTypes.length; ++i) {
                if (!(actualParamTypes[i] instanceof Class)) continue;
                typeArgsMap.put(paramTypes[i].getName(), actualParamTypes[i]);
            }
        }
        return genericTypeArgsExtra;
    }

    public static Integer findCollectionSize(DataProviderStrategy strategy, List<Annotation> annotations, Class<?> collectionElementType, Holder<AttributeStrategy<?>> elementStrategyHolder, Holder<AttributeStrategy<?>> keyStrategyHolder) throws InstantiationException, IllegalAccessException {
        Size size = null;
        for (Annotation annotation : annotations) {
            if (annotation instanceof PodamCollection) {
                Class<AttributeStrategy<?>> attributeStrategy;
                PodamCollection collectionAnnotation = (PodamCollection)annotation;
                if (null != elementStrategyHolder) {
                    attributeStrategy = collectionAnnotation.collectionElementStrategy();
                    if (null == attributeStrategy || ObjectStrategy.class.isAssignableFrom(attributeStrategy)) {
                        attributeStrategy = collectionAnnotation.mapElementStrategy();
                    }
                    if (null != attributeStrategy) {
                        elementStrategyHolder.value = attributeStrategy.newInstance();
                    }
                }
                if (null != keyStrategyHolder && null != (attributeStrategy = collectionAnnotation.mapKeyStrategy())) {
                    keyStrategyHolder.value = attributeStrategy.newInstance();
                }
                return collectionAnnotation.nbrElements();
            }
            if (!(annotation instanceof Size)) continue;
            size = (Size)annotation;
        }
        Integer nbrElements = strategy.getNumberOfCollectionElements(collectionElementType);
        if (null != size) {
            if (nbrElements > size.max()) {
                nbrElements = size.max();
            }
            if (nbrElements < size.min()) {
                nbrElements = size.min();
            }
        }
        return nbrElements;
    }

    public static Type[] mergeActualAndSuppliedGenericTypes(Class<?> attributeType, Type genericAttributeType, Type[] suppliedTypes, Map<String, Type> typeArgsMap) {
        WildcardType wildcardType;
        TypeVariable<Class<?>>[] actualTypes = attributeType.getTypeParameters();
        if (actualTypes.length <= suppliedTypes.length) {
            return suppliedTypes;
        }
        Object[] genericTypes = null;
        if (genericAttributeType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)genericAttributeType;
            genericTypes = paramType.getActualTypeArguments();
        } else if (genericAttributeType instanceof WildcardType && ArrayUtils.isEmpty((Object[])(genericTypes = (wildcardType = (WildcardType)genericAttributeType).getLowerBounds()))) {
            genericTypes = wildcardType.getUpperBounds();
        }
        ArrayList resolvedTypes = new ArrayList();
        ArrayList<Type> substitutionTypes = new ArrayList<Type>(Arrays.asList(suppliedTypes));
        for (int i = 0; i < actualTypes.length; ++i) {
            AtomicReference<Type[]> methodGenericTypeArgs;
            Class<?> type = null;
            if (actualTypes[i] instanceof TypeVariable) {
                type = typeArgsMap.get(actualTypes[i].getName());
            } else if (actualTypes[i] instanceof WildcardType) {
                methodGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
                type = TypeManufacturerUtil.resolveGenericParameter(actualTypes[i], typeArgsMap, methodGenericTypeArgs);
            }
            if (type == null && genericTypes != null) {
                if (genericTypes[i] instanceof Class) {
                    type = genericTypes[i];
                } else if (genericTypes[i] instanceof WildcardType) {
                    methodGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
                    type = TypeManufacturerUtil.resolveGenericParameter((Type)genericTypes[i], typeArgsMap, methodGenericTypeArgs);
                } else if (genericTypes[i] instanceof ParameterizedType) {
                    type = genericTypes[i];
                } else {
                    LOG.debug("Skipping type {} {}", actualTypes[i], genericTypes[i]);
                }
            }
            if (type == null) continue;
            resolvedTypes.add(type);
            if (substitutionTypes.isEmpty() || !((Type)substitutionTypes.get(0)).equals(type)) continue;
            substitutionTypes.remove(0);
        }
        Object[] resolved = resolvedTypes.toArray(new Type[resolvedTypes.size()]);
        Object[] supplied = substitutionTypes.toArray(new Type[substitutionTypes.size()]);
        return (Type[])ArrayUtils.addAll((Object[])resolved, (Object[])supplied);
    }

    public static Class<?> resolveGenericParameter(Type paramType, Map<String, Type> typeArgsMap, AtomicReference<Type[]> methodGenericTypeArgs) {
        Class<Object> parameterType = null;
        HashMap<String, Type> localMap = new HashMap<String, Type>(typeArgsMap);
        methodGenericTypeArgs.set(PodamConstants.NO_TYPES);
        if (paramType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)paramType;
            Type type = (Type)localMap.get(typeVariable.getName());
            if (type != null) {
                parameterType = TypeManufacturerUtil.resolveGenericParameter(type, localMap, methodGenericTypeArgs);
            }
        } else if (paramType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)paramType;
            parameterType = (Class<?>)pType.getRawType();
            methodGenericTypeArgs.set(pType.getActualTypeArguments());
        } else if (paramType instanceof WildcardType) {
            String msg;
            WildcardType wType = (WildcardType)paramType;
            Object[] bounds = wType.getLowerBounds();
            if (bounds != null && bounds.length > 0) {
                msg = "Lower bounds:";
            } else {
                bounds = wType.getUpperBounds();
                msg = "Upper bounds:";
            }
            if (bounds != null && bounds.length > 0) {
                LOG.debug(msg + Arrays.toString(bounds));
                parameterType = TypeManufacturerUtil.resolveGenericParameter((Type)bounds[0], localMap, methodGenericTypeArgs);
            }
        } else if (paramType instanceof Class) {
            parameterType = (Class)paramType;
        }
        if (parameterType == null) {
            LOG.warn("Unrecognized type {}. Will use Object instead", (Object)paramType);
            parameterType = Object.class;
        }
        return parameterType;
    }

    public static Object returnAttributeDataStrategyValue(Class<?> attributeType, AttributeStrategy<?> attributeStrategy) throws IllegalArgumentException {
        Object retValue = attributeStrategy.getValue();
        if (retValue != null) {
            Class<?> desiredType;
            Class<?> clazz = desiredType = attributeType.isPrimitive() ? PodamUtils.primitiveToBoxedType(attributeType) : attributeType;
            if (!desiredType.isAssignableFrom(retValue.getClass())) {
                String errMsg = "The type of the Podam Attribute Strategy is not " + attributeType.getName() + " but " + retValue.getClass().getName() + ". An exception will be thrown.";
                LOG.error(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
        }
        return retValue;
    }
}

