/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.common;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.common.AttributeStrategy;
import uk.co.jemos.podam.exceptions.PodamMockeryException;

public class BeanValidationStrategy
implements AttributeStrategy<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(BeanValidationStrategy.class);
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private List<Annotation> annotations;
    private Class<?> attributeType;

    public BeanValidationStrategy(List<Annotation> annotations, Class<?> attributeType) {
        this.annotations = annotations;
        this.attributeType = attributeType;
    }

    @Override
    public Object getValue() throws PodamMockeryException {
        Max maxAnno;
        Min minAnno;
        DecimalMax decimalMax;
        if (null != BeanValidationStrategy.findTypeFromList(this.annotations, AssertTrue.class)) {
            return Boolean.TRUE;
        }
        if (null != BeanValidationStrategy.findTypeFromList(this.annotations, AssertFalse.class)) {
            return Boolean.FALSE;
        }
        if (null != BeanValidationStrategy.findTypeFromList(this.annotations, Past.class)) {
            int days = RANDOM.nextInt(365) + 1;
            long timestamp = System.currentTimeMillis() - TimeUnit.DAYS.toSeconds(days);
            return this.timestampToReturnType(timestamp);
        }
        if (null != BeanValidationStrategy.findTypeFromList(this.annotations, Future.class)) {
            int days = RANDOM.nextInt(365) + 1;
            long timestamp = System.currentTimeMillis() + TimeUnit.DAYS.toSeconds(days);
            return this.timestampToReturnType(timestamp);
        }
        Size size = BeanValidationStrategy.findTypeFromList(this.annotations, Size.class);
        if (null != size) {
            int minValue = size.min();
            int maxValue = size.max();
            if (maxValue == Integer.MAX_VALUE) {
                maxValue = 10;
            }
            long length = PodamUtils.getLongInRange(minValue, maxValue);
            StringBuilder sb = new StringBuilder();
            while ((long)sb.length() < length) {
                sb.append(PodamUtils.getNiceCharacter());
            }
            return sb.toString();
        }
        Pattern pattern = BeanValidationStrategy.findTypeFromList(this.annotations, Pattern.class);
        if (null != pattern) {
            LOG.warn("At the moment PODAM doesn't support @Pattern({}), returning null", (Object)pattern.regexp());
            return null;
        }
        boolean isRound = false;
        boolean isFloat = false;
        BigDecimal min = new BigDecimal(-1.7976931348623157E308);
        BigDecimal max = new BigDecimal(Double.MAX_VALUE);
        DecimalMin decimalMin = BeanValidationStrategy.findTypeFromList(this.annotations, DecimalMin.class);
        if (null != decimalMin) {
            isFloat = true;
            min = new BigDecimal(decimalMin.value());
        }
        if (null != (decimalMax = BeanValidationStrategy.findTypeFromList(this.annotations, DecimalMax.class))) {
            isFloat = true;
            max = new BigDecimal(decimalMax.value());
        }
        if (null != (minAnno = BeanValidationStrategy.findTypeFromList(this.annotations, Min.class))) {
            isRound = true;
            min = new BigDecimal(minAnno.value()).max(min);
        }
        if (null != (maxAnno = BeanValidationStrategy.findTypeFromList(this.annotations, Max.class))) {
            isRound = true;
            max = new BigDecimal(maxAnno.value()).min(max);
        }
        Digits digits = BeanValidationStrategy.findTypeFromList(this.annotations, Digits.class);
        BigDecimal divisor = null;
        if (null != digits) {
            isRound = true;
            divisor = BigDecimal.TEN.pow(digits.fraction());
            BigDecimal limit = BigDecimal.TEN.pow(digits.integer());
            max = limit.min(max).multiply(divisor);
            min = limit.negate().max(min).multiply(divisor);
        }
        if (isRound || isFloat) {
            BigDecimal value = this.getValueInRange(min, max);
            if (isRound) {
                BigInteger intValue = value.toBigInteger();
                value = new BigDecimal(intValue);
            }
            if (null != divisor) {
                value = value.divide(divisor);
            }
            return this.decimalToReturnType(value);
        }
        return null;
    }

    private static <T> T findTypeFromList(List<?> list, Class<T> type) {
        for (Object item : list) {
            if (!type.isAssignableFrom(item.getClass())) continue;
            return (T)item;
        }
        return null;
    }

    private BigDecimal getValueInRange(BigDecimal min, BigDecimal max) {
        BigDecimal scale = new BigDecimal(RANDOM.nextDouble());
        return min.add(max.subtract(min).multiply(scale));
    }

    private Object decimalToReturnType(BigDecimal result) {
        if (String.class.equals(this.attributeType)) {
            return result.toPlainString();
        }
        if (Double.class.equals(this.attributeType) || Double.TYPE.equals(this.attributeType)) {
            return result.doubleValue();
        }
        if (Float.class.equals(this.attributeType) || Float.TYPE.equals(this.attributeType)) {
            return Float.valueOf(result.floatValue());
        }
        if (Long.class.equals(this.attributeType) || Long.TYPE.equals(this.attributeType)) {
            return result.longValue();
        }
        if (Integer.class.equals(this.attributeType) || Integer.TYPE.equals(this.attributeType)) {
            return result.intValue();
        }
        if (Short.class.equals(this.attributeType) || Short.TYPE.equals(this.attributeType)) {
            return result.shortValue();
        }
        if (Byte.class.equals(this.attributeType) || Byte.TYPE.equals(this.attributeType)) {
            return result.byteValue();
        }
        if (this.attributeType.isAssignableFrom(BigDecimal.class)) {
            return result;
        }
        if (this.attributeType.isAssignableFrom(BigInteger.class)) {
            return result.toBigInteger();
        }
        LOG.warn("Unsupported attribute type {}", this.attributeType);
        return null;
    }

    private Object timestampToReturnType(Long result) {
        if (this.attributeType.isAssignableFrom(Date.class)) {
            return new Date(result);
        }
        if (this.attributeType.isAssignableFrom(Calendar.class)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(result);
            return calendar;
        }
        LOG.warn("Unsupported attribute type {}", this.attributeType);
        return null;
    }
}

