/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.common.PodamCharValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;

public class CharTypeManufacturerImpl
extends AbstractTypeManufacturer<Character> {
    @Override
    public Character getType(DataProviderStrategy strategy, AttributeMetadata attributeMetadata, Map<String, Type> genericTypesArgumentsMap) {
        Character retValue = null;
        for (Annotation annotation : attributeMetadata.getAttributeAnnotations()) {
            char maxValue;
            if (!PodamCharValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamCharValue annotationStrategy = (PodamCharValue)annotation;
            char charValue = annotationStrategy.charValue();
            if (charValue != ' ') {
                retValue = Character.valueOf(charValue);
                break;
            }
            char minValue = annotationStrategy.minValue();
            if (minValue > (maxValue = annotationStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.getCharacterInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        if (retValue == null) {
            retValue = this.getCharacter(attributeMetadata);
        }
        return retValue;
    }

    public Character getCharacter(AttributeMetadata attributeMetadata) {
        return PodamUtils.getNiceCharacter();
    }

    public Character getCharacterInRange(char minValue, char maxValue, AttributeMetadata attributeMetadata) {
        return Character.valueOf((char)((double)minValue + Math.random() * (double)(maxValue - minValue) + 0.5));
    }
}

