/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.common.PodamFloatValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;

public class FloatTypeManufacturerImpl
extends AbstractTypeManufacturer<Float> {
    private static final Logger LOG = LoggerFactory.getLogger(FloatTypeManufacturerImpl.class);

    @Override
    public Float getType(DataProviderStrategy strategy, AttributeMetadata attributeMetadata, Map<String, Type> genericTypesArgumentsMap) {
        Float retValue = null;
        for (Annotation annotation : attributeMetadata.getAttributeAnnotations()) {
            float maxValue;
            if (!PodamFloatValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamFloatValue floatStrategy = (PodamFloatValue)annotation;
            String numValueStr = floatStrategy.numValue();
            if (StringUtils.isNotEmpty((CharSequence)numValueStr)) {
                try {
                    retValue = Float.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The annotation value: " + numValueStr + " could not be converted to a Float. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            float minValue = floatStrategy.minValue();
            if (minValue > (maxValue = floatStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.getFloatInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        if (retValue == null) {
            retValue = this.getFloat(attributeMetadata);
        }
        return retValue;
    }

    public Float getFloat(AttributeMetadata attributeMetadata) {
        return Float.valueOf((float)this.getDouble());
    }

    public Float getFloatInRange(float minValue, float maxValue, AttributeMetadata attributeMetadata) {
        float retValue;
        if (minValue == maxValue) {
            return Float.valueOf(minValue);
        }
        while ((retValue = (float)((double)minValue + Math.random() * (double)(maxValue - minValue + 1.0f))) > maxValue) {
        }
        return Float.valueOf(retValue);
    }
}

