/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.common.PodamIntValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;

public class IntTypeManufacturerImpl
extends AbstractTypeManufacturer<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(IntTypeManufacturerImpl.class);

    @Override
    public Integer getType(DataProviderStrategy strategy, AttributeMetadata attributeMetadata, Map<String, Type> genericTypesArgumentsMap) {
        Integer retValue = null;
        for (Annotation annotation : attributeMetadata.getAttributeAnnotations()) {
            int maxValue;
            if (!PodamIntValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamIntValue intStrategy = (PodamIntValue)annotation;
            String numValueStr = intStrategy.numValue();
            if (StringUtils.isNotEmpty((CharSequence)numValueStr)) {
                try {
                    retValue = Integer.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The annotation value: " + numValueStr + " could not be converted to an Integer. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            int minValue = intStrategy.minValue();
            if (minValue > (maxValue = intStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.getIntegerInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        if (retValue == null) {
            retValue = this.getInteger(attributeMetadata);
        }
        return retValue;
    }

    public Integer getInteger(AttributeMetadata attributeMetadata) {
        return this.getInteger(Integer.MAX_VALUE);
    }

    public int getIntegerInRange(int minValue, int maxValue, AttributeMetadata attributeMetadata) {
        return PodamUtils.getIntegerInRange(minValue, maxValue);
    }
}

