/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.common.PodamLongValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;

public class LongTypeManufacturerImpl
extends AbstractTypeManufacturer<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(LongTypeManufacturerImpl.class);

    @Override
    public Long getType(DataProviderStrategy strategy, AttributeMetadata attributeMetadata, Map<String, Type> genericTypesArgumentsMap) {
        Long retValue = null;
        for (Annotation annotation : attributeMetadata.getAttributeAnnotations()) {
            long maxValue;
            if (!PodamLongValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamLongValue longStrategy = (PodamLongValue)annotation;
            String numValueStr = longStrategy.numValue();
            if (StringUtils.isNotEmpty((CharSequence)numValueStr)) {
                try {
                    retValue = Long.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The annotation value: " + numValueStr + " could not be converted to a Long. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            long minValue = longStrategy.minValue();
            if (minValue > (maxValue = longStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.getLongInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        if (retValue == null) {
            retValue = this.getLong(attributeMetadata);
        }
        return retValue;
    }

    public Long getLong(AttributeMetadata attributeMetadata) {
        return System.nanoTime();
    }

    public Long getLongInRange(long minValue, long maxValue, AttributeMetadata attributeMetadata) {
        return PodamUtils.getLongInRange(minValue, maxValue);
    }
}

