/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.common.PodamShortValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;

public class ShortTypeManufacturerImpl
extends AbstractTypeManufacturer<Short> {
    private static final Logger LOG = LoggerFactory.getLogger(ShortTypeManufacturerImpl.class);

    @Override
    public Short getType(DataProviderStrategy strategy, AttributeMetadata attributeMetadata, Map<String, Type> genericTypesArgumentsMap) {
        Short retValue = null;
        for (Annotation annotation : attributeMetadata.getAttributeAnnotations()) {
            short maxValue;
            if (!PodamShortValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamShortValue shortStrategy = (PodamShortValue)annotation;
            String numValueStr = shortStrategy.numValue();
            if (StringUtils.isNotEmpty((CharSequence)numValueStr)) {
                try {
                    retValue = Short.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The precise value: " + numValueStr + " cannot be converted to a short type. An exception will be thrown.";
                    LOG.error(errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            short minValue = shortStrategy.minValue();
            if (minValue > (maxValue = shortStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.getShortInRange(minValue, maxValue, attributeMetadata);
            break;
        }
        if (retValue == null) {
            retValue = this.getShort(attributeMetadata);
        }
        return retValue;
    }

    public Short getShort(AttributeMetadata attributeMetadata) {
        return (short)this.getInteger(Short.MAX_VALUE);
    }

    public Short getShortInRange(short minValue, short maxValue, AttributeMetadata attributeMetadata) {
        return (short)((double)minValue + Math.random() * (double)(maxValue - minValue) + 0.5);
    }
}

