/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.ClassAttribute;
import uk.co.jemos.podam.api.ClassInfo;
import uk.co.jemos.podam.api.ClassInfoStrategy;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.DefaultClassInfoStrategy;
import uk.co.jemos.podam.api.MapArguments;
import uk.co.jemos.podam.api.MapKeyOrElementsArguments;
import uk.co.jemos.podam.api.NullExternalFactory;
import uk.co.jemos.podam.api.PodamFactory;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.api.RandomDataProviderStrategyImpl;
import uk.co.jemos.podam.common.AttributeStrategy;
import uk.co.jemos.podam.common.Holder;
import uk.co.jemos.podam.common.ManufacturingContext;
import uk.co.jemos.podam.common.PodamConstants;
import uk.co.jemos.podam.exceptions.PodamMockeryException;
import uk.co.jemos.podam.typeManufacturers.TypeManufacturerUtil;

@NotThreadSafe
@Immutable
public class PodamFactoryImpl
implements PodamFactory {
    private static final String RESOLVING_COLLECTION_EXCEPTION_STR = "An exception occurred while resolving the collection";
    private static final String MAP_CREATION_EXCEPTION_STR = "An exception occurred while creating a Map object";
    private static final Logger LOG = LoggerFactory.getLogger(PodamFactoryImpl.class);
    private static final Map<String, Type> NULL_TYPE_ARGS_MAP = new HashMap<String, Type>();
    private PodamFactory externalFactory = NullExternalFactory.getInstance();
    private DataProviderStrategy strategy = new RandomDataProviderStrategyImpl();
    private ClassInfoStrategy classInfoStrategy = DefaultClassInfoStrategy.getInstance();

    public PodamFactoryImpl() {
        this(NullExternalFactory.getInstance(), new RandomDataProviderStrategyImpl());
    }

    public PodamFactoryImpl(DataProviderStrategy strategy) {
        this(NullExternalFactory.getInstance(), strategy);
    }

    public PodamFactoryImpl(PodamFactory externalFactory) {
        this(externalFactory, new RandomDataProviderStrategyImpl());
    }

    public PodamFactoryImpl(PodamFactory externalFactory, DataProviderStrategy strategy) {
        this.externalFactory = externalFactory;
        this.strategy = strategy;
    }

    @Override
    public <T> T manufacturePojoWithFullData(Class<T> pojoClass, Type ... genericTypeArgs) {
        ManufacturingContext manufacturingCtx = new ManufacturingContext();
        manufacturingCtx.getPojos().put(pojoClass, 1);
        manufacturingCtx.setConstructorOrdering(DataProviderStrategy.Order.HEAVY_FIRST);
        return this.doManufacturePojo(pojoClass, manufacturingCtx, genericTypeArgs);
    }

    @Override
    public <T> T manufacturePojo(Class<T> pojoClass, Type ... genericTypeArgs) {
        ManufacturingContext manufacturingCtx = new ManufacturingContext();
        manufacturingCtx.getPojos().put(pojoClass, 1);
        return this.doManufacturePojo(pojoClass, manufacturingCtx, genericTypeArgs);
    }

    @Override
    public <T> T populatePojo(T pojo, Type ... genericTypeArgs) {
        ManufacturingContext manufacturingCtx = new ManufacturingContext();
        manufacturingCtx.getPojos().put(pojo.getClass(), 1);
        HashMap<String, Type> typeArgsMap = new HashMap<String, Type>();
        Type[] genericTypeArgsExtra = TypeManufacturerUtil.fillTypeArgMap(typeArgsMap, pojo.getClass(), genericTypeArgs);
        try {
            List<Annotation> annotations = null;
            return this.populatePojoInternal(pojo, annotations, manufacturingCtx, typeArgsMap, genericTypeArgsExtra);
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
    }

    @Override
    public DataProviderStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public PodamFactory setStrategy(DataProviderStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    @Override
    public ClassInfoStrategy getClassStrategy() {
        return this.classInfoStrategy;
    }

    @Override
    public PodamFactory setClassStrategy(ClassInfoStrategy classInfoStrategy) {
        this.classInfoStrategy = classInfoStrategy;
        return this;
    }

    @Override
    public PodamFactory getExternalFactory() {
        return this.externalFactory;
    }

    @Override
    public PodamFactory setExternalFactory(PodamFactory externalFactory) {
        this.externalFactory = externalFactory;
        return this;
    }

    private <T> T instantiatePojoWithFactory(Class<?> factoryClass, Class<T> pojoClass, ManufacturingContext manufacturingCtx, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Method[] declaredMethods = TypeManufacturerUtil.findSuitableConstructors(factoryClass, pojoClass);
        this.strategy.sort(declaredMethods, manufacturingCtx.getConstructorOrdering());
        Object[] parameterValues = null;
        for (Method candidateConstructor : declaredMethods) {
            Object factoryInstance = null;
            if (!Modifier.isStatic(candidateConstructor.getModifiers())) {
                factoryInstance = this.manufacturePojo(factoryClass, new Type[0]);
            }
            parameterValues = this.getParameterValuesForMethod(candidateConstructor, pojoClass, manufacturingCtx, typeArgsMap, genericTypeArgs);
            try {
                Object retValue = candidateConstructor.invoke(factoryInstance, parameterValues);
                LOG.debug("Could create an instance using " + candidateConstructor);
                return (T)retValue;
            }
            catch (Exception t) {
                LOG.debug("PODAM could not create an instance for constructor: " + candidateConstructor + ". Will try another one...", (Throwable)t);
            }
        }
        LOG.debug("For class {} PODAM could not possibly create a value statically. Will try other means.", pojoClass);
        return null;
    }

    private <T> T instantiatePojo(Class<T> pojoClass, ManufacturingContext manufacturingCtx, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) throws SecurityException {
        T retValue = null;
        Constructor<?>[] constructors = pojoClass.getConstructors();
        if (constructors.length == 0 || Modifier.isAbstract(pojoClass.getModifiers())) {
            try {
                retValue = this.instantiatePojoWithFactory(pojoClass, pojoClass, manufacturingCtx, typeArgsMap, genericTypeArgs);
            }
            catch (Exception e) {
                LOG.debug("We couldn't create an instance for pojo: " + pojoClass + " with factory methods, will  try non-public constructors.", (Throwable)e);
            }
            if (retValue == null) {
                constructors = pojoClass.getDeclaredConstructors();
            }
        }
        if (retValue == null) {
            this.strategy.sort(constructors, manufacturingCtx.getConstructorOrdering());
            for (Constructor<?> constructor : constructors) {
                try {
                    Object[] parameterValues = this.getParameterValuesForConstructor(constructor, pojoClass, manufacturingCtx, typeArgsMap, genericTypeArgs);
                    if (!constructor.isAccessible()) {
                        constructor.setAccessible(true);
                    }
                    Object tmp = constructor.newInstance(parameterValues);
                    retValue = (T)tmp;
                    LOG.debug("We could create an instance with constructor: " + constructor);
                    break;
                }
                catch (Exception e) {
                    LOG.debug("We couldn't create an instance for pojo: {} with constructor: {}. Will try with another one.", new Object[]{pojoClass, constructor, e});
                }
            }
        }
        if (retValue == null) {
            LOG.debug("For class {} PODAM could not possibly create a value. Will try other means.", pojoClass);
        }
        return retValue;
    }

    private <T> T doManufacturePojo(Class<T> pojoClass, ManufacturingContext manufacturingCtx, Type ... genericTypeArgs) {
        try {
            Class<?> declaringClass = null;
            Object declaringInstance = null;
            AttributeMetadata pojoMetadata = new AttributeMetadata(pojoClass, pojoClass, genericTypeArgs, declaringClass, declaringInstance);
            return this.manufacturePojoInternal(pojoClass, pojoMetadata, manufacturingCtx, genericTypeArgs);
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException(e.getMessage(), e);
        }
    }

    private <T> T manufacturePojoInternal(Class<T> pojoClass, AttributeMetadata pojoMetadata, ManufacturingContext manufacturingCtx, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object objectToReuse = this.strategy.getMemoizedObject(pojoMetadata);
        if (objectToReuse != null) {
            LOG.debug("Fetched memoized object for {} with parameters {}", pojoClass, (Object)Arrays.toString(genericTypeArgs));
            return (T)objectToReuse;
        }
        LOG.debug("Manufacturing {} with parameters {}", pojoClass, (Object)Arrays.toString(genericTypeArgs));
        HashMap<String, Type> typeArgsMap = new HashMap<String, Type>();
        Type[] genericTypeArgsExtra = TypeManufacturerUtil.fillTypeArgMap(typeArgsMap, pojoClass, genericTypeArgs);
        T retValue = this.strategy.getTypeValue(pojoMetadata, typeArgsMap, pojoClass);
        if (null == retValue) {
            if (pojoClass.isInterface()) {
                return this.getValueForAbstractType(pojoClass, pojoMetadata, manufacturingCtx, typeArgsMap, genericTypeArgs);
            }
            try {
                retValue = this.instantiatePojo(pojoClass, manufacturingCtx, typeArgsMap, genericTypeArgsExtra);
            }
            catch (SecurityException e) {
                throw new PodamMockeryException("Security exception while applying introspection.", e);
            }
        }
        if (retValue == null) {
            return this.getValueForAbstractType(pojoClass, pojoMetadata, manufacturingCtx, typeArgsMap, genericTypeArgs);
        }
        this.strategy.cacheMemoizedObject(pojoMetadata, retValue);
        List<Annotation> annotations = null;
        this.populatePojoInternal(retValue, annotations, manufacturingCtx, typeArgsMap, genericTypeArgsExtra);
        return retValue;
    }

    private <T> T populatePojoInternal(T pojo, List<Annotation> annotations, ManufacturingContext manufacturingCtx, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        LOG.debug("Populating pojo {}", pojo.getClass());
        Class<?> pojoClass = pojo.getClass();
        if (pojoClass.isArray()) {
            if (null == annotations) {
                annotations = new ArrayList<Annotation>();
            }
            String attributeName = null;
            this.fillArray(pojo, attributeName, pojoClass.getClass().getComponentType(), pojoClass.getClass().getComponentType(), annotations, manufacturingCtx, typeArgsMap);
        } else if (pojo instanceof Collection) {
            Collection collection = (Collection)pojo;
            AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
            Class<?> elementTypeClass = this.findInheretedCollectionElementType(collection, manufacturingCtx, elementGenericTypeArgs, typeArgsMap, genericTypeArgs);
            if (null == annotations) {
                annotations = new ArrayList<Annotation>();
            }
            for (Annotation annotation : collection.getClass().getAnnotations()) {
                annotations.add(annotation);
            }
            String attributeName = null;
            this.fillCollection(manufacturingCtx, annotations, attributeName, collection, elementTypeClass, elementGenericTypeArgs.get());
        } else if (pojo instanceof Map) {
            Map map = (Map)pojo;
            MapArguments mapArguments = this.findInheretedMapElementType(map, manufacturingCtx, typeArgsMap, genericTypeArgs);
            if (null != annotations) {
                mapArguments.getAnnotations().addAll(annotations);
            }
            this.fillMap(mapArguments, manufacturingCtx);
        }
        ClassInfo classInfo = this.classInfoStrategy.getClassInfo(pojo.getClass());
        Set<ClassAttribute> classAttributes = classInfo.getClassAttributes();
        for (ClassAttribute attribute : classAttributes) {
            if (this.populateReadWriteField(pojo, attribute, typeArgsMap, manufacturingCtx)) continue;
            this.populateReadOnlyField(pojo, attribute, typeArgsMap, manufacturingCtx, genericTypeArgs);
        }
        Collection<Method> extraMethods = this.classInfoStrategy.getExtraMethods(pojoClass);
        if (null != extraMethods) {
            for (Method extraMethod : extraMethods) {
                Object[] args = this.getParameterValuesForMethod(extraMethod, pojoClass, manufacturingCtx, typeArgsMap, genericTypeArgs);
                extraMethod.invoke(pojo, args);
            }
        }
        return pojo;
    }

    private <T> boolean populateReadOnlyField(T pojo, ClassAttribute attribute, Map<String, Type> typeArgsMap, ManufacturingContext manufacturingCtx, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Method getter = PodamUtils.selectLatestMethod(attribute.getGetters());
        if (getter == null) {
            return false;
        }
        if (getter.getGenericParameterTypes().length > 0) {
            LOG.warn("Skipping invalid getter {}", (Object)getter);
            return false;
        }
        Class<?> pojoType = getter.getReturnType();
        if (pojoType.isPrimitive()) {
            return false;
        }
        Object fieldValue = null;
        try {
            fieldValue = getter.invoke(pojo, PodamConstants.NO_ARGS);
        }
        catch (Exception e) {
            LOG.debug("Cannot access {}, skipping", (Object)getter);
        }
        if (fieldValue != null) {
            Type[] genericTypeArgsAll;
            Map<String, Type> paramTypeArgsMap;
            LOG.debug("Populating read-only field {}", (Object)getter);
            Type genericPojoType = getter.getGenericReturnType();
            if (genericPojoType instanceof ParameterizedType) {
                paramTypeArgsMap = new HashMap<String, Type>(typeArgsMap);
                ParameterizedType paramType = (ParameterizedType)genericPojoType;
                Type[] actualTypes = paramType.getActualTypeArguments();
                TypeManufacturerUtil.fillTypeArgMap(paramTypeArgsMap, pojoType, actualTypes);
                genericTypeArgsAll = TypeManufacturerUtil.fillTypeArgMap(paramTypeArgsMap, pojoType, genericTypeArgs);
            } else {
                paramTypeArgsMap = typeArgsMap;
                genericTypeArgsAll = genericTypeArgs;
            }
            List<Annotation> pojoAttributeAnnotations = PodamUtils.getAttributeAnnotations(attribute.getAttribute(), getter);
            Class<?> fieldClass = fieldValue.getClass();
            Integer depth = manufacturingCtx.getPojos().get(fieldClass);
            if (depth == null) {
                depth = 0;
            }
            if (depth < this.strategy.getMaxDepth(fieldClass)) {
                manufacturingCtx.getPojos().put(fieldClass, depth + 1);
                this.populatePojoInternal(fieldValue, pojoAttributeAnnotations, manufacturingCtx, paramTypeArgsMap, genericTypeArgsAll);
                manufacturingCtx.getPojos().put(fieldClass, depth);
            } else {
                LOG.warn("Loop of depth " + depth + " in filling read-only field {} detected.", (Object)getter);
            }
            return true;
        }
        return false;
    }

    private <T> boolean populateReadWriteField(T pojo, ClassAttribute attribute, Map<String, Type> typeArgsMap, ManufacturingContext manufacturingCtx) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Method setter = PodamUtils.selectLatestMethod(attribute.getSetters());
        if (setter == null) {
            return false;
        }
        Class<?>[] parameterTypes = setter.getParameterTypes();
        if (parameterTypes.length != 1) {
            LOG.warn("Skipping setter with non-single arguments {}", (Object)setter);
            return false;
        }
        LOG.debug("Populating read-write field {}", (Object)setter);
        Class<?> attributeType = parameterTypes[0];
        List<Annotation> pojoAttributeAnnotations = PodamUtils.getAttributeAnnotations(attribute.getAttribute(), setter);
        AttributeStrategy<?> attributeStrategy = TypeManufacturerUtil.findAttributeStrategy(this.strategy, pojoAttributeAnnotations, attributeType);
        Object setterArg = null;
        if (null != attributeStrategy) {
            setterArg = TypeManufacturerUtil.returnAttributeDataStrategyValue(attributeType, pojoAttributeAnnotations, attributeStrategy);
        } else {
            Type[] typeArguments;
            AtomicReference<Type[]> typeGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
            Type genericType = setter.getGenericParameterTypes()[0];
            if (!(genericType instanceof GenericArrayType)) {
                attributeType = TypeManufacturerUtil.resolveGenericParameter(genericType, typeArgsMap, typeGenericTypeArgs);
                typeArguments = typeGenericTypeArgs.get();
            } else {
                typeArguments = PodamConstants.NO_TYPES;
            }
            for (int i = 0; i < typeArguments.length; ++i) {
                Class<?> resolvedType;
                if (!(typeArguments[i] instanceof TypeVariable) || Collection.class.isAssignableFrom(resolvedType = TypeManufacturerUtil.resolveGenericParameter(typeArguments[i], typeArgsMap, typeGenericTypeArgs)) || Map.class.isAssignableFrom(resolvedType)) continue;
                typeArguments[i] = resolvedType;
            }
            setterArg = this.manufactureAttributeValue(pojo, manufacturingCtx, attributeType, genericType, pojoAttributeAnnotations, attribute.getName(), typeArgsMap, typeArguments);
        }
        try {
            setter.invoke(pojo, setterArg);
        }
        catch (IllegalAccessException e) {
            LOG.warn("{} is not accessible. Setting it to accessible. However this is a security hack and your code should really adhere to JavaBeans standards.", (Object)setter.toString());
            setter.setAccessible(true);
            setter.invoke(pojo, setterArg);
        }
        return true;
    }

    private Object manufactureAttributeValue(Object pojo, ManufacturingContext manufacturingCtx, Class<?> attributeType, Type genericAttributeType, List<Annotation> annotations, String attributeName, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> realAttributeType;
        Class<?> pojoClass;
        Object attributeValue = null;
        Class<?> clazz = pojoClass = pojo instanceof Class ? (Class<?>)pojo : pojo.getClass();
        if (attributeType != genericAttributeType && Object.class.equals(attributeType) && genericAttributeType instanceof TypeVariable) {
            AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
            realAttributeType = TypeManufacturerUtil.resolveGenericParameter(genericAttributeType, typeArgsMap, elementGenericTypeArgs);
        } else {
            realAttributeType = attributeType;
        }
        Type[] genericTypeArgsAll = TypeManufacturerUtil.mergeActualAndSuppliedGenericTypes(attributeType, genericAttributeType, genericTypeArgs, typeArgsMap);
        AttributeMetadata attributeMetadata = new AttributeMetadata(attributeName, realAttributeType, genericAttributeType, genericTypeArgsAll, annotations, pojoClass, pojo);
        if (realAttributeType.isArray()) {
            attributeValue = this.resolveArrayElementValue(pojo, manufacturingCtx, attributeMetadata, typeArgsMap);
        } else if (Collection.class.isAssignableFrom(realAttributeType)) {
            attributeValue = this.resolveCollectionValueWhenCollectionIsPojoAttribute(pojo, manufacturingCtx, attributeMetadata, typeArgsMap);
        } else if (Map.class.isAssignableFrom(realAttributeType)) {
            attributeValue = this.resolveMapValueWhenMapIsPojoAttribute(pojo, manufacturingCtx, attributeMetadata, typeArgsMap);
        }
        if (attributeValue == null) {
            Integer depth = manufacturingCtx.getPojos().get(realAttributeType);
            if (depth == null) {
                depth = 0;
            }
            if (depth < this.strategy.getMaxDepth(pojoClass)) {
                manufacturingCtx.getPojos().put(realAttributeType, depth + 1);
                attributeValue = this.manufacturePojoInternal(realAttributeType, attributeMetadata, manufacturingCtx, genericTypeArgsAll);
                manufacturingCtx.getPojos().put(realAttributeType, depth);
            } else {
                attributeValue = this.resortToExternalFactory(manufacturingCtx, "Loop of depth " + depth + " in {} production detected. Resorting to {} external factory", realAttributeType, genericTypeArgsAll);
            }
        }
        return attributeValue;
    }

    private <T> T resortToExternalFactory(ManufacturingContext manufacturingCtx, String msg, Class<T> pojoClass, Type ... genericTypeArgs) {
        LOG.warn(msg, pojoClass, (Object)this.externalFactory.getClass().getName());
        if (manufacturingCtx.getConstructorOrdering() == DataProviderStrategy.Order.HEAVY_FIRST) {
            return this.externalFactory.manufacturePojoWithFullData(pojoClass, genericTypeArgs);
        }
        return this.externalFactory.manufacturePojo(pojoClass, genericTypeArgs);
    }

    private Collection<? super Object> resolveCollectionValueWhenCollectionIsPojoAttribute(Object pojo, ManufacturingContext manufacturingCtx, AttributeMetadata attributeMetadata, Map<String, Type> typeArgsMap) {
        String attributeName = attributeMetadata.getAttributeName();
        Object defaultValue = null;
        if (null != pojo && null != attributeName && !Character.isDigit(attributeName.charAt(0))) {
            defaultValue = (Collection)PodamUtils.getFieldValue(pojo, attributeName);
        }
        Object retValue = null;
        if (null != defaultValue && (defaultValue.getClass().getModifiers() & 2) == 0) {
            retValue = defaultValue;
        } else {
            Class<?> collectionType = attributeMetadata.getAttributeType();
            retValue = (Collection)this.strategy.getTypeValue(attributeMetadata, typeArgsMap, collectionType);
            if (null != retValue && null != defaultValue) {
                retValue.addAll(defaultValue);
            }
        }
        if (null == retValue) {
            return null;
        }
        try {
            Class<?> typeClass = null;
            AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
            if (ArrayUtils.isEmpty((Object[])attributeMetadata.getAttrGenericArgs())) {
                typeClass = this.findInheretedCollectionElementType((Collection<Object>)retValue, manufacturingCtx, elementGenericTypeArgs, typeArgsMap, attributeMetadata.getAttrGenericArgs());
            } else {
                Type actualTypeArgument = attributeMetadata.getAttrGenericArgs()[0];
                typeClass = TypeManufacturerUtil.resolveGenericParameter(actualTypeArgument, typeArgsMap, elementGenericTypeArgs);
            }
            this.fillCollection(manufacturingCtx, attributeMetadata.getAttributeAnnotations(), attributeName, (Collection<? super Object>)retValue, typeClass, elementGenericTypeArgs.get());
        }
        catch (SecurityException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        catch (IllegalArgumentException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException(RESOLVING_COLLECTION_EXCEPTION_STR, e);
        }
        return retValue;
    }

    private Class<?> findInheretedCollectionElementType(Collection<Object> collection, ManufacturingContext manufacturingCtx, AtomicReference<Type[]> elementGenericTypeArgs, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) {
        Class<?> pojoClass;
        Class<?> collectionClass = pojoClass = collection.getClass();
        Type[] typeParams = collectionClass.getTypeParameters();
        block0: while (typeParams.length < 1) {
            Class<?> clazz;
            for (Type genericIface : collectionClass.getGenericInterfaces()) {
                Class<?> clazz2 = TypeManufacturerUtil.resolveGenericParameter(genericIface, typeArgsMap, elementGenericTypeArgs);
                if (!Collection.class.isAssignableFrom(clazz2)) continue;
                collectionClass = clazz2;
                typeParams = elementGenericTypeArgs.get();
                continue block0;
            }
            Type type = collectionClass.getGenericSuperclass();
            if (type != null && Collection.class.isAssignableFrom(clazz = TypeManufacturerUtil.resolveGenericParameter(type, typeArgsMap, elementGenericTypeArgs))) {
                collectionClass = clazz;
                typeParams = elementGenericTypeArgs.get();
                continue;
            }
            if (!Collection.class.equals(collectionClass)) continue;
            LOG.warn("Collection {} doesn't have generic types,will use Object instead", pojoClass);
            typeParams = new Type[]{Object.class};
        }
        Class<?> elementTypeClass = TypeManufacturerUtil.resolveGenericParameter(typeParams[0], typeArgsMap, elementGenericTypeArgs);
        Type[] elementGenericArgs = (Type[])ArrayUtils.addAll((Object[])elementGenericTypeArgs.get(), (Object[])genericTypeArgs);
        elementGenericTypeArgs.set(elementGenericArgs);
        return elementTypeClass;
    }

    private void fillCollection(ManufacturingContext manufacturingCtx, List<Annotation> annotations, String attributeName, Collection<? super Object> collection, Class<?> collectionElementType, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Holder elementStrategyHolder = new Holder();
        Holder<AttributeStrategy<?>> keyStrategyHolder = null;
        Integer nbrElements = TypeManufacturerUtil.findCollectionSize(this.strategy, annotations, collectionElementType, elementStrategyHolder, keyStrategyHolder);
        AttributeStrategy<?> elementStrategy = elementStrategyHolder.getValue();
        try {
            if (collection.size() > nbrElements) {
                collection.clear();
            }
            for (int i = collection.size(); i < nbrElements; ++i) {
                Object element = TypeManufacturerUtil.returnAttributeDataStrategyValue(collectionElementType, annotations, elementStrategy);
                if (null == element) {
                    element = this.manufactureAttributeValue(collection, manufacturingCtx, collectionElementType, collectionElementType, annotations, attributeName, NULL_TYPE_ARGS_MAP, genericTypeArgs);
                }
                collection.add(element);
            }
        }
        catch (UnsupportedOperationException e) {
            LOG.warn("Cannot fill immutable collection {}", collection.getClass());
        }
    }

    private Map<? super Object, ? super Object> resolveMapValueWhenMapIsPojoAttribute(Object pojo, ManufacturingContext manufacturingCtx, AttributeMetadata attributeMetadata, Map<String, Type> typeArgsMap) {
        Object retValue;
        String attributeName = attributeMetadata.getAttributeName();
        Object defaultValue = null;
        if (null != pojo && !Character.isDigit(attributeName.charAt(0))) {
            defaultValue = (Map)PodamUtils.getFieldValue(pojo, attributeName);
        }
        if (null != defaultValue && (defaultValue.getClass().getModifiers() & 2) == 0) {
            retValue = defaultValue;
        } else {
            Class<?> mapType = attributeMetadata.getAttributeType();
            retValue = (Map)this.strategy.getTypeValue(attributeMetadata, typeArgsMap, mapType);
            if (null != retValue && null != defaultValue) {
                retValue.putAll(defaultValue);
            }
        }
        if (null == retValue) {
            return null;
        }
        try {
            Class<?> keyClass = null;
            Class<?> elementClass = null;
            AtomicReference<Type[]> keyGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
            AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
            if (ArrayUtils.isEmpty((Object[])attributeMetadata.getAttrGenericArgs())) {
                MapArguments mapArgs = this.findInheretedMapElementType((Map<Object, Object>)retValue, manufacturingCtx, typeArgsMap, attributeMetadata.getAttrGenericArgs());
                keyClass = mapArgs.getKeyOrValueType();
                elementClass = mapArgs.getElementClass();
            } else {
                if (attributeMetadata.getAttrGenericArgs().length != 2) {
                    throw new IllegalStateException("In a Map only key value generic type are expected,but received " + Arrays.toString(attributeMetadata.getAttrGenericArgs()));
                }
                Type[] actualTypeArguments = attributeMetadata.getAttrGenericArgs();
                keyClass = TypeManufacturerUtil.resolveGenericParameter(actualTypeArguments[0], typeArgsMap, keyGenericTypeArgs);
                elementClass = TypeManufacturerUtil.resolveGenericParameter(actualTypeArguments[1], typeArgsMap, elementGenericTypeArgs);
            }
            MapArguments mapArguments = new MapArguments();
            mapArguments.setAttributeName(attributeName);
            mapArguments.getAnnotations().addAll(attributeMetadata.getAttributeAnnotations());
            mapArguments.setMapToBeFilled((Map<? super Object, ? super Object>)retValue);
            mapArguments.setKeyOrValueType(keyClass);
            mapArguments.setElementClass(elementClass);
            mapArguments.setKeyGenericTypeArgs(keyGenericTypeArgs.get());
            mapArguments.setElementGenericTypeArgs(elementGenericTypeArgs.get());
            this.fillMap(mapArguments, manufacturingCtx);
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException(MAP_CREATION_EXCEPTION_STR, e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException(MAP_CREATION_EXCEPTION_STR, e);
        }
        catch (SecurityException e) {
            throw new PodamMockeryException(MAP_CREATION_EXCEPTION_STR, e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException(MAP_CREATION_EXCEPTION_STR, e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException(MAP_CREATION_EXCEPTION_STR, e);
        }
        return retValue;
    }

    private MapArguments findInheretedMapElementType(Map<Object, Object> map, ManufacturingContext manufacturingCtx, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) {
        Class<?> pojoClass;
        Class<?> mapClass = pojoClass = map.getClass();
        AtomicReference<Type[]> elementGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
        Type[] typeParams = mapClass.getTypeParameters();
        block0: while (typeParams.length < 2) {
            Class<?> clazz;
            for (Type genericIface : mapClass.getGenericInterfaces()) {
                Class<?> clazz2 = TypeManufacturerUtil.resolveGenericParameter(genericIface, typeArgsMap, elementGenericTypeArgs);
                if (!Map.class.isAssignableFrom(clazz2)) continue;
                typeParams = elementGenericTypeArgs.get();
                mapClass = clazz2;
                continue block0;
            }
            Type type = mapClass.getGenericSuperclass();
            if (type != null && Map.class.isAssignableFrom(clazz = TypeManufacturerUtil.resolveGenericParameter(type, typeArgsMap, elementGenericTypeArgs))) {
                typeParams = elementGenericTypeArgs.get();
                mapClass = clazz;
                continue;
            }
            if (!Map.class.equals(mapClass)) continue;
            LOG.warn("Map {} doesn't have generic types,will use Object, Object instead", pojoClass);
            typeParams = new Type[]{Object.class, Object.class};
        }
        AtomicReference<Type[]> keyGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
        Class<?> keyClass = TypeManufacturerUtil.resolveGenericParameter(typeParams[0], typeArgsMap, keyGenericTypeArgs);
        Class<?> elementClass = TypeManufacturerUtil.resolveGenericParameter(typeParams[1], typeArgsMap, elementGenericTypeArgs);
        Type[] keyGenericArgs = (Type[])ArrayUtils.addAll((Object[])keyGenericTypeArgs.get(), (Object[])genericTypeArgs);
        Type[] elementGenericArgs = (Type[])ArrayUtils.addAll((Object[])elementGenericTypeArgs.get(), (Object[])genericTypeArgs);
        MapArguments mapArguments = new MapArguments();
        for (Annotation annotation : pojoClass.getAnnotations()) {
            mapArguments.getAnnotations().add(annotation);
        }
        mapArguments.setMapToBeFilled(map);
        mapArguments.setKeyOrValueType(keyClass);
        mapArguments.setElementClass(elementClass);
        mapArguments.setKeyGenericTypeArgs(keyGenericArgs);
        mapArguments.setElementGenericTypeArgs(elementGenericArgs);
        return mapArguments;
    }

    private void fillMap(MapArguments mapArguments, ManufacturingContext manufacturingCtx) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Holder elementStrategyHolder = new Holder();
        Holder keyStrategyHolder = new Holder();
        Integer nbrElements = TypeManufacturerUtil.findCollectionSize(this.strategy, mapArguments.getAnnotations(), mapArguments.getElementClass(), elementStrategyHolder, keyStrategyHolder);
        AttributeStrategy<?> keyStrategy = keyStrategyHolder.getValue();
        AttributeStrategy<?> elementStrategy = elementStrategyHolder.getValue();
        Map<? super Object, ? super Object> map = mapArguments.getMapToBeFilled();
        try {
            if (map.size() > nbrElements) {
                map.clear();
            }
            for (int i = map.size(); i < nbrElements; ++i) {
                Object keyValue = null;
                Object elementValue = null;
                MapKeyOrElementsArguments valueArguments = new MapKeyOrElementsArguments();
                valueArguments.setAttributeName(mapArguments.getAttributeName());
                valueArguments.setMapToBeFilled(mapArguments.getMapToBeFilled());
                valueArguments.getAnnotations().addAll(mapArguments.getAnnotations());
                valueArguments.setKeyOrValueType(mapArguments.getKeyOrValueType());
                valueArguments.setElementStrategy(keyStrategy);
                valueArguments.setGenericTypeArgs(mapArguments.getKeyGenericTypeArgs());
                keyValue = this.getMapKeyOrElementValue(valueArguments, manufacturingCtx);
                valueArguments.setKeyOrValueType(mapArguments.getElementClass());
                valueArguments.setElementStrategy(elementStrategy);
                valueArguments.setGenericTypeArgs(mapArguments.getElementGenericTypeArgs());
                elementValue = this.getMapKeyOrElementValue(valueArguments, manufacturingCtx);
                if (elementValue == null && map instanceof ConcurrentHashMap) continue;
                map.put(keyValue, elementValue);
            }
        }
        catch (UnsupportedOperationException e) {
            LOG.warn("Cannot fill immutable map {}", map.getClass());
        }
    }

    private Object getMapKeyOrElementValue(MapKeyOrElementsArguments keyOrElementsArguments, ManufacturingContext manufacturingCtx) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        AttributeStrategy<?> strategy = keyOrElementsArguments.getElementStrategy();
        Object retValue = TypeManufacturerUtil.returnAttributeDataStrategyValue(keyOrElementsArguments.getKeyOrValueType(), keyOrElementsArguments.getAnnotations(), strategy);
        if (null == retValue) {
            retValue = this.manufactureAttributeValue(keyOrElementsArguments.getMapToBeFilled(), manufacturingCtx, keyOrElementsArguments.getKeyOrValueType(), keyOrElementsArguments.getKeyOrValueType(), keyOrElementsArguments.getAnnotations(), keyOrElementsArguments.getAttributeName(), NULL_TYPE_ARGS_MAP, keyOrElementsArguments.getGenericTypeArgs());
        }
        return retValue;
    }

    private void fillArray(Object array, String attributeName, Class<?> elementType, Type genericElementType, List<Annotation> annotations, ManufacturingContext manufacturingCtx, Map<String, Type> typeArgsMap) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Type genericComponentType;
        Class<?> componentType = array.getClass().getComponentType();
        AtomicReference<Type[]> genericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
        if (genericElementType instanceof GenericArrayType) {
            genericComponentType = ((GenericArrayType)genericElementType).getGenericComponentType();
            if (genericComponentType instanceof TypeVariable) {
                TypeVariable componentTypeVariable = (TypeVariable)genericComponentType;
                Type resolvedType = typeArgsMap.get(componentTypeVariable.getName());
                componentType = TypeManufacturerUtil.resolveGenericParameter(resolvedType, typeArgsMap, genericTypeArgs);
            }
        } else {
            genericComponentType = componentType;
        }
        Holder elementStrategyHolder = new Holder();
        Holder<AttributeStrategy<?>> keyStrategyHolder = null;
        TypeManufacturerUtil.findCollectionSize(this.strategy, annotations, elementType, elementStrategyHolder, keyStrategyHolder);
        AttributeStrategy<?> elementStrategy = elementStrategyHolder.getValue();
        int nbrElements = Array.getLength(array);
        for (int i = 0; i < nbrElements; ++i) {
            Object arrayElement = Array.get(array, i);
            if (null != arrayElement && !arrayElement.getClass().isPrimitive() && !(arrayElement instanceof Number)) continue;
            arrayElement = TypeManufacturerUtil.returnAttributeDataStrategyValue(componentType, annotations, elementStrategy);
            if (null == arrayElement) {
                arrayElement = this.manufactureAttributeValue(array, manufacturingCtx, componentType, genericComponentType, annotations, attributeName, typeArgsMap, genericTypeArgs.get());
            }
            Array.set(array, i, arrayElement);
        }
    }

    private Object resolveArrayElementValue(Object pojo, ManufacturingContext manufacturingCtx, AttributeMetadata attributeMetadata, Map<String, Type> typeArgsMap) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> arrayType = attributeMetadata.getAttributeType();
        Object array = this.strategy.getTypeValue(attributeMetadata, typeArgsMap, arrayType);
        this.fillArray(array, attributeMetadata.getAttributeName(), attributeMetadata.getAttributeType(), attributeMetadata.getAttributeGenericType(), attributeMetadata.getAttributeAnnotations(), manufacturingCtx, typeArgsMap);
        return array;
    }

    private Object[] getParameterValuesForConstructor(Constructor<?> constructor, Class<?> pojoClass, ManufacturingContext manufacturingCtx, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length == 0) {
            return PodamConstants.NO_ARGS;
        }
        Object[] parameterValues = new Object[parameterTypes.length];
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        Object[] genericTypes = constructor.getGenericParameterTypes();
        String ctorName = Arrays.toString(genericTypes);
        for (int idx = 0; idx < parameterTypes.length; ++idx) {
            List<Annotation> annotations = Arrays.asList(parameterAnnotations[idx]);
            Class<?> genericType = idx < genericTypes.length ? genericTypes[idx] : parameterTypes[idx];
            parameterValues[idx] = this.manufactureParameterValue(pojoClass, idx + ctorName, parameterTypes[idx], genericType, annotations, typeArgsMap, manufacturingCtx, genericTypeArgs);
        }
        return parameterValues;
    }

    private Object[] getParameterValuesForMethod(Method method, Class<?> pojoClass, ManufacturingContext manufacturingCtx, Map<String, Type> typeArgsMap, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            return PodamConstants.NO_ARGS;
        }
        Object[] parameterValues = new Object[parameterTypes.length];
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Object[] genericTypes = method.getGenericParameterTypes();
        String methodName = Arrays.toString(genericTypes);
        for (int idx = 0; idx < parameterTypes.length; ++idx) {
            List<Annotation> annotations = Arrays.asList(parameterAnnotations[idx]);
            Class<?> genericType = idx < genericTypes.length ? genericTypes[idx] : parameterTypes[idx];
            parameterValues[idx] = this.manufactureParameterValue(pojoClass, idx + methodName, parameterTypes[idx], genericType, annotations, typeArgsMap, manufacturingCtx, genericTypeArgs);
        }
        return parameterValues;
    }

    private Object manufactureParameterValue(Class<?> pojoClass, String parameterName, Class<?> parameterType, Type genericType, List<Annotation> annotations, Map<String, Type> typeArgsMap, ManufacturingContext manufacturingCtx, Type ... genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Map<String, Type> typeArgsMapForParam;
        AttributeStrategy<?> attributeStrategy = TypeManufacturerUtil.findAttributeStrategy(this.strategy, annotations, parameterType);
        if (null != attributeStrategy) {
            return TypeManufacturerUtil.returnAttributeDataStrategyValue(parameterType, annotations, attributeStrategy);
        }
        if (genericType instanceof ParameterizedType) {
            typeArgsMapForParam = new HashMap<String, Type>(typeArgsMap);
            ParameterizedType parametrizedType = (ParameterizedType)genericType;
            TypeVariable<Class<?>>[] argumentTypes = parameterType.getTypeParameters();
            Type[] argumentGenericTypes = parametrizedType.getActualTypeArguments();
            for (int k = 0; k < argumentTypes.length; ++k) {
                if (!(argumentGenericTypes[k] instanceof Class)) continue;
                Class genericParam = (Class)argumentGenericTypes[k];
                typeArgsMapForParam.put(argumentTypes[k].getName(), genericParam);
            }
        } else {
            typeArgsMapForParam = typeArgsMap;
        }
        return this.manufactureAttributeValue(pojoClass, manufacturingCtx, parameterType, genericType, annotations, parameterName, typeArgsMapForParam, genericTypeArgs);
    }

    private <T> T getValueForAbstractType(Class<T> pojoClass, AttributeMetadata pojoMetadata, ManufacturingContext manufacturingCtx, Map<String, Type> typeArgsMap, Type[] genericTypeArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        T retValue;
        Class<T> specificClass = this.strategy.getSpecificClass(pojoClass);
        if (!specificClass.equals(pojoClass)) {
            return this.manufacturePojoInternal(specificClass, pojoMetadata, manufacturingCtx, genericTypeArgs);
        }
        Class<?> factory = this.strategy.getFactoryClass(pojoClass);
        if (factory != null && (retValue = this.instantiatePojoWithFactory(factory, pojoClass, manufacturingCtx, typeArgsMap, genericTypeArgs)) != null) {
            return retValue;
        }
        return this.resortToExternalFactory(manufacturingCtx, "Cannot instantiate a class {}. Resorting to {} external factory", pojoClass, genericTypeArgs);
    }
}

