/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.ClassAttribute;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.RandomDataProviderStrategy;
import uk.co.jemos.podam.common.AbstractConstructorComparator;
import uk.co.jemos.podam.common.AbstractMethodComparator;
import uk.co.jemos.podam.common.AttributeStrategy;
import uk.co.jemos.podam.common.ConstructorHeavyFirstComparator;
import uk.co.jemos.podam.common.ConstructorLightFirstComparator;
import uk.co.jemos.podam.common.ManufacturingContext;
import uk.co.jemos.podam.common.MethodHeavyFirstComparator;
import uk.co.jemos.podam.common.MethodLightFirstComparator;
import uk.co.jemos.podam.exceptions.PodamMockeryException;
import uk.co.jemos.podam.typeManufacturers.ArrayTypeManufacturerImpl;
import uk.co.jemos.podam.typeManufacturers.BooleanTypeManufacturerImpl;
import uk.co.jemos.podam.typeManufacturers.ByteTypeManufacturerImpl;
import uk.co.jemos.podam.typeManufacturers.CharTypeManufacturerImpl;
import uk.co.jemos.podam.typeManufacturers.CollectionTypeManufacturerImpl;
import uk.co.jemos.podam.typeManufacturers.DoubleTypeManufacturerImpl;
import uk.co.jemos.podam.typeManufacturers.EnumTypeManufacturerImpl;
import uk.co.jemos.podam.typeManufacturers.FloatTypeManufacturerImpl;
import uk.co.jemos.podam.typeManufacturers.IntTypeManufacturerImpl;
import uk.co.jemos.podam.typeManufacturers.LongTypeManufacturerImpl;
import uk.co.jemos.podam.typeManufacturers.MapTypeManufacturerImpl;
import uk.co.jemos.podam.typeManufacturers.ShortTypeManufacturerImpl;
import uk.co.jemos.podam.typeManufacturers.StringTypeManufacturerImpl;
import uk.co.jemos.podam.typeManufacturers.TypeManufacturer;
import uk.co.jemos.podam.typeManufacturers.TypeTypeManufacturerImpl;

@ThreadSafe
public abstract class AbstractRandomDataProviderStrategy
implements RandomDataProviderStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRandomDataProviderStrategy.class);
    private int maxDepth = 3;
    private final AtomicInteger nbrOfCollectionElements = new AtomicInteger();
    private final AtomicBoolean isMemoizationEnabled = new AtomicBoolean();
    private final Map<Class<?>, Map<Type[], Object>> memoizationTable = new HashMap();
    private final ConcurrentHashMap<Class<?>, TypeManufacturer<?>> typeManufacturers = new ConcurrentHashMap();
    private final Map<Class<?>, Class<?>> specificTypes = new ConcurrentHashMap();
    private final Map<Class<?>, Class<?>> factoryTypes = new ConcurrentHashMap();
    private final Map<Class<? extends Annotation>, AttributeStrategy<?>> attributeStrategies = new ConcurrentHashMap();
    private final Map<Class<?>, Map<String, AttributeStrategy<?>>> attributeClassStrategies = new ConcurrentHashMap();
    private AbstractConstructorComparator constructorHeavyComparator = ConstructorHeavyFirstComparator.INSTANCE;
    private AbstractConstructorComparator constructorLightComparator = ConstructorLightFirstComparator.INSTANCE;
    private AbstractMethodComparator methodHeavyComparator = MethodHeavyFirstComparator.INSTANCE;
    private AbstractMethodComparator methodLightComparator = MethodLightFirstComparator.INSTANCE;

    public AbstractRandomDataProviderStrategy() {
        this(5);
    }

    public AbstractRandomDataProviderStrategy(int nbrOfCollectionElements) {
        this.nbrOfCollectionElements.set(nbrOfCollectionElements);
        ByteTypeManufacturerImpl byteManufacturer = new ByteTypeManufacturerImpl();
        this.typeManufacturers.put(Byte.TYPE, byteManufacturer);
        this.typeManufacturers.put(Byte.class, byteManufacturer);
        BooleanTypeManufacturerImpl booleanManufacturer = new BooleanTypeManufacturerImpl();
        this.typeManufacturers.put(Boolean.TYPE, booleanManufacturer);
        this.typeManufacturers.put(Boolean.class, booleanManufacturer);
        CharTypeManufacturerImpl charManufacturer = new CharTypeManufacturerImpl();
        this.typeManufacturers.put(Character.TYPE, charManufacturer);
        this.typeManufacturers.put(Character.class, charManufacturer);
        ShortTypeManufacturerImpl shortManufacturer = new ShortTypeManufacturerImpl();
        this.typeManufacturers.put(Short.TYPE, shortManufacturer);
        this.typeManufacturers.put(Short.class, shortManufacturer);
        IntTypeManufacturerImpl intManufacturer = new IntTypeManufacturerImpl();
        this.typeManufacturers.put(Integer.TYPE, intManufacturer);
        this.typeManufacturers.put(Integer.class, intManufacturer);
        LongTypeManufacturerImpl longManufacturer = new LongTypeManufacturerImpl();
        this.typeManufacturers.put(Long.TYPE, longManufacturer);
        this.typeManufacturers.put(Long.class, longManufacturer);
        FloatTypeManufacturerImpl floatManufacturer = new FloatTypeManufacturerImpl();
        this.typeManufacturers.put(Float.TYPE, floatManufacturer);
        this.typeManufacturers.put(Float.class, floatManufacturer);
        DoubleTypeManufacturerImpl doubleManufacturer = new DoubleTypeManufacturerImpl();
        this.typeManufacturers.put(Double.TYPE, doubleManufacturer);
        this.typeManufacturers.put(Double.class, doubleManufacturer);
        StringTypeManufacturerImpl stringManufacturer = new StringTypeManufacturerImpl();
        this.typeManufacturers.put(CharSequence.class, stringManufacturer);
        EnumTypeManufacturerImpl enumManufacturer = new EnumTypeManufacturerImpl();
        this.typeManufacturers.put(Enum.class, enumManufacturer);
        TypeTypeManufacturerImpl typeManufacturer = new TypeTypeManufacturerImpl();
        this.typeManufacturers.put(Type.class, typeManufacturer);
        CollectionTypeManufacturerImpl collectionManufacturer = new CollectionTypeManufacturerImpl();
        this.typeManufacturers.put(Collection.class, collectionManufacturer);
        MapTypeManufacturerImpl mapManufacturer = new MapTypeManufacturerImpl();
        this.typeManufacturers.put(Map.class, mapManufacturer);
        ArrayTypeManufacturerImpl arrayManufacturer = new ArrayTypeManufacturerImpl();
        this.typeManufacturers.put(Cloneable.class, arrayManufacturer);
    }

    @Override
    public int getNumberOfCollectionElements(Class<?> type) {
        return this.nbrOfCollectionElements.get();
    }

    @Override
    public void setDefaultNumberOfCollectionElements(int newNumberOfCollectionElements) {
        this.nbrOfCollectionElements.set(newNumberOfCollectionElements);
    }

    @Override
    public int getMaxDepth(Class<?> type) {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    @Override
    public boolean isMemoizationEnabled() {
        return this.isMemoizationEnabled.get();
    }

    @Override
    public void setMemoization(boolean isMemoizationEnabled) {
        this.isMemoizationEnabled.set(isMemoizationEnabled);
    }

    @Override
    public synchronized Object getMemoizedObject(AttributeMetadata attributeMetadata) {
        Map<Type[], Object> map;
        Class<?> pojoClass;
        if (this.isMemoizationEnabled.get() && ((pojoClass = attributeMetadata.getPojoClass()) == null || !pojoClass.isArray() && !Collection.class.isAssignableFrom(pojoClass) && !Map.class.isAssignableFrom(pojoClass)) && (map = this.memoizationTable.get(attributeMetadata.getAttributeType())) != null) {
            for (Map.Entry<Type[], Object> entry : map.entrySet()) {
                if (!Arrays.equals(entry.getKey(), attributeMetadata.getAttrGenericArgs())) continue;
                LOG.trace("Found memoized {}<{}>", attributeMetadata.getAttributeType(), (Object)attributeMetadata.getAttrGenericArgs());
                return entry.getValue();
            }
        }
        return null;
    }

    @Override
    public synchronized void cacheMemoizedObject(AttributeMetadata attributeMetadata, Object instance) {
        if (this.isMemoizationEnabled.get()) {
            Map<Type[], Object> map = this.memoizationTable.get(attributeMetadata.getAttributeType());
            if (map == null) {
                map = new HashMap<Type[], Object>();
                this.memoizationTable.put(attributeMetadata.getAttributeType(), map);
            }
            LOG.trace("Saving memoized {}<{}>", attributeMetadata.getAttributeType(), (Object)attributeMetadata.getAttrGenericArgs());
            map.put(attributeMetadata.getAttrGenericArgs(), instance);
        }
    }

    @Override
    public synchronized void clearMemoizationCache() {
        this.memoizationTable.clear();
    }

    @Override
    public void sort(Constructor<?>[] constructors, DataProviderStrategy.Order order) {
        AbstractConstructorComparator constructorComparator;
        switch (order) {
            case HEAVY_FIRST: {
                constructorComparator = this.constructorHeavyComparator;
                break;
            }
            default: {
                constructorComparator = this.constructorLightComparator;
            }
        }
        Arrays.sort(constructors, constructorComparator);
    }

    @Override
    public void sort(Method[] methods, DataProviderStrategy.Order order) {
        AbstractMethodComparator methodComparator;
        switch (order) {
            case HEAVY_FIRST: {
                methodComparator = this.methodHeavyComparator;
                break;
            }
            default: {
                methodComparator = this.methodLightComparator;
            }
        }
        Arrays.sort(methods, methodComparator);
    }

    @Override
    public <T> DataProviderStrategy addOrReplaceTypeManufacturer(Class<? extends T> type, TypeManufacturer<T> typeManufacturer) {
        this.typeManufacturers.put(type, typeManufacturer);
        return this;
    }

    @Override
    public <T> DataProviderStrategy removeTypeManufacturer(Class<T> type) {
        this.typeManufacturers.remove(type);
        return this;
    }

    @Override
    public <T> T getTypeValue(AttributeMetadata attributeMetadata, ManufacturingContext manufacturingCtx, Class<T> pojoType) {
        if (null == attributeMetadata) {
            throw new IllegalArgumentException("The attribute metadata inside the wrapper cannot be null");
        }
        if (null == attributeMetadata.getAttributeAnnotations()) {
            throw new IllegalArgumentException("The annotations list within the attribute metadata cannot be null, although it can be empty");
        }
        ArrayDeque types = new ArrayDeque();
        types.add(pojoType);
        while (!types.isEmpty()) {
            Class type = (Class)types.remove();
            TypeManufacturer<?> manufacturer = this.typeManufacturers.get(type);
            if (null != manufacturer) {
                try {
                    Object tmp = manufacturer.getType(this, attributeMetadata, manufacturingCtx);
                    if (null != tmp) {
                        this.log(attributeMetadata);
                        return (T)tmp;
                    }
                    LOG.debug("{} cannot manufacture {}", manufacturer, pojoType);
                }
                catch (Exception e) {
                    throw new PodamMockeryException("Unable to instantiate " + pojoType, e);
                }
            }
            for (Class<?> iface : type.getInterfaces()) {
                types.add(iface);
            }
            if (null == (type = type.getSuperclass())) continue;
            types.add(type);
        }
        LOG.debug("Failed to find suitable manufacturer for type {}", pojoType);
        return null;
    }

    @Override
    public <T> AbstractRandomDataProviderStrategy addOrReplaceFactory(Class<T> abstractClass, Class<?> factoryClass) {
        this.factoryTypes.put(abstractClass, factoryClass);
        return this;
    }

    @Override
    public <T> AbstractRandomDataProviderStrategy removeFactory(Class<T> abstractClass) {
        this.factoryTypes.remove(abstractClass);
        return this;
    }

    @Override
    public Class<?> getFactoryClass(Class<?> nonInstantiatableClass) {
        return this.factoryTypes.get(nonInstantiatableClass);
    }

    @Override
    public <T> DataProviderStrategy addOrReplaceSpecific(Class<T> abstractClass, Class<? extends T> specificClass) {
        this.specificTypes.put(abstractClass, specificClass);
        return this;
    }

    @Override
    public <T> DataProviderStrategy removeSpecific(Class<T> abstractClass) {
        this.specificTypes.remove(abstractClass);
        return this;
    }

    @Override
    public <T> Class<? extends T> getSpecificClass(Class<T> nonInstantiatableClass) {
        Class<Object> found = this.specificTypes.get(nonInstantiatableClass);
        if (found == null) {
            found = nonInstantiatableClass;
        }
        return found;
    }

    @Override
    public RandomDataProviderStrategy addOrReplaceAttributeStrategy(Class<? extends Annotation> annotationClass, AttributeStrategy<?> attributeStrategy) {
        this.attributeStrategies.put(annotationClass, attributeStrategy);
        return this;
    }

    @Override
    public RandomDataProviderStrategy removeAttributeStrategy(Class<? extends Annotation> annotationClass) {
        this.attributeStrategies.remove(annotationClass);
        return this;
    }

    @Override
    public AttributeStrategy<?> getStrategyForAnnotation(Class<? extends Annotation> annotationClass) {
        return this.attributeStrategies.get(annotationClass);
    }

    @Override
    public RandomDataProviderStrategy addOrReplaceAttributeStrategy(Class<?> type, String attributeName, AttributeStrategy<?> attributeStrategy) {
        Map<String, AttributeStrategy<?>> classStrategies = this.attributeClassStrategies.get(type);
        if (null == classStrategies) {
            classStrategies = new ConcurrentHashMap();
            this.attributeClassStrategies.put(type, classStrategies);
        }
        classStrategies.put(attributeName, attributeStrategy);
        return this;
    }

    @Override
    public RandomDataProviderStrategy removeAttributeStrategy(Class<?> type, String attributeName) {
        Map<String, AttributeStrategy<?>> classStrategies = this.attributeClassStrategies.get(type);
        if (null != classStrategies) {
            classStrategies.remove(attributeName);
        }
        return this;
    }

    @Override
    public AttributeStrategy<?> getStrategyForAttribute(ClassAttribute attribute) {
        Class<?> type;
        Map<String, AttributeStrategy<?>> classStrategies;
        AttributeStrategy<?> attributeStrategy = null;
        Field field = attribute.getAttribute();
        if (null != field && null != (classStrategies = this.attributeClassStrategies.get(type = field.getDeclaringClass()))) {
            attributeStrategy = classStrategies.get(attribute.getName());
        }
        return attributeStrategy;
    }

    @Override
    public AbstractConstructorComparator getConstructorLightComparator() {
        return this.constructorLightComparator;
    }

    @Override
    public void setConstructorLightComparator(AbstractConstructorComparator constructorLightComparator) {
        this.constructorLightComparator = constructorLightComparator;
    }

    @Override
    public AbstractConstructorComparator getConstructorHeavyComparator() {
        return this.constructorHeavyComparator;
    }

    @Override
    public void setConstructorHeavyComparator(AbstractConstructorComparator constructorHeavyComparator) {
        this.constructorHeavyComparator = constructorHeavyComparator;
    }

    @Override
    public AbstractMethodComparator getMethodLightComparator() {
        return this.methodLightComparator;
    }

    @Override
    public void setMethodLightComparator(AbstractMethodComparator methodLightComparator) {
        this.methodLightComparator = methodLightComparator;
    }

    @Override
    public AbstractMethodComparator getMethodHeavyComparator() {
        return this.methodHeavyComparator;
    }

    @Override
    public void setMethodHeavyComparator(AbstractMethodComparator methodHeavyComparator) {
        this.methodHeavyComparator = methodHeavyComparator;
    }

    private void log(AttributeMetadata attributeMetadata) {
        LOG.trace("Providing data for attribute {}.{}", (Object)(attributeMetadata.getPojoClass() != null ? attributeMetadata.getPojoClass().getName() : ""), (Object)(attributeMetadata.getAttributeName() != null ? attributeMetadata.getAttributeName() : ""));
    }
}

