/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.common.PodamConstants;

public abstract class PodamUtils {
    public static final char[] NICE_ASCII_CHARACTERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_'};
    private static final Logger LOG = LoggerFactory.getLogger(PodamUtils.class);

    public static Field getField(Class<?> pojoClass, String attributeName) {
        for (Class<?> clazz = pojoClass; clazz != null; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredField(attributeName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        LOG.warn("A field could not be found for attribute '{}[{}]'", pojoClass, (Object)attributeName);
        return null;
    }

    public static <T> T getFieldValue(Object pojo, String attributeName) {
        Object retValue = null;
        try {
            Field field = PodamUtils.getField(pojo.getClass(), attributeName);
            if (field != null) {
                Object t;
                field.setAccessible(true);
                retValue = t = field.get(pojo);
            } else {
                LOG.info("The field {}[{}] didn't exist.", pojo.getClass(), (Object)attributeName);
            }
        }
        catch (Exception e) {
            LOG.warn("We couldn't get default value for {}[{}]", new Object[]{pojo.getClass(), attributeName, e});
        }
        return (T)retValue;
    }

    public static <T> T getValueWithMethod(Object pojo, String methodName, Class<?> ... methodParams) {
        Object retValue = null;
        try {
            Method method = pojo.getClass().getMethod(methodName, methodParams);
            if (method != null) {
                Object t;
                method.setAccessible(true);
                retValue = t = method.invoke(pojo, PodamConstants.NO_ARGS);
            } else {
                LOG.info("The method {}:{} didn't exist.", pojo.getClass(), (Object)methodName);
            }
        }
        catch (Exception e) {
            LOG.warn("We couldn't get default value for {}[{}]", new Object[]{pojo.getClass(), methodName, e});
        }
        return (T)retValue;
    }

    public static <T> T getFieldValueWithGetter(Object pojo, String attributeName) {
        Object retValue = null;
        return PodamUtils.getValueWithMethod(pojo, "get" + Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1), PodamConstants.NO_CLASSES);
    }

    public static Method selectLatestMethod(Set<Method> methods) {
        Method selected = null;
        for (Method method : methods) {
            if (selected != null && !selected.getDeclaringClass().isAssignableFrom(method.getDeclaringClass())) continue;
            selected = method;
        }
        return selected;
    }

    public static List<Annotation> getAttributeAnnotations(Field attribute, Method ... methods) {
        ArrayList<Annotation> retValue = new ArrayList<Annotation>();
        if (null != attribute) {
            for (Annotation annotation : attribute.getAnnotations()) {
                retValue.add(annotation);
            }
        }
        for (Method method : methods) {
            Annotation[][] paramAnnotations = method.getParameterAnnotations();
            if (paramAnnotations.length > 0) {
                for (Annotation annotation : paramAnnotations[0]) {
                    retValue.add(annotation);
                }
                continue;
            }
            for (Annotation annotation : method.getAnnotations()) {
                retValue.add(annotation);
            }
        }
        return retValue;
    }

    public static Character getNiceCharacter() {
        int randomCharIdx = PodamUtils.getIntegerInRange(0, NICE_ASCII_CHARACTERS.length - 1);
        return Character.valueOf(NICE_ASCII_CHARACTERS[randomCharIdx]);
    }

    public static String getNiceString(int length) {
        StringBuilder sb = new StringBuilder(length);
        while (sb.length() < length) {
            sb.append(PodamUtils.getNiceCharacter());
        }
        return sb.toString();
    }

    public static long getLongInRange(long minValue, long maxValue) {
        return (long)(PodamUtils.getDoubleInRange((double)minValue - 0.5, (double)maxValue + 0.5 - 0.0) + 0.5);
    }

    public static int getIntegerInRange(int minValue, int maxValue) {
        return (int)PodamUtils.getLongInRange(minValue, maxValue);
    }

    public static double getDoubleInRange(double minValue, double maxValue) {
        double retValue;
        if (minValue == maxValue) {
            return minValue;
        }
        double margin = maxValue - minValue + 0.1;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((retValue = minValue + ((Random)random).nextDouble() * margin) > maxValue) {
        }
        return retValue;
    }

    public static Class<?> primitiveToBoxedType(Class<?> primitiveType) {
        if (Integer.TYPE.equals(primitiveType)) {
            return Integer.class;
        }
        if (Double.TYPE.equals(primitiveType)) {
            return Double.class;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return Long.class;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return Byte.class;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return Float.class;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return Character.class;
        }
        if (Short.TYPE.equals(primitiveType)) {
            return Short.class;
        }
        if (Boolean.TYPE.equals(primitiveType)) {
            return Boolean.class;
        }
        return primitiveType;
    }
}

