/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.common;

import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Future;
import jakarta.validation.constraints.FutureOrPresent;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Negative;
import jakarta.validation.constraints.NegativeOrZero;
import jakarta.validation.constraints.Past;
import jakarta.validation.constraints.PastOrPresent;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.common.AttributeStrategy;
import uk.co.jemos.podam.common.EmailStrategy;
import uk.co.jemos.podam.common.PodamConstants;
import uk.co.jemos.podam.exceptions.PodamMockeryException;

public class BeanValidationStrategy
implements AttributeStrategy<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(BeanValidationStrategy.class);
    private static final String METHOD_NAME_FROM = "from";
    private static final String SIMPLE_NAME_LIST_CLASS = "List";
    private static final String NAME_VALUE = "value";
    private Class<?> attributeType;
    private EmailStrategy emailStrategy = new EmailStrategy();

    public BeanValidationStrategy(Class<?> attributeType) {
        this.attributeType = attributeType;
    }

    @Override
    public Object getValue(Class<?> attrType, List<Annotation> annotations) throws PodamMockeryException {
        NegativeOrZero negativeOrZeroAnno;
        Negative negativeAnno;
        PositiveOrZero positiveOrZeroAnno;
        Positive positiveAnno;
        Max maxAnno;
        Min minAnno;
        DecimalMax decimalMax;
        BigDecimal max;
        BigDecimal min;
        if (null != BeanValidationStrategy.findTypeFromList(annotations, AssertTrue.class)) {
            return Boolean.TRUE;
        }
        if (null != BeanValidationStrategy.findTypeFromList(annotations, AssertFalse.class)) {
            return Boolean.FALSE;
        }
        if (null != BeanValidationStrategy.findTypeFromList(annotations, Past.class)) {
            long days = PodamUtils.getIntegerInRange(1, 365);
            long offset = -TimeUnit.DAYS.toSeconds(days);
            return this.timestampToReturnType(offset);
        }
        if (null != BeanValidationStrategy.findTypeFromList(annotations, PastOrPresent.class)) {
            long days = PodamUtils.getIntegerInRange(0, 365);
            long offset = -TimeUnit.DAYS.toSeconds(days);
            return this.timestampToReturnType(offset);
        }
        if (null != BeanValidationStrategy.findTypeFromList(annotations, Future.class)) {
            long days = PodamUtils.getIntegerInRange(1, 365);
            long offset = TimeUnit.DAYS.toSeconds(days);
            return this.timestampToReturnType(offset + 10L);
        }
        if (null != BeanValidationStrategy.findTypeFromList(annotations, FutureOrPresent.class)) {
            long days = PodamUtils.getIntegerInRange(0, 365);
            long offset = TimeUnit.DAYS.toSeconds(days);
            return this.timestampToReturnType(offset + 10L);
        }
        Size size = BeanValidationStrategy.findTypeFromList(annotations, Size.class);
        if (null != size) {
            int minValue = size.min();
            int maxValue = size.max();
            if (minValue < 1 && maxValue > 0) {
                minValue = 1;
            }
            if (maxValue == Integer.MAX_VALUE) {
                maxValue = 10;
            }
            int length = PodamUtils.getIntegerInRange(minValue, maxValue);
            return PodamUtils.getNiceString(length);
        }
        Email email = BeanValidationStrategy.findTypeFromList(annotations, Email.class);
        if (null != email) {
            return this.emailStrategy.getValue((Class)attrType, (List)annotations);
        }
        Pattern pattern = BeanValidationStrategy.findTypeFromList(annotations, Pattern.class);
        if (null != pattern) {
            LOG.warn("At the moment PODAM doesn't support @Pattern({}), returning null", (Object)pattern.regexp());
            return null;
        }
        boolean isRound = false;
        boolean isFloat = false;
        if (Long.class.equals(this.attributeType) || Long.TYPE.equals(this.attributeType)) {
            min = new BigDecimal(Long.MIN_VALUE);
            max = new BigDecimal(Long.MAX_VALUE);
        } else if (Integer.class.equals(this.attributeType) || Integer.TYPE.equals(this.attributeType)) {
            min = new BigDecimal(Integer.MIN_VALUE);
            max = new BigDecimal(Integer.MAX_VALUE);
        } else if (Short.class.equals(this.attributeType) || Short.TYPE.equals(this.attributeType)) {
            min = new BigDecimal(Short.MIN_VALUE);
            max = new BigDecimal(Short.MAX_VALUE);
        } else if (Byte.class.equals(this.attributeType) || Byte.TYPE.equals(this.attributeType)) {
            min = new BigDecimal(-128);
            max = new BigDecimal(127);
        } else {
            min = new BigDecimal(-1.7976931348623157E308);
            max = new BigDecimal(Double.MAX_VALUE);
        }
        DecimalMin decimalMin = BeanValidationStrategy.findTypeFromList(annotations, DecimalMin.class);
        if (null != decimalMin) {
            isFloat = true;
            min = new BigDecimal(decimalMin.value());
        }
        if (null != (decimalMax = BeanValidationStrategy.findTypeFromList(annotations, DecimalMax.class))) {
            isFloat = true;
            max = new BigDecimal(decimalMax.value());
        }
        if (null != (minAnno = BeanValidationStrategy.findTypeFromList(annotations, Min.class))) {
            isRound = true;
            min = new BigDecimal(minAnno.value()).max(min);
        }
        if (null != (maxAnno = BeanValidationStrategy.findTypeFromList(annotations, Max.class))) {
            isRound = true;
            max = new BigDecimal(maxAnno.value()).min(max);
        }
        if (null != (positiveAnno = BeanValidationStrategy.findTypeFromList(annotations, Positive.class))) {
            isFloat = true;
            max = new BigDecimal(Integer.MAX_VALUE);
            min = new BigDecimal(1);
        }
        if (null != (positiveOrZeroAnno = BeanValidationStrategy.findTypeFromList(annotations, PositiveOrZero.class))) {
            isFloat = true;
            max = new BigDecimal(Integer.MAX_VALUE);
            min = new BigDecimal(0);
        }
        if (null != (negativeAnno = BeanValidationStrategy.findTypeFromList(annotations, Negative.class))) {
            isFloat = true;
            max = new BigDecimal(-1);
            min = new BigDecimal(Integer.MIN_VALUE);
        }
        if (null != (negativeOrZeroAnno = BeanValidationStrategy.findTypeFromList(annotations, NegativeOrZero.class))) {
            isFloat = true;
            max = new BigDecimal(0);
            min = new BigDecimal(Integer.MIN_VALUE);
        }
        Digits digits = BeanValidationStrategy.findTypeFromList(annotations, Digits.class);
        BigDecimal divisor = null;
        if (null != digits) {
            isRound = true;
            divisor = BigDecimal.TEN.pow(digits.fraction());
            BigDecimal limit = BigDecimal.TEN.pow(digits.integer());
            max = limit.min(max).multiply(divisor);
            min = limit.negate().max(min).multiply(divisor);
        }
        if (isRound || isFloat) {
            BigDecimal value = this.getValueInRange(min, max);
            if (isRound) {
                BigInteger intValue = value.toBigInteger();
                value = new BigDecimal(intValue);
            }
            if (null != divisor) {
                value = value.divide(divisor);
            }
            return this.decimalToReturnType(value);
        }
        return null;
    }

    public static <T> T findTypeFromList(List<?> list, Class<T> type) {
        for (Object item : list) {
            if (!type.isAssignableFrom(item.getClass())) continue;
            Object found = item;
            return (T)found;
        }
        for (Class<?> innerType : type.getClasses()) {
            Object[] found;
            Object foundList;
            if (!SIMPLE_NAME_LIST_CLASS.equals(innerType.getSimpleName()) || null == (foundList = BeanValidationStrategy.findTypeFromList(list, innerType)) || (found = (Object[])PodamUtils.getValueWithMethod(foundList, NAME_VALUE, PodamConstants.NO_CLASSES)).length <= 0) continue;
            return (T)found[0];
        }
        return null;
    }

    private BigDecimal getValueInRange(BigDecimal min, BigDecimal max) {
        BigDecimal scale = new BigDecimal(PodamUtils.getDoubleInRange(0.0, 1.0));
        return min.add(max.subtract(min).multiply(scale));
    }

    private Object decimalToReturnType(BigDecimal result) {
        if (String.class.equals(this.attributeType)) {
            return result.toPlainString();
        }
        if (Double.class.equals(this.attributeType) || Double.TYPE.equals(this.attributeType)) {
            return result.doubleValue();
        }
        if (Float.class.equals(this.attributeType) || Float.TYPE.equals(this.attributeType)) {
            return Float.valueOf(result.floatValue());
        }
        if (Long.class.equals(this.attributeType) || Long.TYPE.equals(this.attributeType)) {
            return result.longValue();
        }
        if (Integer.class.equals(this.attributeType) || Integer.TYPE.equals(this.attributeType)) {
            return result.intValue();
        }
        if (Short.class.equals(this.attributeType) || Short.TYPE.equals(this.attributeType)) {
            return result.shortValue();
        }
        if (Byte.class.equals(this.attributeType) || Byte.TYPE.equals(this.attributeType)) {
            return result.byteValue();
        }
        if (this.attributeType.isAssignableFrom(BigDecimal.class)) {
            return result;
        }
        if (this.attributeType.isAssignableFrom(BigInteger.class)) {
            return result.toBigInteger();
        }
        LOG.warn("Unsupported attribute type {}", this.attributeType);
        return null;
    }

    private Object timestampToReturnType(Long offsetSecs) {
        if (TemporalAccessor.class.isAssignableFrom(this.attributeType)) {
            try {
                OffsetDateTime temporal = OffsetDateTime.now();
                temporal = Year.class.isAssignableFrom(this.attributeType) ? temporal.plus(offsetSecs, ChronoUnit.YEARS) : (MonthDay.class.isAssignableFrom(this.attributeType) ? temporal.plus(Long.signum(offsetSecs), ChronoUnit.DAYS) : temporal.plus(offsetSecs, ChronoUnit.SECONDS));
                Method method = this.attributeType.getMethod(METHOD_NAME_FROM, TemporalAccessor.class);
                if (null != method) {
                    return method.invoke(null, temporal);
                }
                LOG.warn("Attribute {} has no {} method", this.attributeType, (Object)METHOD_NAME_FROM);
            }
            catch (Exception e) {
                LOG.warn("Failed to instantiate Temporal attribute {}", this.attributeType, (Object)e);
                return null;
            }
        }
        long timestamp = System.currentTimeMillis() + offsetSecs * 1000L;
        if (this.attributeType.isAssignableFrom(Date.class)) {
            return new Date(timestamp);
        }
        if (this.attributeType.isAssignableFrom(Calendar.class)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(timestamp);
            return calendar;
        }
        LOG.warn("Unsupported attribute type {}", this.attributeType);
        return null;
    }
}

