/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.common;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.common.PodamConstants;
import uk.co.jemos.podam.typeManufacturers.TypeManufacturerUtil;

public class ManufacturingContext {
    private DataProviderStrategy.Order constructorOrdering = DataProviderStrategy.Order.LIGHT_FIRST;
    private Map<Class<?>, Integer> pojos = new HashMap();
    private Map<String, Type> typeArgsMap = new HashMap<String, Type>();
    private Deque<Map<String, Type>> backupTypeArgsMaps = new ArrayDeque<Map<String, Type>>();

    public DataProviderStrategy.Order getConstructorOrdering() {
        return this.constructorOrdering;
    }

    public void setConstructorOrdering(DataProviderStrategy.Order constructorOrdering) {
        this.constructorOrdering = constructorOrdering;
    }

    public Map<Class<?>, Integer> getPojos() {
        return this.pojos;
    }

    public boolean isTypeArgsEmpty() {
        return this.typeArgsMap.isEmpty();
    }

    public Type resolveType(String typeName) {
        return this.typeArgsMap.get(typeName);
    }

    public Map<String, Type> createEmptyTypeArgsMap() {
        return new HashMap<String, Type>();
    }

    public Type[] cloneTypeArgsMap(Class<?> pojoType, ParameterizedType parameterizedPojoType, Type[] genericTypeArgs) {
        this.backupTypeArgsMaps.push(this.typeArgsMap);
        this.typeArgsMap = new HashMap<String, Type>(this.typeArgsMap);
        Type[] actualTypes = parameterizedPojoType.getActualTypeArguments();
        ManufacturingContext.fillTypeArgsMap(this, pojoType, actualTypes);
        return ManufacturingContext.fillTypeArgsMap(this, pojoType, genericTypeArgs);
    }

    public void cloneTypeArgsMap() {
        this.backupTypeArgsMaps.push(this.typeArgsMap);
        this.typeArgsMap = new HashMap<String, Type>(this.typeArgsMap);
    }

    public void backupTypeArgsMap(Map<String, Type> typeArgsMap) {
        this.backupTypeArgsMaps.push(this.typeArgsMap);
        this.typeArgsMap = typeArgsMap;
    }

    public Map<String, Type> restoreTypeArgsMap() {
        Map<String, Type> oldTypeArgsMap = this.typeArgsMap;
        this.typeArgsMap = this.backupTypeArgsMaps.pop();
        return oldTypeArgsMap;
    }

    public static Type[] fillTypeArgsMap(ManufacturingContext manufacturingCtx, Class<?> pojoClass, Type[] genericTypeArgs) {
        Method[] suitableConstructors;
        Object[] typeArray = pojoClass.getTypeParameters();
        ArrayList typeParameters = new ArrayList(Arrays.asList(typeArray));
        ArrayList<Type> genericTypes = new ArrayList<Type>(Arrays.asList(genericTypeArgs));
        Iterator iterator = typeParameters.iterator();
        Iterator iterator2 = genericTypes.iterator();
        while (iterator.hasNext()) {
            Type genericType;
            Type type = genericType = iterator2.hasNext() ? (Type)iterator2.next() : null;
            if (!manufacturingCtx.typeArgsMap.containsKey(((TypeVariable)iterator.next()).getName())) continue;
            iterator.remove();
            if (!(genericType instanceof TypeVariable)) continue;
            iterator2.remove();
        }
        if (typeParameters.size() > genericTypes.size()) {
            String msg = pojoClass.getCanonicalName() + " is missing generic type arguments, expected " + Arrays.toString(typeArray) + ", provided " + Arrays.toString(genericTypeArgs);
            throw new IllegalArgumentException(msg);
        }
        for (Method constructor : suitableConstructors = TypeManufacturerUtil.findSuitableConstructors(pojoClass, pojoClass)) {
            TypeVariable<Method>[] ctorTypeParams = constructor.getTypeParameters();
            if (ctorTypeParams.length != genericTypes.size()) continue;
            for (int i = 0; i < ctorTypeParams.length; ++i) {
                Type foundType = (Type)genericTypes.get(i);
                manufacturingCtx.putTypeArg(ctorTypeParams[i].getName(), foundType);
            }
        }
        for (int i = 0; i < typeParameters.size(); ++i) {
            Type foundType = (Type)genericTypes.remove(0);
            manufacturingCtx.putTypeArg(((TypeVariable)typeParameters.get(i)).getName(), foundType);
        }
        Type[] genericTypeArgsExtra = genericTypes.size() > 0 ? genericTypes.toArray(new Type[genericTypes.size()]) : PodamConstants.NO_TYPES;
        Class<?> clazz = pojoClass;
        while (clazz != null) {
            Type superType = clazz.getGenericSuperclass();
            clazz = clazz.getSuperclass();
            if (!(superType instanceof ParameterizedType)) continue;
            ParameterizedType paramType = (ParameterizedType)superType;
            Type[] actualParamTypes = paramType.getActualTypeArguments();
            TypeVariable<Class<?>>[] paramTypes = clazz.getTypeParameters();
            for (int i = 0; i < actualParamTypes.length && i < paramTypes.length; ++i) {
                if (!(actualParamTypes[i] instanceof Class)) continue;
                manufacturingCtx.putTypeArg(paramTypes[i].getName(), actualParamTypes[i]);
            }
        }
        return genericTypeArgsExtra;
    }

    private void putTypeArg(String typeName, Type type) {
        this.typeArgsMap.put(typeName, type);
    }
}

