/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.concurrent.atomic.AtomicReference;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.common.AttributeStrategy;
import uk.co.jemos.podam.common.Holder;
import uk.co.jemos.podam.common.ManufacturingContext;
import uk.co.jemos.podam.common.PodamConstants;
import uk.co.jemos.podam.exceptions.PodamMockeryException;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;
import uk.co.jemos.podam.typeManufacturers.TypeManufacturerUtil;

public class ArrayTypeManufacturerImpl
extends AbstractTypeManufacturer<Cloneable> {
    @Override
    public Cloneable getType(DataProviderStrategy strategy, AttributeMetadata attributeMetadata, ManufacturingContext manufacturingCtx) {
        Class<?> attrType = attributeMetadata.getAttributeType();
        if (attrType.isArray()) {
            Integer nbrElements;
            Type genericComponentType;
            Type genericType = attributeMetadata.getAttributeGenericType();
            Class<?> componentType = null;
            AtomicReference<Type[]> genericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
            if (genericType instanceof GenericArrayType && (genericComponentType = ((GenericArrayType)genericType).getGenericComponentType()) instanceof TypeVariable) {
                TypeVariable componentTypeVariable = (TypeVariable)genericComponentType;
                Type resolvedType = manufacturingCtx.resolveType(componentTypeVariable.getName());
                componentType = TypeManufacturerUtil.resolveGenericParameter(resolvedType, manufacturingCtx, genericTypeArgs);
            }
            if (componentType == null) {
                componentType = attrType.getComponentType();
            }
            Holder elementStrategyHolder = new Holder();
            Holder<AttributeStrategy<?>> keyStrategyHolder = null;
            try {
                nbrElements = TypeManufacturerUtil.findCollectionSize(strategy, attributeMetadata.getAttributeAnnotations(), attrType, elementStrategyHolder, keyStrategyHolder);
            }
            catch (InstantiationException e) {
                throw new PodamMockeryException("Instantiation failed", e);
            }
            catch (IllegalAccessException e) {
                throw new PodamMockeryException("Instantiation failed", e);
            }
            return (Cloneable)Array.newInstance(componentType, (int)nbrElements);
        }
        return null;
    }
}

