/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import org.apache.commons.lang3.StringUtils;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.common.ManufacturingContext;
import uk.co.jemos.podam.common.PodamDoubleValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;

public class DoubleTypeManufacturerImpl
extends AbstractTypeManufacturer<Double> {
    @Override
    public Double getType(DataProviderStrategy strategy, AttributeMetadata attributeMetadata, ManufacturingContext manufacturingCtx) {
        Double retValue;
        PodamDoubleValue annotationStrategy = this.findElementOfType(attributeMetadata.getAttributeAnnotations(), PodamDoubleValue.class);
        if (null != annotationStrategy) {
            String numValueStr = annotationStrategy.numValue();
            if (StringUtils.isNotEmpty((CharSequence)numValueStr)) {
                try {
                    retValue = Double.valueOf(numValueStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("The annotation value: " + numValueStr + " could not be converted to a Double. An exception will be thrown.", nfe);
                }
            } else {
                double maxValue;
                double minValue = annotationStrategy.minValue();
                if (minValue > (maxValue = annotationStrategy.maxValue())) {
                    maxValue = minValue;
                }
                retValue = this.getDoubleInRange(minValue, maxValue, attributeMetadata);
            }
        } else {
            retValue = this.getDouble(attributeMetadata);
        }
        return retValue;
    }

    public Double getDouble(AttributeMetadata attributeMetadata) {
        return this.getDouble();
    }

    public Double getDoubleInRange(double minValue, double maxValue, AttributeMetadata attributeMetadata) {
        return PodamUtils.getDoubleInRange(minValue, maxValue);
    }
}

