/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import org.apache.commons.lang3.StringUtils;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.common.ManufacturingContext;
import uk.co.jemos.podam.common.PodamIntValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;

public class IntTypeManufacturerImpl
extends AbstractTypeManufacturer<Integer> {
    @Override
    public Integer getType(DataProviderStrategy strategy, AttributeMetadata attributeMetadata, ManufacturingContext manufacturingCtx) {
        Integer retValue;
        PodamIntValue annotationStrategy = this.findElementOfType(attributeMetadata.getAttributeAnnotations(), PodamIntValue.class);
        if (null != annotationStrategy) {
            String numValueStr = annotationStrategy.numValue();
            if (StringUtils.isNotEmpty((CharSequence)numValueStr)) {
                try {
                    retValue = Integer.valueOf(numValueStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("The annotation value: " + numValueStr + " could not be converted to an Integer. An exception will be thrown.", nfe);
                }
            } else {
                int maxValue;
                int minValue = annotationStrategy.minValue();
                if (minValue > (maxValue = annotationStrategy.maxValue())) {
                    maxValue = minValue;
                }
                retValue = this.getIntegerInRange(minValue, maxValue, attributeMetadata);
            }
        } else {
            retValue = this.getInteger(attributeMetadata);
        }
        return retValue;
    }

    public Integer getInteger(AttributeMetadata attributeMetadata) {
        return this.getInteger(Integer.MAX_VALUE);
    }

    public int getIntegerInRange(int minValue, int maxValue, AttributeMetadata attributeMetadata) {
        return PodamUtils.getIntegerInRange(minValue, maxValue);
    }
}

