/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import org.apache.commons.lang3.StringUtils;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.common.ManufacturingContext;
import uk.co.jemos.podam.common.PodamShortValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;

public class ShortTypeManufacturerImpl
extends AbstractTypeManufacturer<Short> {
    @Override
    public Short getType(DataProviderStrategy strategy, AttributeMetadata attributeMetadata, ManufacturingContext manufacturingCtx) {
        Short retValue;
        PodamShortValue annotationStrategy = this.findElementOfType(attributeMetadata.getAttributeAnnotations(), PodamShortValue.class);
        if (null != annotationStrategy) {
            String numValueStr = annotationStrategy.numValue();
            if (StringUtils.isNotEmpty((CharSequence)numValueStr)) {
                try {
                    retValue = Short.valueOf(numValueStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("The precise value: " + numValueStr + " cannot be converted to a short type. An exception will be thrown.", nfe);
                }
            } else {
                short maxValue;
                short minValue = annotationStrategy.minValue();
                if (minValue > (maxValue = annotationStrategy.maxValue())) {
                    maxValue = minValue;
                }
                retValue = this.getShortInRange(minValue, maxValue, attributeMetadata);
            }
        } else {
            retValue = this.getShort(attributeMetadata);
        }
        return retValue;
    }

    public Short getShort(AttributeMetadata attributeMetadata) {
        return (short)this.getInteger(Short.MAX_VALUE);
    }

    public Short getShortInRange(short minValue, short maxValue, AttributeMetadata attributeMetadata) {
        return (short)PodamUtils.getIntegerInRange(minValue, maxValue);
    }
}

