/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import jakarta.validation.Constraint;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.ObjectStrategy;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.common.AttributeStrategy;
import uk.co.jemos.podam.common.BeanValidationStrategy;
import uk.co.jemos.podam.common.Holder;
import uk.co.jemos.podam.common.ManufacturingContext;
import uk.co.jemos.podam.common.PodamAnnotation;
import uk.co.jemos.podam.common.PodamCollection;
import uk.co.jemos.podam.common.PodamConstants;
import uk.co.jemos.podam.common.PodamStrategyValue;

public abstract class TypeManufacturerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TypeManufacturerUtil.class);
    private static final String CONSTRAINTS_PACKAGE_NAME = NotNull.class.getPackage().getName();

    /*
     * WARNING - void declaration
     */
    public static AttributeStrategy<?> findAttributeStrategy(DataProviderStrategy strategy, List<Annotation> annotations, Class<?> attributeType) throws InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, InvocationTargetException {
        void var8_17;
        Class<?> tmp;
        ArrayList<Annotation> localAnnotations = new ArrayList<Annotation>(annotations);
        ArrayList annotationsToCheck = new ArrayList();
        ArrayList<void> constraintAnnotationsWithoutRegisteredStrategy = new ArrayList<void>();
        Iterator localAnnotationsIter = localAnnotations.iterator();
        while (localAnnotationsIter.hasNext()) {
            void var8_8;
            AttributeStrategy<?> attributeStrategy;
            Class<?>[] classArray;
            Annotation annotation = (Annotation)localAnnotationsIter.next();
            if (annotation instanceof PodamStrategyValue) {
                PodamStrategyValue podamStrategyValue = (PodamStrategyValue)annotation;
                return podamStrategyValue.value().newInstance();
            }
            if (annotation.annotationType().getAnnotation(PodamAnnotation.class) != null) {
                return null;
            }
            Class<?> clazz = annotation.getClass();
            if (Proxy.isProxyClass(clazz) && (classArray = clazz.getInterfaces()).length == 1) {
                Class<?> tmp2;
                Class<?> clazz2 = tmp2 = classArray[0];
            }
            if (null != (attributeStrategy = strategy.getStrategyForAnnotation((Class<? extends Annotation>)var8_8))) {
                return attributeStrategy;
            }
            for (Class<?> iface : var8_8.getInterfaces()) {
                if (!Annotation.class.isAssignableFrom(iface)) continue;
                tmp = iface;
                annotationsToCheck.add(tmp);
            }
            if (annotation.annotationType().getAnnotation(Constraint.class) != null || var8_8.getPackage().getName().startsWith(CONSTRAINTS_PACKAGE_NAME)) {
                if (annotation instanceof NotNull || annotation instanceof NotBlank || annotation instanceof NotEmpty || annotation.annotationType().getName().equals("org.hibernate.validator.constraints.NotEmpty") || annotation.annotationType().getName().equals("org.hibernate.validator.constraints.NotBlank")) {
                    localAnnotationsIter.remove();
                    continue;
                }
                if (var8_8.getPackage().getName().startsWith(CONSTRAINTS_PACKAGE_NAME)) continue;
                constraintAnnotationsWithoutRegisteredStrategy.add(var8_8);
                continue;
            }
            localAnnotationsIter.remove();
        }
        for (Class clazz : annotationsToCheck) {
            AttributeStrategy<?> attributeStrategy = strategy.getStrategyForAnnotation(clazz);
            if (null != attributeStrategy) {
                return attributeStrategy;
            }
            for (Class<?> iface : clazz.getInterfaces()) {
                if (!Annotation.class.isAssignableFrom(iface)) continue;
                tmp = iface;
                annotationsToCheck.add(tmp);
            }
        }
        for (Class clazz : constraintAnnotationsWithoutRegisteredStrategy) {
            LOG.warn("Please, register AttributeStrategy for custom constraint {}, in DataProviderStrategy! Value will be left to null", (Object)clazz);
        }
        Object var8_15 = null;
        if (!(localAnnotations.isEmpty() || Collection.class.isAssignableFrom(attributeType) || Map.class.isAssignableFrom(attributeType) || attributeType.isArray())) {
            BeanValidationStrategy beanValidationStrategy = new BeanValidationStrategy(attributeType);
        }
        return var8_17;
    }

    public static Method[] findSuitableConstructors(Class<?> factoryClass, Class<?> pojoClass) {
        Method[] declaredMethods = factoryClass.getDeclaredMethods();
        ArrayList<Method> constructors = new ArrayList<Method>();
        for (Method candidateConstructor : declaredMethods) {
            if (!candidateConstructor.getReturnType().equals(pojoClass) || !Modifier.isStatic(candidateConstructor.getModifiers()) && factoryClass.equals(pojoClass)) continue;
            constructors.add(candidateConstructor);
        }
        return constructors.toArray(new Method[constructors.size()]);
    }

    public static Integer findCollectionSize(DataProviderStrategy strategy, List<Annotation> annotations, Class<?> collectionElementType, Holder<AttributeStrategy<?>> elementStrategyHolder, Holder<AttributeStrategy<?>> keyStrategyHolder) throws InstantiationException, IllegalAccessException {
        Size size = null;
        for (Annotation annotation : annotations) {
            if (annotation instanceof PodamCollection) {
                Class<AttributeStrategy<?>> attributeStrategy;
                PodamCollection collectionAnnotation = (PodamCollection)annotation;
                if (null != elementStrategyHolder) {
                    attributeStrategy = collectionAnnotation.collectionElementStrategy();
                    if (null == attributeStrategy || ObjectStrategy.class.isAssignableFrom(attributeStrategy)) {
                        attributeStrategy = collectionAnnotation.mapElementStrategy();
                    }
                    if (null != attributeStrategy) {
                        elementStrategyHolder.setValue(attributeStrategy.newInstance());
                    }
                }
                if (null != keyStrategyHolder && null != (attributeStrategy = collectionAnnotation.mapKeyStrategy())) {
                    keyStrategyHolder.setValue(attributeStrategy.newInstance());
                }
                return collectionAnnotation.nbrElements();
            }
            if (!(annotation instanceof Size)) continue;
            size = (Size)annotation;
        }
        Integer nbrElements = strategy.getNumberOfCollectionElements(collectionElementType);
        if (null != size) {
            if (nbrElements > size.max()) {
                nbrElements = size.max();
            }
            if (nbrElements < size.min()) {
                nbrElements = size.min();
            }
        }
        return nbrElements;
    }

    public static Type[] mergeActualAndSuppliedGenericTypes(Class<?> attributeType, Type genericAttributeType, Type[] suppliedTypes, ManufacturingContext manufacturingCtx) {
        WildcardType wildcardType;
        TypeVariable<Class<?>>[] actualTypes = attributeType.getTypeParameters();
        if (actualTypes.length <= suppliedTypes.length) {
            return suppliedTypes;
        }
        Object[] genericTypes = null;
        if (genericAttributeType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)genericAttributeType;
            genericTypes = paramType.getActualTypeArguments();
        } else if (genericAttributeType instanceof WildcardType && ArrayUtils.isEmpty((Object[])(genericTypes = (wildcardType = (WildcardType)genericAttributeType).getLowerBounds()))) {
            genericTypes = wildcardType.getUpperBounds();
        }
        ArrayList resolvedTypes = new ArrayList();
        ArrayList<Type> substitutionTypes = new ArrayList<Type>(Arrays.asList(suppliedTypes));
        for (int i = 0; i < actualTypes.length; ++i) {
            AtomicReference<Type[]> methodGenericTypeArgs;
            Class<?> type = null;
            if (actualTypes[i] instanceof TypeVariable) {
                type = manufacturingCtx.resolveType(actualTypes[i].getName());
            } else if (actualTypes[i] instanceof WildcardType) {
                methodGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
                type = TypeManufacturerUtil.resolveGenericParameter(actualTypes[i], manufacturingCtx, methodGenericTypeArgs);
            }
            if (type == null && genericTypes != null) {
                if (genericTypes[i] instanceof Class) {
                    type = genericTypes[i];
                } else if (genericTypes[i] instanceof WildcardType) {
                    methodGenericTypeArgs = new AtomicReference<Type[]>(PodamConstants.NO_TYPES);
                    type = TypeManufacturerUtil.resolveGenericParameter((Type)genericTypes[i], manufacturingCtx, methodGenericTypeArgs);
                } else if (genericTypes[i] instanceof ParameterizedType) {
                    type = genericTypes[i];
                } else {
                    LOG.debug("Skipping type {} {}", actualTypes[i], genericTypes[i]);
                }
            }
            if (type == null) continue;
            resolvedTypes.add(type);
            if (substitutionTypes.isEmpty() || !((Type)substitutionTypes.get(0)).equals(type)) continue;
            substitutionTypes.remove(0);
        }
        Object[] resolved = resolvedTypes.toArray(new Type[resolvedTypes.size()]);
        Object[] supplied = substitutionTypes.toArray(new Type[substitutionTypes.size()]);
        return (Type[])ArrayUtils.addAll((Object[])resolved, (Object[])supplied);
    }

    public static Class<?> resolveGenericParameter(Type paramType, ManufacturingContext manufacturingCtx, AtomicReference<Type[]> methodGenericTypeArgs) {
        Class<?> parameterType = null;
        manufacturingCtx.cloneTypeArgsMap();
        methodGenericTypeArgs.set(PodamConstants.NO_TYPES);
        if (paramType instanceof Class) {
            parameterType = (Class<?>)paramType;
        } else if (paramType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)paramType;
            Type type = manufacturingCtx.resolveType(typeVariable.getName());
            if (type != null) {
                parameterType = TypeManufacturerUtil.resolveGenericParameter(type, manufacturingCtx, methodGenericTypeArgs);
            }
        } else if (paramType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)paramType;
            parameterType = (Class<?>)pType.getRawType();
            Type[] actualTypeArgs = pType.getActualTypeArguments();
            if (!manufacturingCtx.isTypeArgsEmpty()) {
                for (int i = 0; i < actualTypeArgs.length; ++i) {
                    Class<?> tmp = TypeManufacturerUtil.resolveGenericParameter(actualTypeArgs[i], manufacturingCtx, methodGenericTypeArgs);
                    if (tmp == actualTypeArgs[i] || !ArrayUtils.isEmpty((Object[])methodGenericTypeArgs.get())) continue;
                    actualTypeArgs[i] = tmp;
                }
            }
            methodGenericTypeArgs.set(actualTypeArgs);
        } else if (paramType instanceof WildcardType) {
            String msg;
            WildcardType wType = (WildcardType)paramType;
            Object[] bounds = wType.getLowerBounds();
            if (ArrayUtils.isNotEmpty((Object[])bounds)) {
                msg = "Lower bounds:";
            } else {
                bounds = wType.getUpperBounds();
                msg = "Upper bounds:";
            }
            if (ArrayUtils.isNotEmpty((Object[])bounds)) {
                LOG.debug(msg + Arrays.toString(bounds));
                parameterType = TypeManufacturerUtil.resolveGenericParameter((Type)bounds[0], manufacturingCtx, methodGenericTypeArgs);
            }
        }
        if (parameterType == null) {
            LOG.warn("Unrecognized type {}. Will use Object instead", (Object)paramType);
            parameterType = Object.class;
        }
        manufacturingCtx.restoreTypeArgsMap();
        return parameterType;
    }

    public static Object returnAttributeDataStrategyValue(Class<?> attributeType, List<Annotation> annotations, AttributeStrategy<?> attributeStrategy) throws IllegalArgumentException {
        if (null == attributeStrategy) {
            return null;
        }
        Object retValue = attributeStrategy.getValue(attributeType, annotations);
        if (retValue != null) {
            Class<?> desiredType;
            Class<?> clazz = desiredType = attributeType.isPrimitive() ? PodamUtils.primitiveToBoxedType(attributeType) : attributeType;
            if (!desiredType.isAssignableFrom(retValue.getClass())) {
                String errMsg = "The AttributeStrategy " + attributeStrategy.getClass().getName() + " produced value of type " + retValue.getClass().getName() + " incompatible with attribute type " + attributeType.getName();
                throw new IllegalArgumentException(errMsg);
            }
            LOG.debug("The parameter {} will be filled using the following strategy {}", attributeType, attributeStrategy);
        }
        return retValue;
    }
}

