/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.csv.validator;

import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxesRunTime;
import scalaz.Apply;
import scalaz.Leibniz$;
import scalaz.NonEmptyList;
import scalaz.NonEmptyList$;
import scalaz.Scalaz$;
import scalaz.Validation;
import scalaz.Validation$;
import uk.gov.nationalarchives.csv.validator.AllErrorsMetaDataValidator;
import uk.gov.nationalarchives.csv.validator.ErrorMessage;
import uk.gov.nationalarchives.csv.validator.ErrorMessage$;
import uk.gov.nationalarchives.csv.validator.FailMessage;
import uk.gov.nationalarchives.csv.validator.WarningMessage;
import uk.gov.nationalarchives.csv.validator.WarningMessage$;
import uk.gov.nationalarchives.csv.validator.metadata.Cell;
import uk.gov.nationalarchives.csv.validator.metadata.Row;
import uk.gov.nationalarchives.csv.validator.schema.ColumnDefinition;
import uk.gov.nationalarchives.csv.validator.schema.GlobalDirective;
import uk.gov.nationalarchives.csv.validator.schema.Optional;
import uk.gov.nationalarchives.csv.validator.schema.Rule;
import uk.gov.nationalarchives.csv.validator.schema.Schema;
import uk.gov.nationalarchives.csv.validator.schema.TotalColumns;
import uk.gov.nationalarchives.csv.validator.schema.Warning;

public abstract class AllErrorsMetaDataValidator$class {
    public static Validation validateRows(AllErrorsMetaDataValidator $this, Iterator rows, Schema schema2) {
        List v = AllErrorsMetaDataValidator$class.validateRows$1($this, AllErrorsMetaDataValidator$class.validateRows$default$1$1($this), rows, schema2);
        return (Validation)Scalaz$.MODULE$.ToTraverseOps((Object)v, Scalaz$.MODULE$.listInstance()).sequence(Leibniz$.MODULE$.refl(), Validation$.MODULE$.ValidationApplicative(NonEmptyList$.MODULE$.nonEmptyListSemigroup()));
    }

    private static Validation validateRow(AllErrorsMetaDataValidator $this, Row row, Schema schema2) {
        Validation totalColumnsV = AllErrorsMetaDataValidator$class.totalColumns($this, row, schema2);
        Validation rulesV = AllErrorsMetaDataValidator$class.rules($this, row, schema2);
        return (Validation)Scalaz$.MODULE$.ToApplyOps((Object)totalColumnsV, (Apply)Validation$.MODULE$.ValidationApplicative(NonEmptyList$.MODULE$.nonEmptyListSemigroup())).$bar$at$bar((Object)rulesV).apply((Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final List<Object> apply(Object x$2, List<Object> x$3) {
                Object object = x$2;
                return x$3.$colon$colon(object);
            }
        }, (Apply)Validation$.MODULE$.ValidationApplicative(NonEmptyList$.MODULE$.nonEmptyListSemigroup()));
    }

    private static Validation totalColumns(AllErrorsMetaDataValidator $this, Row row, Schema schema2) {
        Option tc = schema2.globalDirectives().collectFirst((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends GlobalDirective, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TotalColumns) {
                    TotalColumns totalColumns = (TotalColumns)A1;
                    object = totalColumns;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(GlobalDirective x1) {
                GlobalDirective globalDirective = x1;
                boolean bl = globalDirective instanceof TotalColumns;
                return bl;
            }
        });
        return tc.isEmpty() || BoxesRunTime.equalsNumObject((Number)((TotalColumns)tc.get()).numberOfColumns(), (Object)BoxesRunTime.boxToInteger((int)row.cells().length())) ? Scalaz$.MODULE$.ToValidationV((Object)BoxesRunTime.boxToBoolean((boolean)true)).successNel() : Scalaz$.MODULE$.ToValidationV((Object)new ErrorMessage(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected @totalColumns of ", " and found ", " on line ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TotalColumns)tc.get()).numberOfColumns(), BoxesRunTime.boxToInteger((int)row.cells().length()), BoxesRunTime.boxToInteger((int)row.lineNumber())})))).failNel();
    }

    private static Validation rules(AllErrorsMetaDataValidator $this, Row row, Schema schema2) {
        Function1 cells = row.cells().lift();
        List v = (List)((TraversableLike)schema2.columnDefinitions().zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<ColumnDefinition, Object> check$ifrefutable$1) {
                Tuple2<ColumnDefinition, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable($this, row, schema2, cells){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AllErrorsMetaDataValidator $outer;
            private final Row row$1;
            private final Schema schema$1;
            private final Function1 cells$1;

            public final Validation<NonEmptyList<FailMessage>, Object> apply(Tuple2<ColumnDefinition, Object> x$5) {
                Tuple2<ColumnDefinition, Object> tuple2 = x$5;
                if (tuple2 != null) {
                    int columnIndex = tuple2._2$mcI$sp();
                    Validation validation = AllErrorsMetaDataValidator$class.uk$gov$nationalarchives$csv$validator$AllErrorsMetaDataValidator$$validateCell(this.$outer, columnIndex, this.cells$1, this.row$1, this.schema$1);
                    return validation;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.row$1 = row$1;
                this.schema$1 = schema$1;
                this.cells$1 = cells$1;
            }
        }, List$.MODULE$.canBuildFrom());
        return (Validation)Scalaz$.MODULE$.ToTraverseOps((Object)v, Scalaz$.MODULE$.listInstance()).sequence(Leibniz$.MODULE$.refl(), Validation$.MODULE$.ValidationApplicative(NonEmptyList$.MODULE$.nonEmptyListSemigroup()));
    }

    public static Validation uk$gov$nationalarchives$csv$validator$AllErrorsMetaDataValidator$$validateCell(AllErrorsMetaDataValidator $this, int columnIndex, Function1 cells, Row row, Schema schema2) {
        Option option = (Option)cells.apply((Object)BoxesRunTime.boxToInteger((int)columnIndex));
        Validation validation = option instanceof Some ? AllErrorsMetaDataValidator$class.rulesForCell($this, columnIndex, row, schema2) : Scalaz$.MODULE$.ToValidationV((Object)new ErrorMessage(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing value at line: ", ", column: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)row.lineNumber()), ((ColumnDefinition)schema2.columnDefinitions().apply(columnIndex)).id()})))).failNel();
        return validation;
    }

    private static Validation rulesForCell(AllErrorsMetaDataValidator $this, int columnIndex, Row row, Schema schema2) {
        ColumnDefinition columnDefinition2 = (ColumnDefinition)schema2.columnDefinitions().apply(columnIndex);
        return ((Cell)row.cells().apply(columnIndex)).value().trim().isEmpty() && AllErrorsMetaDataValidator$class.isOptionDirective$1($this, columnDefinition2) ? Scalaz$.MODULE$.ToValidationV((Object)BoxesRunTime.boxToBoolean((boolean)true)).successNel() : (Validation)Scalaz$.MODULE$.ToTraverseOps(((List)columnDefinition2.rules().map((Function1)new Serializable($this, columnIndex, row, schema2){
            public static final long serialVersionUID = 0L;
            private final int columnIndex$1;
            private final Row row$2;
            private final Schema schema$2;

            public final Validation<NonEmptyList<String>, Object> apply(Rule x$8) {
                return x$8.evaluate(this.columnIndex$1, this.row$2, this.schema$2);
            }
            {
                this.columnIndex$1 = columnIndex$1;
                this.row$2 = row$2;
                this.schema$2 = schema$2;
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this, columnDefinition2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AllErrorsMetaDataValidator $outer;
            private final ColumnDefinition columnDefinition$1;

            public final Validation<NonEmptyList<FailMessage>, Object> apply(Validation<NonEmptyList<String>, Object> ruleResult) {
                return AllErrorsMetaDataValidator$class.isWarningDirective$1(this.$outer, this.columnDefinition$1) ? AllErrorsMetaDataValidator$class.convert2Warnings$1(this.$outer, ruleResult) : AllErrorsMetaDataValidator$class.convert2Errors$1(this.$outer, ruleResult);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnDefinition$1 = columnDefinition$1;
            }
        }, List$.MODULE$.canBuildFrom()), Scalaz$.MODULE$.listInstance()).sequence(Leibniz$.MODULE$.refl(), Validation$.MODULE$.ValidationApplicative(NonEmptyList$.MODULE$.nonEmptyListSemigroup()));
    }

    private static final List validateRows$1(AllErrorsMetaDataValidator $this, List results, Iterator rows$1, Schema schema$3) {
        while (rows$1.hasNext()) {
            Validation result;
            Row row = (Row)rows$1.next();
            Validation validation = result = AllErrorsMetaDataValidator$class.validateRow($this, row, schema$3);
            results = results.$colon$colon((Object)validation);
        }
        return results.reverse();
    }

    private static final List validateRows$default$1$1(AllErrorsMetaDataValidator $this) {
        return List$.MODULE$.empty();
    }

    public static final boolean isWarningDirective$1(AllErrorsMetaDataValidator $this, ColumnDefinition columnDefinition$1) {
        return columnDefinition$1.directives().contains((Object)new Warning());
    }

    private static final boolean isOptionDirective$1(AllErrorsMetaDataValidator $this, ColumnDefinition columnDefinition$1) {
        return columnDefinition$1.directives().contains((Object)new Optional());
    }

    public static final Validation convert2Warnings$1(AllErrorsMetaDataValidator $this, Validation results) {
        return results.leftMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final NonEmptyList<WarningMessage> apply(NonEmptyList<String> x$6) {
                return x$6.map((Function1)WarningMessage$.MODULE$);
            }
        });
    }

    public static final Validation convert2Errors$1(AllErrorsMetaDataValidator $this, Validation results) {
        return results.leftMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final NonEmptyList<ErrorMessage> apply(NonEmptyList<String> x$7) {
                return x$7.map((Function1)ErrorMessage$.MODULE$);
            }
        });
    }

    public static void $init$(AllErrorsMetaDataValidator $this) {
    }
}

