/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.csv.validator.schema;

import java.io.File;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scalax.file.Path;
import scalax.file.Path$;
import scalax.file.PathSet;
import scalaz.Scalaz$;
import scalaz.Validation;
import uk.gov.nationalarchives.csv.validator.Util;
import uk.gov.nationalarchives.csv.validator.Util$FileSystem$;
import uk.gov.nationalarchives.csv.validator.Util$TypedPath$;
import uk.gov.nationalarchives.csv.validator.schema.FileWildcardSearch;
import uk.gov.nationalarchives.csv.validator.schema.FileWildcardSearch$;

public abstract class FileWildcardSearch$class {
    public static Tuple2 findBase(FileWildcardSearch $this, String path) {
        Util.TypedPath typedBasePath = Util$TypedPath$.MODULE$.apply(path);
        return FileWildcardSearch$class.findBaseRecur$1($this, typedBasePath, typedBasePath.name());
    }

    public static Validation search(FileWildcardSearch $this, Tuple2 filePaths) {
        Validation validation;
        block3: {
            try {
                Tuple2<Util.TypedPath, String> tuple2;
                block4: {
                    Try<File> try_;
                    block7: {
                        None$ none$;
                        String matchPath;
                        Util.TypedPath basePath;
                        String fullPath;
                        block6: {
                            block5: {
                                Tuple2 tuple22;
                                fullPath = new Util.FileSystem((Option<String>)None$.MODULE$, new StringBuilder().append((Object)((String)filePaths._1())).append(filePaths._2()).toString(), $this.pathSubstitutions()).expandBasePath();
                                tuple2 = $this.findBase(fullPath);
                                if (tuple2 == null) break block4;
                                Util.TypedPath basePath2 = (Util.TypedPath)tuple2._1();
                                String matchPath2 = (String)tuple2._2();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)basePath2, (Object)matchPath2);
                                basePath = (Util.TypedPath)tuple23._1();
                                matchPath = (String)tuple23._2();
                                try_ = Util$FileSystem$.MODULE$.createFile(((Object)basePath.toPlatform()).toString());
                                if (!(try_ instanceof Success)) break block5;
                                Success success = (Success)try_;
                                File f = (File)success.value();
                                none$ = new Some((Object)Path$.MODULE$.apply(f));
                                break block6;
                            }
                            if (!(try_ instanceof Failure)) break block7;
                            none$ = None$.MODULE$;
                        }
                        None$ path = none$;
                        validation = FileWildcardSearch$class.basePathExists$1($this, basePath, filePaths) ? Scalaz$.MODULE$.ToValidationV((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"incorrect basepath ", " found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FileWildcardSearch$class.pathString$1($this, fullPath, filePaths)}))).failNel() : (FileWildcardSearch$class.wildcardNotInRoot$1($this, filePaths) ? Scalaz$.MODULE$.ToValidationV((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"root ", " should not contain wildcards"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FileWildcardSearch$class.pathString$1($this, fullPath, filePaths)}))).failNel() : (FileWildcardSearch$class.matchUsesWildDirectory$1($this, matchPath) ? FileWildcardSearch$class.findMatches$1($this, $this.wildcardPath(), fullPath, matchPath, (Option)path) : (FileWildcardSearch$class.matchUsesWildFiles$1($this, matchPath) ? FileWildcardSearch$class.findMatches$1($this, $this.wildcardFile(), fullPath, matchPath, (Option)path) : (FileWildcardSearch$class.fileExists$1($this, basePath, matchPath) ? $this.matchSimplePath(new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)basePath), System.getProperty("file.separator"))).append((Object)matchPath).toString()) : Scalaz$.MODULE$.ToValidationV((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file \"", "\" not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Util$TypedPath$.MODULE$.apply(fullPath).toPlatform()}))).failNel()))));
                        break block3;
                    }
                    throw new MatchError(try_);
                }
                throw new MatchError(tuple2);
            }
            catch (Throwable throwable) {
                validation = Scalaz$.MODULE$.ToValidationV((Object)throwable.getMessage()).failNel();
            }
        }
        return validation;
    }

    private static final Tuple2 findBaseRecur$1(FileWildcardSearch $this, Util.TypedPath p, String subPath) {
        Option<Util.TypedPath> option;
        block3: {
            Tuple2 tuple2;
            block2: {
                Util.TypedPath parent;
                while (true) {
                    if (None$.MODULE$.equals(option = p.parent())) {
                        tuple2 = new Tuple2((Object)p.thisFolder(), (Object)subPath);
                        break block2;
                    }
                    if (!(option instanceof Some)) break block3;
                    Some some = (Some)option;
                    parent = (Util.TypedPath)some.x();
                    if (!parent.path().contains("*")) break;
                    subPath = new StringBuilder().append((Object)parent.name()).append((Object)BoxesRunTime.boxToCharacter((char)p.separator())).append((Object)subPath).toString();
                    p = parent;
                }
                tuple2 = new Tuple2((Object)parent, (Object)subPath);
            }
            return tuple2;
        }
        throw new MatchError(option);
    }

    private static final String pathString$1(FileWildcardSearch $this, String fullPath$1, Tuple2 filePaths$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (localfile: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePaths$1._1(), Util$TypedPath$.MODULE$.apply(fullPath$1).toPlatform()}));
    }

    private static final Validation findMatches$1(FileWildcardSearch $this, Function2 wc, String fullPath$1, String matchPath$1, Option path$1) {
        Option option;
        block4: {
            Validation validation;
            block3: {
                block2: {
                    option = path$1;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Path p = (Path)some.x();
                    validation = $this.matchWildcardPaths((PathSet<Path>)((PathSet)wc.apply((Object)p, (Object)matchPath$1)), fullPath$1);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                validation = Scalaz$.MODULE$.ToValidationV((Object)"no file").failNel();
            }
            return validation;
        }
        throw new MatchError((Object)option);
    }

    private static final boolean basePathExists$1(FileWildcardSearch $this, Util.TypedPath basePath$1, Tuple2 filePaths$1) {
        boolean bl;
        block4: {
            block0: {
                Try<File> try_;
                block3: {
                    boolean bl2;
                    block2: {
                        block1: {
                            if (((String)filePaths$1._1()).length() <= 0) break block0;
                            try_ = Util$FileSystem$.MODULE$.createFile(((Object)basePath$1.toPlatform()).toString());
                            if (!(try_ instanceof Success)) break block1;
                            Success success = (Success)try_;
                            File f = (File)success.value();
                            bl2 = f.exists();
                            break block2;
                        }
                        if (!(try_ instanceof Failure)) break block3;
                        bl2 = false;
                    }
                    if (bl2) break block0;
                    bl = true;
                    break block4;
                }
                throw new MatchError(try_);
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean wildcardNotInRoot$1(FileWildcardSearch $this, Tuple2 filePaths$1) {
        return ((String)filePaths$1._1()).contains("*");
    }

    private static final boolean matchUsesWildDirectory$1(FileWildcardSearch $this, String matchPath$1) {
        return matchPath$1.contains("**");
    }

    private static final boolean matchUsesWildFiles$1(FileWildcardSearch $this, String matchPath$1) {
        return matchPath$1.contains("*");
    }

    private static final boolean fileExists$1(FileWildcardSearch $this, Util.TypedPath basePath$1, String matchPath$1) {
        Try<File> try_;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    Util.TypedPath platformPath = basePath$1.toPlatform();
                    String path = new StringBuilder().append((Object)((Object)platformPath).toString()).append((Object)BoxesRunTime.boxToCharacter((char)platformPath.separator())).append((Object)matchPath$1).toString();
                    try_ = Util$FileSystem$.MODULE$.createFile(path);
                    if (!(try_ instanceof Success)) break block2;
                    Success success = (Success)try_;
                    File file = (File)success.value();
                    bl = file.exists();
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                bl = false;
            }
            return bl;
        }
        throw new MatchError(try_);
    }

    public static void $init$(FileWildcardSearch $this) {
        $this.uk$gov$nationalarchives$csv$validator$schema$FileWildcardSearch$_setter_$wildcardPath_$eq((Function2)new FileWildcardSearch$.anonfun.10($this));
        $this.uk$gov$nationalarchives$csv$validator$schema$FileWildcardSearch$_setter_$wildcardFile_$eq((Function2)new FileWildcardSearch$.anonfun.11($this));
    }
}

