/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import uk.org.okapibarcode.Settings;
import uk.org.okapibarcode.backend.AustraliaPost;
import uk.org.okapibarcode.backend.AztecCode;
import uk.org.okapibarcode.backend.AztecRune;
import uk.org.okapibarcode.backend.ChannelCode;
import uk.org.okapibarcode.backend.Codabar;
import uk.org.okapibarcode.backend.CodablockF;
import uk.org.okapibarcode.backend.Code11;
import uk.org.okapibarcode.backend.Code128;
import uk.org.okapibarcode.backend.Code16k;
import uk.org.okapibarcode.backend.Code2Of5;
import uk.org.okapibarcode.backend.Code32;
import uk.org.okapibarcode.backend.Code3Of9;
import uk.org.okapibarcode.backend.Code3Of9Extended;
import uk.org.okapibarcode.backend.Code49;
import uk.org.okapibarcode.backend.Code93;
import uk.org.okapibarcode.backend.CodeOne;
import uk.org.okapibarcode.backend.Composite;
import uk.org.okapibarcode.backend.DataBar14;
import uk.org.okapibarcode.backend.DataBarExpanded;
import uk.org.okapibarcode.backend.DataBarLimited;
import uk.org.okapibarcode.backend.DataMatrix;
import uk.org.okapibarcode.backend.Ean;
import uk.org.okapibarcode.backend.GridMatrix;
import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.JapanPost;
import uk.org.okapibarcode.backend.KixCode;
import uk.org.okapibarcode.backend.KoreaPost;
import uk.org.okapibarcode.backend.Logmars;
import uk.org.okapibarcode.backend.MaxiCode;
import uk.org.okapibarcode.backend.MicroQrCode;
import uk.org.okapibarcode.backend.MsiPlessey;
import uk.org.okapibarcode.backend.Nve18;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Pdf417;
import uk.org.okapibarcode.backend.Pharmacode;
import uk.org.okapibarcode.backend.Pharmacode2Track;
import uk.org.okapibarcode.backend.Pharmazentralnummer;
import uk.org.okapibarcode.backend.Postnet;
import uk.org.okapibarcode.backend.QrCode;
import uk.org.okapibarcode.backend.RoyalMail4State;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.backend.Telepen;
import uk.org.okapibarcode.backend.Upc;
import uk.org.okapibarcode.backend.UspsOneCode;
import uk.org.okapibarcode.backend.UspsPackage;
import uk.org.okapibarcode.output.Java2DRenderer;
import uk.org.okapibarcode.output.PostScriptRenderer;
import uk.org.okapibarcode.output.SvgRenderer;

public class MakeBarcode {
    public void process(Settings settings, String dataInput, String outputFileName) {
        Symbol symbol;
        int type = settings.getSymbolType();
        String extension = "";
        HumanReadableLocation hrtLocation = settings.getHrtPosition();
        Color ink = settings.getForegroundColour();
        Color paper = settings.getBackgroundColour();
        if (settings.isReverseColour()) {
            ink = Color.WHITE;
            paper = Color.BLACK;
        }
        try {
            switch (type) {
                case 1: {
                    Code11 code11 = new Code11();
                    code11.setHumanReadableLocation(hrtLocation);
                    code11.setContent(dataInput);
                    symbol = code11;
                    break;
                }
                case 2: {
                    Code2Of5 c25matrix = new Code2Of5();
                    c25matrix.setMode(Code2Of5.ToFMode.MATRIX);
                    c25matrix.setHumanReadableLocation(hrtLocation);
                    c25matrix.setContent(dataInput);
                    symbol = c25matrix;
                    break;
                }
                case 3: {
                    Code2Of5 c25inter = new Code2Of5();
                    c25inter.setMode(Code2Of5.ToFMode.INTERLEAVED);
                    c25inter.setHumanReadableLocation(hrtLocation);
                    c25inter.setContent(dataInput);
                    symbol = c25inter;
                    break;
                }
                case 4: {
                    Code2Of5 c25iata = new Code2Of5();
                    c25iata.setMode(Code2Of5.ToFMode.IATA);
                    c25iata.setHumanReadableLocation(hrtLocation);
                    c25iata.setContent(dataInput);
                    symbol = c25iata;
                    break;
                }
                case 6: {
                    Code2Of5 c25logic = new Code2Of5();
                    c25logic.setMode(Code2Of5.ToFMode.DATA_LOGIC);
                    c25logic.setHumanReadableLocation(hrtLocation);
                    c25logic.setContent(dataInput);
                    symbol = c25logic;
                    break;
                }
                case 7: {
                    Code2Of5 c25ind = new Code2Of5();
                    c25ind.setMode(Code2Of5.ToFMode.INDUSTRIAL);
                    c25ind.setHumanReadableLocation(hrtLocation);
                    c25ind.setContent(dataInput);
                    symbol = c25ind;
                    break;
                }
                case 8: 
                case 99: 
                case 101: {
                    Code3Of9 code3of9 = new Code3Of9();
                    if (type == 99 || type == 101) {
                        code3of9.setDataType(Symbol.DataType.HIBC);
                    }
                    code3of9.setHumanReadableLocation(hrtLocation);
                    code3of9.setContent(dataInput);
                    symbol = code3of9;
                    break;
                }
                case 9: {
                    Code3Of9Extended code3of9ext = new Code3Of9Extended();
                    code3of9ext.setHumanReadableLocation(hrtLocation);
                    code3of9ext.setContent(dataInput);
                    symbol = code3of9ext;
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    Ean ean = new Ean();
                    if (this.eanCalculateVersion(dataInput) == 8) {
                        ean.setMode(Ean.Mode.EAN8);
                    } else {
                        ean.setMode(Ean.Mode.EAN13);
                    }
                    ean.setContent(dataInput);
                    symbol = ean;
                    break;
                }
                case 18: {
                    Codabar codabar = new Codabar();
                    codabar.setHumanReadableLocation(hrtLocation);
                    codabar.setContent(dataInput);
                    symbol = codabar;
                    break;
                }
                case 16: 
                case 20: 
                case 59: 
                case 60: 
                case 61: 
                case 98: 
                case 100: {
                    Code128 code128 = new Code128();
                    code128.unsetCc();
                    if (settings.isDataGs1Mode() || type == 16) {
                        code128.setDataType(Symbol.DataType.GS1);
                    }
                    if (type == 98 || type == 100) {
                        code128.setDataType(Symbol.DataType.HIBC);
                    }
                    if (type == 60) {
                        code128.setSuppressModeC(true);
                    }
                    code128.setReaderInit(settings.isReaderInit());
                    code128.setHumanReadableLocation(hrtLocation);
                    code128.setContent(dataInput);
                    symbol = code128;
                    break;
                }
                case 21: {
                    Code2Of5 dpLeit = new Code2Of5();
                    dpLeit.setMode(Code2Of5.ToFMode.DP_LEITCODE);
                    dpLeit.setHumanReadableLocation(hrtLocation);
                    dpLeit.setContent(dataInput);
                    symbol = dpLeit;
                    break;
                }
                case 22: {
                    Code2Of5 dpIdent = new Code2Of5();
                    dpIdent.setMode(Code2Of5.ToFMode.DP_IDENTCODE);
                    dpIdent.setHumanReadableLocation(hrtLocation);
                    dpIdent.setContent(dataInput);
                    symbol = dpIdent;
                    break;
                }
                case 23: {
                    Code16k code16k = new Code16k();
                    if (settings.isDataGs1Mode()) {
                        code16k.setDataType(Symbol.DataType.GS1);
                    }
                    code16k.setReaderInit(settings.isReaderInit());
                    code16k.setContent(dataInput);
                    symbol = code16k;
                    break;
                }
                case 24: {
                    Code49 code49 = new Code49();
                    code49.setHumanReadableLocation(hrtLocation);
                    code49.setContent(dataInput);
                    symbol = code49;
                    break;
                }
                case 25: {
                    Code93 code93 = new Code93();
                    code93.setHumanReadableLocation(hrtLocation);
                    code93.setContent(dataInput);
                    symbol = code93;
                    break;
                }
                case 29: {
                    DataBar14 dataBar14 = new DataBar14();
                    dataBar14.setMode(DataBar14.Mode.LINEAR);
                    dataBar14.setHumanReadableLocation(hrtLocation);
                    dataBar14.setContent(dataInput);
                    symbol = dataBar14;
                    break;
                }
                case 30: {
                    DataBarLimited dataBarLimited = new DataBarLimited();
                    dataBarLimited.setHumanReadableLocation(hrtLocation);
                    dataBarLimited.setContent(dataInput);
                    symbol = dataBarLimited;
                    break;
                }
                case 31: {
                    DataBarExpanded dataBarE = new DataBarExpanded();
                    dataBarE.setStacked(false);
                    dataBarE.setHumanReadableLocation(hrtLocation);
                    dataBarE.setContent(dataInput);
                    symbol = dataBarE;
                    break;
                }
                case 32: {
                    Telepen telepen = new Telepen();
                    telepen.setMode(Telepen.Mode.NORMAL);
                    telepen.setHumanReadableLocation(hrtLocation);
                    telepen.setContent(dataInput);
                    symbol = telepen;
                    break;
                }
                case 34: 
                case 35: 
                case 36: {
                    Upc upca = new Upc();
                    upca.setMode(Upc.Mode.UPCA);
                    upca.setContent(dataInput);
                    symbol = upca;
                    break;
                }
                case 37: 
                case 38: 
                case 39: {
                    Upc upce = new Upc();
                    upce.setMode(Upc.Mode.UPCE);
                    upce.setContent(dataInput);
                    symbol = upce;
                    break;
                }
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 54: {
                    Postnet postnet = new Postnet();
                    postnet.setMode(Postnet.Mode.POSTNET);
                    postnet.setContent(dataInput);
                    symbol = postnet;
                    break;
                }
                case 47: {
                    MsiPlessey msiPlessey = new MsiPlessey();
                    msiPlessey.setHumanReadableLocation(hrtLocation);
                    msiPlessey.setContent(dataInput);
                    symbol = msiPlessey;
                    break;
                }
                case 50: {
                    Logmars logmars = new Logmars();
                    logmars.setHumanReadableLocation(hrtLocation);
                    logmars.setContent(dataInput);
                    symbol = logmars;
                    break;
                }
                case 51: {
                    Pharmacode pharmacode = new Pharmacode();
                    pharmacode.setContent(dataInput);
                    symbol = pharmacode;
                    break;
                }
                case 53: {
                    Pharmacode2Track pharmacode2t = new Pharmacode2Track();
                    pharmacode2t.setContent(dataInput);
                    symbol = pharmacode2t;
                    break;
                }
                case 55: 
                case 56: 
                case 106: 
                case 107: {
                    Pdf417 pdf417 = new Pdf417();
                    if (settings.isDataGs1Mode()) {
                        pdf417.setDataType(Symbol.DataType.GS1);
                    }
                    if (type == 106 || type == 107) {
                        pdf417.setDataType(Symbol.DataType.HIBC);
                    } else if (type == 56) {
                        pdf417.setMode(Pdf417.Mode.TRUNCATED);
                    }
                    pdf417.setPreferredEccLevel(settings.getSymbolECC() - 1);
                    pdf417.setDataColumns(settings.getSymbolColumns());
                    pdf417.setReaderInit(settings.isReaderInit());
                    pdf417.setContent(dataInput);
                    symbol = pdf417;
                    break;
                }
                case 57: {
                    MaxiCode maxiCode = new MaxiCode();
                    maxiCode.setPrimary(settings.getPrimaryData());
                    maxiCode.setMode(settings.getEncodeMode());
                    maxiCode.setContent(dataInput);
                    symbol = maxiCode;
                    break;
                }
                case 58: 
                case 104: 
                case 105: {
                    QrCode qrCode = new QrCode();
                    if (settings.isDataGs1Mode()) {
                        qrCode.setDataType(Symbol.DataType.GS1);
                    }
                    if (type == 104 || type == 105) {
                        qrCode.setDataType(Symbol.DataType.HIBC);
                    }
                    switch (settings.getSymbolECC()) {
                        case 0: {
                            qrCode.setPreferredEccLevel(QrCode.EccLevel.L);
                            break;
                        }
                        case 1: {
                            qrCode.setPreferredEccLevel(QrCode.EccLevel.M);
                            break;
                        }
                        case 2: {
                            qrCode.setPreferredEccLevel(QrCode.EccLevel.Q);
                            break;
                        }
                        case 3: {
                            qrCode.setPreferredEccLevel(QrCode.EccLevel.H);
                        }
                    }
                    qrCode.setPreferredVersion(settings.getSymbolVersion());
                    qrCode.setReaderInit(settings.isReaderInit());
                    qrCode.setContent(dataInput);
                    symbol = qrCode;
                    break;
                }
                case 63: 
                case 64: 
                case 65: {
                    AustraliaPost auPost = new AustraliaPost();
                    auPost.setPostMode();
                    auPost.setContent(dataInput);
                    symbol = auPost;
                    break;
                }
                case 66: {
                    AustraliaPost auReply = new AustraliaPost();
                    auReply.setReplyMode();
                    auReply.setContent(dataInput);
                    symbol = auReply;
                    break;
                }
                case 67: {
                    AustraliaPost auRoute = new AustraliaPost();
                    auRoute.setRouteMode();
                    auRoute.setContent(dataInput);
                    symbol = auRoute;
                    break;
                }
                case 68: {
                    AustraliaPost auRedirect = new AustraliaPost();
                    auRedirect.setRedirectMode();
                    auRedirect.setContent(dataInput);
                    symbol = auRedirect;
                    break;
                }
                case 70: {
                    RoyalMail4State royalMail = new RoyalMail4State();
                    royalMail.setContent(dataInput);
                    symbol = royalMail;
                    break;
                }
                case 71: 
                case 102: 
                case 103: {
                    DataMatrix dataMatrix = new DataMatrix();
                    if (settings.isDataGs1Mode()) {
                        dataMatrix.setDataType(Symbol.DataType.GS1);
                    }
                    if (type == 102 || type == 103) {
                        dataMatrix.setDataType(Symbol.DataType.HIBC);
                    }
                    dataMatrix.setReaderInit(settings.isReaderInit());
                    dataMatrix.setPreferredSize(settings.getSymbolVersion());
                    dataMatrix.setForceMode(settings.isMakeSquare() ? DataMatrix.ForceMode.SQUARE : DataMatrix.ForceMode.NONE);
                    dataMatrix.setContent(dataInput);
                    symbol = dataMatrix;
                    break;
                }
                case 74: 
                case 110: 
                case 111: {
                    CodablockF codablockF = new CodablockF();
                    if (settings.isDataGs1Mode()) {
                        codablockF.setDataType(Symbol.DataType.GS1);
                    }
                    if (type == 110 || type == 111) {
                        codablockF.setDataType(Symbol.DataType.HIBC);
                    }
                    codablockF.setContent(dataInput);
                    symbol = codablockF;
                    break;
                }
                case 75: {
                    Nve18 nve18 = new Nve18();
                    nve18.setHumanReadableLocation(hrtLocation);
                    nve18.setContent(dataInput);
                    symbol = nve18;
                    break;
                }
                case 76: {
                    JapanPost japanPost = new JapanPost();
                    japanPost.setContent(dataInput);
                    symbol = japanPost;
                    break;
                }
                case 77: {
                    KoreaPost koreaPost = new KoreaPost();
                    koreaPost.setHumanReadableLocation(hrtLocation);
                    koreaPost.setContent(dataInput);
                    symbol = koreaPost;
                    break;
                }
                case 79: {
                    DataBar14 dataBar14s = new DataBar14();
                    dataBar14s.setMode(DataBar14.Mode.STACKED);
                    dataBar14s.setContent(dataInput);
                    symbol = dataBar14s;
                    break;
                }
                case 80: {
                    DataBar14 dataBar14so = new DataBar14();
                    dataBar14so.setMode(DataBar14.Mode.OMNI);
                    dataBar14so.setContent(dataInput);
                    symbol = dataBar14so;
                    break;
                }
                case 81: {
                    DataBarExpanded dataBarES = new DataBarExpanded();
                    dataBarES.setPreferredColumns(settings.getSymbolColumns());
                    dataBarES.setStacked(true);
                    dataBarES.setContent(dataInput);
                    symbol = dataBarES;
                    break;
                }
                case 82: 
                case 83: {
                    Postnet planet = new Postnet();
                    planet.setMode(Postnet.Mode.PLANET);
                    planet.setContent(dataInput);
                    symbol = planet;
                    break;
                }
                case 84: 
                case 108: 
                case 109: {
                    Pdf417 microPdf417 = new Pdf417();
                    microPdf417.setMode(Pdf417.Mode.MICRO);
                    if (settings.isDataGs1Mode()) {
                        microPdf417.setDataType(Symbol.DataType.GS1);
                    }
                    if (type == 108 || type == 109) {
                        microPdf417.setDataType(Symbol.DataType.HIBC);
                    }
                    microPdf417.setReaderInit(settings.isReaderInit());
                    microPdf417.setDataColumns(settings.getSymbolColumns());
                    microPdf417.setContent(dataInput);
                    symbol = microPdf417;
                    break;
                }
                case 85: {
                    UspsOneCode uspsIMail = new UspsOneCode();
                    uspsIMail.setContent(dataInput);
                    symbol = uspsIMail;
                    break;
                }
                case 87: {
                    Telepen telepenNum = new Telepen();
                    telepenNum.setMode(Telepen.Mode.NUMERIC);
                    telepenNum.setHumanReadableLocation(hrtLocation);
                    telepenNum.setContent(dataInput);
                    symbol = telepenNum;
                    break;
                }
                case 89: {
                    Code2Of5 itf14 = new Code2Of5();
                    itf14.setMode(Code2Of5.ToFMode.ITF14);
                    itf14.setHumanReadableLocation(hrtLocation);
                    itf14.setContent(dataInput);
                    symbol = itf14;
                    break;
                }
                case 90: {
                    KixCode kixCode = new KixCode();
                    kixCode.setContent(dataInput);
                    symbol = kixCode;
                    break;
                }
                case 92: 
                case 112: {
                    AztecCode aztecCode = new AztecCode();
                    if (settings.isDataGs1Mode()) {
                        aztecCode.setDataType(Symbol.DataType.GS1);
                    }
                    if (type == 112) {
                        aztecCode.setDataType(Symbol.DataType.HIBC);
                    }
                    aztecCode.setReaderInit(settings.isReaderInit());
                    aztecCode.setPreferredEccLevel(settings.getSymbolECC());
                    aztecCode.setPreferredSize(settings.getSymbolVersion());
                    aztecCode.setContent(dataInput);
                    symbol = aztecCode;
                    break;
                }
                case 93: {
                    Code32 code32 = new Code32();
                    code32.setHumanReadableLocation(hrtLocation);
                    code32.setContent(dataInput);
                    symbol = code32;
                    break;
                }
                case 97: {
                    MicroQrCode microQrCode = new MicroQrCode();
                    switch (settings.getSymbolECC()) {
                        case 0: {
                            microQrCode.setEccMode(MicroQrCode.EccMode.L);
                            break;
                        }
                        case 1: {
                            microQrCode.setEccMode(MicroQrCode.EccMode.M);
                            break;
                        }
                        case 2: {
                            microQrCode.setEccMode(MicroQrCode.EccMode.Q);
                            break;
                        }
                        case 3: {
                            microQrCode.setEccMode(MicroQrCode.EccMode.H);
                        }
                    }
                    microQrCode.setPreferredVersion(settings.getSymbolVersion());
                    microQrCode.setContent(dataInput);
                    symbol = microQrCode;
                    break;
                }
                case 52: 
                case 113: {
                    Pharmazentralnummer pzn = new Pharmazentralnummer();
                    pzn.setContent(dataInput);
                    symbol = pzn;
                    break;
                }
                case 117: {
                    UspsPackage uspsPackage = new UspsPackage();
                    uspsPackage.setContent(dataInput);
                    symbol = uspsPackage;
                    break;
                }
                case 128: {
                    AztecRune aztecRune = new AztecRune();
                    aztecRune.setContent(dataInput);
                    symbol = aztecRune;
                    break;
                }
                case 130: {
                    Composite compositeEan = new Composite();
                    compositeEan.setSymbology(Composite.LinearEncoding.EAN);
                    compositeEan.setLinearContent(settings.getPrimaryData());
                    compositeEan.setContent(dataInput);
                    symbol = compositeEan;
                    break;
                }
                case 131: {
                    Composite compositeC128 = new Composite();
                    compositeC128.setSymbology(Composite.LinearEncoding.CODE_128);
                    compositeC128.setLinearContent(settings.getPrimaryData());
                    compositeC128.setContent(dataInput);
                    symbol = compositeC128;
                    break;
                }
                case 132: {
                    Composite compositeDb14 = new Composite();
                    compositeDb14.setSymbology(Composite.LinearEncoding.DATABAR_14);
                    compositeDb14.setLinearContent(settings.getPrimaryData());
                    compositeDb14.setContent(dataInput);
                    symbol = compositeDb14;
                    break;
                }
                case 133: {
                    Composite compositeDbLtd = new Composite();
                    compositeDbLtd.setSymbology(Composite.LinearEncoding.DATABAR_LIMITED);
                    compositeDbLtd.setLinearContent(settings.getPrimaryData());
                    compositeDbLtd.setContent(dataInput);
                    symbol = compositeDbLtd;
                    break;
                }
                case 134: {
                    Composite compositeDbExt = new Composite();
                    compositeDbExt.setSymbology(Composite.LinearEncoding.DATABAR_EXPANDED);
                    compositeDbExt.setLinearContent(settings.getPrimaryData());
                    compositeDbExt.setContent(dataInput);
                    symbol = compositeDbExt;
                    break;
                }
                case 135: {
                    Composite compositeUpcA = new Composite();
                    compositeUpcA.setSymbology(Composite.LinearEncoding.UPCA);
                    compositeUpcA.setLinearContent(settings.getPrimaryData());
                    compositeUpcA.setContent(dataInput);
                    symbol = compositeUpcA;
                    break;
                }
                case 136: {
                    Composite compositeUpcE = new Composite();
                    compositeUpcE.setSymbology(Composite.LinearEncoding.UPCE);
                    compositeUpcE.setLinearContent(settings.getPrimaryData());
                    compositeUpcE.setContent(dataInput);
                    symbol = compositeUpcE;
                    break;
                }
                case 137: {
                    Composite compositeDb14Stack = new Composite();
                    compositeDb14Stack.setSymbology(Composite.LinearEncoding.DATABAR_14_STACK);
                    compositeDb14Stack.setLinearContent(settings.getPrimaryData());
                    compositeDb14Stack.setContent(dataInput);
                    symbol = compositeDb14Stack;
                    break;
                }
                case 138: {
                    Composite compositeDb14SO = new Composite();
                    compositeDb14SO.setSymbology(Composite.LinearEncoding.DATABAR_14_STACK_OMNI);
                    compositeDb14SO.setLinearContent(settings.getPrimaryData());
                    compositeDb14SO.setContent(dataInput);
                    symbol = compositeDb14SO;
                    break;
                }
                case 139: {
                    Composite compositeDb14ES = new Composite();
                    compositeDb14ES.setSymbology(Composite.LinearEncoding.DATABAR_EXPANDED_STACK);
                    compositeDb14ES.setLinearContent(settings.getPrimaryData());
                    compositeDb14ES.setContent(dataInput);
                    symbol = compositeDb14ES;
                    break;
                }
                case 140: {
                    ChannelCode channelCode = new ChannelCode();
                    channelCode.setPreferredNumberOfChannels(settings.getSymbolColumns());
                    channelCode.setHumanReadableLocation(hrtLocation);
                    channelCode.setContent(dataInput);
                    symbol = channelCode;
                    break;
                }
                case 141: {
                    CodeOne codeOne = new CodeOne();
                    if (settings.isDataGs1Mode()) {
                        codeOne.setDataType(Symbol.DataType.GS1);
                    }
                    codeOne.setReaderInit(settings.isReaderInit());
                    switch (settings.getSymbolVersion()) {
                        case 0: {
                            codeOne.setPreferredVersion(CodeOne.Version.NONE);
                            break;
                        }
                        case 1: {
                            codeOne.setPreferredVersion(CodeOne.Version.A);
                            break;
                        }
                        case 2: {
                            codeOne.setPreferredVersion(CodeOne.Version.B);
                            break;
                        }
                        case 3: {
                            codeOne.setPreferredVersion(CodeOne.Version.C);
                            break;
                        }
                        case 4: {
                            codeOne.setPreferredVersion(CodeOne.Version.D);
                            break;
                        }
                        case 5: {
                            codeOne.setPreferredVersion(CodeOne.Version.E);
                            break;
                        }
                        case 6: {
                            codeOne.setPreferredVersion(CodeOne.Version.F);
                            break;
                        }
                        case 7: {
                            codeOne.setPreferredVersion(CodeOne.Version.G);
                            break;
                        }
                        case 8: {
                            codeOne.setPreferredVersion(CodeOne.Version.H);
                            break;
                        }
                        case 9: {
                            codeOne.setPreferredVersion(CodeOne.Version.S);
                            break;
                        }
                        case 10: {
                            codeOne.setPreferredVersion(CodeOne.Version.T);
                        }
                    }
                    codeOne.setContent(dataInput);
                    symbol = codeOne;
                    break;
                }
                case 142: {
                    GridMatrix gridMatrix = new GridMatrix();
                    if (settings.isDataGs1Mode()) {
                        gridMatrix.setDataType(Symbol.DataType.GS1);
                    }
                    gridMatrix.setReaderInit(settings.isReaderInit());
                    gridMatrix.setPreferredEccLevel(settings.getSymbolECC());
                    gridMatrix.setPreferredVersion(settings.getSymbolVersion());
                    gridMatrix.setContent(dataInput);
                    symbol = gridMatrix;
                    break;
                }
                default: {
                    System.out.println("Invaid barcode type");
                    return;
                }
            }
        }
        catch (OkapiException e) {
            System.out.printf("Encoding error: %s\n", e.getMessage());
            return;
        }
        File file = new File(outputFileName);
        try {
            int i = file.getName().lastIndexOf(46);
            if (i > 0) {
                extension = file.getName().substring(i + 1);
            }
            switch (extension) {
                case "png": 
                case "gif": 
                case "jpg": 
                case "bmp": {
                    BufferedImage image = new BufferedImage(symbol.getWidth(), symbol.getHeight(), 1);
                    Graphics2D g2d = image.createGraphics();
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    Java2DRenderer renderer = new Java2DRenderer(g2d, 1.0, paper, ink);
                    System.out.printf("MakeBarcode\n", new Object[0]);
                    renderer.render(symbol);
                    try {
                        ImageIO.write((RenderedImage)image, extension, file);
                    }
                    catch (IOException e) {
                        System.out.printf("Error outputting to file\n", new Object[0]);
                    }
                    break;
                }
                case "svg": {
                    SvgRenderer svg = new SvgRenderer(new FileOutputStream(file), 1.0, paper, ink, true);
                    svg.render(symbol);
                    break;
                }
                case "eps": {
                    PostScriptRenderer eps = new PostScriptRenderer(new FileOutputStream(file), 1.0, paper, ink);
                    eps.render(symbol);
                    break;
                }
                default: {
                    System.out.println("Unsupported output format");
                    break;
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.printf("File Not Found\n", new Object[0]);
        }
        catch (IOException e) {
            System.out.printf("Write Error\n", new Object[0]);
        }
    }

    private int eanCalculateVersion(String dataInput) {
        int length = 0;
        boolean latch = true;
        for (int i = 0; i < dataInput.length(); ++i) {
            if (dataInput.charAt(i) >= '0' && dataInput.charAt(i) <= '9') {
                if (!latch) continue;
                ++length;
                continue;
            }
            latch = false;
        }
        if (length <= 7) {
            return 8;
        }
        return 13;
    }
}

