/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode;

import com.beust.jcommander.JCommander;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import uk.org.okapibarcode.MakeBarcode;
import uk.org.okapibarcode.Settings;
import uk.org.okapibarcode.gui.OkapiUI;

public class OkapiBarcode {
    public static void main(String[] args) {
        Settings settings = new Settings();
        new JCommander((Object)settings, args);
        if (!settings.isGuiSupressed()) {
            OkapiUI okapiUi = new OkapiUI();
            okapiUi.setVisible(true);
        } else {
            int returnValue = OkapiBarcode.commandLine(settings);
            if (returnValue != 0) {
                System.out.println("An error occurred");
            }
        }
    }

    private static int commandLine(Settings settings) {
        String inputData = settings.getInputData();
        String inputFile = settings.getInputFile();
        if (settings.isDisplayTypes()) {
            System.out.print(" 1: Code 11           54: Brazilian CepNet         97: Micro QR Code\n 2: Standard 2of5     55: PDF417                   98: HIBC Code 128\n 3: Interleaved 2of5  56: PDF417 Trunc             99: HIBC Code 39\n 4: IATA 2of5         57: Maxicode                102: HIBC Data Matrix\n 6: Data Logic        58: QR Code                 104: HIBC QR Code\n 7: Industrial 2of5   60: Code 128-B              106: HIBC PDF417\n 8: Code 39           63: AP Standard Customer    108: HIBC MicroPDF417\n 9: Extended Code 39  66: AP Reply Paid           110: HIBC Codablock-F\n13: EAN               67: AP Routing              112: HIBC Aztec Code\n18: Codabar           68: AP Redirection          113: PZN-8\n20: Code 128          70: RM4SCC                  117: USPS IMpb\n21: Leitcode          71: Data Matrix             128: Aztec Runes\n22: Identcode         74: Codablock-F             129: Code 32\n23: Code 16k          75: NVE-18                  130: Comp EAN\n24: Code 49           76: Japanese Post           131: Comp GS1-128\n25: Code 93           77: Korea Post              132: Comp Databar-14\n29: Databar-14        79: Databar-14 Stack        133: Comp Databar Ltd\n30: Databar Limited   80: Databar-14 Stack Omni   134: Comp Databar Ext\n31: Databar Extended  81: Databar Extended Stack  135: Comp UPC-A\n32: Telepen Alpha     82: Planet                  136: Comp UPC-E\n34: UPC-A             84: MicroPDF                137: Comp Databar-14 Stack\n37: UPC-E             85: USPS Intelligent Mail   138: Comp Databar Stack Omni\n40: Postnet           87: Telepen Numeric         139: Comp Databar Ext Stack\n47: MSI Plessey       89: ITF-14                  140: Channel Code\n50: Logmars           90: KIX Code                141: Code One \n51: Pharma One-Track  92: Aztec Code              142: Grid Matrix\n53: Pharma Two-Track  93: Code 32\n");
        }
        if (inputData.isEmpty() && inputFile.isEmpty()) {
            System.out.println("error: No data received, no symbol generated");
            return 0;
        }
        if (inputFile.isEmpty()) {
            if (!settings.isDataBinaryMode()) {
                inputData = OkapiBarcode.escapeCharProcess(inputData);
            }
            MakeBarcode mb = new MakeBarcode();
            mb.process(settings, inputData, settings.getOutputFile());
        } else {
            OkapiBarcode.processFile(settings);
        }
        return 0;
    }

    private static void processFile(Settings settings) {
        File name = new File(settings.getInputFile());
        int counter = 0;
        if (!settings.isBatchMode()) {
            try (FileInputStream fis = new FileInputStream(name);){
                byte[] inputBytes = new byte[fis.available()];
                fis.read(inputBytes);
                String inputData = new String(inputBytes, "UTF-8");
                MakeBarcode mb = new MakeBarcode();
                mb.process(settings, inputData, settings.getOutputFile());
            }
            catch (IOException e) {
                System.out.println("File Read Error");
            }
        } else {
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), "UTF8"));){
                String inputData;
                while ((inputData = in.readLine()) != null) {
                    MakeBarcode mb = new MakeBarcode();
                    mb.process(settings, inputData, OkapiBarcode.calcFileName(settings, ++counter));
                }
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("Encoding exception");
            }
            catch (IOException e) {
                System.out.println("File Read Error");
            }
        }
    }

    private static String calcFileName(Settings settings, int counter) {
        int i;
        String fileName = "";
        int spaces = 0;
        String number = Integer.toString(counter);
        String template = settings.getOutputFile().equals("out.png") ? "~~~~~.png" : settings.getOutputFile();
        for (i = 0; i < template.length(); ++i) {
            switch (template.charAt(i)) {
                case '#': 
                case '~': {
                    ++spaces;
                }
            }
        }
        int blanks = spaces - number.length();
        if (blanks < 0) {
            System.out.println("Invalid output filename");
            return "out.png";
        }
        int blankPosition = 0;
        block8: for (i = 0; i < template.length(); ++i) {
            switch (template.charAt(i)) {
                case '#': {
                    fileName = blankPosition >= blanks ? fileName + number.charAt(blankPosition - blanks) : fileName + ' ';
                    ++blankPosition;
                    continue block8;
                }
                case '~': {
                    fileName = blankPosition >= blanks ? fileName + number.charAt(blankPosition - blanks) : fileName + '0';
                    ++blankPosition;
                    continue block8;
                }
                default: {
                    fileName = fileName + template.charAt(i);
                }
            }
        }
        return fileName;
    }

    private static String escapeCharProcess(String inputString) {
        String outputString = "";
        int i = 0;
        do {
            if (inputString.charAt(i) == '\\') {
                if (i < inputString.length() - 1) {
                    switch (inputString.charAt(i + 1)) {
                        case '0': {
                            outputString = outputString + 0;
                            break;
                        }
                        case 'E': {
                            outputString = outputString + 4;
                            break;
                        }
                        case 'a': {
                            outputString = outputString + 7;
                            break;
                        }
                        case 'b': {
                            outputString = outputString + 8;
                            break;
                        }
                        case 't': {
                            outputString = outputString + 9;
                            break;
                        }
                        case 'n': {
                            outputString = outputString + 10;
                            break;
                        }
                        case 'v': {
                            outputString = outputString + 11;
                            break;
                        }
                        case 'f': {
                            outputString = outputString + 12;
                            break;
                        }
                        case 'r': {
                            outputString = outputString + 13;
                            break;
                        }
                        case 'e': {
                            outputString = outputString + 27;
                            break;
                        }
                        case 'G': {
                            outputString = outputString + 29;
                            break;
                        }
                        case 'R': {
                            outputString = outputString + 30;
                            break;
                        }
                        default: {
                            outputString = outputString + '\\';
                            outputString = outputString + inputString.charAt(i);
                        }
                    }
                    i += 2;
                    continue;
                }
                outputString = outputString + '\\';
                ++i;
                continue;
            }
            outputString = outputString + inputString.charAt(i);
            ++i;
        } while (i < inputString.length());
        return outputString;
    }
}

