/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.nio.charset.StandardCharsets;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;

public class Code128
extends Symbol {
    protected static final String[] CODE128_TABLE = new String[]{"212222", "222122", "222221", "121223", "121322", "131222", "122213", "122312", "132212", "221213", "221312", "231212", "112232", "122132", "122231", "113222", "123122", "123221", "223211", "221132", "221231", "213212", "223112", "312131", "311222", "321122", "321221", "312212", "322112", "322211", "212123", "212321", "232121", "111323", "131123", "131321", "112313", "132113", "132311", "211313", "231113", "231311", "112133", "112331", "132131", "113123", "113321", "133121", "313121", "211331", "231131", "213113", "213311", "213131", "311123", "311321", "331121", "312113", "312311", "332111", "314111", "221411", "431111", "111224", "111422", "121124", "121421", "141122", "141221", "112214", "112412", "122114", "122411", "142112", "142211", "241211", "221114", "413111", "241112", "134111", "111242", "121142", "121241", "114212", "124112", "124211", "411212", "421112", "421211", "212141", "214121", "412121", "111143", "111341", "131141", "114113", "114311", "411113", "411311", "113141", "114131", "311141", "411131", "211412", "211214", "211232", "2331112"};
    private boolean suppressModeC = false;
    private Composite compositeMode = Composite.OFF;

    public void setSuppressModeC(boolean suppressModeC) {
        this.suppressModeC = suppressModeC;
    }

    public boolean getSuppressModeC() {
        return this.suppressModeC;
    }

    protected void setCca() {
        this.compositeMode = Composite.CCA;
    }

    protected void setCcb() {
        this.compositeMode = Composite.CCB;
    }

    protected void setCcc() {
        this.compositeMode = Composite.CCC;
    }

    public void unsetCc() {
        this.compositeMode = Composite.OFF;
    }

    @Override
    protected boolean gs1Supported() {
        return true;
    }

    @Override
    protected void encode() {
        Mode current_set;
        Mode mode;
        int k;
        int i;
        int input_point = 0;
        int bar_characters = 0;
        int total_sum = 0;
        FMode f_state = FMode.LATCHN;
        Mode[] mode_type = new Mode[200];
        int[] mode_length = new int[200];
        int[] values = new int[200];
        int linkage_flag = 0;
        int index_point = 0;
        int read = 0;
        this.inputData = Code128.toBytes(this.content, StandardCharsets.ISO_8859_1, new int[0]);
        if (this.inputData == null) {
            throw new OkapiException("Invalid characters in input data");
        }
        int sourcelen = this.inputData.length;
        FMode[] fset = new FMode[200];
        Mode[] set = new Mode[200];
        if (sourcelen > 170) {
            throw new OkapiException("Input data too long");
        }
        for (i = 0; i < sourcelen; ++i) {
            int ch = this.inputData[i];
            fset[i] = ch >= 128 && ch != -1 && ch != -2 && ch != -3 && ch != -4 ? FMode.SHIFTF : FMode.LATCHN;
        }
        int j = 0;
        for (i = 0; i < sourcelen; ++i) {
            j = fset[i] == FMode.SHIFTF ? ++j : 0;
            if (j >= 5) {
                for (k = i; k > i - 5; --k) {
                    fset[k] = FMode.LATCHF;
                }
            }
            if (j < 3 || i != sourcelen - 1) continue;
            for (k = i; k > i - 3; --k) {
                fset[k] = FMode.LATCHF;
            }
        }
        for (i = 1; i < sourcelen; ++i) {
            if (fset[i - 1] != FMode.LATCHF || fset[i] != FMode.LATCHN) continue;
            j = 0;
            while (fset[i + j] == FMode.LATCHN && i + j < sourcelen) {
                ++j;
            }
            if (j >= 5 && (j >= 3 || i + j != sourcelen - 1)) continue;
            for (k = 0; k < j; ++k) {
                fset[i + k] = FMode.SHIFTN;
            }
        }
        int letter = this.inputData[input_point];
        int numbers = letter >= 48 && letter <= 57 ? 1 : 0;
        mode_type[0] = mode = this.findSubset(letter, numbers);
        mode_length[0] = mode_length[0] + this.length(letter, mode);
        for (i = 1; i < sourcelen; ++i) {
            letter = this.inputData[i];
            Mode last_mode = mode;
            mode = this.findSubset(letter, numbers);
            if (mode == last_mode) {
                int n = index_point;
                mode_length[n] = mode_length[n] + this.length(letter, mode);
            } else {
                mode_type[++index_point] = mode;
                mode_length[index_point] = this.length(letter, mode);
            }
            if (letter >= 48 && letter <= 57) {
                ++numbers;
                continue;
            }
            numbers = 0;
        }
        ++index_point;
        index_point = this.reduceSubsetChanges(mode_type, mode_length, index_point);
        read = 0;
        for (i = 0; i < index_point; ++i) {
            for (j = 0; j < mode_length[i]; ++j) {
                set[read] = mode_type[i];
                ++read;
            }
        }
        int cs = 0;
        int nums = 0;
        int fncs = 0;
        for (i = 0; i < read; ++i) {
            if (set[i] == Mode.LATCHC) {
                ++cs;
                if (this.inputData[i] >= 48 && this.inputData[i] <= 57) {
                    ++nums;
                    continue;
                }
                if (this.inputData[i] != -1) continue;
                ++fncs;
                continue;
            }
            this.resolveOddCs(set, i, cs, nums, fncs);
            cs = 0;
            nums = 0;
            fncs = 0;
        }
        this.resolveOddCs(set, i, cs, nums, fncs);
        if (set[0] == Mode.SHIFTA) {
            i = 0;
            do {
                set[i] = Mode.LATCHA;
            } while (set[++i] == Mode.SHIFTA);
        }
        if (set[0] == Mode.SHIFTB) {
            i = 0;
            do {
                set[i] = Mode.LATCHB;
            } while (set[++i] == Mode.SHIFTB);
        }
        Mode last_set = Mode.NULL;
        double glyph_count = 0.0;
        for (i = 0; i < sourcelen; ++i) {
            if (set[i] == Mode.SHIFTA || set[i] == Mode.SHIFTB) {
                glyph_count += 1.0;
            }
            if (fset[i] == FMode.SHIFTF || fset[i] == FMode.SHIFTN) {
                glyph_count += 1.0;
            }
            if ((set[i] == Mode.LATCHA || set[i] == Mode.LATCHB || set[i] == Mode.LATCHC) && set[i] != last_set) {
                last_set = set[i];
                glyph_count += 1.0;
            }
            if (i == 0) {
                if (fset[i] == FMode.LATCHF) {
                    glyph_count += 2.0;
                }
            } else {
                if (fset[i] == FMode.LATCHF && fset[i - 1] != FMode.LATCHF) {
                    glyph_count += 2.0;
                }
                if (fset[i] != FMode.LATCHF && fset[i - 1] == FMode.LATCHF) {
                    glyph_count += 2.0;
                }
            }
            if (set[i] == Mode.LATCHC) {
                if (this.inputData[i] == -1) {
                    glyph_count += 1.0;
                    continue;
                }
                glyph_count += 0.5;
                continue;
            }
            glyph_count += 1.0;
        }
        if (glyph_count > 80.0) {
            throw new OkapiException("Input data too long");
        }
        this.info("Encoding: ");
        if (this.readerInit) {
            switch (set[0]) {
                case LATCHA: {
                    values[0] = 103;
                    current_set = Mode.LATCHA;
                    values[1] = 96;
                    ++bar_characters;
                    this.info("STARTA FNC3 ");
                    break;
                }
                case LATCHB: {
                    values[0] = 104;
                    current_set = Mode.LATCHB;
                    values[1] = 96;
                    ++bar_characters;
                    this.info("STARTB FNC3 ");
                    break;
                }
                default: {
                    values[0] = 104;
                    values[1] = 96;
                    values[2] = 99;
                    bar_characters += 2;
                    current_set = Mode.LATCHC;
                    this.info("STARTB FNC3 CODEC ");
                    break;
                }
            }
        } else {
            switch (set[0]) {
                case LATCHA: {
                    values[0] = 103;
                    current_set = Mode.LATCHA;
                    this.info("STARTA ");
                    break;
                }
                case LATCHB: {
                    values[0] = 104;
                    current_set = Mode.LATCHB;
                    this.info("STARTB ");
                    break;
                }
                default: {
                    values[0] = 105;
                    current_set = Mode.LATCHC;
                    this.info("STARTC ");
                }
            }
        }
        ++bar_characters;
        if (this.inputDataType == Symbol.DataType.GS1) {
            values[1] = 102;
            ++bar_characters;
            this.info("FNC1 ");
        }
        if (fset[0] == FMode.LATCHF) {
            switch (current_set) {
                case LATCHA: {
                    values[bar_characters] = 101;
                    values[bar_characters + 1] = 101;
                    this.info("FNC4 FNC4 ");
                    break;
                }
                case LATCHB: {
                    values[bar_characters] = 100;
                    values[bar_characters + 1] = 100;
                    this.info("FNC4 FNC4 ");
                }
            }
            bar_characters += 2;
            f_state = FMode.LATCHF;
        }
        read = 0;
        do {
            if (read != 0 && set[read] != current_set) {
                switch (set[read]) {
                    case LATCHA: {
                        values[bar_characters] = 101;
                        ++bar_characters;
                        current_set = Mode.LATCHA;
                        this.info("CODEA ");
                        break;
                    }
                    case LATCHB: {
                        values[bar_characters] = 100;
                        ++bar_characters;
                        current_set = Mode.LATCHB;
                        this.info("CODEB ");
                        break;
                    }
                    case LATCHC: {
                        values[bar_characters] = 99;
                        ++bar_characters;
                        current_set = Mode.LATCHC;
                        this.info("CODEC ");
                    }
                }
            }
            if (read != 0) {
                if (fset[read] == FMode.LATCHF && f_state == FMode.LATCHN) {
                    switch (current_set) {
                        case LATCHA: {
                            values[bar_characters] = 101;
                            values[bar_characters + 1] = 101;
                            this.info("FNC4 FNC4 ");
                            break;
                        }
                        case LATCHB: {
                            values[bar_characters] = 100;
                            values[bar_characters + 1] = 100;
                            this.info("FNC4 FNC4 ");
                        }
                    }
                    bar_characters += 2;
                    f_state = FMode.LATCHF;
                }
                if (fset[read] == FMode.LATCHN && f_state == FMode.LATCHF) {
                    switch (current_set) {
                        case LATCHA: {
                            values[bar_characters] = 101;
                            values[bar_characters + 1] = 101;
                            this.info("FNC4 FNC4 ");
                            break;
                        }
                        case LATCHB: {
                            values[bar_characters] = 100;
                            values[bar_characters + 1] = 100;
                            this.info("FNC4 FNC4 ");
                        }
                    }
                    bar_characters += 2;
                    f_state = FMode.LATCHN;
                }
            }
            if (fset[read] == FMode.SHIFTF || fset[read] == FMode.SHIFTN) {
                switch (current_set) {
                    case LATCHA: {
                        values[bar_characters] = 101;
                        this.info("FNC4 ");
                        break;
                    }
                    case LATCHB: {
                        values[bar_characters] = 100;
                        this.info("FNC4 ");
                    }
                }
                ++bar_characters;
            }
            if (set[read] == Mode.SHIFTA || set[read] == Mode.SHIFTB) {
                values[bar_characters] = 98;
                this.info("SHFT ");
                ++bar_characters;
            }
            int c = this.inputData[read];
            switch (set[read]) {
                case LATCHA: 
                case SHIFTA: {
                    if (c == -1) {
                        values[bar_characters] = 102;
                        this.info("FNC1 ");
                    } else if (c == -2) {
                        values[bar_characters] = 97;
                        this.info("FNC2 ");
                    } else if (c == -3) {
                        values[bar_characters] = 96;
                        this.info("FNC3 ");
                    } else if (c == -4) {
                        values[bar_characters] = 101;
                        this.info("FNC4 ");
                    } else if (c > 127) {
                        values[bar_characters] = c < 160 ? c - 128 + 64 : c - 128 - 32;
                        this.infoSpace(values[bar_characters]);
                    } else {
                        values[bar_characters] = c < 32 ? c + 64 : c - 32;
                        this.infoSpace(values[bar_characters]);
                    }
                    ++bar_characters;
                    ++read;
                    break;
                }
                case LATCHB: 
                case SHIFTB: {
                    if (c == -1) {
                        values[bar_characters] = 102;
                        this.info("FNC1 ");
                    } else if (c == -2) {
                        values[bar_characters] = 97;
                        this.info("FNC2 ");
                    } else if (c == -3) {
                        values[bar_characters] = 96;
                        this.info("FNC3 ");
                    } else if (c == -4) {
                        values[bar_characters] = 100;
                        this.info("FNC4 ");
                    } else if (c > 127) {
                        values[bar_characters] = c - 32 - 128;
                        this.infoSpace(values[bar_characters]);
                    } else {
                        values[bar_characters] = c - 32;
                        this.infoSpace(values[bar_characters]);
                    }
                    ++bar_characters;
                    ++read;
                    break;
                }
                case LATCHC: {
                    int weight;
                    if (c == -1) {
                        values[bar_characters] = 102;
                        this.info("FNC1 ");
                        ++bar_characters;
                        ++read;
                        break;
                    }
                    int d = this.inputData[read + 1];
                    values[bar_characters] = weight = 10 * (c - 48) + (d - 48);
                    this.infoSpace(values[bar_characters]);
                    ++bar_characters;
                    read += 2;
                }
            }
        } while (read < sourcelen);
        this.infoLine();
        switch (this.compositeMode) {
            case CCA: 
            case CCB: {
                switch (set[sourcelen - 1]) {
                    case LATCHA: {
                        linkage_flag = 100;
                        break;
                    }
                    case LATCHB: {
                        linkage_flag = 99;
                        break;
                    }
                    case LATCHC: {
                        linkage_flag = 101;
                    }
                }
                this.infoLine("Linkage Flag: " + linkage_flag);
                break;
            }
            case CCC: {
                switch (set[sourcelen - 1]) {
                    case LATCHA: {
                        linkage_flag = 99;
                        break;
                    }
                    case LATCHB: {
                        linkage_flag = 101;
                        break;
                    }
                    case LATCHC: {
                        linkage_flag = 100;
                    }
                }
                this.infoLine("Linkage Flag: " + linkage_flag);
                break;
            }
        }
        if (linkage_flag != 0) {
            values[bar_characters] = linkage_flag;
            ++bar_characters;
        }
        this.infoLine("Data Codewords: " + bar_characters);
        for (i = 0; i < bar_characters; ++i) {
            total_sum += i == 0 ? values[i] : values[i] * i;
        }
        int checkDigit = total_sum % 103;
        this.infoLine("Check Digit: " + checkDigit);
        StringBuilder dest = new StringBuilder(6 * bar_characters + 6 + 7);
        for (i = 0; i < bar_characters; ++i) {
            dest.append(CODE128_TABLE[values[i]]);
        }
        dest.append(CODE128_TABLE[checkDigit]);
        dest.append(CODE128_TABLE[106]);
        if (this.inputDataType != Symbol.DataType.GS1) {
            this.readable = Code128.removeFncEscapeSequences(this.content);
            if (this.inputDataType == Symbol.DataType.HIBC) {
                this.readable = "*" + this.readable + "*";
            }
        }
        if (this.compositeMode == Composite.OFF) {
            this.pattern = new String[]{dest.toString()};
            this.row_height = new int[]{-1};
            this.row_count = 1;
        } else {
            this.pattern = new String[]{"0" + dest, dest.toString()};
            this.row_height = new int[]{1, -1};
            this.row_count = 2;
        }
    }

    private static String removeFncEscapeSequences(String s) {
        return s.replace("\\<FNC1>", "").replace("\\<FNC2>", "").replace("\\<FNC3>", "").replace("\\<FNC4>", "");
    }

    private void resolveOddCs(Mode[] set, int i, int cs, int nums, int fncs) {
        if ((nums & 1) != 0) {
            int index;
            Mode m = i - cs == 0 || fncs > 0 ? ((index = i - 1) + 1 < set.length && set[index + 1] != null && set[index + 1] != Mode.LATCHC ? set[index + 1] : Mode.LATCHB) : ((index = i - nums) - 1 >= 0 && set[index - 1] != null && set[index - 1] != Mode.LATCHC ? set[index - 1] : Mode.LATCHB);
            set[index] = m;
        }
    }

    private Mode findSubset(int letter, int numbers) {
        Mode mode = letter == -1 ? (numbers % 2 == 0 ? Mode.ABORC : Mode.AORB) : (letter == -2 || letter == -3 || letter == -4 ? Mode.AORB : (letter <= 31 ? Mode.SHIFTA : (letter >= 48 && letter <= 57 ? Mode.ABORC : (letter <= 95 ? Mode.AORB : (letter <= 127 ? Mode.SHIFTB : (letter <= 159 ? Mode.SHIFTA : (letter <= 223 ? Mode.AORB : Mode.SHIFTB)))))));
        if (this.suppressModeC && mode == Mode.ABORC) {
            mode = Mode.AORB;
        }
        return mode;
    }

    private int length(int letter, Mode mode) {
        if (letter == -1 && mode == Mode.ABORC) {
            return 2;
        }
        return 1;
    }

    private int reduceSubsetChanges(Mode[] mode_type, int[] mode_length, int index_point) {
        int totalLength = 0;
        for (int i = 0; i < index_point; ++i) {
            Mode current = mode_type[i];
            int length = mode_length[i];
            Mode last = i != 0 ? mode_type[i - 1] : Mode.NULL;
            Mode next = i != index_point - 1 ? mode_type[i + 1] : Mode.NULL;
            int extraLength = 0;
            for (int j = 0; j < length - extraLength; ++j) {
                if (this.length(this.inputData[totalLength + j], current) != 2) continue;
                ++extraLength;
            }
            if (i == 0) {
                if (index_point == 1 && length == 2 && current == Mode.ABORC) {
                    mode_type[i] = Mode.LATCHC;
                    current = Mode.LATCHC;
                }
                if (current == Mode.ABORC) {
                    if (length >= 4) {
                        mode_type[i] = Mode.LATCHC;
                        current = Mode.LATCHC;
                    } else {
                        mode_type[i] = Mode.AORB;
                        current = Mode.AORB;
                    }
                }
                if (current == Mode.SHIFTA) {
                    mode_type[i] = Mode.LATCHA;
                    current = Mode.LATCHA;
                }
                if (current == Mode.AORB && next == Mode.SHIFTA) {
                    mode_type[i] = Mode.LATCHA;
                    current = Mode.LATCHA;
                }
                if (current == Mode.AORB) {
                    mode_type[i] = Mode.LATCHB;
                    current = Mode.LATCHB;
                }
            } else {
                if (current == Mode.ABORC && length >= 4) {
                    mode_type[i] = Mode.LATCHC;
                    current = Mode.LATCHC;
                }
                if (current == Mode.ABORC) {
                    mode_type[i] = Mode.AORB;
                    current = Mode.AORB;
                }
                if (current == Mode.AORB && last == Mode.LATCHA) {
                    mode_type[i] = Mode.LATCHA;
                    current = Mode.LATCHA;
                }
                if (current == Mode.AORB && last == Mode.LATCHB) {
                    mode_type[i] = Mode.LATCHB;
                    current = Mode.LATCHB;
                }
                if (current == Mode.AORB && next == Mode.SHIFTA) {
                    mode_type[i] = Mode.LATCHA;
                    current = Mode.LATCHA;
                }
                if (current == Mode.AORB && next == Mode.SHIFTB) {
                    mode_type[i] = Mode.LATCHB;
                    current = Mode.LATCHB;
                }
                if (current == Mode.AORB) {
                    mode_type[i] = Mode.LATCHB;
                    current = Mode.LATCHB;
                }
                if (current == Mode.SHIFTA && length > 1) {
                    mode_type[i] = Mode.LATCHA;
                    current = Mode.LATCHA;
                }
                if (current == Mode.SHIFTB && length > 1) {
                    mode_type[i] = Mode.LATCHB;
                    current = Mode.LATCHB;
                }
                if (current == Mode.SHIFTA && last == Mode.LATCHA) {
                    mode_type[i] = Mode.LATCHA;
                    current = Mode.LATCHA;
                }
                if (current == Mode.SHIFTB && last == Mode.LATCHB) {
                    mode_type[i] = Mode.LATCHB;
                    current = Mode.LATCHB;
                }
                if (current == Mode.SHIFTA && next == Mode.AORB) {
                    mode_type[i] = Mode.LATCHA;
                    current = Mode.LATCHA;
                }
                if (current == Mode.SHIFTB && next == Mode.AORB) {
                    mode_type[i] = Mode.LATCHB;
                    current = Mode.LATCHB;
                }
                if (current == Mode.SHIFTA && last == Mode.LATCHC) {
                    mode_type[i] = Mode.LATCHA;
                    current = Mode.LATCHA;
                }
                if (current == Mode.SHIFTB && last == Mode.LATCHC) {
                    mode_type[i] = Mode.LATCHB;
                    current = Mode.LATCHB;
                }
            }
            int n = i;
            mode_length[n] = mode_length[n] - extraLength;
            totalLength += mode_length[i];
        }
        return this.combineSubsetBlocks(mode_type, mode_length, index_point);
    }

    private int combineSubsetBlocks(Mode[] mode_type, int[] mode_length, int index_point) {
        if (index_point > 1) {
            for (int i = 1; i < index_point; ++i) {
                if (mode_type[i - 1] != mode_type[i]) continue;
                mode_length[i - 1] = mode_length[i - 1] + mode_length[i];
                for (int j = i + 1; j < index_point; ++j) {
                    mode_length[j - 1] = mode_length[j];
                    mode_type[j - 1] = mode_type[j];
                }
                --index_point;
                --i;
            }
        }
        return index_point;
    }

    @Override
    protected int[] getCodewords() {
        return this.getPatternAsCodewords(6);
    }

    private static enum Composite {
        OFF,
        CCA,
        CCB,
        CCC;

    }

    private static enum FMode {
        SHIFTN,
        LATCHN,
        SHIFTF,
        LATCHF;

    }

    private static enum Mode {
        NULL,
        SHIFTA,
        LATCHA,
        SHIFTB,
        LATCHB,
        SHIFTC,
        LATCHC,
        AORB,
        ABORC;

    }
}

