/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.Code3Of9;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;

public class Code3Of9Extended
extends Symbol {
    private static final String[] E_CODE_39 = new String[]{"%U", "$A", "$B", "$C", "$D", "$E", "$F", "$G", "$H", "$I", "$J", "$K", "$L", "$M", "$N", "$O", "$P", "$Q", "$R", "$S", "$T", "$U", "$V", "$W", "$X", "$Y", "$Z", "%A", "%B", "%C", "%D", "%E", " ", "/A", "/B", "/C", "/D", "/E", "/F", "/G", "/H", "/I", "/J", "/K", "/L", "-", ".", "/O", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "/Z", "%F", "%G", "%H", "%I", "%J", "%V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "%K", "%L", "%M", "%N", "%O", "%W", "+A", "+B", "+C", "+D", "+E", "+F", "+G", "+H", "+I", "+J", "+K", "+L", "+M", "+N", "+O", "+P", "+Q", "+R", "+S", "+T", "+U", "+V", "+W", "+X", "+Y", "+Z", "%P", "%Q", "%R", "%S", "%T"};
    private CheckDigit checkOption = CheckDigit.NONE;

    public void setCheckDigit(CheckDigit checkMode) {
        this.checkOption = checkMode;
    }

    @Override
    protected void encode() {
        String buffer = "";
        int l = this.content.length();
        Code3Of9 c = new Code3Of9();
        if (this.checkOption == CheckDigit.MOD43) {
            c.setCheckDigit(Code3Of9.CheckDigit.MOD43);
        }
        if (!this.content.matches("[\u0000-\u007f]+")) {
            throw new OkapiException("Invalid characters in input data");
        }
        for (int i = 0; i < l; ++i) {
            char asciicode = this.content.charAt(i);
            buffer = buffer + E_CODE_39[asciicode];
        }
        c.setContent(buffer);
        this.readable = this.content;
        this.pattern = new String[1];
        this.pattern[0] = c.pattern[0];
        this.row_count = 1;
        this.row_height = new int[1];
        this.row_height[0] = -1;
    }

    public static enum CheckDigit {
        NONE,
        MOD43;

    }
}

