/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.awt.geom.Rectangle2D;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import uk.org.okapibarcode.backend.Code128;
import uk.org.okapibarcode.backend.DataBar14;
import uk.org.okapibarcode.backend.DataBarExpanded;
import uk.org.okapibarcode.backend.DataBarLimited;
import uk.org.okapibarcode.backend.Ean;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.backend.TextBox;
import uk.org.okapibarcode.backend.Upc;
import uk.org.okapibarcode.util.Strings;

public class Composite
extends Symbol {
    private static final int[] CCA_COEFFS = new int[]{522, 568, 723, 809, 427, 919, 460, 155, 566, 861, 285, 19, 803, 17, 766, 76, 925, 537, 597, 784, 691, 437, 237, 308, 436, 284, 646, 653, 428, 379};
    private static final int[] COEFRS = new int[]{27, 917, 522, 568, 723, 809, 237, 308, 436, 284, 646, 653, 428, 379, 274, 562, 232, 755, 599, 524, 801, 132, 295, 116, 442, 428, 295, 42, 176, 65, 361, 575, 922, 525, 176, 586, 640, 321, 536, 742, 677, 742, 687, 284, 193, 517, 273, 494, 263, 147, 593, 800, 571, 320, 803, 133, 231, 390, 685, 330, 63, 410, 539, 422, 6, 93, 862, 771, 453, 106, 610, 287, 107, 505, 733, 877, 381, 612, 723, 476, 462, 172, 430, 609, 858, 822, 543, 376, 511, 400, 672, 762, 283, 184, 440, 35, 519, 31, 460, 594, 225, 535, 517, 352, 605, 158, 651, 201, 488, 502, 648, 733, 717, 83, 404, 97, 280, 771, 840, 629, 4, 381, 843, 623, 264, 543, 521, 310, 864, 547, 858, 580, 296, 379, 53, 779, 897, 444, 400, 925, 749, 415, 822, 93, 217, 208, 928, 244, 583, 620, 246, 148, 447, 631, 292, 908, 490, 704, 516, 258, 457, 907, 594, 723, 674, 292, 272, 96, 684, 432, 686, 606, 860, 569, 193, 219, 129, 186, 236, 287, 192, 775, 278, 173, 40, 379, 712, 463, 646, 776, 171, 491, 297, 763, 156, 732, 95, 270, 447, 90, 507, 48, 228, 821, 808, 898, 784, 663, 627, 378, 382, 262, 380, 602, 754, 336, 89, 614, 87, 432, 670, 616, 157, 374, 242, 726, 600, 269, 375, 898, 845, 454, 354, 130, 814, 587, 804, 34, 211, 330, 539, 297, 827, 865, 37, 517, 834, 315, 550, 86, 801, 4, 108, 539, 524, 894, 75, 766, 882, 857, 74, 204, 82, 586, 708, 250, 905, 786, 138, 720, 858, 194, 311, 913, 275, 190, 375, 850, 438, 733, 194, 280, 201, 280, 828, 757, 710, 814, 919, 89, 68, 569, 11, 204, 796, 605, 540, 913, 801, 700, 799, 137, 439, 418, 592, 668, 353, 859, 370, 694, 325, 240, 216, 257, 284, 549, 209, 884, 315, 70, 329, 793, 490, 274, 877, 162, 749, 812, 684, 461, 334, 376, 849, 521, 307, 291, 803, 712, 19, 358, 399, 908, 103, 511, 51, 8, 517, 225, 289, 470, 637, 731, 66, 255, 917, 269, 463, 830, 730, 433, 848, 585, 136, 538, 906, 90, 2, 290, 743, 199, 655, 903, 329, 49, 802, 580, 355, 588, 188, 462, 10, 134, 628, 320, 479, 130, 739, 71, 263, 318, 374, 601, 192, 605, 142, 673, 687, 234, 722, 384, 177, 752, 607, 640, 455, 193, 689, 707, 805, 641, 48, 60, 732, 621, 895, 544, 261, 852, 655, 309, 697, 755, 756, 60, 231, 773, 434, 421, 726, 528, 503, 118, 49, 795, 32, 144, 500, 238, 836, 394, 280, 566, 319, 9, 647, 550, 73, 914, 342, 126, 32, 681, 331, 792, 620, 60, 609, 441, 180, 791, 893, 754, 605, 383, 228, 749, 760, 213, 54, 297, 134, 54, 834, 299, 922, 191, 910, 532, 609, 829, 189, 20, 167, 29, 872, 449, 83, 402, 41, 656, 505, 579, 481, 173, 404, 251, 688, 95, 497, 555, 642, 543, 307, 159, 924, 558, 648, 55, 497, 10, 352, 77, 373, 504, 35, 599, 428, 207, 409, 574, 118, 498, 285, 380, 350, 492, 197, 265, 920, 155, 914, 299, 229, 643, 294, 871, 306, 88, 87, 193, 352, 781, 846, 75, 327, 520, 435, 543, 203, 666, 249, 346, 781, 621, 640, 268, 794, 534, 539, 781, 408, 390, 644, 102, 476, 499, 290, 632, 545, 37, 858, 916, 552, 41, 542, 289, 122, 272, 383, 800, 485, 98, 752, 472, 761, 107, 784, 860, 658, 741, 290, 204, 681, 407, 855, 85, 99, 62, 482, 180, 20, 297, 451, 593, 913, 142, 808, 684, 287, 536, 561, 76, 653, 899, 729, 567, 744, 390, 513, 192, 516, 258, 240, 518, 794, 395, 768, 848, 51, 610, 384, 168, 190, 826, 328, 596, 786, 303, 570, 381, 415, 641, 156, 237, 151, 429, 531, 207, 676, 710, 89, 168, 304, 402, 40, 708, 575, 162, 864, 229, 65, 861, 841, 512, 164, 477, 221, 92, 358, 785, 288, 357, 850, 836, 827, 736, 707, 94, 8, 494, 114, 521, 2, 499, 851, 543, 152, 729, 771, 95, 248, 361, 578, 323, 856, 797, 289, 51, 684, 466, 533, 820, 669, 45, 902, 452, 167, 342, 244, 173, 35, 463, 651, 51, 699, 591, 452, 578, 37, 124, 298, 332, 552, 43, 427, 119, 662, 777, 475, 850, 764, 364, 578, 911, 283, 711, 472, 420, 245, 288, 594, 394, 511, 327, 589, 777, 699, 688, 43, 408, 842, 383, 721, 521, 560, 644, 714, 559, 62, 145, 873, 663, 713, 159, 672, 729, 624, 59, 193, 417, 158, 209, 563, 564, 343, 693, 109, 608, 563, 365, 181, 772, 677, 310, 248, 353, 708, 410, 579, 870, 617, 841, 632, 860, 289, 536, 35, 777, 618, 586, 424, 833, 77, 597, 346, 269, 757, 632, 695, 751, 331, 247, 184, 45, 787, 680, 18, 66, 407, 369, 54, 492, 228, 613, 830, 922, 437, 519, 644, 905, 789, 420, 305, 441, 207, 300, 892, 827, 141, 537, 381, 662, 513, 56, 252, 341, 242, 797, 838, 837, 720, 224, 307, 631, 61, 87, 560, 310, 756, 665, 397, 808, 851, 309, 473, 795, 378, 31, 647, 915, 459, 806, 590, 731, 425, 216, 548, 249, 321, 881, 699, 535, 673, 782, 210, 815, 905, 303, 843, 922, 281, 73, 469, 791, 660, 162, 498, 308, 155, 422, 907, 817, 187, 62, 16, 425, 535, 336, 286, 437, 375, 273, 610, 296, 183, 923, 116, 667, 751, 353, 62, 366, 691, 379, 687, 842, 37, 357, 720, 742, 330, 5, 39, 923, 311, 424, 242, 749, 321, 54, 669, 316, 342, 299, 534, 105, 667, 488, 640, 672, 576, 540, 316, 486, 721, 610, 46, 656, 447, 171, 616, 464, 190, 531, 297, 321, 762, 752, 533, 175, 134, 14, 381, 433, 717, 45, 111, 20, 596, 284, 736, 138, 646, 411, 877, 669, 141, 919, 45, 780, 407, 164, 332, 899, 165, 726, 600, 325, 498, 655, 357, 752, 768, 223, 849, 647, 63, 310, 863, 251, 366, 304, 282, 738, 675, 410, 389, 244, 31, 121, 303, 263};
    private static final int[] CCA_VARIANTS = new int[]{5, 6, 7, 8, 9, 10, 12, 4, 5, 6, 7, 8, 3, 4, 5, 6, 7, 4, 4, 5, 5, 6, 6, 7, 4, 5, 6, 7, 7, 4, 5, 6, 7, 8, 0, 0, 4, 4, 9, 9, 15, 0, 4, 9, 15, 15, 0, 4, 9, 15, 22};
    private static final int[] A_RAP_TABLE = new int[]{39, 1, 32, 8, 14, 43, 20, 11, 1, 5, 15, 21, 40, 43, 46, 34, 29, 0, 0, 0, 0, 0, 0, 0, 43, 33, 37, 47, 1, 20, 23, 26, 14, 9, 19, 33, 12, 40, 46, 23, 52, 23, 13, 17, 27, 33, 52, 3, 6, 46, 41, 6, 0, 3, 3, 3, 0, 3, 3, 0, 3, 6, 6, 0, 0, 0, 0, 3};
    private static final String[] CODAGEMC = new String[]{"urA", "xfs", "ypy", "unk", "xdw", "yoz", "pDA", "uls", "pBk", "eBA", "pAs", "eAk", "prA", "uvs", "xhy", "pnk", "utw", "xgz", "fDA", "pls", "fBk", "frA", "pvs", "uxy", "fnk", "ptw", "uwz", "fls", "psy", "fvs", "pxy", "ftw", "pwz", "fxy", "yrx", "ufk", "xFw", "ymz", "onA", "uds", "xEy", "olk", "ucw", "dBA", "oks", "uci", "dAk", "okg", "dAc", "ovk", "uhw", "xaz", "dnA", "ots", "ugy", "dlk", "osw", "ugj", "dks", "osi", "dvk", "oxw", "uiz", "dts", "owy", "dsw", "owj", "dxw", "oyz", "dwy", "dwj", "ofA", "uFs", "xCy", "odk", "uEw", "xCj", "clA", "ocs", "uEi", "ckk", "ocg", "ckc", "ckE", "cvA", "ohs", "uay", "ctk", "ogw", "uaj", "css", "ogi", "csg", "csa", "cxs", "oiy", "cww", "oij", "cwi", "cyy", "oFk", "uCw", "xBj", "cdA", "oEs", "uCi", "cck", "oEg", "uCb", "ccc", "oEa", "ccE", "oED", "chk", "oaw", "uDj", "cgs", "oai", "cgg", "oab", "cga", "cgD", "obj", "cib", "cFA", "oCs", "uBi", "cEk", "oCg", "uBb", "cEc", "oCa", "cEE", "oCD", "cEC", "cas", "cag", "caa", "cCk", "uAr", "oBa", "oBD", "cCB", "tfk", "wpw", "yez", "mnA", "tds", "woy", "mlk", "tcw", "woj", "FBA", "mks", "FAk", "mvk", "thw", "wqz", "FnA", "mts", "tgy", "Flk", "msw", "Fks", "Fkg", "Fvk", "mxw", "tiz", "Fts", "mwy", "Fsw", "Fsi", "Fxw", "myz", "Fwy", "Fyz", "vfA", "xps", "yuy", "vdk", "xow", "yuj", "qlA", "vcs", "xoi", "qkk", "vcg", "xob", "qkc", "vca", "mfA", "tFs", "wmy", "qvA", "mdk", "tEw", "wmj", "qtk", "vgw", "xqj", "hlA", "Ekk", "mcg", "tEb", "hkk", "qsg", "hkc", "EvA", "mhs", "tay", "hvA", "Etk", "mgw", "taj", "htk", "qww", "vij", "hss", "Esg", "hsg", "Exs", "miy", "hxs", "Eww", "mij", "hww", "qyj", "hwi", "Eyy", "hyy", "Eyj", "hyj", "vFk", "xmw", "ytj", "qdA", "vEs", "xmi", "qck", "vEg", "xmb", "qcc", "vEa", "qcE", "qcC", "mFk", "tCw", "wlj", "qhk", "mEs", "tCi", "gtA", "Eck", "vai", "tCb", "gsk", "Ecc", "mEa", "gsc", "qga", "mED", "EcC", "Ehk", "maw", "tDj", "gxk", "Egs", "mai", "gws", "qii", "mab", "gwg", "Ega", "EgD", "Eiw", "mbj", "gyw", "Eii", "gyi", "Eib", "gyb", "gzj", "qFA", "vCs", "xli", "qEk", "vCg", "xlb", "qEc", "vCa", "qEE", "vCD", "qEC", "qEB", "EFA", "mCs", "tBi", "ghA", "EEk", "mCg", "tBb", "ggk", "qag", "vDb", "ggc", "EEE", "mCD", "ggE", "qaD", "ggC", "Eas", "mDi", "gis", "Eag", "mDb", "gig", "qbb", "gia", "EaD", "giD", "gji", "gjb", "qCk", "vBg", "xkr", "qCc", "vBa", "qCE", "vBD", "qCC", "qCB", "ECk", "mBg", "tAr", "gak", "ECc", "mBa", "gac", "qDa", "mBD", "gaE", "ECC", "gaC", "ECB", "EDg", "gbg", "gba", "gbD", "vAq", "vAn", "qBB", "mAq", "EBE", "gDE", "gDC", "gDB", "lfA", "sps", "wey", "ldk", "sow", "ClA", "lcs", "soi", "Ckk", "lcg", "Ckc", "CkE", "CvA", "lhs", "sqy", "Ctk", "lgw", "sqj", "Css", "lgi", "Csg", "Csa", "Cxs", "liy", "Cww", "lij", "Cwi", "Cyy", "Cyj", "tpk", "wuw", "yhj", "ndA", "tos", "wui", "nck", "tog", "wub", "ncc", "toa", "ncE", "toD", "lFk", "smw", "wdj", "nhk", "lEs", "smi", "atA", "Cck", "tqi", "smb", "ask", "ngg", "lEa", "asc", "CcE", "asE", "Chk", "law", "snj", "axk", "Cgs", "trj", "aws", "nii", "lab", "awg", "Cga", "awa", "Ciw", "lbj", "ayw", "Cii", "ayi", "Cib", "Cjj", "azj", "vpA", "xus", "yxi", "vok", "xug", "yxb", "voc", "xua", "voE", "xuD", "voC", "nFA", "tms", "wti", "rhA", "nEk", "xvi", "wtb", "rgk", "vqg", "xvb", "rgc", "nEE", "tmD", "rgE", "vqD", "nEB", "CFA", "lCs", "sli", "ahA", "CEk", "lCg", "slb", "ixA", "agk", "nag", "tnb", "iwk", "rig", "vrb", "lCD", "iwc", "agE", "naD", "iwE", "CEB", "Cas", "lDi", "ais", "Cag", "lDb", "iys", "aig", "nbb", "iyg", "rjb", "CaD", "aiD", "Cbi", "aji", "Cbb", "izi", "ajb", "vmk", "xtg", "ywr", "vmc", "xta", "vmE", "xtD", "vmC", "vmB", "nCk", "tlg", "wsr", "rak", "nCc", "xtr", "rac", "vna", "tlD", "raE", "nCC", "raC", "nCB", "raB", "CCk", "lBg", "skr", "aak", "CCc", "lBa", "iik", "aac", "nDa", "lBD", "iic", "rba", "CCC", "iiE", "aaC", "CCB", "aaB", "CDg", "lBr", "abg", "CDa", "ijg", "aba", "CDD", "ija", "abD", "CDr", "ijr", "vlc", "xsq", "vlE", "xsn", "vlC", "vlB", "nBc", "tkq", "rDc", "nBE", "tkn", "rDE", "vln", "rDC", "nBB", "rDB", "CBc", "lAq", "aDc", "CBE", "lAn", "ibc", "aDE", "nBn", "ibE", "rDn", "CBB", "ibC", "aDB", "ibB", "aDq", "ibq", "ibn", "xsf", "vkl", "tkf", "nAm", "nAl", "CAo", "aBo", "iDo", "CAl", "aBl", "kpk", "BdA", "kos", "Bck", "kog", "seb", "Bcc", "koa", "BcE", "koD", "Bhk", "kqw", "sfj", "Bgs", "kqi", "Bgg", "kqb", "Bga", "BgD", "Biw", "krj", "Bii", "Bib", "Bjj", "lpA", "sus", "whi", "lok", "sug", "loc", "sua", "loE", "suD", "loC", "BFA", "kms", "sdi", "DhA", "BEk", "svi", "sdb", "Dgk", "lqg", "svb", "Dgc", "BEE", "kmD", "DgE", "lqD", "BEB", "Bas", "kni", "Dis", "Bag", "knb", "Dig", "lrb", "Dia", "BaD", "Bbi", "Dji", "Bbb", "Djb", "tuk", "wxg", "yir", "tuc", "wxa", "tuE", "wxD", "tuC", "tuB", "lmk", "stg", "nqk", "lmc", "sta", "nqc", "tva", "stD", "nqE", "lmC", "nqC", "lmB", "nqB", "BCk", "klg", "Dak", "BCc", "str", "bik", "Dac", "lna", "klD", "bic", "nra", "BCC", "biE", "DaC", "BCB", "DaB", "BDg", "klr", "Dbg", "BDa", "bjg", "Dba", "BDD", "bja", "DbD", "BDr", "Dbr", "bjr", "xxc", "yyq", "xxE", "yyn", "xxC", "xxB", "ttc", "wwq", "vvc", "xxq", "wwn", "vvE", "xxn", "vvC", "ttB", "vvB", "llc", "ssq", "nnc", "llE", "ssn", "rrc", "nnE", "ttn", "rrE", "vvn", "llB", "rrC", "nnB", "rrB", "BBc", "kkq", "DDc", "BBE", "kkn", "bbc", "DDE", "lln", "jjc", "bbE", "nnn", "BBB", "jjE", "rrn", "DDB", "jjC", "BBq", "DDq", "BBn", "bbq", "DDn", "jjq", "bbn", "jjn", "xwo", "yyf", "xwm", "xwl", "tso", "wwf", "vto", "xwv", "vtm", "tsl", "vtl", "lko", "ssf", "nlo", "lkm", "rno", "nlm", "lkl", "rnm", "nll", "rnl", "BAo", "kkf", "DBo", "lkv", "bDo", "DBm", "BAl", "jbo", "bDm", "DBl", "jbm", "bDl", "jbl", "DBv", "jbv", "xwd", "vsu", "vst", "nku", "rlu", "rlt", "DAu", "bBu", "jDu", "jDt", "ApA", "Aok", "keg", "Aoc", "AoE", "AoC", "Aqs", "Aqg", "Aqa", "AqD", "Ari", "Arb", "kuk", "kuc", "sha", "kuE", "shD", "kuC", "kuB", "Amk", "kdg", "Bqk", "kvg", "kda", "Bqc", "kva", "BqE", "kvD", "BqC", "AmB", "BqB", "Ang", "kdr", "Brg", "kvr", "Bra", "AnD", "BrD", "Anr", "Brr", "sxc", "sxE", "sxC", "sxB", "ktc", "lvc", "sxq", "sgn", "lvE", "sxn", "lvC", "ktB", "lvB", "Alc", "Bnc", "AlE", "kcn", "Drc", "BnE", "AlC", "DrE", "BnC", "AlB", "DrC", "BnB", "Alq", "Bnq", "Aln", "Drq", "Bnn", "Drn", "wyo", "wym", "wyl", "swo", "txo", "wyv", "txm", "swl", "txl", "kso", "sgf", "lto", "swv", "nvo", "ltm", "ksl", "nvm", "ltl", "nvl", "Ako", "kcf", "Blo", "ksv", "Dno", "Blm", "Akl", "bro", "Dnm", "Bll", "brm", "Dnl", "Akv", "Blv", "Dnv", "brv", "yze", "yzd", "wye", "xyu", "wyd", "xyt", "swe", "twu", "swd", "vxu", "twt", "vxt", "kse", "lsu", "ksd", "ntu", "lst", "rvu", "ypk", "zew", "xdA", "yos", "zei", "xck", "yog", "zeb", "xcc", "yoa", "xcE", "yoD", "xcC", "xhk", "yqw", "zfj", "utA", "xgs", "yqi", "usk", "xgg", "yqb", "usc", "xga", "usE", "xgD", "usC", "uxk", "xiw", "yrj", "ptA", "uws", "xii", "psk", "uwg", "xib", "psc", "uwa", "psE", "uwD", "psC", "pxk", "uyw", "xjj", "ftA", "pws", "uyi", "fsk", "pwg", "uyb", "fsc", "pwa", "fsE", "pwD", "fxk", "pyw", "uzj", "fws", "pyi", "fwg", "pyb", "fwa", "fyw", "pzj", "fyi", "fyb", "xFA", "yms", "zdi", "xEk", "ymg", "zdb", "xEc", "yma", "xEE", "ymD", "xEC", "xEB", "uhA", "xas", "yni", "ugk", "xag", "ynb", "ugc", "xaa", "ugE", "xaD", "ugC", "ugB", "oxA", "uis", "xbi", "owk", "uig", "xbb", "owc", "uia", "owE", "uiD", "owC", "owB", "dxA", "oys", "uji", "dwk", "oyg", "ujb", "dwc", "oya", "dwE", "oyD", "dwC", "dys", "ozi", "dyg", "ozb", "dya", "dyD", "dzi", "dzb", "xCk", "ylg", "zcr", "xCc", "yla", "xCE", "ylD", "xCC", "xCB", "uak", "xDg", "ylr", "uac", "xDa", "uaE", "xDD", "uaC", "uaB", "oik", "ubg", "xDr", "oic", "uba", "oiE", "ubD", "oiC", "oiB", "cyk", "ojg", "ubr", "cyc", "oja", "cyE", "ojD", "cyC", "cyB", "czg", "ojr", "cza", "czD", "czr", "xBc", "ykq", "xBE", "ykn", "xBC", "xBB", "uDc", "xBq", "uDE", "xBn", "uDC", "uDB", "obc", "uDq", "obE", "uDn", "obC", "obB", "cjc", "obq", "cjE", "obn", "cjC", "cjB", "cjq", "cjn", "xAo", "ykf", "xAm", "xAl", "uBo", "xAv", "uBm", "uBl", "oDo", "uBv", "oDm", "oDl", "cbo", "oDv", "cbm", "cbl", "xAe", "xAd", "uAu", "uAt", "oBu", "oBt", "wpA", "yes", "zFi", "wok", "yeg", "zFb", "woc", "yea", "woE", "yeD", "woC", "woB", "thA", "wqs", "yfi", "tgk", "wqg", "yfb", "tgc", "wqa", "tgE", "wqD", "tgC", "tgB", "mxA", "tis", "wri", "mwk", "tig", "wrb", "mwc", "tia", "mwE", "tiD", "mwC", "mwB", "FxA", "mys", "tji", "Fwk", "myg", "tjb", "Fwc", "mya", "FwE", "myD", "FwC", "Fys", "mzi", "Fyg", "mzb", "Fya", "FyD", "Fzi", "Fzb", "yuk", "zhg", "hjs", "yuc", "zha", "hbw", "yuE", "zhD", "hDy", "yuC", "yuB", "wmk", "ydg", "zEr", "xqk", "wmc", "zhr", "xqc", "yva", "ydD", "xqE", "wmC", "xqC", "wmB", "xqB", "tak", "wng", "ydr", "vik", "tac", "wna", "vic", "xra", "wnD", "viE", "taC", "viC", "taB", "viB", "mik", "tbg", "wnr", "qyk", "mic", "tba", "qyc", "vja", "tbD", "qyE", "miC", "qyC", "miB", "qyB", "Eyk", "mjg", "tbr", "hyk", "Eyc", "mja", "hyc", "qza", "mjD", "hyE", "EyC", "hyC", "EyB", "Ezg", "mjr", "hzg", "Eza", "hza", "EzD", "hzD", "Ezr", "ytc", "zgq", "grw", "ytE", "zgn", "gny", "ytC", "glz", "ytB", "wlc", "ycq", "xnc", "wlE", "ycn", "xnE", "ytn", "xnC", "wlB", "xnB", "tDc", "wlq", "vbc", "tDE", "wln", "vbE", "xnn", "vbC", "tDB", "vbB", "mbc", "tDq", "qjc", "mbE", "tDn", "qjE", "vbn", "qjC", "mbB", "qjB", "Ejc", "mbq", "gzc", "EjE", "mbn", "gzE", "qjn", "gzC", "EjB", "gzB", "Ejq", "gzq", "Ejn", "gzn", "yso", "zgf", "gfy", "ysm", "gdz", "ysl", "wko", "ycf", "xlo", "ysv", "xlm", "wkl", "xll", "tBo", "wkv", "vDo", "tBm", "vDm", "tBl", "vDl", "mDo", "tBv", "qbo", "vDv", "qbm", "mDl", "qbl", "Ebo", "mDv", "gjo", "Ebm", "gjm", "Ebl", "gjl", "Ebv", "gjv", "yse", "gFz", "ysd", "wke", "xku", "wkd", "xkt", "tAu", "vBu", "tAt", "vBt", "mBu", "qDu", "mBt", "qDt", "EDu", "gbu", "EDt", "gbt", "ysF", "wkF", "xkh", "tAh", "vAx", "mAx", "qBx", "wek", "yFg", "zCr", "wec", "yFa", "weE", "yFD", "weC", "weB", "sqk", "wfg", "yFr", "sqc", "wfa", "sqE", "wfD", "sqC", "sqB", "lik", "srg", "wfr", "lic", "sra", "liE", "srD", "liC", "liB", "Cyk", "ljg", "srr", "Cyc", "lja", "CyE", "ljD", "CyC", "CyB", "Czg", "ljr", "Cza", "CzD", "Czr", "yhc", "zaq", "arw", "yhE", "zan", "any", "yhC", "alz", "yhB", "wdc", "yEq", "wvc", "wdE", "yEn", "wvE", "yhn", "wvC", "wdB", "wvB", "snc", "wdq", "trc", "snE", "wdn", "trE", "wvn", "trC", "snB", "trB", "lbc", "snq", "njc", "lbE", "snn", "njE", "trn", "njC", "lbB", "njB", "Cjc", "lbq", "azc", "CjE", "lbn", "azE", "njn", "azC", "CjB", "azB", "Cjq", "azq", "Cjn", "azn", "zio", "irs", "rfy", "zim", "inw", "rdz", "zil", "ily", "ikz", "ygo", "zaf", "afy", "yxo", "ziv", "ivy", "adz", "yxm", "ygl", "itz", "yxl", "wco", "yEf", "wto", "wcm", "xvo", "yxv", "wcl", "xvm", "wtl", "xvl", "slo", "wcv", "tno", "slm", "vro", "tnm", "sll", "vrm", "tnl", "vrl", "lDo", "slv", "nbo", "lDm", "rjo", "nbm", "lDl", "rjm", "nbl", "rjl", "Cbo", "lDv", "ajo", "Cbm", "izo", "ajm", "Cbl", "izm", "ajl", "izl", "Cbv", "ajv", "zie", "ifw", "rFz", "zid", "idy", "icz", "yge", "aFz", "ywu", "ygd", "ihz", "ywt", "wce", "wsu", "wcd", "xtu", "wst", "xtt", "sku", "tlu", "skt", "vnu", "tlt", "vnt", "lBu", "nDu", "lBt", "rbu", "nDt", "rbt", "CDu", "abu", "CDt", "iju", "abt", "ijt", "ziF", "iFy", "iEz", "ygF", "ywh", "wcF", "wsh", "xsx", "skh", "tkx", "vlx", "lAx", "nBx", "rDx", "CBx", "aDx", "ibx", "iCz", "wFc", "yCq", "wFE", "yCn", "wFC", "wFB", "sfc", "wFq", "sfE", "wFn", "sfC", "sfB", "krc", "sfq", "krE", "sfn", "krC", "krB", "Bjc", "krq", "BjE", "krn", "BjC", "BjB", "Bjq", "Bjn", "yao", "zDf", "Dfy", "yam", "Ddz", "yal", "wEo", "yCf", "who", "wEm", "whm", "wEl", "whl", "sdo", "wEv", "svo", "sdm", "svm", "sdl", "svl", "kno", "sdv", "lro", "knm", "lrm", "knl", "lrl", "Bbo", "knv", "Djo", "Bbm", "Djm", "Bbl", "Djl", "Bbv", "Djv", "zbe", "bfw", "npz", "zbd", "bdy", "bcz", "yae", "DFz", "yiu", "yad", "bhz", "yit", "wEe", "wgu", "wEd", "wxu", "wgt", "wxt", "scu", "stu", "sct", "tvu", "stt", "tvt", "klu", "lnu", "klt", "nru", "lnt", "nrt", "BDu", "Dbu", "BDt", "bju", "Dbt", "bjt", "jfs", "rpy", "jdw", "roz", "jcy", "jcj", "zbF", "bFy", "zjh", "jhy", "bEz", "jgz", "yaF", "yih", "yyx", "wEF", "wgh", "wwx", "xxx", "sch", "ssx", "ttx", "vvx", "kkx", "llx", "nnx", "rrx", "BBx", "DDx", "bbx", "jFw", "rmz", "jEy", "jEj", "bCz", "jaz", "jCy", "jCj", "jBj", "wCo", "wCm", "wCl", "sFo", "wCv", "sFm", "sFl", "kfo", "sFv", "kfm", "kfl", "Aro", "kfv", "Arm", "Arl", "Arv", "yDe", "Bpz", "yDd", "wCe", "wau", "wCd", "wat", "sEu", "shu", "sEt", "sht", "kdu", "kvu", "kdt", "kvt", "Anu", "Bru", "Ant", "Brt", "zDp", "Dpy", "Doz", "yDF", "ybh", "wCF", "wah", "wix", "sEh", "sgx", "sxx", "kcx", "ktx", "lvx", "Alx", "Bnx", "Drx", "bpw", "nuz", "boy", "boj", "Dmz", "bqz", "jps", "ruy", "jow", "ruj", "joi", "job", "bmy", "jqy", "bmj", "jqj", "jmw", "rtj", "jmi", "jmb", "blj", "jnj", "jli", "jlb", "jkr", "sCu", "sCt", "kFu", "kFt", "Afu", "Aft", "wDh", "sCh", "sax", "kEx", "khx", "Adx", "Avx", "Buz", "Duy", "Duj", "buw", "nxj", "bui", "bub", "Dtj", "bvj", "jus", "rxi", "jug", "rxb", "jua", "juD", "bti", "jvi", "btb", "jvb", "jtg", "rwr", "jta", "jtD", "bsr", "jtr", "jsq", "jsn", "Bxj", "Dxi", "Dxb", "bxg", "nyr", "bxa", "bxD", "Dwr", "bxr", "bwq", "bwn", "pjk", "urw", "ejA", "pbs", "uny", "ebk", "pDw", "ulz", "eDs", "pBy", "eBw", "zfc", "fjk", "prw", "zfE", "fbs", "pny", "zfC", "fDw", "plz", "zfB", "fBy", "yrc", "zfq", "frw", "yrE", "zfn", "fny", "yrC", "flz", "yrB", "xjc", "yrq", "xjE", "yrn", "xjC", "xjB", "uzc", "xjq", "uzE", "xjn", "uzC", "uzB", "pzc", "uzq", "pzE", "uzn", "pzC", "djA", "ors", "ufy", "dbk", "onw", "udz", "dDs", "oly", "dBw", "okz", "dAy", "zdo", "drs", "ovy", "zdm", "dnw", "otz", "zdl", "dly", "dkz", "yno", "zdv", "dvy", "ynm", "dtz", "ynl", "xbo", "ynv", "xbm", "xbl", "ujo", "xbv", "ujm", "ujl", "ozo", "ujv", "ozm", "ozl", "crk", "ofw", "uFz", "cns", "ody", "clw", "ocz", "cky", "ckj", "zcu", "cvw", "ohz", "zct", "cty", "csz", "ylu", "cxz", "ylt", "xDu", "xDt", "ubu", "ubt", "oju", "ojt", "cfs", "oFy", "cdw", "oEz", "ccy", "ccj", "zch", "chy", "cgz", "ykx", "xBx", "uDx", "cFw", "oCz", "cEy", "cEj", "caz", "cCy", "cCj", "FjA", "mrs", "tfy", "Fbk", "mnw", "tdz", "FDs", "mly", "FBw", "mkz", "FAy", "zFo", "Frs", "mvy", "zFm", "Fnw", "mtz", "zFl", "Fly", "Fkz", "yfo", "zFv", "Fvy", "yfm", "Ftz", "yfl", "wro", "yfv", "wrm", "wrl", "tjo", "wrv", "tjm", "tjl", "mzo", "tjv", "mzm", "mzl", "qrk", "vfw", "xpz", "hbA", "qns", "vdy", "hDk", "qlw", "vcz", "hBs", "qky", "hAw", "qkj", "hAi", "Erk", "mfw", "tFz", "hrk", "Ens", "mdy", "hns", "qty", "mcz", "hlw", "Eky", "hky", "Ekj", "hkj", "zEu", "Evw", "mhz", "zhu", "zEt", "hvw", "Ety", "zht", "hty", "Esz", "hsz", "ydu", "Exz", "yvu", "ydt", "hxz", "yvt", "wnu", "xru", "wnt", "xrt", "tbu", "vju", "tbt", "vjt", "mju", "mjt", "grA", "qfs", "vFy", "gnk", "qdw", "vEz", "gls", "qcy", "gkw", "qcj", "gki", "gkb", "Efs", "mFy", "gvs", "Edw", "mEz", "gtw", "qgz", "gsy", "Ecj", "gsj", "zEh", "Ehy", "zgx", "gxy", "Egz", "gwz", "ycx", "ytx", "wlx", "xnx", "tDx", "vbx", "mbx", "gfk", "qFw", "vCz", "gds", "qEy", "gcw", "qEj", "gci", "gcb", "EFw", "mCz", "ghw", "EEy", "ggy", "EEj", "ggj", "Eaz", "giz", "gFs", "qCy", "gEw", "qCj", "gEi", "gEb", "ECy", "gay", "ECj", "gaj", "gCw", "qBj", "gCi", "gCb", "EBj", "gDj", "gBi", "gBb", "Crk", "lfw", "spz", "Cns", "ldy", "Clw", "lcz", "Cky", "Ckj", "zCu", "Cvw", "lhz", "zCt", "Cty", "Csz", "yFu", "Cxz", "yFt", "wfu", "wft", "sru", "srt", "lju", "ljt", "arA", "nfs", "tpy", "ank", "ndw", "toz", "als", "ncy", "akw", "ncj", "aki", "akb", "Cfs", "lFy", "avs", "Cdw", "lEz", "atw", "ngz", "asy", "Ccj", "asj", "zCh", "Chy", "zax", "axy", "Cgz", "awz", "yEx", "yhx", "wdx", "wvx", "snx", "trx", "lbx", "rfk", "vpw", "xuz", "inA", "rds", "voy", "ilk", "rcw", "voj", "iks", "rci", "ikg", "rcb", "ika", "afk", "nFw", "tmz", "ivk", "ads", "nEy", "its", "rgy", "nEj", "isw", "aci", "isi", "acb", "isb", "CFw", "lCz", "ahw", "CEy", "ixw", "agy", "CEj", "iwy", "agj", "iwj", "Caz", "aiz", "iyz", "ifA", "rFs", "vmy", "idk", "rEw", "vmj", "ics", "rEi", "icg", "rEb", "ica", "icD", "aFs", "nCy", "ihs", "aEw", "nCj", "igw", "raj", "igi", "aEb", "igb", "CCy", "aay", "CCj", "iiy", "aaj", "iij", "iFk", "rCw", "vlj", "iEs", "rCi", "iEg", "rCb", "iEa", "iED", "aCw", "nBj", "iaw", "aCi", "iai", "aCb", "iab", "CBj", "aDj", "ibj", "iCs", "rBi", "iCg", "rBb", "iCa", "iCD", "aBi", "iDi", "aBb", "iDb", "iBg", "rAr", "iBa", "iBD", "aAr", "iBr", "iAq", "iAn", "Bfs", "kpy", "Bdw", "koz", "Bcy", "Bcj", "Bhy", "Bgz", "yCx", "wFx", "sfx", "krx", "Dfk", "lpw", "suz", "Dds", "loy", "Dcw", "loj", "Dci", "Dcb", "BFw", "kmz", "Dhw", "BEy", "Dgy", "BEj", "Dgj", "Baz", "Diz", "bfA", "nps", "tuy", "bdk", "now", "tuj", "bcs", "noi", "bcg", "nob", "bca", "bcD", "DFs", "lmy", "bhs", "DEw", "lmj", "bgw", "DEi", "bgi", "DEb", "bgb", "BCy", "Day", "BCj", "biy", "Daj", "bij", "rpk", "vuw", "xxj", "jdA", "ros", "vui", "jck", "rog", "vub", "jcc", "roa", "jcE", "roD", "jcC", "bFk", "nmw", "ttj", "jhk", "bEs", "nmi", "jgs", "rqi", "nmb", "jgg", "bEa", "jga", "bED", "jgD", "DCw", "llj", "baw", "DCi", "jiw", "bai", "DCb", "jii", "bab", "jib", "BBj", "DDj", "bbj", "jjj", "jFA", "rms", "vti", "jEk", "rmg", "vtb", "jEc", "rma", "jEE", "rmD", "jEC", "jEB", "bCs", "nli", "jas", "bCg", "nlb", "jag", "rnb", "jaa", "bCD", "jaD", "DBi", "bDi", "DBb", "jbi", "bDb", "jbb", "jCk", "rlg", "vsr", "jCc", "rla", "jCE", "rlD", "jCC", "jCB", "bBg", "nkr", "jDg", "bBa", "jDa", "bBD", "jDD", "DAr", "bBr", "jDr", "jBc", "rkq", "jBE", "rkn", "jBC", "jBB", "bAq", "jBq", "bAn", "jBn", "jAo", "rkf", "jAm", "jAl", "bAf", "jAv", "Apw", "kez", "Aoy", "Aoj", "Aqz", "Bps", "kuy", "Bow", "kuj", "Boi", "Bob", "Amy", "Bqy", "Amj", "Bqj", "Dpk", "luw", "sxj", "Dos", "lui", "Dog", "lub", "Doa", "DoD", "Bmw", "ktj", "Dqw", "Bmi", "Dqi", "Bmb", "Dqb", "Alj", "Bnj", "Drj", "bpA", "nus", "txi", "bok", "nug", "txb", "boc", "nua", "boE", "nuD", "boC", "boB", "Dms", "lti", "bqs", "Dmg", "ltb", "bqg", "nvb", "bqa", "DmD", "bqD", "Bli", "Dni", "Blb", "bri", "Dnb", "brb", "ruk", "vxg", "xyr", "ruc", "vxa", "ruE", "vxD", "ruC", "ruB", "bmk", "ntg", "twr", "jqk", "bmc", "nta", "jqc", "rva", "ntD", "jqE", "bmC", "jqC", "bmB", "jqB", "Dlg", "lsr", "bng", "Dla", "jrg", "bna", "DlD", "jra", "bnD", "jrD", "Bkr", "Dlr", "bnr", "jrr", "rtc", "vwq", "rtE", "vwn", "rtC", "rtB", "blc", "nsq", "jnc", "blE", "nsn", "jnE", "rtn", "jnC", "blB", "jnB", "Dkq", "blq", "Dkn", "jnq", "bln", "jnn", "rso", "vwf", "rsm", "rsl", "bko", "nsf", "jlo", "bkm", "jlm", "bkl", "jll", "Dkf", "bkv", "jlv", "rse", "rsd", "bke", "jku", "bkd", "jkt", "Aey", "Aej", "Auw", "khj", "Aui", "Aub", "Adj", "Avj", "Bus", "kxi", "Bug", "kxb", "Bua", "BuD", "Ati", "Bvi", "Atb", "Bvb", "Duk", "lxg", "syr", "Duc", "lxa", "DuE", "lxD", "DuC", "DuB", "Btg", "kwr", "Dvg", "lxr", "Dva", "BtD", "DvD", "Asr", "Btr", "Dvr", "nxc", "tyq", "nxE", "tyn", "nxC", "nxB", "Dtc", "lwq", "bvc", "nxq", "lwn", "bvE", "DtC", "bvC", "DtB", "bvB", "Bsq", "Dtq", "Bsn", "bvq", "Dtn", "bvn", "vyo", "xzf", "vym", "vyl", "nwo", "tyf", "rxo", "nwm", "rxm", "nwl", "rxl", "Dso", "lwf", "bto", "Dsm", "jvo", "btm", "Dsl", "jvm", "btl", "jvl", "Bsf", "Dsv", "btv", "jvv", "vye", "vyd", "nwe", "rwu", "nwd", "rwt", "Dse", "bsu", "Dsd", "jtu", "bst", "jtt", "vyF", "nwF", "rwh", "DsF", "bsh", "jsx", "Ahi", "Ahb", "Axg", "kir", "Axa", "AxD", "Agr", "Axr", "Bxc", "kyq", "BxE", "kyn", "BxC", "BxB", "Awq", "Bxq", "Awn", "Bxn", "lyo", "szf", "lym", "lyl", "Bwo", "kyf", "Dxo", "lyv", "Dxm", "Bwl", "Dxl", "Awf", "Bwv", "Dxv", "tze", "tzd", "lye", "nyu", "lyd", "nyt", "Bwe", "Dwu", "Bwd", "bxu", "Dwt", "bxt", "tzF", "lyF", "nyh", "BwF", "Dwh", "bwx", "Aiq", "Ain", "Ayo", "kjf", "Aym", "Ayl", "Aif", "Ayv", "kze", "kzd", "Aye", "Byu", "Ayd", "Byt", "szp"};
    private static final char[] BR_SET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '*', '+', '-'};
    private static final String[] PDF_TTF = new String[]{"00000", "00001", "00010", "00011", "00100", "00101", "00110", "00111", "01000", "01001", "01010", "01011", "01100", "01101", "01110", "01111", "10000", "10001", "10010", "10011", "10100", "10101", "10110", "10111", "11000", "11001", "11010", "11011", "11100", "11101", "11110", "11111", "01", "1111111101010100", "11111101000101001"};
    private static final String[] RAPLR = new String[]{"", "221311", "311311", "312211", "222211", "213211", "214111", "223111", "313111", "322111", "412111", "421111", "331111", "241111", "232111", "231211", "321211", "411211", "411121", "411112", "321112", "312112", "311212", "311221", "311131", "311122", "311113", "221113", "221122", "221131", "221221", "222121", "312121", "321121", "231121", "231112", "222112", "213112", "212212", "212221", "212131", "212122", "212113", "211213", "211123", "211132", "211141", "211231", "211222", "211312", "211321", "211411", "212311"};
    private static final String[] RAPC = new String[]{"", "112231", "121231", "122131", "131131", "131221", "132121", "141121", "141211", "142111", "133111", "132211", "131311", "122311", "123211", "124111", "115111", "114211", "114121", "123121", "123112", "122212", "122221", "121321", "121411", "112411", "113311", "113221", "113212", "113122", "122122", "131122", "131113", "122113", "113113", "112213", "112222", "112312", "112321", "111421", "111331", "111322", "111232", "111223", "111133", "111124", "111214", "112114", "121114", "121123", "121132", "112132", "112141"};
    private static final int[] MICRO_VARIANTS = new int[]{1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 11, 14, 17, 20, 24, 28, 8, 11, 14, 17, 20, 23, 26, 6, 8, 10, 12, 15, 20, 26, 32, 38, 44, 4, 6, 8, 10, 12, 15, 20, 26, 32, 38, 44, 7, 7, 7, 8, 8, 8, 8, 9, 9, 10, 11, 13, 15, 12, 14, 16, 18, 21, 26, 32, 38, 44, 50, 8, 12, 14, 16, 18, 21, 26, 32, 38, 44, 50, 0, 0, 0, 7, 7, 7, 7, 15, 15, 24, 34, 57, 84, 45, 70, 99, 115, 133, 154, 180, 212, 250, 294, 7, 45, 70, 99, 115, 133, 154, 180, 212, 250, 294};
    private static final int[] MICROCOEFFS = new int[]{76, 925, 537, 597, 784, 691, 437, 237, 308, 436, 284, 646, 653, 428, 379, 567, 527, 622, 257, 289, 362, 501, 441, 205, 377, 457, 64, 244, 826, 841, 818, 691, 266, 612, 462, 45, 565, 708, 825, 213, 15, 68, 327, 602, 904, 597, 864, 757, 201, 646, 684, 347, 127, 388, 7, 69, 851, 764, 713, 342, 384, 606, 583, 322, 592, 678, 204, 184, 394, 692, 669, 677, 154, 187, 241, 286, 274, 354, 478, 915, 691, 833, 105, 215, 460, 829, 476, 109, 904, 664, 230, 5, 80, 74, 550, 575, 147, 868, 642, 274, 562, 232, 755, 599, 524, 801, 132, 295, 116, 442, 428, 295, 42, 176, 65, 279, 577, 315, 624, 37, 855, 275, 739, 120, 297, 312, 202, 560, 321, 233, 756, 760, 573, 108, 519, 781, 534, 129, 425, 681, 553, 422, 716, 763, 693, 624, 610, 310, 691, 347, 165, 193, 259, 568, 443, 284, 887, 544, 788, 93, 477, 760, 331, 608, 269, 121, 159, 830, 446, 893, 699, 245, 441, 454, 325, 858, 131, 847, 764, 169, 361, 575, 922, 525, 176, 586, 640, 321, 536, 742, 677, 742, 687, 284, 193, 517, 273, 494, 263, 147, 593, 800, 571, 320, 803, 133, 231, 390, 685, 330, 63, 410, 234, 228, 438, 848, 133, 703, 529, 721, 788, 322, 280, 159, 738, 586, 388, 684, 445, 680, 245, 595, 614, 233, 812, 32, 284, 658, 745, 229, 95, 689, 920, 771, 554, 289, 231, 125, 117, 518, 476, 36, 659, 848, 678, 64, 764, 840, 157, 915, 470, 876, 109, 25, 632, 405, 417, 436, 714, 60, 376, 97, 413, 706, 446, 21, 3, 773, 569, 267, 272, 213, 31, 560, 231, 758, 103, 271, 572, 436, 339, 730, 82, 285, 923, 797, 576, 875, 156, 706, 63, 81, 257, 874, 411, 416, 778, 50, 205, 303, 188, 535, 909, 155, 637, 230, 534, 96, 575, 102, 264, 233, 919, 593, 865, 26, 579, 623, 766, 146, 10, 739, 246, 127, 71, 244, 211, 477, 920, 876, 427, 820, 718, 435};
    private static final int[] RAP_TABLE = new int[]{1, 8, 36, 19, 9, 25, 1, 1, 8, 36, 19, 9, 27, 1, 7, 15, 25, 37, 1, 1, 21, 15, 1, 47, 1, 7, 15, 25, 37, 1, 1, 21, 15, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 7, 15, 25, 37, 17, 9, 29, 31, 25, 19, 1, 7, 15, 25, 37, 17, 9, 29, 31, 25, 9, 8, 36, 19, 17, 33, 1, 9, 8, 36, 19, 17, 35, 1, 7, 15, 25, 37, 33, 17, 37, 47, 49, 43, 1, 7, 15, 25, 37, 33, 17, 37, 47, 49, 0, 3, 6, 0, 6, 0, 0, 0, 3, 6, 0, 6, 6, 0, 0, 6, 0, 0, 0, 0, 6, 6, 0, 3, 0, 0, 6, 0, 0, 0, 0, 6, 6, 0};
    private StringBuilder binary_string;
    private int ecc;
    private LinearEncoding symbology = LinearEncoding.CODE_128;
    private int[] general_field;
    private GeneralFieldMode[] general_field_type;
    private int cc_width;
    private int[][] pwr928 = new int[69][7];
    private int[] codeWords = new int[180];
    private int codeWordCount;
    private int[] bitStr = new int[13];
    private int[] inputData;
    private CompositeMode cc_mode;
    private Symbol.DataType linearDataType;
    private String linearContent;
    private CompositeMode userPreferredMode = CompositeMode.CC_A;
    private int target_bitsize;
    private int remainder;
    private int linearWidth;
    private Integer guardPatternExtraHeight;
    private int separatorHeight = 1;
    private Integer preferredColumns;

    public Composite() {
        this.inputDataType = Symbol.DataType.GS1;
    }

    @Override
    protected boolean gs1Supported() {
        return true;
    }

    public void setSymbology(LinearEncoding linearSymbology) {
        this.symbology = linearSymbology;
    }

    public LinearEncoding getSymbology() {
        return this.symbology;
    }

    public void setLinearDataType(Symbol.DataType linearDataType) {
        this.linearDataType = linearDataType;
    }

    public Symbol.DataType getLinearDataType() {
        return this.linearDataType;
    }

    public void setLinearContent(String linearContent) {
        this.linearContent = linearContent;
    }

    public String getLinearContent() {
        return this.linearContent;
    }

    public void setPreferredMode(CompositeMode userMode) {
        this.userPreferredMode = userMode;
    }

    public CompositeMode getPreferredMode() {
        return this.userPreferredMode;
    }

    public CompositeMode getModeUsed() {
        return this.cc_mode;
    }

    public void setGuardPatternExtraHeight(int guardPatternExtraHeight) {
        this.guardPatternExtraHeight = guardPatternExtraHeight;
    }

    public void setSeparatorHeight(int separatorHeight) {
        if (separatorHeight < 1) {
            throw new IllegalArgumentException("Invalid Composite separator height: " + separatorHeight);
        }
        this.separatorHeight = separatorHeight;
    }

    public void setPreferredColumns(int columns) {
        if (columns < 1 || columns > 10) {
            throw new IllegalArgumentException("Invalid column count: " + columns);
        }
        this.preferredColumns = columns;
    }

    @Override
    protected void encode() {
        Symbol linear;
        ArrayList<Rectangle2D.Double> combine_rect = new ArrayList<Rectangle2D.Double>();
        ArrayList<TextBox> combine_txt = new ArrayList<TextBox>();
        int top_shift = 0;
        int bottom_shift = 0;
        this.linearWidth = 0;
        if (this.linearContent.isEmpty()) {
            throw new OkapiException("No linear data set");
        }
        this.encodeComposite();
        switch (this.symbology) {
            case UPCA: {
                Upc upca = new Upc();
                upca.setMode(Upc.Mode.UPCA);
                upca.setLinkageFlag(true);
                if (this.guardPatternExtraHeight != null) {
                    upca.setGuardPatternExtraHeight(this.guardPatternExtraHeight);
                }
                linear = upca;
                bottom_shift = 6;
                top_shift = 3;
                break;
            }
            case UPCE: {
                Upc upce = new Upc();
                upce.setMode(Upc.Mode.UPCE);
                upce.setLinkageFlag(true);
                if (this.guardPatternExtraHeight != null) {
                    upce.setGuardPatternExtraHeight(this.guardPatternExtraHeight);
                }
                linear = upce;
                bottom_shift = 6;
                top_shift = 3;
                break;
            }
            case EAN: {
                Ean ean = new Ean();
                if (this.eanCalculateVersion() == 8) {
                    ean.setMode(Ean.Mode.EAN8);
                    bottom_shift = this.cc_mode == CompositeMode.CC_A ? 4 : 14;
                } else {
                    ean.setMode(Ean.Mode.EAN13);
                    bottom_shift = 6;
                    top_shift = 3;
                }
                ean.setLinkageFlag(true);
                if (this.guardPatternExtraHeight != null) {
                    ean.setGuardPatternExtraHeight(this.guardPatternExtraHeight);
                }
                linear = ean;
                break;
            }
            case CODE_128: {
                Code128 code128 = new Code128();
                switch (this.cc_mode) {
                    case CC_A: {
                        code128.setCca();
                        break;
                    }
                    case CC_B: {
                        code128.setCcb();
                        break;
                    }
                    case CC_C: {
                        code128.setCcc();
                        bottom_shift = 7;
                    }
                }
                code128.setDataType(Symbol.DataType.GS1);
                linear = code128;
                break;
            }
            case DATABAR_14: {
                DataBar14 dataBar14 = new DataBar14();
                dataBar14.setLinkageFlag(true);
                dataBar14.setMode(DataBar14.Mode.LINEAR);
                linear = dataBar14;
                bottom_shift = 4;
                break;
            }
            case DATABAR_14_STACK_OMNI: {
                DataBar14 dataBar14SO = new DataBar14();
                dataBar14SO.setLinkageFlag(true);
                dataBar14SO.setMode(DataBar14.Mode.OMNI);
                dataBar14SO.setSeparatorHeight(this.separatorHeight);
                linear = dataBar14SO;
                top_shift = 1;
                break;
            }
            case DATABAR_14_STACK: {
                DataBar14 dataBar14S = new DataBar14();
                dataBar14S.setLinkageFlag(true);
                dataBar14S.setMode(DataBar14.Mode.STACKED);
                dataBar14S.setSeparatorHeight(this.separatorHeight);
                linear = dataBar14S;
                top_shift = 1;
                break;
            }
            case DATABAR_LIMITED: {
                DataBarLimited dataBarLimited = new DataBarLimited();
                dataBarLimited.setLinkageFlag();
                linear = dataBarLimited;
                top_shift = 1;
                bottom_shift = this.cc_mode == CompositeMode.CC_A ? 0 : 10;
                break;
            }
            case DATABAR_EXPANDED: {
                DataBarExpanded dataBarExpanded = new DataBarExpanded();
                dataBarExpanded.setLinkageFlag(true);
                dataBarExpanded.setStacked(false);
                linear = dataBarExpanded;
                top_shift = 2;
                break;
            }
            case DATABAR_EXPANDED_STACK: {
                DataBarExpanded dataBarExpandedS = new DataBarExpanded();
                dataBarExpandedS.setLinkageFlag(true);
                dataBarExpandedS.setStacked(true);
                if (this.preferredColumns != null) {
                    dataBarExpandedS.setPreferredColumns(this.preferredColumns);
                }
                linear = dataBarExpandedS;
                top_shift = 2;
                break;
            }
            default: {
                throw new OkapiException("Linear symbol not recognised");
            }
        }
        if (this.linearDataType != null) {
            linear.setDataType(this.linearDataType);
        }
        this.copyPropertiesTo(linear);
        linear.setContent(this.linearContent);
        if (this.symbology == LinearEncoding.CODE_128) {
            this.linearWidth = linear.symbol_width;
            if (this.cc_mode == CompositeMode.CC_C) {
                this.row_count = 0;
                this.rectangles.clear();
                this.symbol_height = 0;
                this.symbol_width = 0;
                this.encodeInfo.setLength(0);
                this.encodeComposite();
            } else if (this.linearWidth > this.symbol_width) {
                top_shift = (this.linearWidth - this.symbol_width) / 2;
            }
        }
        for (Iterator<TextBox> orig : this.rectangles) {
            combine_rect.add(new Rectangle2D.Double(((Rectangle2D.Double)((Object)orig)).x + (double)top_shift, ((Rectangle2D.Double)((Object)orig)).y, ((Rectangle2D.Double)((Object)orig)).width, ((Rectangle2D.Double)((Object)orig)).height));
        }
        int extraSepHeight = this.separatorHeight - 1;
        if (extraSepHeight > 0 && (this.symbology == LinearEncoding.EAN || this.symbology == LinearEncoding.UPCA || this.symbology == LinearEncoding.UPCE)) {
            throw new OkapiException("Composite EAN and UPC separator height cannot be changed");
        }
        for (Rectangle2D.Double double_ : linear.rectangles) {
            double h = double_.height + (double)(extraSepHeight > 0 && double_.height == 1.0 ? extraSepHeight : 0);
            double y = double_.y + (double)(extraSepHeight > 0 && double_.height != 1.0 ? extraSepHeight : 0);
            combine_rect.add(new Rectangle2D.Double(double_.x + (double)bottom_shift, y + (double)this.symbol_height, double_.width, h));
        }
        for (TextBox textBox : linear.texts) {
            combine_txt.add(new TextBox(textBox.x + (double)bottom_shift, textBox.y + (double)this.symbol_height + (double)extraSepHeight, textBox.width, textBox.text, this.humanReadableAlignment));
        }
        int max_x = 0;
        for (Rectangle2D.Double rect : combine_rect) {
            if (!(rect.x + rect.width > (double)max_x)) continue;
            max_x = (int)Math.ceil(rect.x + rect.width);
        }
        this.rectangles = combine_rect;
        this.texts = combine_txt;
        this.symbol_height += linear.symbol_height + extraSepHeight;
        this.symbol_width = max_x;
        this.info(linear.getEncodeInfo());
    }

    private void copyPropertiesTo(Symbol linear) {
        linear.setBarHeight(this.getBarHeight());
        linear.setHumanReadableLocation(this.getHumanReadableLocation());
        linear.setHumanReadableAlignment(this.getHumanReadableAlignment());
        linear.setModuleWidth(this.getModuleWidth());
        linear.setQuietZoneHorizontal(this.getQuietZoneHorizontal());
        linear.setQuietZoneVertical(this.getQuietZoneVertical());
        if (this.getFont() != null) {
            linear.setFont(this.getFont());
        } else {
            linear.setFontName(this.getFontName());
            linear.setFontSize(this.getFontSize());
        }
    }

    private void encodeComposite() {
        if (this.content.length() > 2990) {
            throw new OkapiException("2D component input data too long");
        }
        this.inputData = Composite.toBytes(this.content, StandardCharsets.US_ASCII, new int[0]);
        if (this.inputData == null) {
            throw new OkapiException("Invalid characters in input data");
        }
        this.cc_mode = this.userPreferredMode;
        if (this.cc_mode == CompositeMode.CC_C && this.symbology != LinearEncoding.CODE_128) {
            throw new OkapiException("Invalid mode (CC-C only valid with GS1-128 linear component)");
        }
        switch (this.symbology) {
            case EAN: {
                if (this.eanCalculateVersion() == 8) {
                    this.cc_width = 3;
                    break;
                }
                this.cc_width = 4;
                break;
            }
            case UPCE: 
            case DATABAR_14_STACK_OMNI: 
            case DATABAR_14_STACK: {
                this.cc_width = 2;
                break;
            }
            case DATABAR_LIMITED: {
                this.cc_width = 3;
                break;
            }
            case UPCA: 
            case CODE_128: 
            case DATABAR_14: 
            case DATABAR_EXPANDED: 
            case DATABAR_EXPANDED_STACK: {
                this.cc_width = 4;
            }
        }
        this.infoLine("Composite Width: " + this.cc_width);
        if (this.cc_mode == CompositeMode.CC_A && !this.cc_binary_string()) {
            this.cc_mode = CompositeMode.CC_B;
        }
        if (this.cc_mode == CompositeMode.CC_B && !this.cc_binary_string()) {
            if (this.symbology != LinearEncoding.CODE_128) {
                throw new OkapiException("Input too long");
            }
            this.cc_mode = CompositeMode.CC_C;
        }
        if (this.cc_mode == CompositeMode.CC_C && !this.cc_binary_string()) {
            throw new OkapiException("Input too long");
        }
        switch (this.cc_mode) {
            case CC_A: {
                this.cc_a();
                this.infoLine("Composite Type: CC-A");
                break;
            }
            case CC_B: {
                this.cc_b();
                this.infoLine("Composite Type: CC-B");
                break;
            }
            case CC_C: {
                this.cc_c();
                this.infoLine("Composite Type: CC-C");
            }
        }
        super.plotSymbol();
    }

    @Override
    protected void plotSymbol() {
    }

    private int eanCalculateVersion() {
        int length = 0;
        boolean latch = true;
        for (int i = 0; i < this.linearContent.length(); ++i) {
            if (this.linearContent.charAt(i) >= '0' && this.linearContent.charAt(i) <= '9') {
                if (!latch) continue;
                ++length;
                continue;
            }
            latch = false;
        }
        if (length <= 7) {
            return 8;
        }
        return 13;
    }

    private boolean calculateSymbolSize() {
        int binary_length = this.binary_string.length();
        if (this.cc_mode == CompositeMode.CC_A) {
            switch (this.cc_width) {
                case 2: {
                    if (binary_length > 167) {
                        return false;
                    }
                    if (binary_length <= 167) {
                        this.target_bitsize = 167;
                    }
                    if (binary_length <= 138) {
                        this.target_bitsize = 138;
                    }
                    if (binary_length <= 118) {
                        this.target_bitsize = 118;
                    }
                    if (binary_length <= 108) {
                        this.target_bitsize = 108;
                    }
                    if (binary_length <= 88) {
                        this.target_bitsize = 88;
                    }
                    if (binary_length <= 78) {
                        this.target_bitsize = 78;
                    }
                    if (binary_length > 59) break;
                    this.target_bitsize = 59;
                    break;
                }
                case 3: {
                    if (binary_length > 167) {
                        return false;
                    }
                    if (binary_length <= 167) {
                        this.target_bitsize = 167;
                    }
                    if (binary_length <= 138) {
                        this.target_bitsize = 138;
                    }
                    if (binary_length <= 118) {
                        this.target_bitsize = 118;
                    }
                    if (binary_length <= 98) {
                        this.target_bitsize = 98;
                    }
                    if (binary_length > 78) break;
                    this.target_bitsize = 78;
                    break;
                }
                case 4: {
                    if (binary_length > 197) {
                        return false;
                    }
                    if (binary_length <= 197) {
                        this.target_bitsize = 197;
                    }
                    if (binary_length <= 167) {
                        this.target_bitsize = 167;
                    }
                    if (binary_length <= 138) {
                        this.target_bitsize = 138;
                    }
                    if (binary_length <= 108) {
                        this.target_bitsize = 108;
                    }
                    if (binary_length > 78) break;
                    this.target_bitsize = 78;
                }
            }
        }
        if (this.cc_mode == CompositeMode.CC_B) {
            switch (this.cc_width) {
                case 2: {
                    if (binary_length > 336) {
                        return false;
                    }
                    if (binary_length <= 336) {
                        this.target_bitsize = 336;
                    }
                    if (binary_length <= 296) {
                        this.target_bitsize = 296;
                    }
                    if (binary_length <= 256) {
                        this.target_bitsize = 256;
                    }
                    if (binary_length <= 208) {
                        this.target_bitsize = 208;
                    }
                    if (binary_length <= 160) {
                        this.target_bitsize = 160;
                    }
                    if (binary_length <= 104) {
                        this.target_bitsize = 104;
                    }
                    if (binary_length > 56) break;
                    this.target_bitsize = 56;
                    break;
                }
                case 3: {
                    if (binary_length > 768) {
                        return false;
                    }
                    if (binary_length <= 768) {
                        this.target_bitsize = 768;
                    }
                    if (binary_length <= 648) {
                        this.target_bitsize = 648;
                    }
                    if (binary_length <= 536) {
                        this.target_bitsize = 536;
                    }
                    if (binary_length <= 416) {
                        this.target_bitsize = 416;
                    }
                    if (binary_length <= 304) {
                        this.target_bitsize = 304;
                    }
                    if (binary_length <= 208) {
                        this.target_bitsize = 208;
                    }
                    if (binary_length <= 152) {
                        this.target_bitsize = 152;
                    }
                    if (binary_length <= 112) {
                        this.target_bitsize = 112;
                    }
                    if (binary_length <= 72) {
                        this.target_bitsize = 72;
                    }
                    if (binary_length > 32) break;
                    this.target_bitsize = 32;
                    break;
                }
                case 4: {
                    if (binary_length > 1184) {
                        return false;
                    }
                    if (binary_length <= 1184) {
                        this.target_bitsize = 1184;
                    }
                    if (binary_length <= 1016) {
                        this.target_bitsize = 1016;
                    }
                    if (binary_length <= 840) {
                        this.target_bitsize = 840;
                    }
                    if (binary_length <= 672) {
                        this.target_bitsize = 672;
                    }
                    if (binary_length <= 496) {
                        this.target_bitsize = 496;
                    }
                    if (binary_length <= 352) {
                        this.target_bitsize = 352;
                    }
                    if (binary_length <= 264) {
                        this.target_bitsize = 264;
                    }
                    if (binary_length <= 208) {
                        this.target_bitsize = 208;
                    }
                    if (binary_length <= 152) {
                        this.target_bitsize = 152;
                    }
                    if (binary_length <= 96) {
                        this.target_bitsize = 96;
                    }
                    if (binary_length > 56) break;
                    this.target_bitsize = 56;
                }
            }
        }
        if (this.cc_mode == CompositeMode.CC_C) {
            int byte_length = binary_length / 8;
            if (binary_length % 8 != 0) {
                ++byte_length;
            }
            int codewords_used = byte_length / 6 * 5;
            int ecc_level = 7;
            if ((codewords_used += byte_length % 6) <= 1280) {
                ecc_level = 6;
            }
            if (codewords_used <= 640) {
                ecc_level = 5;
            }
            if (codewords_used <= 320) {
                ecc_level = 4;
            }
            if (codewords_used <= 160) {
                ecc_level = 3;
            }
            if (codewords_used <= 40) {
                ecc_level = 2;
            }
            this.ecc = ecc_level;
            int ecc_codewords = 1;
            for (int i = 1; i <= ecc_level + 1; ++i) {
                ecc_codewords *= 2;
            }
            codewords_used += ecc_codewords;
            this.cc_width = this.linearWidth == 0 ? (int)(0.5 + Math.sqrt((double)(codewords_used += 3) / 3.0)) : (this.linearWidth - 53) / 17;
            if (codewords_used / this.cc_width > 90) {
                ++this.cc_width;
            }
            int rows = codewords_used / this.cc_width;
            if (codewords_used % this.cc_width != 0) {
                ++rows;
            }
            while (this.cc_width > 3 * rows) {
                --this.cc_width;
                rows = codewords_used / this.cc_width;
                if (codewords_used % this.cc_width == 0) continue;
                ++rows;
            }
            int codewords_total = this.cc_width * rows;
            int target_codewords = codewords_total - ecc_codewords;
            int target_bytesize = 6 * ((target_codewords -= 3) / 5);
            this.target_bitsize = 8 * (target_bytesize += target_codewords % 5);
        }
        this.remainder = this.target_bitsize - binary_length;
        return true;
    }

    private boolean cc_binary_string() {
        int d2;
        int d1;
        int i;
        int j;
        int encoding_method = 1;
        int read_posn = 0;
        int ai_crop = 0;
        boolean fnc1_latch = false;
        boolean alpha_pad = false;
        int ai90_mode = 0;
        this.ecc = 0;
        int value = 0;
        this.target_bitsize = 0;
        if (this.inputData[0] == 49 && (this.inputData[1] == 48 || this.inputData[1] == 49 || this.inputData[1] == 55) && this.inputData.length >= 8) {
            encoding_method = 2;
        }
        if (this.inputData[0] == 57 && this.inputData[1] == 48) {
            encoding_method = 3;
        }
        this.info("Composite Encodation: ");
        switch (encoding_method) {
            case 1: {
                this.infoLine("0");
                break;
            }
            case 2: {
                this.infoLine("10");
                break;
            }
            case 3: {
                this.infoLine("11");
            }
        }
        this.binary_string = new StringBuilder();
        if (encoding_method == 1) {
            this.binary_string.append('0');
        }
        if (encoding_method == 2) {
            this.binary_string.append("10");
            if (this.inputData[1] == 48) {
                this.binary_string.append("11");
            } else {
                int group_val = (10 * (this.inputData[2] - 48) + (this.inputData[3] - 48)) * 384;
                group_val += (10 * (this.inputData[4] - 48) + (this.inputData[5] - 48) - 1) * 32;
                Strings.binaryAppend(this.binary_string, group_val += 10 * (this.inputData[6] - 48) + (this.inputData[7] - 48), 16);
                if (this.inputData[1] == 49) {
                    this.binary_string.append('0');
                } else {
                    this.binary_string.append('1');
                }
                read_posn = 8;
            }
            if (read_posn + 2 < this.inputData.length) {
                if (this.inputData[read_posn] == 49 && this.inputData[read_posn + 1] == 48) {
                    read_posn += 2;
                } else {
                    fnc1_latch = true;
                }
            } else {
                fnc1_latch = true;
            }
        }
        if (encoding_method == 3) {
            j = this.inputData.length;
            for (i = this.inputData.length - 1; i > 2; --i) {
                if (this.inputData[i] != -1) continue;
                j = i;
            }
            int[] ninety = Arrays.copyOfRange(this.inputData, 2, j);
            int alpha = 0;
            int alphanum = 0;
            int numeric = 0;
            for (i = 0; i < ninety.length; ++i) {
                if (ninety[i] >= 65 && ninety[i] <= 90) {
                    ++alpha;
                }
                if (ninety[i] >= 48 && ninety[i] <= 57) {
                    ++numeric;
                }
                switch (ninety[i]) {
                    case 42: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: {
                        ++alphanum;
                    }
                }
                if (ninety[i] >= 48 && ninety[i] <= 57 || ninety[i] >= 65 && ninety[i] <= 90 || ninety[i] == 42 || ninety[i] == 44 || ninety[i] == 45 || ninety[i] == 46 || ninety[i] == 47) continue;
                throw new OkapiException("Invalid AI 90 data");
            }
            int test1 = -1;
            for (i = 3; i >= 0; --i) {
                if (i >= ninety.length || ninety[i] < 65 || ninety[i] > 90) continue;
                test1 = i;
            }
            boolean test2 = false;
            for (i = 0; i < test1; ++i) {
                if (ninety[i] >= 48 && ninety[i] <= 57) continue;
                test2 = true;
            }
            boolean test3 = false;
            if (test1 >= 1 && ninety[0] == 48) {
                test3 = true;
            }
            if (test1 != -1 && !test2 && !test3) {
                this.binary_string.append("11");
                numeric -= test1;
                --alpha;
                if (alphanum > 0) {
                    this.binary_string.append('0');
                    ai90_mode = 1;
                } else if (alpha > numeric) {
                    this.binary_string.append("11");
                    ai90_mode = 2;
                } else {
                    this.binary_string.append("10");
                    ai90_mode = 3;
                }
                int next_ai_posn = 2 + ninety.length;
                if (next_ai_posn < this.inputData.length && this.inputData[next_ai_posn] == -1) {
                    if (next_ai_posn + 2 < this.inputData.length && this.inputData[next_ai_posn + 1] == 50 && this.inputData[next_ai_posn + 2] == 49) {
                        ai_crop = 1;
                    }
                    if (next_ai_posn + 4 < this.inputData.length && this.inputData[next_ai_posn + 1] == 56 && this.inputData[next_ai_posn + 2] == 48 && this.inputData[next_ai_posn + 3] == 48 && this.inputData[next_ai_posn + 4] == 52) {
                        ai_crop = 2;
                    }
                }
                switch (ai_crop) {
                    case 0: {
                        this.binary_string.append('0');
                        break;
                    }
                    case 1: {
                        this.binary_string.append("10");
                        break;
                    }
                    case 2: {
                        this.binary_string.append("11");
                    }
                }
                int numeric_value = 0;
                for (i = 0; i < test1; ++i) {
                    numeric_value *= 10;
                    numeric_value += ninety[i] - 48;
                }
                int table3_letter = -1;
                if (numeric_value < 31) {
                    table3_letter = "BDHIJKLNPQRSTVWZ".indexOf(ninety[test1]);
                }
                if (table3_letter != -1) {
                    Strings.binaryAppend(this.binary_string, numeric_value, 5);
                    Strings.binaryAppend(this.binary_string, table3_letter, 4);
                } else {
                    this.binary_string.append("11111");
                    Strings.binaryAppend(this.binary_string, numeric_value, 10);
                    Strings.binaryAppend(this.binary_string, ninety[test1] - 65, 5);
                }
                read_posn = test1 + 3;
            } else {
                this.binary_string.append('0');
                read_posn = 0;
            }
            if (ai90_mode == 2) {
                do {
                    if (this.inputData[read_posn] >= 48 && this.inputData[read_posn] <= 57) {
                        Strings.binaryAppend(this.binary_string, this.inputData[read_posn] + 4, 6);
                    }
                    if (this.inputData[read_posn] >= 65 && this.inputData[read_posn] <= 90) {
                        Strings.binaryAppend(this.binary_string, this.inputData[read_posn] - 65, 5);
                    }
                    if (this.inputData[read_posn] != -1) continue;
                    this.binary_string.append("11111");
                } while (this.inputData[++read_posn - 1] != -1 && read_posn < this.inputData.length);
                alpha_pad = true;
            }
            if (ai90_mode == 1) {
                do {
                    if (this.inputData[read_posn] >= 48 && this.inputData[read_posn] <= 57) {
                        Strings.binaryAppend(this.binary_string, this.inputData[read_posn] - 43, 5);
                    }
                    if (this.inputData[read_posn] >= 65 && this.inputData[read_posn] <= 90) {
                        Strings.binaryAppend(this.binary_string, this.inputData[read_posn] - 33, 6);
                    }
                    switch (this.inputData[read_posn]) {
                        case -1: {
                            this.binary_string.append("01111");
                            break;
                        }
                        case 42: {
                            this.binary_string.append("111010");
                            break;
                        }
                        case 44: {
                            this.binary_string.append("111011");
                            break;
                        }
                        case 45: {
                            this.binary_string.append("111100");
                            break;
                        }
                        case 46: {
                            this.binary_string.append("111101");
                            break;
                        }
                        case 47: {
                            this.binary_string.append("111110");
                        }
                    }
                } while (this.inputData[++read_posn - 1] != -1 && read_posn < this.inputData.length);
            }
            read_posn += 2 * ai_crop;
        }
        j = 0;
        if (fnc1_latch) {
            this.general_field = new int[this.inputData.length - read_posn + 1];
            this.general_field[0] = -1;
            System.arraycopy(this.inputData, read_posn, this.general_field, 1, this.general_field.length - 1);
        } else {
            this.general_field = Arrays.copyOfRange(this.inputData, read_posn, this.inputData.length);
        }
        boolean latch = false;
        if (this.general_field.length != 0) {
            int latchOffset;
            alpha_pad = false;
            this.general_field_type = new GeneralFieldMode[this.general_field.length];
            for (i = 0; i < this.general_field.length; ++i) {
                if (this.general_field[i] == -1) {
                    this.general_field_type[i] = GeneralFieldMode.ANY_ENC;
                } else if (this.general_field[i] < 32 || this.general_field[i] > 122) {
                    this.general_field_type[i] = GeneralFieldMode.INVALID_CHAR;
                    latch = true;
                } else {
                    this.general_field_type[i] = GeneralFieldMode.ISOIEC;
                }
                if (this.general_field[i] == 35) {
                    this.general_field_type[i] = GeneralFieldMode.INVALID_CHAR;
                    latch = true;
                }
                if (this.general_field[i] == 36) {
                    this.general_field_type[i] = GeneralFieldMode.INVALID_CHAR;
                    latch = true;
                }
                if (this.general_field[i] == 64) {
                    this.general_field_type[i] = GeneralFieldMode.INVALID_CHAR;
                    latch = true;
                }
                if (this.general_field[i] == 92) {
                    this.general_field_type[i] = GeneralFieldMode.INVALID_CHAR;
                    latch = true;
                }
                if (this.general_field[i] == 94) {
                    this.general_field_type[i] = GeneralFieldMode.INVALID_CHAR;
                    latch = true;
                }
                if (this.general_field[i] == 96) {
                    this.general_field_type[i] = GeneralFieldMode.INVALID_CHAR;
                    latch = true;
                }
                if (this.general_field[i] >= 65 && this.general_field[i] <= 90) {
                    this.general_field_type[i] = GeneralFieldMode.ALPHA_OR_ISO;
                }
                if (this.general_field[i] == 42) {
                    this.general_field_type[i] = GeneralFieldMode.ALPHA_OR_ISO;
                }
                if (this.general_field[i] == 44) {
                    this.general_field_type[i] = GeneralFieldMode.ALPHA_OR_ISO;
                }
                if (this.general_field[i] == 45) {
                    this.general_field_type[i] = GeneralFieldMode.ALPHA_OR_ISO;
                }
                if (this.general_field[i] == 46) {
                    this.general_field_type[i] = GeneralFieldMode.ALPHA_OR_ISO;
                }
                if (this.general_field[i] == 47) {
                    this.general_field_type[i] = GeneralFieldMode.ALPHA_OR_ISO;
                }
                if (this.general_field[i] < 48 || this.general_field[i] > 57) continue;
                this.general_field_type[i] = GeneralFieldMode.ANY_ENC;
            }
            if (latch) {
                throw new OkapiException("Invalid characters in input data");
            }
            for (i = 0; i < this.general_field.length - 1; ++i) {
                if (this.general_field_type[i] != GeneralFieldMode.ISOIEC || this.general_field[i + 1] != -1) continue;
                this.general_field_type[i + 1] = GeneralFieldMode.ISOIEC;
            }
            for (i = 0; i < this.general_field.length - 1; ++i) {
                if (this.general_field_type[i] != GeneralFieldMode.ALPHA_OR_ISO || this.general_field[i + 1] != -1) continue;
                this.general_field_type[i + 1] = GeneralFieldMode.ALPHA_OR_ISO;
            }
            latch = this.applyGeneralFieldRules();
            i = 0;
            do {
                switch (this.general_field_type[i]) {
                    case NUMERIC: {
                        if (i != 0 && this.general_field_type[i - 1] != GeneralFieldMode.NUMERIC && this.general_field[i - 1] != -1) {
                            this.binary_string.append("000");
                        }
                        d1 = this.general_field[i] != -1 ? this.general_field[i] - 48 : 10;
                        d2 = i < this.general_field.length - 1 ? (this.general_field[i + 1] != -1 ? this.general_field[i + 1] - 48 : 10) : 10;
                        if (d1 == 10 && d2 == 10) break;
                        value = 11 * d1 + d2 + 8;
                        Strings.binaryAppend(this.binary_string, value, 7);
                        i += 2;
                        break;
                    }
                    case ALPHA: {
                        if (i == 0 || this.general_field_type[i - 1] == GeneralFieldMode.NUMERIC || this.general_field[i - 1] == -1) {
                            this.binary_string.append("0000");
                        } else if (this.general_field_type[i - 1] == GeneralFieldMode.ISOIEC) {
                            this.binary_string.append("00100");
                        }
                        if (this.general_field[i] >= 48 && this.general_field[i] <= 57) {
                            value = this.general_field[i] - 43;
                            Strings.binaryAppend(this.binary_string, value, 5);
                        }
                        if (this.general_field[i] >= 65 && this.general_field[i] <= 90) {
                            value = this.general_field[i] - 33;
                            Strings.binaryAppend(this.binary_string, value, 6);
                        }
                        if (this.general_field[i] == -1) {
                            this.binary_string.append("01111");
                        }
                        if (this.general_field[i] == 42) {
                            this.binary_string.append("111010");
                        }
                        if (this.general_field[i] == 44) {
                            this.binary_string.append("111011");
                        }
                        if (this.general_field[i] == 45) {
                            this.binary_string.append("111100");
                        }
                        if (this.general_field[i] == 46) {
                            this.binary_string.append("111101");
                        }
                        if (this.general_field[i] == 47) {
                            this.binary_string.append("111110");
                        }
                        ++i;
                        break;
                    }
                    case ISOIEC: {
                        if (i == 0 || this.general_field_type[i - 1] == GeneralFieldMode.NUMERIC || this.general_field[i - 1] == -1) {
                            this.binary_string.append("0000");
                            this.binary_string.append("00100");
                        } else if (this.general_field_type[i - 1] == GeneralFieldMode.ALPHA) {
                            this.binary_string.append("00100");
                        }
                        if (this.general_field[i] >= 48 && this.general_field[i] <= 57) {
                            value = this.general_field[i] - 43;
                            Strings.binaryAppend(this.binary_string, value, 5);
                        }
                        if (this.general_field[i] >= 65 && this.general_field[i] <= 90) {
                            value = this.general_field[i] - 1;
                            Strings.binaryAppend(this.binary_string, value, 7);
                        }
                        if (this.general_field[i] >= 97 && this.general_field[i] <= 122) {
                            value = this.general_field[i] - 7;
                            Strings.binaryAppend(this.binary_string, value, 7);
                        }
                        if (this.general_field[i] == -1) {
                            this.binary_string.append("01111");
                        }
                        if (this.general_field[i] == 33) {
                            this.binary_string.append("11101000");
                        }
                        if (this.general_field[i] == 34) {
                            this.binary_string.append("11101001");
                        }
                        if (this.general_field[i] == 37) {
                            this.binary_string.append("11101010");
                        }
                        if (this.general_field[i] == 38) {
                            this.binary_string.append("11101011");
                        }
                        if (this.general_field[i] == 39) {
                            this.binary_string.append("11101100");
                        }
                        if (this.general_field[i] == 40) {
                            this.binary_string.append("11101101");
                        }
                        if (this.general_field[i] == 41) {
                            this.binary_string.append("11101110");
                        }
                        if (this.general_field[i] == 42) {
                            this.binary_string.append("11101111");
                        }
                        if (this.general_field[i] == 43) {
                            this.binary_string.append("11110000");
                        }
                        if (this.general_field[i] == 44) {
                            this.binary_string.append("11110001");
                        }
                        if (this.general_field[i] == 45) {
                            this.binary_string.append("11110010");
                        }
                        if (this.general_field[i] == 46) {
                            this.binary_string.append("11110011");
                        }
                        if (this.general_field[i] == 47) {
                            this.binary_string.append("11110100");
                        }
                        if (this.general_field[i] == 58) {
                            this.binary_string.append("11110101");
                        }
                        if (this.general_field[i] == 59) {
                            this.binary_string.append("11110110");
                        }
                        if (this.general_field[i] == 60) {
                            this.binary_string.append("11110111");
                        }
                        if (this.general_field[i] == 61) {
                            this.binary_string.append("11111000");
                        }
                        if (this.general_field[i] == 62) {
                            this.binary_string.append("11111001");
                        }
                        if (this.general_field[i] == 63) {
                            this.binary_string.append("11111010");
                        }
                        if (this.general_field[i] == 95) {
                            this.binary_string.append("11111011");
                        }
                        if (this.general_field[i] == 32) {
                            this.binary_string.append("11111100");
                        }
                        ++i;
                    }
                }
                latchOffset = 0;
                if (!latch) continue;
                latchOffset = 1;
            } while (i + latchOffset < this.general_field.length);
        }
        if (!this.calculateSymbolSize()) {
            return false;
        }
        if (latch) {
            i = this.general_field.length - 1;
            if (this.general_field[i] == -1) {
                this.binary_string.append("000001111");
            } else if (this.remainder >= 4 && this.remainder <= 6) {
                d1 = this.general_field[i] - 48;
                value = d1 + 1;
                Strings.binaryAppend(this.binary_string, value, 4);
            } else {
                d1 = this.general_field[i] - 48;
                d2 = 10;
                value = 11 * d1 + d2 + 8;
                Strings.binaryAppend(this.binary_string, value, 7);
            }
        }
        if (this.binary_string.length() > 11805) {
            throw new OkapiException("Input too long");
        }
        if (!this.calculateSymbolSize()) {
            return false;
        }
        this.infoLine("Composite Binary Length: " + this.binary_string.length());
        this.logBinaryString();
        if (this.binary_string.length() < this.target_bitsize) {
            if (alpha_pad) {
                this.binary_string.append("11111");
                alpha_pad = false;
            }
            if (this.general_field.length == 0 || this.general_field_type[this.general_field.length - 1] == GeneralFieldMode.NUMERIC) {
                this.binary_string.append("0000");
            }
            while (this.binary_string.length() < this.target_bitsize) {
                this.binary_string.append("00100");
            }
            this.binary_string.delete(this.target_bitsize, this.binary_string.length());
        }
        return true;
    }

    private void logBinaryString() {
        this.info("Composite Binary String: ");
        int nibble = 0;
        block6: for (int i = 0; i < this.binary_string.length(); ++i) {
            switch (i % 4) {
                case 0: {
                    if (this.binary_string.charAt(i) != '1') continue block6;
                    nibble += 8;
                    continue block6;
                }
                case 1: {
                    if (this.binary_string.charAt(i) != '1') continue block6;
                    nibble += 4;
                    continue block6;
                }
                case 2: {
                    if (this.binary_string.charAt(i) != '1') continue block6;
                    nibble += 2;
                    continue block6;
                }
                case 3: {
                    if (this.binary_string.charAt(i) == '1') {
                        ++nibble;
                    }
                    this.info(Integer.toHexString(nibble));
                    nibble = 0;
                }
            }
        }
        if (this.binary_string.length() % 4 != 0) {
            this.info(Integer.toHexString(nibble));
        }
        this.infoLine();
    }

    private boolean applyGeneralFieldRules() {
        int j;
        GeneralFieldMode current;
        int i;
        int[] blockLength = new int[200];
        GeneralFieldMode[] blockType = new GeneralFieldMode[200];
        int block_count = 0;
        blockLength[block_count] = 1;
        blockType[block_count] = this.general_field_type[0];
        for (i = 1; i < this.general_field.length; ++i) {
            current = this.general_field_type[i];
            GeneralFieldMode last = this.general_field_type[i - 1];
            if (current == last) {
                blockLength[block_count] = blockLength[block_count] + 1;
                continue;
            }
            blockLength[++block_count] = 1;
            blockType[block_count] = this.general_field_type[i];
        }
        ++block_count;
        for (i = 0; i < block_count; ++i) {
            current = blockType[i];
            GeneralFieldMode next = blockType[i + 1];
            if (current == GeneralFieldMode.ISOIEC && i != block_count - 1) {
                if (next == GeneralFieldMode.ANY_ENC && blockLength[i + 1] >= 4) {
                    blockType[i + 1] = GeneralFieldMode.NUMERIC;
                }
                if (next == GeneralFieldMode.ANY_ENC && blockLength[i + 1] < 4) {
                    blockType[i + 1] = GeneralFieldMode.ISOIEC;
                }
                if (next == GeneralFieldMode.ALPHA_OR_ISO && blockLength[i + 1] >= 5) {
                    blockType[i + 1] = GeneralFieldMode.ALPHA;
                }
                if (next == GeneralFieldMode.ALPHA_OR_ISO && blockLength[i + 1] < 5) {
                    blockType[i + 1] = GeneralFieldMode.ISOIEC;
                }
            }
            if (current == GeneralFieldMode.ALPHA_OR_ISO) {
                blockType[i] = GeneralFieldMode.ALPHA;
            }
            if (current == GeneralFieldMode.ALPHA && i != block_count - 1) {
                if (next == GeneralFieldMode.ANY_ENC && blockLength[i + 1] >= 6) {
                    blockType[i + 1] = GeneralFieldMode.NUMERIC;
                }
                if (next == GeneralFieldMode.ANY_ENC && blockLength[i + 1] < 6) {
                    blockType[i + 1] = i == block_count - 2 && blockLength[i + 1] >= 4 ? GeneralFieldMode.NUMERIC : GeneralFieldMode.ALPHA;
                }
            }
            if (current != GeneralFieldMode.ANY_ENC) continue;
            blockType[i] = GeneralFieldMode.NUMERIC;
        }
        if (block_count > 1) {
            for (i = 1; i < block_count; ++i) {
                if (blockType[i - 1] != blockType[i]) continue;
                blockLength[i - 1] = blockLength[i - 1] + blockLength[i];
                for (j = i + 1; j < block_count; ++j) {
                    blockLength[j - 1] = blockLength[j];
                    blockType[j - 1] = blockType[j];
                }
                --block_count;
                --i;
            }
        }
        for (i = 0; i < block_count - 1; ++i) {
            if (blockType[i] != GeneralFieldMode.NUMERIC || (blockLength[i] & 1) == 0) continue;
            blockLength[i] = blockLength[i] - 1;
            blockLength[i + 1] = blockLength[i + 1] + 1;
        }
        j = 0;
        for (i = 0; i < block_count; ++i) {
            for (int k = 0; k < blockLength[i]; ++k) {
                this.general_field_type[j] = blockType[i];
                ++j;
            }
        }
        return blockType[block_count - 1] == GeneralFieldMode.NUMERIC && (blockLength[block_count - 1] & 1) != 0;
    }

    private void cc_a() {
        int j;
        int i;
        int[] rsCodeWords = new int[8];
        int[] dummy = new int[5];
        StringBuilder bin = new StringBuilder();
        int variant = 0;
        for (i = 0; i < 13; ++i) {
            this.bitStr[i] = 0;
        }
        for (i = 0; i < 28; ++i) {
            this.codeWords[i] = 0;
        }
        StringBuilder local_source = new StringBuilder(208);
        local_source.append((CharSequence)this.binary_string);
        for (i = this.binary_string.length(); i < 208; ++i) {
            local_source.append('0');
        }
        for (int segment = 0; segment < 13; ++segment) {
            int strpos = segment * 16;
            this.bitStr[segment] = 0;
            for (i = 0; i < 16; ++i) {
                if (local_source.charAt(strpos + i) != '1') continue;
                int n = segment;
                this.bitStr[n] = this.bitStr[n] + (32768 >> i);
            }
        }
        this.init928();
        int cwCnt = this.encode928(this.binary_string.length());
        block0 : switch (this.cc_width) {
            case 2: {
                switch (cwCnt) {
                    case 6: {
                        variant = 0;
                        break;
                    }
                    case 8: {
                        variant = 1;
                        break;
                    }
                    case 9: {
                        variant = 2;
                        break;
                    }
                    case 11: {
                        variant = 3;
                        break;
                    }
                    case 12: {
                        variant = 4;
                        break;
                    }
                    case 14: {
                        variant = 5;
                        break;
                    }
                    case 17: {
                        variant = 6;
                    }
                }
                break;
            }
            case 3: {
                switch (cwCnt) {
                    case 8: {
                        variant = 7;
                        break;
                    }
                    case 10: {
                        variant = 8;
                        break;
                    }
                    case 12: {
                        variant = 9;
                        break;
                    }
                    case 14: {
                        variant = 10;
                        break;
                    }
                    case 17: {
                        variant = 11;
                    }
                }
                break;
            }
            case 4: {
                switch (cwCnt) {
                    case 8: {
                        variant = 12;
                        break block0;
                    }
                    case 11: {
                        variant = 13;
                        break block0;
                    }
                    case 14: {
                        variant = 14;
                        break block0;
                    }
                    case 17: {
                        variant = 15;
                        break block0;
                    }
                    case 20: {
                        variant = 16;
                    }
                }
            }
        }
        int rows = CCA_VARIANTS[variant];
        int k = CCA_VARIANTS[17 + variant];
        int offset = CCA_VARIANTS[34 + variant];
        for (i = 0; i < 8; ++i) {
            rsCodeWords[i] = 0;
        }
        int total = 0;
        this.info("Composite Codewords: ");
        for (i = 0; i < cwCnt; ++i) {
            total = (this.codeWords[i] + rsCodeWords[k - 1]) % 929;
            for (j = k - 1; j >= 0; --j) {
                rsCodeWords[j] = j == 0 ? (929 - total * CCA_COEFFS[offset + j] % 929) % 929 : (rsCodeWords[j - 1] + 929 - total * CCA_COEFFS[offset + j] % 929) % 929;
            }
            this.infoSpace(this.codeWords[i]);
        }
        this.infoLine();
        for (j = 0; j < k; ++j) {
            if (rsCodeWords[j] == 0) continue;
            rsCodeWords[j] = 929 - rsCodeWords[j];
        }
        for (i = k - 1; i >= 0; --i) {
            this.codeWords[cwCnt] = rsCodeWords[i];
            ++cwCnt;
        }
        int LeftRAPStart = A_RAP_TABLE[variant];
        int CentreRAPStart = A_RAP_TABLE[variant + 17];
        int RightRAPStart = A_RAP_TABLE[variant + 34];
        int StartCluster = A_RAP_TABLE[variant + 51] / 3;
        int LeftRAP = LeftRAPStart;
        int CentreRAP = CentreRAPStart;
        int RightRAP = RightRAPStart;
        int Cluster = StartCluster;
        this.readable = "";
        this.row_count = rows;
        this.pattern = new String[this.row_count];
        this.row_height = new int[this.row_count];
        for (i = 0; i < rows; ++i) {
            String codebarre = "";
            offset = 929 * Cluster;
            for (j = 0; j < 5; ++j) {
                dummy[j] = 0;
            }
            for (j = 0; j < this.cc_width; ++j) {
                dummy[j + 1] = this.codeWords[i * this.cc_width + j];
            }
            if (this.cc_width != 3) {
                codebarre = codebarre + RAPLR[LeftRAP];
            }
            codebarre = codebarre + "1";
            codebarre = codebarre + CODAGEMC[offset + dummy[1]];
            codebarre = codebarre + "1";
            if (this.cc_width == 3) {
                codebarre = codebarre + RAPC[CentreRAP];
            }
            if (this.cc_width >= 2) {
                codebarre = codebarre + "1";
                codebarre = codebarre + CODAGEMC[offset + dummy[2]];
                codebarre = codebarre + "1";
            }
            if (this.cc_width == 4) {
                codebarre = codebarre + RAPC[CentreRAP];
            }
            if (this.cc_width >= 3) {
                codebarre = codebarre + "1";
                codebarre = codebarre + CODAGEMC[offset + dummy[3]];
                codebarre = codebarre + "1";
            }
            if (this.cc_width == 4) {
                codebarre = codebarre + "1";
                codebarre = codebarre + CODAGEMC[offset + dummy[4]];
                codebarre = codebarre + "1";
            }
            codebarre = codebarre + RAPLR[RightRAP];
            codebarre = codebarre + "1";
            boolean flip = true;
            bin.setLength(0);
            for (int loop = 0; loop < codebarre.length(); ++loop) {
                if (codebarre.charAt(loop) >= '0' && codebarre.charAt(loop) <= '9') {
                    for (k = 0; k < codebarre.charAt(loop) - 48; ++k) {
                        if (!flip) {
                            bin.append('0');
                            continue;
                        }
                        bin.append('1');
                    }
                    if (!flip) {
                        flip = true;
                        continue;
                    }
                    flip = false;
                    continue;
                }
                bin.append(PDF_TTF[uk.org.okapibarcode.util.Arrays.positionOf(codebarre.charAt(loop), BR_SET)]);
            }
            this.row_height[i] = 2;
            this.pattern[i] = Composite.bin2pat(bin);
            ++CentreRAP;
            ++RightRAP;
            ++Cluster;
            if (++LeftRAP == 53) {
                LeftRAP = 1;
            }
            if (CentreRAP == 53) {
                CentreRAP = 1;
            }
            if (RightRAP == 53) {
                RightRAP = 1;
            }
            if (Cluster != 3) continue;
            Cluster = 0;
        }
    }

    private void init928() {
        int i;
        int[] cw = new int[7];
        cw[6] = 1;
        for (i = 5; i >= 0; --i) {
            cw[i] = 0;
        }
        for (i = 0; i < 7; ++i) {
            this.pwr928[0][i] = cw[i];
        }
        for (int j = 1; j < 69; ++j) {
            int v = 0;
            for (i = 6; i >= 1; --i) {
                v = 2 * cw[i] + v / 928;
                this.pwr928[j][i] = cw[i] = v % 928;
            }
            this.pwr928[j][0] = cw[0] = 2 * cw[0] + v / 928;
        }
    }

    private int encode928(int bitLng) {
        int b = 0;
        int cwLng = 0;
        int cwNdx = 0;
        while (b < bitLng) {
            int i;
            int bitCnt = this.min(bitLng - b, 69);
            int cwCnt = bitCnt / 10 + 1;
            cwLng += cwCnt;
            for (i = 0; i < cwCnt; ++i) {
                this.codeWords[cwNdx + i] = 0;
            }
            for (i = 0; i < bitCnt; ++i) {
                if (!this.getBit(b + bitCnt - i - 1)) continue;
                for (int j = 0; j < cwCnt; ++j) {
                    int n = cwNdx + j;
                    this.codeWords[n] = this.codeWords[n] + this.pwr928[i][j + 7 - cwCnt];
                }
            }
            for (i = cwCnt - 1; i > 0; --i) {
                int n = cwNdx + i - 1;
                this.codeWords[n] = this.codeWords[n] + this.codeWords[cwNdx + i] / 928;
                int n2 = cwNdx + i;
                this.codeWords[n2] = this.codeWords[n2] % 928;
            }
            b += 69;
            cwNdx += 7;
        }
        return cwLng;
    }

    private int min(int first, int second) {
        if (first <= second) {
            return first;
        }
        return second;
    }

    private boolean getBit(int arg) {
        return (this.bitStr[arg >> 4] & 32768 >> (arg & 0xF)) != 0;
    }

    private void cc_b() {
        int loop;
        int j;
        int i;
        int[] mccorrection = new int[50];
        int[] dummy = new int[5];
        StringBuilder bin = new StringBuilder();
        this.inputData = new int[this.binary_string.length() / 8 + 3];
        int length = this.binary_string.length() / 8;
        for (i = 0; i < length; ++i) {
            int binloc = i * 8;
            this.inputData[i] = 0;
            for (j = 0; j < 8; ++j) {
                if (this.binary_string.charAt(binloc + j) != '1') continue;
                int n = i;
                this.inputData[n] = this.inputData[n] + (128 >> j);
            }
        }
        this.codeWordCount = 0;
        this.codeWords[this.codeWordCount] = 920;
        ++this.codeWordCount;
        this.byteprocess(0, length);
        int variant = 0;
        if (this.cc_width == 2) {
            variant = 13;
            if (this.codeWordCount <= 33) {
                variant = 12;
            }
            if (this.codeWordCount <= 29) {
                variant = 11;
            }
            if (this.codeWordCount <= 24) {
                variant = 10;
            }
            if (this.codeWordCount <= 19) {
                variant = 9;
            }
            if (this.codeWordCount <= 13) {
                variant = 8;
            }
            if (this.codeWordCount <= 8) {
                variant = 7;
            }
        }
        if (this.cc_width == 3) {
            variant = 23;
            if (this.codeWordCount <= 70) {
                variant = 22;
            }
            if (this.codeWordCount <= 58) {
                variant = 21;
            }
            if (this.codeWordCount <= 46) {
                variant = 20;
            }
            if (this.codeWordCount <= 34) {
                variant = 19;
            }
            if (this.codeWordCount <= 24) {
                variant = 18;
            }
            if (this.codeWordCount <= 18) {
                variant = 17;
            }
            if (this.codeWordCount <= 14) {
                variant = 16;
            }
            if (this.codeWordCount <= 10) {
                variant = 15;
            }
            if (this.codeWordCount <= 6) {
                variant = 14;
            }
        }
        if (this.cc_width == 4) {
            variant = 34;
            if (this.codeWordCount <= 108) {
                variant = 33;
            }
            if (this.codeWordCount <= 90) {
                variant = 32;
            }
            if (this.codeWordCount <= 72) {
                variant = 31;
            }
            if (this.codeWordCount <= 54) {
                variant = 30;
            }
            if (this.codeWordCount <= 39) {
                variant = 29;
            }
            if (this.codeWordCount <= 30) {
                variant = 28;
            }
            if (this.codeWordCount <= 24) {
                variant = 27;
            }
            if (this.codeWordCount <= 18) {
                variant = 26;
            }
            if (this.codeWordCount <= 12) {
                variant = 25;
            }
            if (this.codeWordCount <= 8) {
                variant = 24;
            }
        }
        int option_2 = MICRO_VARIANTS[--variant];
        int rows = MICRO_VARIANTS[variant + 34];
        int k = MICRO_VARIANTS[variant + 68];
        int longueur = option_2 * rows - k;
        int offset = MICRO_VARIANTS[variant + 102];
        for (i = longueur - this.codeWordCount; i > 0; --i) {
            this.codeWords[this.codeWordCount] = 900;
            ++this.codeWordCount;
        }
        longueur = this.codeWordCount;
        for (loop = 0; loop < 50; ++loop) {
            mccorrection[loop] = 0;
        }
        int total = 0;
        this.info("Composite Codewords: ");
        for (i = 0; i < longueur; ++i) {
            total = (this.codeWords[i] + mccorrection[k - 1]) % 929;
            for (j = k - 1; j >= 0; --j) {
                mccorrection[j] = j == 0 ? (929 - total * MICROCOEFFS[offset + j] % 929) % 929 : (mccorrection[j - 1] + 929 - total * MICROCOEFFS[offset + j] % 929) % 929;
            }
            this.infoSpace(this.codeWords[i]);
        }
        this.infoLine();
        for (j = 0; j < k; ++j) {
            if (mccorrection[j] == 0) continue;
            mccorrection[j] = 929 - mccorrection[j];
        }
        for (i = k - 1; i >= 0; --i) {
            this.codeWords[this.codeWordCount] = mccorrection[i];
            ++this.codeWordCount;
        }
        int LeftRAPStart = RAP_TABLE[variant];
        int CentreRAPStart = RAP_TABLE[variant + 34];
        int RightRAPStart = RAP_TABLE[variant + 68];
        int StartCluster = RAP_TABLE[variant + 102] / 3;
        int LeftRAP = LeftRAPStart;
        int CentreRAP = CentreRAPStart;
        int RightRAP = RightRAPStart;
        int Cluster = StartCluster;
        this.readable = "";
        this.row_count = rows;
        this.pattern = new String[this.row_count];
        this.row_height = new int[this.row_count];
        for (i = 0; i < rows; ++i) {
            String codebarre = "";
            offset = 929 * Cluster;
            for (j = 0; j < 5; ++j) {
                dummy[j] = 0;
            }
            for (j = 0; j < option_2; ++j) {
                dummy[j + 1] = this.codeWords[i * option_2 + j];
            }
            codebarre = codebarre + RAPLR[LeftRAP];
            codebarre = codebarre + "1";
            codebarre = codebarre + CODAGEMC[offset + dummy[1]];
            codebarre = codebarre + "1";
            if (this.cc_width == 3) {
                codebarre = codebarre + RAPC[CentreRAP];
            }
            if (this.cc_width >= 2) {
                codebarre = codebarre + "1";
                codebarre = codebarre + CODAGEMC[offset + dummy[2]];
                codebarre = codebarre + "1";
            }
            if (this.cc_width == 4) {
                codebarre = codebarre + RAPC[CentreRAP];
            }
            if (this.cc_width >= 3) {
                codebarre = codebarre + "1";
                codebarre = codebarre + CODAGEMC[offset + dummy[3]];
                codebarre = codebarre + "1";
            }
            if (this.cc_width == 4) {
                codebarre = codebarre + "1";
                codebarre = codebarre + CODAGEMC[offset + dummy[4]];
                codebarre = codebarre + "1";
            }
            codebarre = codebarre + RAPLR[RightRAP];
            codebarre = codebarre + "1";
            boolean flip = true;
            bin.setLength(0);
            for (loop = 0; loop < codebarre.length(); ++loop) {
                if (codebarre.charAt(loop) >= '0' && codebarre.charAt(loop) <= '9') {
                    for (k = 0; k < codebarre.charAt(loop) - 48; ++k) {
                        if (!flip) {
                            bin.append('0');
                            continue;
                        }
                        bin.append('1');
                    }
                    if (!flip) {
                        flip = true;
                        continue;
                    }
                    flip = false;
                    continue;
                }
                bin.append(PDF_TTF[uk.org.okapibarcode.util.Arrays.positionOf(codebarre.charAt(loop), BR_SET)]);
            }
            this.pattern[i] = Composite.bin2pat(bin);
            this.row_height[i] = 2;
            ++CentreRAP;
            ++RightRAP;
            ++Cluster;
            if (++LeftRAP == 53) {
                LeftRAP = 1;
            }
            if (CentreRAP == 53) {
                CentreRAP = 1;
            }
            if (RightRAP == 53) {
                RightRAP = 1;
            }
            if (Cluster != 3) continue;
            Cluster = 0;
        }
    }

    private void cc_c() {
        int loop;
        int offset;
        int j;
        int i;
        int[] mccorrection = new int[520];
        int[] dummy = new int[35];
        StringBuilder bin = new StringBuilder();
        this.inputData = new int[this.binary_string.length() / 8 + 4];
        int length = this.binary_string.length() / 8;
        for (i = 0; i < length; ++i) {
            int binloc = i * 8;
            this.inputData[i] = 0;
            for (j = 0; j < 8; ++j) {
                if (this.binary_string.charAt(binloc + j) != '1') continue;
                int n = i;
                this.inputData[n] = this.inputData[n] + (128 >> j);
            }
        }
        this.codeWordCount = 0;
        this.codeWords[this.codeWordCount] = 0;
        ++this.codeWordCount;
        this.codeWords[this.codeWordCount] = 920;
        this.byteprocess(0, length);
        this.codeWords[0] = ++this.codeWordCount;
        int k = 1;
        for (i = 1; i <= this.ecc + 1; ++i) {
            k *= 2;
        }
        switch (this.ecc) {
            case 1: {
                offset = 2;
                break;
            }
            case 2: {
                offset = 6;
                break;
            }
            case 3: {
                offset = 14;
                break;
            }
            case 4: {
                offset = 30;
                break;
            }
            case 5: {
                offset = 62;
                break;
            }
            case 6: {
                offset = 126;
                break;
            }
            case 7: {
                offset = 254;
                break;
            }
            case 8: {
                offset = 510;
                break;
            }
            default: {
                offset = 0;
            }
        }
        int longueur = this.codeWordCount;
        for (loop = 0; loop < 520; ++loop) {
            mccorrection[loop] = 0;
        }
        int total = 0;
        this.info("Composite Codewords: ");
        for (i = 0; i < longueur; ++i) {
            total = (this.codeWords[i] + mccorrection[k - 1]) % 929;
            for (j = k - 1; j >= 0; --j) {
                mccorrection[j] = j == 0 ? (929 - total * COEFRS[offset + j] % 929) % 929 : (mccorrection[j - 1] + 929 - total * COEFRS[offset + j] % 929) % 929;
            }
            this.infoSpace(this.codeWords[i]);
        }
        this.infoLine();
        for (j = 0; j < k; ++j) {
            if (mccorrection[j] == 0) continue;
            mccorrection[j] = 929 - mccorrection[j];
        }
        for (i = k - 1; i >= 0; --i) {
            this.codeWords[this.codeWordCount] = mccorrection[i];
            ++this.codeWordCount;
        }
        int c1 = (this.codeWordCount / this.cc_width - 1) / 3;
        int c2 = this.ecc * 3 + (this.codeWordCount / this.cc_width - 1) % 3;
        int c3 = this.cc_width - 1;
        this.readable = "";
        this.row_count = this.codeWordCount / this.cc_width;
        this.pattern = new String[this.row_count];
        this.row_height = new int[this.row_count];
        for (i = 0; i <= this.codeWordCount / this.cc_width - 1; ++i) {
            for (j = 0; j < this.cc_width; ++j) {
                dummy[j + 1] = this.codeWords[i * this.cc_width + j];
            }
            k = i / 3 * 30;
            switch (i % 3) {
                case 0: {
                    dummy[0] = k + c1;
                    dummy[this.cc_width + 1] = k + c3;
                    break;
                }
                case 1: {
                    dummy[0] = k + c2;
                    dummy[this.cc_width + 1] = k + c1;
                    break;
                }
                case 2: {
                    dummy[0] = k + c3;
                    dummy[this.cc_width + 1] = k + c2;
                }
            }
            String codebarre = "+*";
            for (j = 0; j <= this.cc_width + 1; ++j) {
                switch (i % 3) {
                    case 1: {
                        offset = 929;
                        break;
                    }
                    case 2: {
                        offset = 1858;
                        break;
                    }
                    default: {
                        offset = 0;
                    }
                }
                codebarre = codebarre + CODAGEMC[offset + dummy[j]];
                codebarre = codebarre + "*";
            }
            codebarre = codebarre + "-";
            bin.setLength(0);
            for (loop = 0; loop < codebarre.length(); ++loop) {
                bin.append(PDF_TTF[uk.org.okapibarcode.util.Arrays.positionOf(codebarre.charAt(loop), BR_SET)]);
            }
            this.pattern[i] = Composite.bin2pat(bin);
            this.row_height[i] = 3;
        }
    }

    private void byteprocess(int start, int length) {
        int len = 0;
        int chunkLen = 0;
        this.codeWords[this.codeWordCount++] = this.binary_string.length() % 6 == 0 ? 924 : 901;
        while (len < length) {
            chunkLen = length - len;
            if (6 <= chunkLen) {
                chunkLen = 6;
                len += chunkLen;
                BigInteger total = BigInteger.valueOf(0L);
                while (chunkLen-- != 0) {
                    BigInteger mantisa = BigInteger.valueOf(this.inputData[start++]);
                    total = total.or(mantisa.shiftLeft(chunkLen * 8));
                }
                chunkLen = 5;
                while (chunkLen-- != 0) {
                    BigInteger word = total.mod(BigInteger.valueOf(900L));
                    this.codeWords[this.codeWordCount + chunkLen] = word.intValue();
                    total = total.divide(BigInteger.valueOf(900L));
                }
                this.codeWordCount += 5;
                continue;
            }
            len += chunkLen;
            while (chunkLen-- != 0) {
                this.codeWords[this.codeWordCount++] = this.inputData[start++];
            }
        }
    }

    private static enum GeneralFieldMode {
        NUMERIC,
        ALPHA,
        ISOIEC,
        INVALID_CHAR,
        ANY_ENC,
        ALPHA_OR_ISO;

    }

    public static enum CompositeMode {
        CC_A,
        CC_B,
        CC_C;

    }

    public static enum LinearEncoding {
        UPCA,
        UPCE,
        EAN,
        CODE_128,
        DATABAR_14,
        DATABAR_14_STACK,
        DATABAR_14_STACK_OMNI,
        DATABAR_LIMITED,
        DATABAR_EXPANDED,
        DATABAR_EXPANDED_STACK;

    }
}

