/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;

public class KoreaPost
extends Symbol {
    private static final String[] KOREA_TABLE = new String[]{"1313150613", "0713131313", "0417131313", "1506131313", "0413171313", "17171313", "1315061313", "0413131713", "17131713", "13171713"};

    @Override
    protected void encode() {
        if (!this.content.matches("[0-9]+")) {
            throw new OkapiException("Invalid characters in input");
        }
        if (this.content.length() > 6) {
            throw new OkapiException("Input data too long");
        }
        String padded = "";
        for (int i = 0; i < 6 - this.content.length(); ++i) {
            padded = padded + "0";
        }
        padded = padded + this.content;
        int total = 0;
        String accumulator = "";
        for (int i = 0; i < padded.length(); ++i) {
            int j = Character.getNumericValue(padded.charAt(i));
            accumulator = accumulator + KOREA_TABLE[j];
            total += j;
        }
        int checkd = 10 - total % 10;
        if (checkd == 10) {
            checkd = 0;
        }
        this.infoLine("Check Digit: " + checkd);
        accumulator = accumulator + KOREA_TABLE[checkd];
        this.readable = padded + checkd;
        this.pattern = new String[]{accumulator};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }
}

