/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.awt.geom.Ellipse2D;
import java.util.Arrays;
import uk.org.okapibarcode.backend.Hexagon;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.ReedSolomon;
import uk.org.okapibarcode.backend.Symbol;

public class MaxiCode
extends Symbol {
    private static final int[] MAXICODE_GRID = new int[]{122, 121, 128, 127, 134, 133, 140, 139, 146, 145, 152, 151, 158, 157, 164, 163, 170, 169, 176, 175, 182, 181, 188, 187, 194, 193, 200, 199, 0, 0, 124, 123, 130, 129, 136, 135, 142, 141, 148, 147, 154, 153, 160, 159, 166, 165, 172, 171, 178, 177, 184, 183, 190, 189, 196, 195, 202, 201, 817, 0, 126, 125, 132, 131, 138, 137, 144, 143, 150, 149, 156, 155, 162, 161, 168, 167, 174, 173, 180, 179, 186, 185, 192, 191, 198, 197, 204, 203, 819, 818, 284, 283, 278, 277, 272, 271, 266, 265, 260, 259, 254, 253, 248, 247, 242, 241, 236, 235, 230, 229, 224, 223, 218, 217, 212, 211, 206, 205, 820, 0, 286, 285, 280, 279, 274, 273, 268, 267, 262, 261, 256, 255, 250, 249, 244, 243, 238, 237, 232, 231, 226, 225, 220, 219, 214, 213, 208, 207, 822, 821, 288, 287, 282, 281, 276, 275, 270, 269, 264, 263, 258, 257, 252, 251, 246, 245, 240, 239, 234, 233, 228, 227, 222, 221, 216, 215, 210, 209, 823, 0, 290, 289, 296, 295, 302, 301, 308, 307, 314, 313, 320, 319, 326, 325, 332, 331, 338, 337, 344, 343, 350, 349, 356, 355, 362, 361, 368, 367, 825, 824, 292, 291, 298, 297, 304, 303, 310, 309, 316, 315, 322, 321, 328, 327, 334, 333, 340, 339, 346, 345, 352, 351, 358, 357, 364, 363, 370, 369, 826, 0, 294, 293, 300, 299, 306, 305, 312, 311, 318, 317, 324, 323, 330, 329, 336, 335, 342, 341, 348, 347, 354, 353, 360, 359, 366, 365, 372, 371, 828, 827, 410, 409, 404, 403, 398, 397, 392, 391, 80, 79, 0, 0, 14, 13, 38, 37, 3, 0, 45, 44, 110, 109, 386, 385, 380, 379, 374, 373, 829, 0, 412, 411, 406, 405, 400, 399, 394, 393, 82, 81, 41, 0, 16, 15, 40, 39, 4, 0, 0, 46, 112, 111, 388, 387, 382, 381, 376, 375, 831, 830, 414, 413, 408, 407, 402, 401, 396, 395, 84, 83, 42, 0, 0, 0, 0, 0, 6, 5, 48, 47, 114, 113, 390, 389, 384, 383, 378, 377, 832, 0, 416, 415, 422, 421, 428, 427, 104, 103, 56, 55, 17, 0, 0, 0, 0, 0, 0, 0, 21, 20, 86, 85, 434, 433, 440, 439, 446, 445, 834, 833, 418, 417, 424, 423, 430, 429, 106, 105, 58, 57, 0, 0, 0, 0, 0, 0, 0, 0, 23, 22, 88, 87, 436, 435, 442, 441, 448, 447, 835, 0, 420, 419, 426, 425, 432, 431, 108, 107, 60, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 90, 89, 438, 437, 444, 443, 450, 449, 837, 836, 482, 481, 476, 475, 470, 469, 49, 0, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 54, 53, 464, 463, 458, 457, 452, 451, 838, 0, 484, 483, 478, 477, 472, 471, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 466, 465, 460, 459, 454, 453, 840, 839, 486, 485, 480, 479, 474, 473, 52, 51, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 43, 468, 467, 462, 461, 456, 455, 841, 0, 488, 487, 494, 493, 500, 499, 98, 97, 62, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 92, 91, 506, 505, 512, 511, 518, 517, 843, 842, 490, 489, 496, 495, 502, 501, 100, 99, 64, 63, 0, 0, 0, 0, 0, 0, 0, 0, 29, 28, 94, 93, 508, 507, 514, 513, 520, 519, 844, 0, 492, 491, 498, 497, 504, 503, 102, 101, 66, 65, 18, 0, 0, 0, 0, 0, 0, 0, 19, 30, 96, 95, 510, 509, 516, 515, 522, 521, 846, 845, 560, 559, 554, 553, 548, 547, 542, 541, 74, 73, 33, 0, 0, 0, 0, 0, 0, 11, 68, 67, 116, 115, 536, 535, 530, 529, 524, 523, 847, 0, 562, 561, 556, 555, 550, 549, 544, 543, 76, 75, 0, 0, 8, 7, 36, 35, 12, 0, 70, 69, 118, 117, 538, 537, 532, 531, 526, 525, 849, 848, 564, 563, 558, 557, 552, 551, 546, 545, 78, 77, 0, 34, 10, 9, 26, 25, 0, 0, 72, 71, 120, 119, 540, 539, 534, 533, 528, 527, 850, 0, 566, 565, 572, 571, 578, 577, 584, 583, 590, 589, 596, 595, 602, 601, 608, 607, 614, 613, 620, 619, 626, 625, 632, 631, 638, 637, 644, 643, 852, 851, 568, 567, 574, 573, 580, 579, 586, 585, 592, 591, 598, 597, 604, 603, 610, 609, 616, 615, 622, 621, 628, 627, 634, 633, 640, 639, 646, 645, 853, 0, 570, 569, 576, 575, 582, 581, 588, 587, 594, 593, 600, 599, 606, 605, 612, 611, 618, 617, 624, 623, 630, 629, 636, 635, 642, 641, 648, 647, 855, 854, 728, 727, 722, 721, 716, 715, 710, 709, 704, 703, 698, 697, 692, 691, 686, 685, 680, 679, 674, 673, 668, 667, 662, 661, 656, 655, 650, 649, 856, 0, 730, 729, 724, 723, 718, 717, 712, 711, 706, 705, 700, 699, 694, 693, 688, 687, 682, 681, 676, 675, 670, 669, 664, 663, 658, 657, 652, 651, 858, 857, 732, 731, 726, 725, 720, 719, 714, 713, 708, 707, 702, 701, 696, 695, 690, 689, 684, 683, 678, 677, 672, 671, 666, 665, 660, 659, 654, 653, 859, 0, 734, 733, 740, 739, 746, 745, 752, 751, 758, 757, 764, 763, 770, 769, 776, 775, 782, 781, 788, 787, 794, 793, 800, 799, 806, 805, 812, 811, 861, 860, 736, 735, 742, 741, 748, 747, 754, 753, 760, 759, 766, 765, 772, 771, 778, 777, 784, 783, 790, 789, 796, 795, 802, 801, 808, 807, 814, 813, 862, 0, 738, 737, 744, 743, 750, 749, 756, 755, 762, 761, 768, 767, 774, 773, 780, 779, 786, 785, 792, 791, 798, 797, 804, 803, 810, 809, 816, 815, 864, 863};
    private static final int[] MAXICODE_SET = new int[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 5, 0, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 5, 5, 5, 5, 5, 5, 4, 5, 3, 4, 3, 5, 5, 4, 4, 3, 3, 3, 4, 3, 5, 4, 4, 3, 3, 4, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] MAXICODE_SYMBOL_CHAR = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 30, 28, 29, 30, 35, 32, 53, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 37, 38, 39, 40, 41, 52, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 42, 43, 44, 45, 46, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 32, 54, 34, 35, 36, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 36, 37, 37, 38, 39, 40, 41, 42, 43, 38, 44, 37, 39, 38, 45, 46, 40, 41, 39, 40, 41, 42, 42, 47, 43, 44, 43, 44, 45, 45, 46, 47, 46, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 32, 33, 34, 35, 36, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 32, 33, 34, 35, 36};
    private int mode;
    private int structuredAppendPosition = 1;
    private int structuredAppendTotal = 1;
    private String primaryData = "";
    private int[] codewords;
    private int[] set = new int[144];
    private int[] character = new int[144];
    private boolean[][] grid = new boolean[33][30];

    public void setMode(int mode) {
        if (mode < 2 || mode > 6) {
            throw new IllegalArgumentException("Invalid MaxiCode mode: " + mode);
        }
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setStructuredAppendPosition(int position) {
        if (position < 1 || position > 8) {
            throw new IllegalArgumentException("Invalid MaxiCode structured append position: " + position);
        }
        this.structuredAppendPosition = position;
    }

    public int getStructuredAppendPosition() {
        return this.structuredAppendPosition;
    }

    public void setStructuredAppendTotal(int total) {
        if (total < 1 || total > 8) {
            throw new IllegalArgumentException("Invalid MaxiCode structured append total: " + total);
        }
        this.structuredAppendTotal = total;
    }

    public int getStructuredAppendTotal() {
        return this.structuredAppendTotal;
    }

    public void setPrimary(String primary) {
        this.primaryData = primary;
    }

    public String getPrimary() {
        return this.primaryData;
    }

    @Override
    protected void encode() {
        int i;
        int i2;
        int secondaryECMax;
        int secondaryMax;
        this.eciProcess();
        if (this.mode == 2) {
            for (int i3 = 0; i3 < 10 && i3 < this.primaryData.length(); ++i3) {
                if (this.primaryData.charAt(i3) >= '0' && this.primaryData.charAt(i3) <= '9') continue;
                this.mode = 3;
                break;
            }
        }
        this.processText();
        this.codewords = Arrays.copyOf(this.character, this.character.length);
        if (this.mode == 2 || this.mode == 3) {
            int[] primary = this.getPrimaryCodewords();
            this.codewords = uk.org.okapibarcode.util.Arrays.insertArray(this.codewords, 0, primary);
        } else {
            this.codewords = uk.org.okapibarcode.util.Arrays.insertArray(this.codewords, 0, new int[]{this.mode});
        }
        if (this.structuredAppendTotal > 1) {
            int[] flag = new int[]{33, this.structuredAppendPosition - 1 << 3 | this.structuredAppendTotal - 1};
            int index = this.mode == 2 || this.mode == 3 ? 10 : 1;
            this.codewords = uk.org.okapibarcode.util.Arrays.insertArray(this.codewords, index, flag);
        }
        if (this.mode == 5) {
            secondaryMax = 68;
            secondaryECMax = 56;
        } else {
            secondaryMax = 84;
            secondaryECMax = 40;
        }
        int totalMax = secondaryMax + 10;
        if (this.codewords.length > totalMax) {
            this.codewords = Arrays.copyOfRange(this.codewords, 0, totalMax);
        }
        int[] primary = Arrays.copyOfRange(this.codewords, 0, 10);
        int[] primaryCheck = MaxiCode.getErrorCorrection(primary, 10);
        this.codewords = uk.org.okapibarcode.util.Arrays.insertArray(this.codewords, 10, primaryCheck);
        int[] secondary = Arrays.copyOfRange(this.codewords, 20, this.codewords.length);
        int[] secondaryOdd = new int[secondary.length / 2];
        int[] secondaryEven = new int[secondary.length / 2];
        for (int i4 = 0; i4 < secondary.length; ++i4) {
            if ((i4 & 1) != 0) {
                secondaryOdd[(i4 - 1) / 2] = secondary[i4];
                continue;
            }
            secondaryEven[i4 / 2] = secondary[i4];
        }
        int[] secondaryECOdd = MaxiCode.getErrorCorrection(secondaryOdd, secondaryECMax / 2);
        int[] secondaryECEven = MaxiCode.getErrorCorrection(secondaryEven, secondaryECMax / 2);
        this.codewords = Arrays.copyOf(this.codewords, this.codewords.length + secondaryECOdd.length + secondaryECEven.length);
        for (i2 = 0; i2 < secondaryECOdd.length; ++i2) {
            this.codewords[20 + secondaryMax + 2 * i2 + 1] = secondaryECOdd[i2];
        }
        for (i2 = 0; i2 < secondaryECEven.length; ++i2) {
            this.codewords[20 + secondaryMax + 2 * i2] = secondaryECEven[i2];
        }
        this.infoLine("Mode: " + this.mode);
        this.infoLine("ECC Codewords: " + secondaryECMax);
        this.info("Codewords: ");
        for (i2 = 0; i2 < this.codewords.length; ++i2) {
            this.infoSpace(this.codewords[i2]);
        }
        this.infoLine();
        int[] bit_pattern = new int[7];
        for (i = 0; i < 33; ++i) {
            for (int j = 0; j < 30; ++j) {
                int block = (MAXICODE_GRID[i * 30 + j] + 5) / 6;
                int bit = (MAXICODE_GRID[i * 30 + j] + 5) % 6;
                if (block == 0) continue;
                bit_pattern[0] = (this.codewords[block - 1] & 0x20) >> 5;
                bit_pattern[1] = (this.codewords[block - 1] & 0x10) >> 4;
                bit_pattern[2] = (this.codewords[block - 1] & 8) >> 3;
                bit_pattern[3] = (this.codewords[block - 1] & 4) >> 2;
                bit_pattern[4] = (this.codewords[block - 1] & 2) >> 1;
                bit_pattern[5] = this.codewords[block - 1] & 1;
                this.grid[i][j] = bit_pattern[bit] != 0;
            }
        }
        this.grid[0][28] = true;
        this.grid[0][29] = true;
        this.grid[9][10] = true;
        this.grid[9][11] = true;
        this.grid[10][11] = true;
        this.grid[15][7] = true;
        this.grid[16][8] = true;
        this.grid[16][20] = true;
        this.grid[17][20] = true;
        this.grid[22][10] = true;
        this.grid[23][10] = true;
        this.grid[22][17] = true;
        this.grid[23][17] = true;
        this.row_count = 33;
        this.readable = "";
        this.pattern = new String[33];
        this.row_height = new int[33];
        for (i = 0; i < 33; ++i) {
            StringBuilder bin = new StringBuilder(30);
            for (int j = 0; j < 30; ++j) {
                if (this.grid[i][j]) {
                    bin.append("1");
                    continue;
                }
                bin.append("0");
            }
            this.pattern[i] = MaxiCode.bin2pat(bin);
            this.row_height[i] = 1;
        }
        this.symbol_height = 72;
        this.symbol_width = 74;
    }

    private int[] getPrimaryCodewords() {
        String postcode;
        assert (this.mode == 2 || this.mode == 3);
        if (this.primaryData.length() != 15) {
            throw new OkapiException("Invalid Primary String");
        }
        for (int i = 9; i < 15; ++i) {
            if (this.primaryData.charAt(i) >= '0' && this.primaryData.charAt(i) <= '9') continue;
            throw new OkapiException("Invalid Primary String");
        }
        if (this.mode == 2) {
            postcode = this.primaryData.substring(0, 9);
            int index = postcode.indexOf(32);
            if (index != -1) {
                postcode = postcode.substring(0, index);
            }
        } else {
            assert (this.mode == 3);
            postcode = this.primaryData.substring(0, 6);
        }
        int country = Integer.parseInt(this.primaryData.substring(9, 12));
        int service = Integer.parseInt(this.primaryData.substring(12, 15));
        this.infoLine("Postal Code: " + postcode);
        this.infoLine("Country Code: " + country);
        this.infoLine("Service: " + service);
        if (this.mode == 2) {
            return MaxiCode.getMode2PrimaryCodewords(postcode, country, service);
        }
        assert (this.mode == 3);
        return MaxiCode.getMode3PrimaryCodewords(postcode, country, service);
    }

    private static int[] getMode2PrimaryCodewords(String postcode, int country, int service) {
        for (int i = 0; i < postcode.length(); ++i) {
            if (postcode.charAt(i) >= '0' && postcode.charAt(i) <= '9') continue;
            postcode = postcode.substring(0, i);
            break;
        }
        int postcodeNum = Integer.parseInt(postcode);
        int[] primary = new int[]{(postcodeNum & 3) << 4 | 2, (postcodeNum & 0xFC) >> 2, (postcodeNum & 0x3F00) >> 8, (postcodeNum & 0xFC000) >> 14, (postcodeNum & 0x3F00000) >> 20, (postcodeNum & 0x3C000000) >> 26 | (postcode.length() & 3) << 4, (postcode.length() & 0x3C) >> 2 | (country & 3) << 4, (country & 0xFC) >> 2, (country & 0x300) >> 8 | (service & 0xF) << 2, (service & 0x3F0) >> 4};
        return primary;
    }

    private static int[] getMode3PrimaryCodewords(String postcode, int country, int service) {
        int[] postcodeNums = new int[postcode.length()];
        postcode = postcode.toUpperCase();
        for (int i = 0; i < postcodeNums.length; ++i) {
            postcodeNums[i] = postcode.charAt(i);
            if (postcode.charAt(i) >= 'A' && postcode.charAt(i) <= 'Z') {
                int n = i;
                postcodeNums[n] = postcodeNums[n] - 64;
            }
            if (postcodeNums[i] != 27 && postcodeNums[i] != 31 && postcodeNums[i] != 33 && postcodeNums[i] < 59) continue;
            postcodeNums[i] = 32;
        }
        int[] primary = new int[]{(postcodeNums[5] & 3) << 4 | 3, (postcodeNums[4] & 3) << 4 | (postcodeNums[5] & 0x3C) >> 2, (postcodeNums[3] & 3) << 4 | (postcodeNums[4] & 0x3C) >> 2, (postcodeNums[2] & 3) << 4 | (postcodeNums[3] & 0x3C) >> 2, (postcodeNums[1] & 3) << 4 | (postcodeNums[2] & 0x3C) >> 2, (postcodeNums[0] & 3) << 4 | (postcodeNums[1] & 0x3C) >> 2, (postcodeNums[0] & 0x3C) >> 2 | (country & 3) << 4, (country & 0xFC) >> 2, (country & 0x300) >> 8 | (service & 0xF) << 2, (service & 0x3F0) >> 4};
        return primary;
    }

    private void processText() {
        int maxLength;
        int i;
        int length = this.content.length();
        if (length > 138) {
            throw new OkapiException("Input data too long");
        }
        for (i = 0; i < 144; ++i) {
            this.set[i] = -1;
            this.character[i] = 0;
        }
        for (i = 0; i < length; ++i) {
            this.set[i] = MAXICODE_SET[this.inputData[i]];
            this.character[i] = MAXICODE_SYMBOL_CHAR[this.inputData[i]];
        }
        if (this.set[0] == 0) {
            if (this.character[0] == 13) {
                this.character[0] = 0;
            }
            this.set[0] = 1;
        }
        for (i = 1; i < length; ++i) {
            if (this.set[i] != 0) continue;
            if (this.character[i] == 13) {
                this.set[i] = this.bestSurroundingSet(i, length, 1, 5);
                if (this.set[i] == 5) {
                    this.character[i] = 13;
                    continue;
                }
                this.character[i] = 0;
                continue;
            }
            if (this.character[i] == 28) {
                this.set[i] = this.bestSurroundingSet(i, length, 1, 2, 3, 4, 5);
                if (this.set[i] != 5) continue;
                this.character[i] = 32;
                continue;
            }
            if (this.character[i] == 29) {
                this.set[i] = this.bestSurroundingSet(i, length, 1, 2, 3, 4, 5);
                if (this.set[i] != 5) continue;
                this.character[i] = 33;
                continue;
            }
            if (this.character[i] == 30) {
                this.set[i] = this.bestSurroundingSet(i, length, 1, 2, 3, 4, 5);
                if (this.set[i] != 5) continue;
                this.character[i] = 34;
                continue;
            }
            if (this.character[i] == 32) {
                this.set[i] = this.bestSurroundingSet(i, length, 1, 2, 3, 4, 5);
                if (this.set[i] == 1) {
                    this.character[i] = 32;
                    continue;
                }
                if (this.set[i] == 2) {
                    this.character[i] = 47;
                    continue;
                }
                this.character[i] = 59;
                continue;
            }
            if (this.character[i] == 44) {
                this.set[i] = this.bestSurroundingSet(i, length, 1, 2);
                if (this.set[i] != 2) continue;
                this.character[i] = 48;
                continue;
            }
            if (this.character[i] == 46) {
                this.set[i] = this.bestSurroundingSet(i, length, 1, 2);
                if (this.set[i] != 2) continue;
                this.character[i] = 49;
                continue;
            }
            if (this.character[i] == 47) {
                this.set[i] = this.bestSurroundingSet(i, length, 1, 2);
                if (this.set[i] != 2) continue;
                this.character[i] = 50;
                continue;
            }
            if (this.character[i] != 58) continue;
            this.set[i] = this.bestSurroundingSet(i, length, 1, 2);
            if (this.set[i] != 2) continue;
            this.character[i] = 51;
        }
        for (i = length; i < this.set.length; ++i) {
            this.set[i] = this.set[length - 1] == 2 ? 2 : 1;
            this.character[i] = 33;
        }
        int j = this.mode == 2 || this.mode == 3 ? 9 : 0;
        int count = 0;
        for (i = j; i < 143; ++i) {
            count = this.set[i] == 1 && this.character[i] >= 48 && this.character[i] <= 57 ? ++count : 0;
            if (count != 9) continue;
            this.set[i] = 6;
            this.set[i - 1] = 6;
            this.set[i - 2] = 6;
            this.set[i - 3] = 6;
            this.set[i - 4] = 6;
            this.set[i - 5] = 6;
            this.set[i - 6] = 6;
            this.set[i - 7] = 6;
            this.set[i - 8] = 6;
            count = 0;
        }
        int current_set = 1;
        i = 0;
        do {
            if (this.set[i] == current_set || this.set[i] == 6) continue;
            switch (this.set[i]) {
                case 1: {
                    if (i + 1 < this.set.length && this.set[i + 1] == 1) {
                        if (i + 2 < this.set.length && this.set[i + 2] == 1) {
                            if (i + 3 < this.set.length && this.set[i + 3] == 1) {
                                this.insert(i, 63);
                                current_set = 1;
                                ++length;
                                i += 3;
                                break;
                            }
                            this.insert(i, 57);
                            ++length;
                            i += 2;
                            break;
                        }
                        this.insert(i, 56);
                        ++length;
                        ++i;
                        break;
                    }
                    this.insert(i, 59);
                    ++length;
                    break;
                }
                case 2: {
                    if (i + 1 < this.set.length && this.set[i + 1] == 2) {
                        this.insert(i, 63);
                        current_set = 2;
                        ++length;
                        ++i;
                        break;
                    }
                    this.insert(i, 59);
                    ++length;
                    break;
                }
                case 3: {
                    if (i + 3 < this.set.length && this.set[i + 1] == 3 && this.set[i + 2] == 3 && this.set[i + 3] == 3) {
                        this.insert(i, 60);
                        this.insert(i, 60);
                        current_set = 3;
                        ++length;
                        i += 3;
                        break;
                    }
                    this.insert(i, 60);
                    ++length;
                    break;
                }
                case 4: {
                    if (i + 3 < this.set.length && this.set[i + 1] == 4 && this.set[i + 2] == 4 && this.set[i + 3] == 4) {
                        this.insert(i, 61);
                        this.insert(i, 61);
                        current_set = 4;
                        ++length;
                        i += 3;
                        break;
                    }
                    this.insert(i, 61);
                    ++length;
                    break;
                }
                case 5: {
                    if (i + 3 < this.set.length && this.set[i + 1] == 5 && this.set[i + 2] == 5 && this.set[i + 3] == 5) {
                        this.insert(i, 62);
                        this.insert(i, 62);
                        current_set = 5;
                        ++length;
                        i += 3;
                        break;
                    }
                    this.insert(i, 62);
                    ++length;
                    break;
                }
                default: {
                    throw new OkapiException("Unexpected set " + this.set[i] + " at index " + i + ".");
                }
            }
            ++i;
        } while (++i < this.set.length);
        i = 0;
        do {
            if (this.set[i] == 6) {
                int value = 0;
                for (j = 0; j < 9; ++j) {
                    value *= 10;
                    value += this.character[i + j] - 48;
                }
                this.character[i] = 31;
                this.character[i + 1] = (value & 0x3F000000) >> 24;
                this.character[i + 2] = (value & 0xFC0000) >> 18;
                this.character[i + 3] = (value & 0x3F000) >> 12;
                this.character[i + 4] = (value & 0xFC0) >> 6;
                this.character[i + 5] = value & 0x3F;
                for (j = i += 6; j < 140; ++j) {
                    this.set[j] = this.set[j + 3];
                    this.character[j] = this.character[j + 3];
                }
                length -= 3;
                continue;
            }
            ++i;
        } while (i < this.set.length);
        if (this.eciMode != 3) {
            this.insert(0, 27);
            if (this.eciMode >= 0 && this.eciMode <= 31) {
                this.insert(1, this.eciMode & 0x1F);
                length += 2;
            }
            if (this.eciMode >= 32 && this.eciMode <= 1023) {
                this.insert(1, 32 + (this.eciMode >> 6));
                this.insert(2, this.eciMode & 0x3F);
                length += 3;
            }
            if (this.eciMode >= 1024 && this.eciMode <= Short.MAX_VALUE) {
                this.insert(1, 48 + (this.eciMode >> 12));
                this.insert(2, this.eciMode >> 6 & 0x3F);
                this.insert(3, this.eciMode & 0x3F);
                length += 4;
            }
            if (this.eciMode >= 32768 && this.eciMode <= 999999) {
                this.insert(1, 56 + (this.eciMode >> 18));
                this.insert(2, this.eciMode >> 12 & 0x3F);
                this.insert(3, this.eciMode >> 6 & 0x3F);
                this.insert(4, this.eciMode & 0x3F);
                length += 5;
            }
        }
        if (length > (maxLength = this.mode == 2 || this.mode == 3 ? 84 : (this.mode == 4 || this.mode == 6 ? 93 : (this.mode == 5 ? 77 : 0)))) {
            throw new OkapiException("Input data too long");
        }
    }

    private int bestSurroundingSet(int index, int length, int ... valid) {
        int option1 = this.set[index - 1];
        if (index + 1 < length) {
            int option2 = this.set[index + 1];
            if (uk.org.okapibarcode.util.Arrays.contains(valid, option1) && uk.org.okapibarcode.util.Arrays.contains(valid, option2)) {
                return Math.min(option1, option2);
            }
            if (uk.org.okapibarcode.util.Arrays.contains(valid, option1)) {
                return option1;
            }
            if (uk.org.okapibarcode.util.Arrays.contains(valid, option2)) {
                return option2;
            }
            return valid[0];
        }
        if (uk.org.okapibarcode.util.Arrays.contains(valid, option1)) {
            return option1;
        }
        return valid[0];
    }

    private void insert(int position, int c) {
        for (int i = 143; i > position; --i) {
            this.set[i] = this.set[i - 1];
            this.character[i] = this.character[i - 1];
        }
        this.character[position] = c;
    }

    private static int[] getErrorCorrection(int[] codewords, int ecclen) {
        ReedSolomon rs = new ReedSolomon();
        rs.init_gf(67);
        rs.init_code(ecclen, 1);
        rs.encode(codewords.length, codewords);
        int[] results = new int[ecclen];
        for (int i = 0; i < ecclen; ++i) {
            results[i] = rs.getResult(results.length - 1 - i);
        }
        return results;
    }

    @Override
    protected void plotSymbol() {
        for (int row = 0; row < 33; ++row) {
            for (int col = 0; col < 30; ++col) {
                if (!this.grid[row][col]) continue;
                double x = 2.46 * (double)col + 1.23;
                if ((row & 1) != 0) {
                    x += 1.23;
                }
                double y = 2.135 * (double)row + 1.43;
                this.hexagons.add(new Hexagon(x, y));
            }
        }
        double[] radii = new double[]{10.85, 8.97, 7.1, 5.22, 3.31, 1.43};
        for (int i = 0; i < radii.length; ++i) {
            Ellipse2D.Double circle = new Ellipse2D.Double();
            circle.setFrameFromCenter(35.76, 35.6, 35.76 + radii[i], 35.6 + radii[i]);
            this.target.add(circle);
        }
    }

    @Override
    protected int[] getCodewords() {
        return this.codewords;
    }
}

