/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.Code128;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;

public class Nve18
extends Symbol {
    @Override
    protected void encode() {
        int i;
        String gs1Equivalent = "";
        int count = 0;
        int p = 0;
        if (this.content.length() > 17) {
            throw new OkapiException("Input data too long");
        }
        if (!this.content.matches("[0-9]+")) {
            throw new OkapiException("Invalid characters in input");
        }
        int zeroes = 17 - this.content.length();
        for (i = 0; i < zeroes; ++i) {
            gs1Equivalent = gs1Equivalent + "0";
        }
        gs1Equivalent = gs1Equivalent + this.content;
        for (i = gs1Equivalent.length() - 1; i >= 0; --i) {
            int c = Character.getNumericValue(gs1Equivalent.charAt(i));
            if (p % 2 == 0) {
                c *= 3;
            }
            count += c;
            ++p;
        }
        int cdigit = 10 - count % 10;
        if (cdigit == 10) {
            cdigit = 0;
        }
        this.infoLine("NVE Check Digit: " + cdigit);
        this.content = "[00]" + gs1Equivalent + cdigit;
        Code128 code128 = new Code128();
        code128.setDataType(Symbol.DataType.GS1);
        code128.setHumanReadableLocation(this.humanReadableLocation);
        code128.setContent(this.content);
        this.readable = code128.readable;
        this.pattern = code128.pattern;
        this.row_count = code128.row_count;
        this.row_height = code128.row_height;
        this.symbol_height = code128.symbol_height;
        this.symbol_width = code128.symbol_width;
        this.rectangles = code128.rectangles;
        this.texts = code128.texts;
        this.info(code128.encodeInfo);
    }
}

