/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.Code3Of9;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;

public class Pharmazentralnummer
extends Symbol {
    @Override
    protected void encode() {
        int i;
        int l = this.content.length();
        int count = 0;
        Code3Of9 c = new Code3Of9();
        if (l > 7) {
            throw new OkapiException("Input data too long");
        }
        if (!this.content.matches("[0-9]+")) {
            throw new OkapiException("Invalid characters in input");
        }
        String localstr = "-";
        int zeroes = 7 - l + 1;
        for (i = 1; i < zeroes; ++i) {
            localstr = localstr + '0';
        }
        localstr = localstr + this.content;
        for (i = 1; i < 8; ++i) {
            count += i * Character.getNumericValue(localstr.charAt(i));
        }
        int check_digit = count % 11;
        if (check_digit == 11) {
            check_digit = 0;
        }
        if (check_digit == 10) {
            throw new OkapiException("Not a valid PZN identifier");
        }
        this.infoLine("Check Digit: " + check_digit);
        localstr = localstr + (char)(check_digit + 48);
        c.setContent(localstr);
        this.readable = "PZN" + localstr;
        this.pattern = new String[1];
        this.pattern[0] = c.pattern[0];
        this.row_count = 1;
        this.row_height = new int[1];
        this.row_height[0] = -1;
    }
}

