/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import uk.org.okapibarcode.backend.Ean;
import uk.org.okapibarcode.backend.EanUpcAddOn;
import uk.org.okapibarcode.backend.HumanReadableAlignment;
import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.backend.TextBox;

public class Upc
extends Symbol {
    private static final String[] SET_AC = new String[]{"3211", "2221", "2122", "1411", "1132", "1231", "1114", "1312", "1213", "3112"};
    private static final String[] SET_B = new String[]{"1123", "1222", "2212", "1141", "2311", "1321", "4111", "2131", "3121", "2113"};
    private static final String[] UPC_PARITY_0 = new String[]{"BBBAAA", "BBABAA", "BBAABA", "BBAAAB", "BABBAA", "BAABBA", "BAAABB", "BABABA", "BABAAB", "BAABAB"};
    private static final String[] UPC_PARITY_1 = new String[]{"AAABBB", "AABABB", "AABBAB", "AABBBA", "ABAABB", "ABBAAB", "ABBBAA", "ABABAB", "ABABBA", "ABBABA"};
    private Mode mode = Mode.UPCA;
    private boolean showCheckDigit = true;
    private int guardPatternExtraHeight = 5;
    private boolean linkageFlag;
    private EanUpcAddOn addOn;

    public Upc() {
        this.humanReadableAlignment = HumanReadableAlignment.JUSTIFY;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setShowCheckDigit(boolean showCheckDigit) {
        this.showCheckDigit = showCheckDigit;
    }

    public boolean getShowCheckDigit() {
        return this.showCheckDigit;
    }

    public void setGuardPatternExtraHeight(int guardPatternExtraHeight) {
        this.guardPatternExtraHeight = guardPatternExtraHeight;
    }

    public int getGuardPatternExtraHeight() {
        return this.guardPatternExtraHeight;
    }

    protected void setLinkageFlag(boolean linkageFlag) {
        this.linkageFlag = linkageFlag;
    }

    @Override
    protected void encode() {
        this.separateContent();
        if (this.content.isEmpty()) {
            throw new OkapiException("Missing UPC data");
        }
        if (this.mode == Mode.UPCA) {
            this.upca();
        } else {
            this.upce();
        }
    }

    private void separateContent() {
        int splitPoint = this.content.indexOf(43);
        if (splitPoint == -1) {
            this.addOn = null;
        } else {
            if (splitPoint == this.content.length() - 1) {
                throw new OkapiException("Invalid add-on data");
            }
            this.addOn = new EanUpcAddOn();
            this.addOn.font = this.font;
            this.addOn.fontName = this.fontName;
            this.addOn.fontSize = this.fontSize;
            this.addOn.humanReadableLocation = this.humanReadableLocation == HumanReadableLocation.NONE ? HumanReadableLocation.NONE : HumanReadableLocation.TOP;
            this.addOn.moduleWidth = this.moduleWidth;
            this.addOn.default_height = this.default_height + this.guardPatternExtraHeight - 8;
            this.addOn.setContent(this.content.substring(splitPoint + 1));
            this.content = this.content.substring(0, splitPoint);
        }
    }

    private void upca() {
        this.content = Ean.validateAndPad(this.content, 11);
        char check = Ean.calcDigit(this.content);
        this.infoLine("Check Digit: " + check);
        String hrt = this.content + check;
        StringBuilder dest = new StringBuilder("111");
        for (int i = 0; i < 12; ++i) {
            if (i == 6) {
                dest.append("11111");
            }
            dest.append(SET_AC[hrt.charAt(i) - 48]);
        }
        dest.append("111");
        this.readable = hrt;
        this.pattern = new String[]{dest.toString()};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private void upce() {
        this.content = Ean.validateAndPad(this.content, 7);
        String expanded = this.expandToEquivalentUpcA(this.content, true);
        this.infoLine("UPC-A Equivalent: " + expanded);
        char check = Ean.calcDigit(expanded);
        this.infoLine("Check Digit: " + check);
        String hrt = this.content + check;
        int numberSystem = Upc.getNumberSystem(this.content);
        String[] parityArray = numberSystem == 1 ? UPC_PARITY_1 : UPC_PARITY_0;
        String parity = parityArray[check - 48];
        StringBuilder dest = new StringBuilder("111");
        for (int i = 0; i < 6; ++i) {
            if (parity.charAt(i) == 'A') {
                dest.append(SET_AC[this.content.charAt(i + 1) - 48]);
                continue;
            }
            dest.append(SET_B[this.content.charAt(i + 1) - 48]);
        }
        dest.append("111111");
        this.readable = hrt;
        this.pattern = new String[]{dest.toString()};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    protected String expandToEquivalentUpcA(String content, boolean validate) {
        char[] upce = content.toCharArray();
        char[] upca = new char[11];
        Arrays.fill(upca, '0');
        upca[0] = upce[0];
        upca[1] = upce[1];
        upca[2] = upce[2];
        char emode = upce[6];
        switch (emode) {
            case '0': 
            case '1': 
            case '2': {
                upca[3] = emode;
                upca[8] = upce[3];
                upca[9] = upce[4];
                upca[10] = upce[5];
                break;
            }
            case '3': {
                upca[3] = upce[3];
                upca[9] = upce[4];
                upca[10] = upce[5];
                if (!validate || upce[3] != '0' && upce[3] != '1' && upce[3] != '2') break;
                throw new OkapiException("Invalid UPC-E data");
            }
            case '4': {
                upca[3] = upce[3];
                upca[4] = upce[4];
                upca[10] = upce[5];
                if (!validate || upce[4] != '0') break;
                throw new OkapiException("Invalid UPC-E data");
            }
            default: {
                upca[3] = upce[3];
                upca[4] = upce[4];
                upca[5] = upce[5];
                upca[10] = emode;
                if (!validate || upce[5] != '0') break;
                throw new OkapiException("Invalid UPC-E data");
            }
        }
        return new String(upca);
    }

    private static int getNumberSystem(String content) {
        switch (content.charAt(0)) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
        }
        throw new OkapiException("Invalid input data");
    }

    @Override
    protected void plotSymbol() {
        boolean black = true;
        int compositeOffset = this.linkageFlag ? 6 : 0;
        int hrtOffset = this.humanReadableLocation == HumanReadableLocation.TOP ? this.getTheoreticalHumanReadableHeight() : 0;
        this.rectangles.clear();
        this.texts.clear();
        int x = 0;
        for (int xBlock = 0; xBlock < this.pattern[0].length(); ++xBlock) {
            int w = this.pattern[0].charAt(xBlock) - 48;
            if (black) {
                int y = 0;
                int h = this.default_height;
                if (this.mode == Mode.UPCA) {
                    if (x < 10 || x > 84 || x > 45 && x < 49) {
                        h += this.guardPatternExtraHeight;
                    }
                    if (this.linkageFlag && (x == 0 || x == 94)) {
                        h += 2;
                        y -= 2;
                    }
                } else {
                    if (x < 4 || x > 45) {
                        h += this.guardPatternExtraHeight;
                    }
                    if (this.linkageFlag && (x == 0 || x == 50)) {
                        h += 2;
                        y -= 2;
                    }
                }
                Rectangle2D.Double rect = new Rectangle2D.Double(this.scale(x), y + compositeOffset + hrtOffset, this.scale(w), h);
                this.rectangles.add(rect);
                this.symbol_width = Math.max(this.symbol_width, (int)rect.getMaxX());
                this.symbol_height = Math.max(this.symbol_height, (int)rect.getHeight());
            }
            black = !black;
            x += w;
        }
        if (this.linkageFlag) {
            if (this.mode == Mode.UPCA) {
                this.rectangles.add(new Rectangle2D.Double(this.scale(0), 0.0, this.scale(1), 2.0));
                this.rectangles.add(new Rectangle2D.Double(this.scale(94), 0.0, this.scale(1), 2.0));
                this.rectangles.add(new Rectangle2D.Double(this.scale(-1), 2.0, this.scale(1), 2.0));
                this.rectangles.add(new Rectangle2D.Double(this.scale(95), 2.0, this.scale(1), 2.0));
            } else {
                this.rectangles.add(new Rectangle2D.Double(this.scale(0), 0.0, this.scale(1), 2.0));
                this.rectangles.add(new Rectangle2D.Double(this.scale(50), 0.0, this.scale(1), 2.0));
                this.rectangles.add(new Rectangle2D.Double(this.scale(-1), 2.0, this.scale(1), 2.0));
                this.rectangles.add(new Rectangle2D.Double(this.scale(51), 2.0, this.scale(1), 2.0));
            }
            this.symbol_height += 4;
        }
        if (this.humanReadableLocation == HumanReadableLocation.BOTTOM) {
            this.symbol_height -= this.guardPatternExtraHeight;
            double baseline = this.symbol_height + this.fontSize;
            if (this.mode == Mode.UPCA) {
                this.texts.add(new TextBox(this.scale(-9), baseline, this.scale(4), this.readable.substring(0, 1), HumanReadableAlignment.RIGHT));
                this.texts.add(new TextBox(this.scale(12), baseline, this.scale(32), this.readable.substring(1, 6), this.humanReadableAlignment));
                this.texts.add(new TextBox(this.scale(51), baseline, this.scale(32), this.readable.substring(6, 11), this.humanReadableAlignment));
                if (this.showCheckDigit) {
                    this.texts.add(new TextBox(this.scale(97), baseline, this.scale(4), this.readable.substring(11, 12), HumanReadableAlignment.LEFT));
                }
            } else {
                this.texts.add(new TextBox(this.scale(-9), baseline, this.scale(4), this.readable.substring(0, 1), HumanReadableAlignment.RIGHT));
                this.texts.add(new TextBox(this.scale(5), baseline, this.scale(39), this.readable.substring(1, 7), this.humanReadableAlignment));
                if (this.showCheckDigit) {
                    this.texts.add(new TextBox(this.scale(53), baseline, this.scale(4), this.readable.substring(7, 8), HumanReadableAlignment.LEFT));
                }
            }
        } else if (this.humanReadableLocation == HumanReadableLocation.TOP) {
            double baseline = this.fontSize;
            int width = this.mode == Mode.UPCA ? 94 : 50;
            this.texts.add(new TextBox(this.scale(0), baseline, this.scale(width), this.readable, this.humanReadableAlignment));
        }
        if (this.addOn != null) {
            int gap = 9;
            int baseX = this.symbol_width + this.scale(gap);
            Rectangle2D.Double r1 = (Rectangle2D.Double)this.rectangles.get(0);
            Rectangle2D.Double ar1 = (Rectangle2D.Double)this.addOn.rectangles.get(0);
            int baseY = (int)(r1.y + r1.getHeight() - ar1.y - ar1.getHeight());
            for (TextBox t : this.addOn.getTexts()) {
                this.texts.add(new TextBox((double)baseX + t.x, (double)baseY + t.y, t.width, t.text, t.alignment));
            }
            for (Rectangle2D.Double r : this.addOn.getRectangles()) {
                this.rectangles.add(new Rectangle2D.Double((double)baseX + r.x, (double)baseY + r.y, r.width, r.height));
            }
            this.symbol_width += this.scale(gap) + this.addOn.symbol_width;
            this.pattern[0] = this.pattern[0] + gap + this.addOn.pattern[0];
        }
    }

    private int scale(int w) {
        return this.moduleWidth * w;
    }

    public static enum Mode {
        UPCA,
        UPCE;

    }
}

