/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.gui;

import java.awt.EventQueue;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import uk.org.okapibarcode.gui.OkapiUI;
import uk.org.okapibarcode.gui.OpenFile;

public class MoreData
extends JFrame {
    private JButton cancelButton;
    private TextArea dataInputArea;
    private Label dataLabel;
    private JButton fromFileButton;
    private JButton okButton;
    private JButton resetButton;

    public MoreData() {
        this.initComponents();
        this.pullData();
    }

    private void initComponents() {
        this.dataLabel = new Label();
        this.dataInputArea = new TextArea();
        this.fromFileButton = new JButton();
        this.resetButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Input Data");
        this.setResizable(false);
        this.dataLabel.setName("dataLabel");
        this.dataLabel.setText("Data");
        this.dataInputArea.setName("dataField");
        this.fromFileButton.setText("From File...");
        this.fromFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MoreData.this.fromFileButtonActionPerformed(evt);
            }
        });
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MoreData.this.resetButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MoreData.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MoreData.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.dataLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.resetButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fromFileButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.dataInputArea, -1, 468, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.dataLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataInputArea, -2, 283, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resetButton).addComponent(this.okButton).addComponent(this.cancelButton).addComponent(this.fromFileButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.dataInputArea.setText("");
    }

    private void fromFileButtonActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        if (fileChooser.showOpenDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                this.dataInputArea.setText(OpenFile.ReadFile(file, false));
            }
            catch (Exception e) {
                System.out.println("Cannot read from file" + fileChooser.getSelectedFile().toString());
            }
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        OkapiUI.dataInputField.setText(this.dataInputArea.getText());
        this.dispose();
    }

    private void pullData() {
        this.dataInputArea.setText(OkapiUI.dataInputField.getText());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            Logger.getLogger(MoreData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MoreData.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MoreData().setVisible(true);
            }
        });
    }
}

